/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.function.Consumer;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.HashCodeGenerator;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.planner.codegen.sort.ComparatorCodeGenerator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.runtime.generated.HashFunction;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.HamcrestCondition;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Test;

class CodeSplitTest {
    private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    CodeSplitTest() {
    }

    @Test
    void testJoinCondition() {
        int numFields = 200;
        FlinkTypeFactory typeFactory = new FlinkTypeFactory(this.classLoader, (RelDataTypeSystem)FlinkTypeSystem.INSTANCE);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)typeFactory);
        RelDataType intType = typeFactory.createFieldTypeFromLogicalType((LogicalType)new IntType());
        RexNode[] conditions = new RexNode[numFields];
        for (int i = 0; i < numFields; ++i) {
            conditions[i] = builder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{new RexInputRef(i, intType), new RexInputRef(numFields + i, intType)});
        }
        RexNode joinCondition = builder.makeCall((SqlOperator)SqlStdOperatorTable.AND, conditions);
        RowType rowType = this.getIntRowType(numFields);
        GenericRowData rowData1 = new GenericRowData(numFields);
        GenericRowData rowData2 = new GenericRowData(numFields);
        Random random = new Random();
        for (int i = 0; i < numFields; ++i) {
            rowData1.setField(i, (Object)0);
            rowData2.setField(i, (Object)1);
        }
        boolean result = random.nextBoolean();
        if (!result) {
            rowData1.setField(random.nextInt(numFields), (Object)1);
        }
        Consumer<ReadableConfig> consumer = tableConfig -> {
            JoinCondition instance = (JoinCondition)JoinUtil.generateConditionFunction((ReadableConfig)tableConfig, (ClassLoader)Thread.currentThread().getContextClassLoader(), (RexNode)joinCondition, (LogicalType)rowType, (LogicalType)rowType).newInstance(this.classLoader);
            for (int i = 0; i < 100; ++i) {
                Assertions.assertThat((boolean)instance.apply((RowData)rowData1, (RowData)rowData2)).isEqualTo(result);
            }
        };
        this.runTest(consumer);
    }

    @Test
    void testHashFunction() {
        int numFields = 1000;
        RowType rowType = this.getIntRowType(numFields);
        int[] hashFields = new int[numFields];
        for (int i = 0; i < numFields; ++i) {
            hashFields[i] = i;
        }
        GenericRowData rowData = new GenericRowData(numFields);
        for (int i = 0; i < numFields; ++i) {
            rowData.setField(i, (Object)i);
        }
        Consumer<ReadableConfig> consumer = tableConfig -> {
            HashFunction instance = (HashFunction)HashCodeGenerator.generateRowHash((CodeGeneratorContext)new CodeGeneratorContext(tableConfig, Thread.currentThread().getContextClassLoader()), (LogicalType)rowType, (String)"", (int[])hashFields).newInstance(this.classLoader);
            for (int i = 0; i < 100; ++i) {
                Assertions.assertThat((int)instance.hashCode((Object)rowData)).isEqualTo(-1433414860);
            }
        };
        this.runTest(consumer);
    }

    @Test
    void testRecordComparator() {
        int numFields = 600;
        RowType rowType = this.getIntRowType(numFields);
        SortSpec.SortSpecBuilder builder = SortSpec.builder();
        for (int i = 0; i < numFields; ++i) {
            builder.addField(i, true, true);
        }
        SortSpec sortSpec = builder.build();
        GenericRowData rowData1 = new GenericRowData(numFields);
        GenericRowData rowData2 = new GenericRowData(numFields);
        Random random = new Random();
        for (int i = 0; i < numFields; ++i) {
            int x = random.nextInt(100);
            rowData1.setField(i, (Object)x);
            rowData2.setField(i, (Object)x);
        }
        int result = random.nextInt(3) - 1;
        if (result == -1) {
            rowData1.setField(random.nextInt(numFields), (Object)-1);
        } else if (result == 1) {
            rowData1.setField(random.nextInt(numFields), (Object)100);
        }
        Consumer<ReadableConfig> consumer = tableConfig -> {
            RecordComparator instance = (RecordComparator)ComparatorCodeGenerator.gen((ReadableConfig)tableConfig, (ClassLoader)Thread.currentThread().getContextClassLoader(), (String)"", (RowType)rowType, (SortSpec)sortSpec).newInstance(this.classLoader);
            for (int i = 0; i < 100; ++i) {
                Assertions.assertThat((int)instance.compare((RowData)rowData1, (RowData)rowData2)).isEqualTo(result);
            }
        };
        this.runTest(consumer);
    }

    @Test
    void testProjection() {
        int numFields = 1000;
        RowType rowType = this.getIntRowType(numFields);
        ArrayList<Integer> order = new ArrayList<Integer>();
        for (int i = 0; i < numFields; ++i) {
            order.add(i);
        }
        Collections.shuffle(order);
        GenericRowData input = new GenericRowData(numFields);
        for (int i = 0; i < numFields; ++i) {
            input.setField(i, (Object)i);
        }
        BinaryRowData output = new BinaryRowData(numFields);
        BinaryRowWriter outputWriter = new BinaryRowWriter(output);
        for (int i = 0; i < numFields; ++i) {
            outputWriter.writeInt(i, ((Integer)order.get(i)).intValue());
        }
        outputWriter.complete();
        Consumer<ReadableConfig> consumer = tableConfig -> {
            Projection instance = (Projection)ProjectionCodeGenerator.generateProjection((CodeGeneratorContext)new CodeGeneratorContext(tableConfig, Thread.currentThread().getContextClassLoader()), (String)"", (RowType)rowType, (RowType)rowType, (int[])order.stream().mapToInt(i -> i).toArray()).newInstance(this.classLoader);
            for (int i2 = 0; i2 < 100; ++i2) {
                Assertions.assertThat((Object)instance.apply((RowData)input)).isEqualTo((Object)output);
            }
        };
        this.runTest(consumer);
    }

    private RowType getIntRowType(int numFields) {
        Object[] fieldTypes = new LogicalType[numFields];
        Arrays.fill(fieldTypes, new IntType());
        return RowType.of((LogicalType[])fieldTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(Consumer<ReadableConfig> consumer) {
        Configuration splitTableConfig = new Configuration();
        splitTableConfig.set(TableConfigOptions.MAX_LENGTH_GENERATED_CODE, (Object)4000);
        splitTableConfig.set(TableConfigOptions.MAX_MEMBERS_GENERATED_CODE, (Object)10000);
        consumer.accept((ReadableConfig)splitTableConfig);
        Configuration noSplitTableConfig = new Configuration();
        noSplitTableConfig.set(TableConfigOptions.MAX_LENGTH_GENERATED_CODE, (Object)Integer.MAX_VALUE);
        noSplitTableConfig.set(TableConfigOptions.MAX_MEMBERS_GENERATED_CODE, (Object)Integer.MAX_VALUE);
        PrintStream originalStdOut = System.out;
        try {
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            }));
            consumer.accept((ReadableConfig)noSplitTableConfig);
            Assertions.fail((String)"Expecting compiler exception");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).satisfies((Condition)HamcrestCondition.matching((Matcher)FlinkMatchers.containsMessage((String)"grows beyond 64 KB")));
        }
        finally {
            System.setOut(originalStdOut);
        }
    }
}

