/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.planner.codegen.EqualiserCodeGenerator;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.typeutils.RawValueDataSerializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.VarCharType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EqualiserCodeGeneratorTest {
    EqualiserCodeGeneratorTest() {
    }

    @Test
    void testRaw() {
        RecordEqualiser equaliser = (RecordEqualiser)new EqualiserCodeGenerator(new LogicalType[]{new TypeInformationRawType(Types.INT)}, Thread.currentThread().getContextClassLoader()).generateRecordEqualiser("RAW").newInstance(Thread.currentThread().getContextClassLoader());
        Function<RawValueData, BinaryRowData> func = o -> {
            BinaryRowData row = new BinaryRowData(1);
            BinaryRowWriter writer = new BinaryRowWriter(row);
            writer.writeRawValue(0, o, new RawValueDataSerializer((TypeSerializer)IntSerializer.INSTANCE));
            writer.complete();
            return row;
        };
        EqualiserCodeGeneratorTest.assertBoolean(equaliser, func, RawValueData.fromObject((Object)1), RawValueData.fromObject((Object)1), true);
        EqualiserCodeGeneratorTest.assertBoolean(equaliser, func, RawValueData.fromObject((Object)1), RawValueData.fromObject((Object)2), false);
    }

    @Test
    void testTimestamp() {
        RecordEqualiser equaliser = (RecordEqualiser)new EqualiserCodeGenerator(new LogicalType[]{new TimestampType()}, Thread.currentThread().getContextClassLoader()).generateRecordEqualiser("TIMESTAMP").newInstance(Thread.currentThread().getContextClassLoader());
        Function<TimestampData, BinaryRowData> func = o -> {
            BinaryRowData row = new BinaryRowData(1);
            BinaryRowWriter writer = new BinaryRowWriter(row);
            writer.writeTimestamp(0, o, 9);
            writer.complete();
            return row;
        };
        EqualiserCodeGeneratorTest.assertBoolean(equaliser, func, TimestampData.fromEpochMillis((long)1024L), TimestampData.fromEpochMillis((long)1024L), true);
        EqualiserCodeGeneratorTest.assertBoolean(equaliser, func, TimestampData.fromEpochMillis((long)1024L), TimestampData.fromEpochMillis((long)1025L), false);
    }

    @Test
    void testManyFields() {
        LogicalType[] fieldTypes = (LogicalType[])IntStream.range(0, 499).mapToObj(i -> new VarCharType()).toArray(LogicalType[]::new);
        RecordEqualiser equaliser = (RecordEqualiser)new EqualiserCodeGenerator(fieldTypes, Thread.currentThread().getContextClassLoader()).generateRecordEqualiser("ManyFields").newInstance(Thread.currentThread().getContextClassLoader());
        StringData[] fields = (StringData[])IntStream.range(0, 499).mapToObj(i -> StringData.fromString((String)("Entry " + i))).toArray(StringData[]::new);
        Assertions.assertThat((boolean)equaliser.equals((RowData)GenericRowData.of((Object[])fields), (RowData)GenericRowData.of((Object[])fields))).isTrue();
    }

    private static <T> void assertBoolean(RecordEqualiser equaliser, Function<T, BinaryRowData> toBinaryRow, T o1, T o2, boolean bool) {
        Assertions.assertThat((boolean)equaliser.equals((RowData)GenericRowData.of((Object[])new Object[]{o1}), (RowData)GenericRowData.of((Object[])new Object[]{o2}))).isEqualTo(bool);
        Assertions.assertThat((boolean)equaliser.equals((RowData)toBinaryRow.apply(o1), (RowData)GenericRowData.of((Object[])new Object[]{o2}))).isEqualTo(bool);
        Assertions.assertThat((boolean)equaliser.equals((RowData)GenericRowData.of((Object[])new Object[]{o1}), (RowData)toBinaryRow.apply(o2))).isEqualTo(bool);
        Assertions.assertThat((boolean)equaliser.equals((RowData)toBinaryRow.apply(o1), (RowData)toBinaryRow.apply(o2))).isEqualTo(bool);
    }
}

