/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator$;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001\u001f\tY\u0002K]8kK\u000e$\u0018n\u001c8D_\u0012,w)\u001a8fe\u0006$xN\u001d+fgRT!a\u0001\u0003\u0002\u000f\r|G-Z4f]*\u0011QAB\u0001\ba2\fgN\\3s\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t!\u0001C\u0004\u001d\u0001\t\u0007I\u0011B\u000f\u0002\u0017\rd\u0017m]:M_\u0006$WM]\u000b\u0002=A\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0005Y\u0006twMC\u0001$\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0002#aC\"mCN\u001cHj\\1eKJDaa\n\u0001!\u0002\u0013q\u0012\u0001D2mCN\u001cHj\\1eKJ\u0004\u0003\"B\u0015\u0001\t\u0003Q\u0013a\u0006;fgR\u0004&o\u001c6fGRLwN\u001c\"j]\u0006\u0014\u0018PU8x)\u0005Y\u0003CA\t-\u0013\ti#C\u0001\u0003V]&$\bF\u0001\u00150!\t\u0001t'D\u00012\u0015\t\u00114'A\u0002ba&T!\u0001N\u001b\u0002\u000f),\b/\u001b;fe*\u0011a\u0007D\u0001\u0006UVt\u0017\u000e^\u0005\u0003qE\u0012A\u0001V3ti\")!\b\u0001C\u0001U\u0005AB/Z:u!J|'.Z2uS>tw)\u001a8fe&\u001c'k\\<)\u0005ez\u0003\"B\u001f\u0001\t\u0003Q\u0013a\u0006;fgR\u0004&o\u001c6fGRLwN\\'b]f4\u0015.\u001a7eQ\tat\u0006C\u0003A\u0001\u0011\u0005!&A\u0011uKN$\bK]8kK\u000e$\u0018n\u001c8NC:Lh)[3mI\u001e+g.\u001a:jGJ{w\u000f\u000b\u0002@_!)1\t\u0001C\u0001U\u0005iC/Z:u!J|'.Z2uS>t')\u001b8bef\u0014vn^,ji\"4\u0016M]5bE2,G*\u001a8hi\"$\u0015\r^1)\u0005\t{\u0003\"\u0002$\u0001\t\u0003Q\u0013\u0001\u000b;fgR\u0004&o\u001c6fGRLwN\\,ji\"Le\u000eZ3qK:$WM\u001c;OC6,7i\\;oi\u0016\u0014\bFA#0\u0011\u0015I\u0005\u0001\"\u0001K\u0003\tQ\u0017\u000e\u0006\u0002L\u001dB\u0011q\u0004T\u0005\u0003\u001b\u0002\u0012q!\u00138uK\u001e,'\u000fC\u0003P\u0011\u0002\u0007\u0001+A\u0001j!\t\t\u0012+\u0003\u0002S%\t\u0019\u0011J\u001c;\t\u000bQ\u0003A\u0011A+\u0002\u0005)dGC\u0001,Z!\tyr+\u0003\u0002YA\t!Aj\u001c8h\u0011\u0015Q6\u000b1\u0001\\\u0003\u0005a\u0007CA\t]\u0013\tA&\u0003")
public class ProjectionCodeGeneratorTest {
    private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    private ClassLoader classLoader() {
        return this.classLoader;
    }

    @Test
    public void testProjectionBinaryRow() {
        Projection projection = (Projection)ProjectionCodeGenerator$.MODULE$.generateProjection(new CodeGeneratorContext((ReadableConfig)new Configuration(), this.classLoader()), "name", RowType.of((LogicalType[])new LogicalType[]{new IntType(), new BigIntType()}), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType()}), new int[]{1, 0}).newInstance(this.classLoader());
        BinaryRowData row = (BinaryRowData)projection.apply((RowData)GenericRowData.of((Object[])new Object[]{this.ji(5), this.jl(8L)}));
        Assertions.assertEquals((int)5, (int)row.getInt(1));
        Assertions.assertEquals((long)8L, (long)row.getLong(0));
    }

    @Test
    public void testProjectionGenericRow() {
        Projection projection = (Projection)ProjectionCodeGenerator$.MODULE$.generateProjection(new CodeGeneratorContext((ReadableConfig)new Configuration(), this.classLoader()), "name", RowType.of((LogicalType[])new LogicalType[]{new IntType(), new BigIntType()}), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType()}), new int[]{1, 0}, GenericRowData.class).newInstance(this.classLoader());
        GenericRowData row = (GenericRowData)projection.apply((RowData)GenericRowData.of((Object[])new Object[]{this.ji(5), this.jl(8L)}));
        Assertions.assertEquals((int)5, (int)row.getInt(1));
        Assertions.assertEquals((long)8L, (long)row.getLong(0));
    }

    @Test
    public void testProjectionManyField() {
        RowType rowType = RowType.of((LogicalType[])((LogicalType[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)x$1 -> ProjectionCodeGeneratorTest.$anonfun$testProjectionManyField$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(IntType.class))));
        Projection projection = (Projection)ProjectionCodeGenerator$.MODULE$.generateProjection(new CodeGeneratorContext((ReadableConfig)new Configuration(), this.classLoader()), "name", rowType, rowType, (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).toArray(ClassTag$.MODULE$.Int())).newInstance(this.classLoader());
        Random rnd = new Random();
        GenericRowData input = GenericRowData.of((Object[])((Object[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)x$2 -> this.ji(rnd.nextInt()), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Integer.class))));
        BinaryRowData row = (BinaryRowData)projection.apply((RowData)input);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((int)input.getInt(i), (int)row.getInt(i)));
    }

    @Test
    public void testProjectionManyFieldGenericRow() {
        RowType rowType = RowType.of((LogicalType[])((LogicalType[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)x$3 -> ProjectionCodeGeneratorTest.$anonfun$testProjectionManyFieldGenericRow$1(BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(IntType.class))));
        Projection projection = (Projection)ProjectionCodeGenerator$.MODULE$.generateProjection(new CodeGeneratorContext((ReadableConfig)new Configuration(), this.classLoader()), "name", rowType, rowType, (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).toArray(ClassTag$.MODULE$.Int()), GenericRowData.class).newInstance(this.classLoader());
        Random rnd = new Random();
        GenericRowData input = GenericRowData.of((Object[])((Object[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)x$4 -> this.ji(rnd.nextInt()), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Integer.class))));
        GenericRowData row = (GenericRowData)projection.apply((RowData)input);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((int)input.getInt(i), (int)row.getInt(i)));
    }

    @Test
    public void testProjectionBinaryRowWithVariableLengthData() {
        Projection projection = (Projection)ProjectionCodeGenerator$.MODULE$.generateProjection(new CodeGeneratorContext((ReadableConfig)new Configuration(), this.classLoader()), "name", RowType.of((LogicalType[])new LogicalType[]{new DecimalType(38, 0), new DecimalType(38, 0), new TimestampType(9)}), RowType.of((LogicalType[])new LogicalType[]{new DecimalType(38, 0), new TimestampType(9), new DecimalType(38, 0)}), new int[]{1, 2, 0}).newInstance(this.classLoader());
        DecimalData decimal = DecimalData.fromBigDecimal((BigDecimal)BigDecimal.valueOf(123L), (int)38, (int)0);
        TimestampData timestamp = TimestampData.fromEpochMillis((long)123L);
        BinaryRowData expected = new BinaryRowData(3);
        BinaryRowWriter writer = new BinaryRowWriter(expected);
        writer.writeDecimal(0, decimal, 38);
        writer.writeTimestamp(1, timestamp, 9);
        writer.writeDecimal(2, decimal, 38);
        writer.complete();
        BinaryRowData actual = (BinaryRowData)projection.apply((RowData)GenericRowData.of((Object[])new Object[]{decimal, decimal, timestamp}));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testProjectionWithIndependentNameCounter() {
        String projectionCode1 = ProjectionCodeGenerator$.MODULE$.generateProjection(new CodeGeneratorContext((ReadableConfig)new Configuration(), this.classLoader()), "name", RowType.of((LogicalType[])new LogicalType[]{new IntType(), new BigIntType()}), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType()}), new int[]{1, 0}).getCode();
        String projectionCode2 = ProjectionCodeGenerator$.MODULE$.generateProjection(new CodeGeneratorContext((ReadableConfig)new Configuration(), this.classLoader()), "name", RowType.of((LogicalType[])new LogicalType[]{new IntType(), new BigIntType()}), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType()}), new int[]{1, 0}).getCode();
        Assertions.assertEquals((Object)projectionCode1, (Object)projectionCode2);
    }

    public Integer ji(int i) {
        return new Integer(i);
    }

    public Long jl(long l) {
        return new Long(l);
    }

    public static final /* synthetic */ IntType $anonfun$testProjectionManyField$1(int x$1) {
        return new IntType();
    }

    public static final /* synthetic */ IntType $anonfun$testProjectionManyFieldGenericRow$1(int x$3) {
        return new IntType();
    }
}

