/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import java.util.Collection;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.util.MockStreamingRuntimeContext;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.calcite.SqlToRexConverter;
import org.apache.flink.table.planner.codegen.WatermarkGeneratorCodeGenTest$;
import org.apache.flink.table.planner.codegen.WatermarkGeneratorCodeGenerator$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.table.runtime.generated.GeneratedWatermarkGenerator;
import org.apache.flink.table.runtime.generated.WatermarkGenerator;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u0001=\u0011QdV1uKJl\u0017M]6HK:,'/\u0019;pe\u000e{G-Z$f]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tqaY8eK\u001e,gN\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002+U\u001cX\rR3gS:,GmQ8ogR\u0014Xo\u0019;peB\u0011\u0011#G\u0005\u00035I\u0011qAQ8pY\u0016\fg\u000eC\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0003=\u0001\u0002\"a\b\u0001\u000e\u0003\tAQaF\u000eA\u0002aAqA\t\u0001C\u0002\u0013\u00051%\u0001\u0007qY\u0006tg.\u001a:N_\u000e\\7/F\u0001%!\t)\u0003&D\u0001'\u0015\t9C!A\u0003vi&d7/\u0003\u0002*M\ta\u0001\u000b\\1o]\u0016\u0014Xj\\2lg\"11\u0006\u0001Q\u0001\n\u0011\nQ\u0002\u001d7b]:,'/T8dWN\u0004\u0003\"B\u0017\u0001\t\u0003q\u0013AC4fiBc\u0017M\u001c8feV\tq\u0006\u0005\u00021g5\t\u0011G\u0003\u00023\t\u000591-\u00197dSR,\u0017B\u0001\u001b2\u0005A1E.\u001b8l!2\fgN\\3s\u00136\u0004H\u000eC\u00047\u0001\t\u0007I\u0011A\u001c\u0002\t\u0011\fG/Y\u000b\u0002qA\u0019\u0011H\u0010!\u000e\u0003iR!a\u000f\u001f\u0002\u0013%lW.\u001e;bE2,'BA\u001f\u0013\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u007fi\u0012A\u0001T5tiB\u0011\u0011iQ\u0007\u0002\u0005*\u0011aGB\u0005\u0003\t\n\u0013abR3oKJL7MU8x\t\u0006$\u0018\r\u0003\u0004G\u0001\u0001\u0006I\u0001O\u0001\u0006I\u0006$\u0018\r\t\u0005\u0006\u0011\u0002!\t!S\u0001\u0017i\u0016\u001cH/Q:dK:$\u0017N\\4XCR,'/\\1sWR\t!\n\u0005\u0002\u0012\u0017&\u0011AJ\u0005\u0002\u0005+:LG\u000f\u000b\u0002H\u001dB\u0011qJV\u0007\u0002!*\u0011\u0011KU\u0001\u0004CBL'BA*U\u0003\u001dQW\u000f]5uKJT!!\u0016\u0007\u0002\u000b),h.\u001b;\n\u0005]\u0003&\u0001\u0004+fgR$V-\u001c9mCR,\u0007\"B-\u0001\t\u0003I\u0015A\b;fgR\u0014u.\u001e8eK\u0012|U\u000f^(g\u001fJ$WM],bi\u0016\u0014X.\u0019:lQ\tAf\nC\u0003]\u0001\u0011\u0005\u0011*A\u000fuKN$H*Z4bGf\u001cUo\u001d;p[&TX\rZ,bi\u0016\u0014X.\u0019:lQ\tYf\nC\u0003`\u0001\u0011\u0005\u0011*A\fuKN$8)^:u_6L'0\u001a3XCR,'/\\1sW\"\u0012aL\u0014\u0005\u0006?\u0002!IA\u0019\u000b\u0003\u0015\u000eDQ\u0001Z1A\u0002a\t\u0001\"[:MK\u001e\f7-\u001f\u0005\u0006M\u0002!IaZ\u0001\u001bO\u0016tWM]1uK^\u000bG/\u001a:nCJ\\w)\u001a8fe\u0006$xN\u001d\u000b\u0004QBl\bCA5o\u001b\u0005Q'BA6m\u0003%9WM\\3sCR,GM\u0003\u0002n\r\u00059!/\u001e8uS6,\u0017BA8k\u0005I9\u0016\r^3s[\u0006\u00148nR3oKJ\fGo\u001c:\t\u000bE,\u0007\u0019\u0001:\u0002\t\u0015D\bO\u001d\t\u0003gjt!\u0001\u001e=\u0011\u0005U\u0014R\"\u0001<\u000b\u0005]t\u0011A\u0002\u001fs_>$h(\u0003\u0002z%\u00051\u0001K]3eK\u001aL!a\u001f?\u0003\rM#(/\u001b8h\u0015\tI(\u0003C\u0003\u0018K\u0002\u0007\u0001\u0004\u000b\u0004\u0001\u007f\u0006-\u0011Q\u0002\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001)\u0002\u0013\u0015DH/\u001a8tS>t\u0017\u0002BA\u0005\u0003\u0007\u0011!\"\u0012=uK:$w+\u001b;i\u0003\u00151\u0018\r\\;fY\t\tya\t\u0002\u0002\u0012A!\u00111CA\u0012\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011!\u00049be\u0006lW\r^3sSj,GM\u0003\u0003\u0002\u001c\u0005u\u0011AC3yi\u0016t7/[8og*\u0019Q+a\b\u000b\u0007\u0005\u0005\u0002\"A\u0005uKN$X\u000f^5mg&!\u0011QEA\u000b\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u000f\u001d\tIC\u0001E\u0001\u0003W\tQdV1uKJl\u0017M]6HK:,'/\u0019;pe\u000e{G-Z$f]R+7\u000f\u001e\t\u0004?\u00055bAB\u0001\u0003\u0011\u0003\tycE\u0002\u0002.AAq\u0001HA\u0017\t\u0003\t\u0019\u0004\u0006\u0002\u0002,!A\u0011qGA\u0017\t\u0003\tI$\u0001\u0006qCJ\fW.\u001a;feN$\"!a\u000f\u0011\u000b\u0005u\u0012q\t\r\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nA!\u001e;jY*\u0011\u0011QI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002J\u0005}\"AC\"pY2,7\r^5p]\"B\u0011QGA'\u0003'\n)\u0006\u0005\u0003\u0002\u0014\u0005=\u0013\u0002BA)\u0003+\u0011!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\u0005]\u0013!G;tK\u0012+g-\u001b8fI\u000e{gn\u001d;sk\u000e$xN]\u001f|au\u0004")
public class WatermarkGeneratorCodeGenTest {
    private final boolean useDefinedConstructor;
    private final PlannerMocks plannerMocks;
    private final List<GenericRowData> data;

    @Parameters(name="useDefinedConstructor={0}")
    public static Collection<Object> parameters() {
        return WatermarkGeneratorCodeGenTest$.MODULE$.parameters();
    }

    public PlannerMocks plannerMocks() {
        return this.plannerMocks;
    }

    public FlinkPlannerImpl getPlanner() {
        return this.plannerMocks().getPlanner();
    }

    public List<GenericRowData> data() {
        return this.data;
    }

    @TestTemplate
    public void testAscendingWatermark() {
        WatermarkGenerator generator = this.generateWatermarkGenerator("ts - INTERVAL '0.001' SECOND", this.useDefinedConstructor);
        List results = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> generator.currentWatermark((RowData)d), List$.MODULE$.canBuildFrom());
        .colon.colon expected = new .colon.colon((Object)999L, (List)new .colon.colon(null, (List)new .colon.colon((Object)2999L, (List)new .colon.colon((Object)4999L, (List)new .colon.colon((Object)3999L, (List)new .colon.colon((Object)5999L, (List)Nil$.MODULE$))))));
        Assertions.assertEquals((Object)expected, (Object)results);
    }

    @TestTemplate
    public void testBoundedOutOfOrderWatermark() {
        WatermarkGenerator generator = this.generateWatermarkGenerator("ts - INTERVAL '5' SECOND", this.useDefinedConstructor);
        List results = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> generator.currentWatermark((RowData)d), List$.MODULE$.canBuildFrom());
        .colon.colon expected = new .colon.colon((Object)-4000L, (List)new .colon.colon(null, (List)new .colon.colon((Object)-2000L, (List)new .colon.colon((Object)0L, (List)new .colon.colon((Object)-1000L, (List)new .colon.colon((Object)1000L, (List)Nil$.MODULE$))))));
        Assertions.assertEquals((Object)expected, (Object)results);
    }

    @TestTemplate
    public void testLegacyCustomizedWatermark() {
        this.testCustomizedWatermark(true);
    }

    @TestTemplate
    public void testCustomizedWatermark() {
        this.testCustomizedWatermark(false);
    }

    private void testCustomizedWatermark(boolean isLegacy) {
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        if (isLegacy) {
            this.plannerMocks().getFunctionCatalog().registerTempCatalogScalarFunction(ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)CatalogManagerMocks.DEFAULT_DATABASE, (String)"myFunc"), (ScalarFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        } else {
            this.plannerMocks().getFunctionCatalog().registerTemporaryCatalogFunction(UnresolvedIdentifier.of((String[])new String[]{CatalogManagerMocks.DEFAULT_CATALOG, CatalogManagerMocks.DEFAULT_DATABASE, "myFunc"}), (FunctionDefinition)new JavaUserDefinedScalarFunctions.JavaFunc5(), false);
        }
        WatermarkGenerator generator = this.generateWatermarkGenerator("myFunc(ts, `offset`)", this.useDefinedConstructor);
        if (!this.useDefinedConstructor) {
            generator.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 1, 0));
        }
        generator.open(DefaultOpenContext.INSTANCE);
        List results = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> generator.currentWatermark((RowData)d), List$.MODULE$.canBuildFrom());
        generator.close();
        .colon.colon expected = new .colon.colon((Object)995L, (List)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon((Object)4997L, (List)new .colon.colon((Object)3990L, (List)new .colon.colon((Object)5992L, (List)Nil$.MODULE$))))));
        Assertions.assertEquals((Object)expected, (Object)results);
        Assertions.assertTrue((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.openCalled);
        Assertions.assertTrue((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled);
    }

    private WatermarkGenerator generateWatermarkGenerator(String expr, boolean useDefinedConstructor) {
        WatermarkGenerator watermarkGenerator;
        RelDataType tableRowType = this.plannerMocks().getPlannerContext().getTypeFactory().buildRelNodeRowType((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ts", "offset"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogicalType[]{new TimestampType(3), new IntType()})));
        RowType rowType = FlinkTypeFactory$.MODULE$.toLogicalRowType(tableRowType);
        SqlToRexConverter converter = ((FlinkContext)this.plannerMocks().getPlanner().createToRelContext().getCluster().getPlanner().getContext().unwrap(FlinkContext.class)).getRexFactory().createSqlToRexConverter(tableRowType, null);
        RexNode rexNode = converter.convertToRexNode(expr);
        if (useDefinedConstructor) {
            GeneratedWatermarkGenerator generated = WatermarkGeneratorCodeGenerator$.MODULE$.generateWatermarkGenerator((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader(), rowType, rexNode, Option$.MODULE$.apply((Object)"context"));
            Object[] newReferences = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(generated.getReferences())).$colon$plus((Object)new WatermarkGeneratorSupplier.Context(null){

                public MetricGroup getMetricGroup() {
                    return null;
                }
            }, ClassTag$.MODULE$.Object());
            watermarkGenerator = (WatermarkGenerator)generated.newInstance(Thread.currentThread().getContextClassLoader(), new Object[]{newReferences});
        } else {
            GeneratedWatermarkGenerator generated = WatermarkGeneratorCodeGenerator$.MODULE$.generateWatermarkGenerator((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader(), rowType, rexNode, WatermarkGeneratorCodeGenerator$.MODULE$.generateWatermarkGenerator$default$5());
            watermarkGenerator = (WatermarkGenerator)generated.newInstance(Thread.currentThread().getContextClassLoader());
        }
        return watermarkGenerator;
    }

    public WatermarkGeneratorCodeGenTest(boolean useDefinedConstructor) {
        this.useDefinedConstructor = useDefinedConstructor;
        this.plannerMocks = PlannerMocks.create();
        this.data = new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)1000L), 5}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{null, 4}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)3000L), null}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)5000L), 3}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)4000L), 10}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)6000L), 8}), (List)Nil$.MODULE$))))));
    }
}

