/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.agg;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.agg.AggTestBase;
import org.apache.flink.table.planner.codegen.agg.AggsHandlerCodeGenerator;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.dataview.StateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001#\ta\u0012iZ4t\u0011\u0006tG\r\\3s\u0007>$WmR3oKJ\fGo\u001c:UKN$(BA\u0002\u0005\u0003\r\twm\u001a\u0006\u0003\u000b\u0019\tqaY8eK\u001e,gN\u0003\u0002\b\u0011\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u0017\u0005;w\rV3ti\n\u000b7/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"a\u0005\u0001\t\u000bm\u0001A\u0011\u0001\u000f\u0002\u000fQ,7\u000f^!wOR\tQ\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0003V]&$\bF\u0001\u000e%!\t)C&D\u0001'\u0015\t9\u0003&A\u0002ba&T!!\u000b\u0016\u0002\u000f),\b/\u001b;fe*\u00111FD\u0001\u0006UVt\u0017\u000e^\u0005\u0003[\u0019\u0012A\u0001V3ti\")q\u0006\u0001C\u00019\u0005\u0011B/Z:u\u0003Z<w+\u001b;i%\u0016$(/Y2uQ\tqC\u0005C\u00033\u0001\u0011\u0005A$\u0001\tuKN$\u0018I^4XSRDW*\u001a:hK\"\u0012\u0011\u0007\n\u0005\u0006k\u0001!IAN\u0001\u0003U2$\"aN \u0011\u0005ajT\"A\u001d\u000b\u0005iZ\u0014\u0001\u00027b]\u001eT\u0011\u0001P\u0001\u0005U\u00064\u0018-\u0003\u0002?s\t!Aj\u001c8h\u0011\u0015\u0001E\u00071\u0001B\u0003\u0005a\u0007C\u0001\u0010C\u0013\tqt\u0004C\u0003E\u0001\u0011%Q)\u0001\u0002kIR\u0011a)\u0013\t\u0003q\u001dK!\u0001S\u001d\u0003\r\u0011{WO\u00197f\u0011\u0015\u00015\t1\u0001K!\tq2*\u0003\u0002I?!)Q\n\u0001C\u0005\u001d\u0006\u0011!\u000e\u001e\u000b\u0004\u001fV;\u0006C\u0001)T\u001b\u0005\t&B\u0001*\t\u0003\u0011!\u0017\r^1\n\u0005Q\u000b&AD$f]\u0016\u0014\u0018n\u0019*po\u0012\u000bG/\u0019\u0005\u0006-2\u0003\r!Q\u0001\u0003YFBQ\u0001\u0017'A\u0002\u0005\u000b!\u0001\u001c\u001a\t\u000bi\u0003A\u0011B.\u0002\u0015\u001d,G\u000fS1oI2,'\u000fF\u0002]I&\u0004\"!\u00182\u000e\u0003yS!a\u00181\u0002\u0013\u001d,g.\u001a:bi\u0016$'BA1\t\u0003\u001d\u0011XO\u001c;j[\u0016L!a\u00190\u0003%\u0005;wm\u001d%b]\u0012dWMR;oGRLwN\u001c\u0005\u0006Kf\u0003\rAZ\u0001\f]\u0016,GMU3ue\u0006\u001cG\u000f\u0005\u0002\u001fO&\u0011\u0001n\b\u0002\b\u0005>|G.Z1o\u0011\u0015Q\u0017\f1\u0001g\u0003%qW-\u001a3NKJ<W\r")
public class AggsHandlerCodeGeneratorTest
extends AggTestBase {
    @Test
    public void testAvg() {
        AggsHandleFunction handler = this.getHandler(false, false);
        handler.resetAccumulators();
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(5L), this.jd(5.3), this.jl(2L)}));
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(6L), this.jd(6.5), this.jl(3L)}));
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(7L), this.jd(7.1), this.jl(4L)}));
        RowData ret = handler.getValue();
        Assertions.assertEquals((float)6.0f, (float)ret.getLong(0), (float)0.0f);
        Assertions.assertEquals((double)6.3, (double)ret.getDouble(1), (double)0.0);
        Assertions.assertEquals((float)3.0f, (float)ret.getLong(2), (float)0.0f);
    }

    @Test
    public void testAvgWithRetract() {
        AggsHandleFunction handler = this.getHandler(true, false);
        handler.resetAccumulators();
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(5L), this.jd(5.3), this.jl(2L)}));
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(6L), this.jd(6.3), this.jl(3L)}));
        handler.accumulate((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(7L), this.jd(7.4), this.jl(4L)}));
        handler.retract((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(9L), this.jd(5.5), this.jl(5L)}));
        RowData ret = handler.getValue();
        Assertions.assertEquals((float)4.0f, (float)ret.getLong(0), (float)0.0f);
        Assertions.assertEquals((double)6.75, (double)ret.getDouble(1), (double)0.0);
        Assertions.assertEquals((float)2.0f, (float)ret.getLong(2), (float)0.0f);
    }

    @Test
    public void testAvgWithMerge() {
        AggsHandleFunction handler = this.getHandler(false, true);
        handler.resetAccumulators();
        handler.merge((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(50L), this.jl(2L), this.jd(5.0), this.jl(2L), this.jt(50L, 2L)}));
        handler.merge((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(40L), this.jl(2L), this.jd(4.0), this.jl(2L), this.jt(40L, 2L)}));
        handler.merge((RowData)GenericRowData.of((Object[])new Object[]{"f0", this.jl(43L), this.jl(1L), this.jd(4.0), this.jl(1L), this.jt(43L, 1L)}));
        RowData ret = handler.getValue();
        Assertions.assertEquals((float)26.0f, (float)ret.getLong(0), (float)0.0f);
        Assertions.assertEquals((double)2.6, (double)ret.getDouble(1), (double)0.0);
        Assertions.assertEquals((float)26.0f, (float)ret.getLong(2), (float)0.0f);
    }

    private Long jl(long l) {
        return new Long(l);
    }

    private Double jd(double l) {
        return new Double(l);
    }

    private GenericRowData jt(long l1, long l2) {
        return GenericRowData.of((Object[])new Object[]{this.jl(l1), this.jl(l2)});
    }

    private AggsHandleFunction getHandler(boolean needRetract, boolean needMerge) {
        AggsHandlerCodeGenerator generator = new AggsHandlerCodeGenerator(this.ctx(), this.relBuilder(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.inputTypes()), true);
        Object object = needRetract ? generator.needRetract() : BoxedUnit.UNIT;
        Object object2 = needMerge ? generator.needMerge(1, true, (DataType[])((Object[])new DataType[]{DataTypes.BIGINT(), DataTypes.BIGINT(), DataTypes.DOUBLE(), DataTypes.BIGINT(), TypeConversions.fromLegacyInfoToDataType(this.imperativeAggFunc().getAccumulatorType())})) : BoxedUnit.UNIT;
        AggsHandleFunction handler = (AggsHandleFunction)generator.needAccumulate().generateAggsHandler("Test", this.aggInfoList()).newInstance(this.classLoader());
        handler.open((StateDataViewStore)new PerKeyStateDataViewStore(this.context().getRuntimeContext()));
        return handler;
    }

    public AggsHandlerCodeGeneratorTest() {
        super(false);
    }
}

