/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.operations.ProjectQueryOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MiniClusterExtension.class})
public class LiteralExpressionsSerializationITCase {
    @Test
    void testSqlSerialization() {
        TableEnvironment env = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
        LocalTime localTime = LocalTime.of(12, 12, 12).plus(333L, ChronoUnit.MILLIS);
        LocalDate localDate = LocalDate.of(2024, 2, 3);
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        Instant instant = Instant.ofEpochMilli(1234567L);
        Duration duration = Duration.ofDays(99L).plusSeconds(34L).plusMillis(999L);
        Period period = Period.ofMonths(470);
        Table t = env.fromValues(new Object[]{1}).select(new Expression[]{Expressions.lit((Object)1, (DataType)((DataType)DataTypes.TINYINT().notNull())), Expressions.lit((Object)1, (DataType)((DataType)DataTypes.SMALLINT().notNull())), Expressions.lit((Object)1, (DataType)((DataType)DataTypes.INT().notNull())), Expressions.lit((Object)1L, (DataType)((DataType)DataTypes.BIGINT().notNull())), Expressions.lit((Object)1.0, (DataType)((DataType)DataTypes.DOUBLE().notNull())), Expressions.lit((Object)Float.valueOf(1.0f), (DataType)((DataType)DataTypes.FLOAT().notNull())), Expressions.lit((Object)"abc", (DataType)((DataType)DataTypes.STRING().notNull())), Expressions.lit((Object)new byte[]{1, 2, 3}, (DataType)((DataType)DataTypes.BYTES().notNull())), Expressions.lit((Object)true, (DataType)((DataType)DataTypes.BOOLEAN().notNull())), Expressions.lit((Object)new BigDecimal("123.456"), (DataType)((DataType)DataTypes.DECIMAL((int)6, (int)3).notNull())), Expressions.lit((Object)new BigDecimal("123.456"), (DataType)((DataType)DataTypes.DECIMAL((int)6, (int)2).notNull())), Expressions.nullOf((DataType)DataTypes.STRING()), Expressions.lit((Object)localDate, (DataType)((DataType)DataTypes.DATE().notNull())), Expressions.lit((Object)localTime, (DataType)((DataType)DataTypes.TIME().notNull())), Expressions.lit((Object)localDateTime, (DataType)((DataType)DataTypes.TIMESTAMP((int)3).notNull())), Expressions.lit((Object)instant, (DataType)((DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull())), Expressions.lit((Object)duration, (DataType)((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND((int)9)).notNull())), Expressions.lit((Object)period, (DataType)((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()).notNull()))});
        ProjectQueryOperation operation = (ProjectQueryOperation)t.getQueryOperation();
        String exprStr = operation.getProjectList().stream().map(ResolvedExpression::asSerializableString).collect(Collectors.joining(",\n"));
        Assertions.assertThat((String)exprStr).isEqualTo("CAST(1 AS TINYINT),\nCAST(1 AS SMALLINT),\n1,\nCAST(1 AS BIGINT),\nCAST(1.0 AS DOUBLE),\nCAST(1.0 AS FLOAT),\n'abc',\nX'010203',\nTRUE,\n123.456,\nCAST(123.456 AS DECIMAL(6, 2)),\nCAST(NULL AS VARCHAR(2147483647)),\nDATE '2024-02-03',\nTIME '12:12:12.333',\nTIMESTAMP '2024-02-03 12:12:12.333',\nTO_TIMESTAMP_LTZ(1234567, 3),\nINTERVAL '99 00:00:34.999' DAY TO SECOND(3),\nINTERVAL '39-2' YEAR TO MONTH");
        TableResult tableResult = env.sqlQuery(String.format("SELECT %s", exprStr)).execute();
        List results = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        Assertions.assertThat((List)results).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{(byte)1, (short)1, 1, 1L, 1.0, Float.valueOf(1.0f), "abc", new byte[]{1, 2, 3}, true, new BigDecimal("123.456"), new BigDecimal("123.46"), null, localDate, localTime, localDateTime, instant, duration, period})});
    }
}

