/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase$;
import org.apache.flink.table.planner.expressions.utils.Func3$;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u001f\tYA*\u001b;fe\u0006dG+Z:u\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003\u001d\u0001H.\u00198oKJT!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\u00111CA\u0001\u0006kRLGn]\u0005\u0003+I\u0011!#\u0012=qe\u0016\u001c8/[8o)\u0016\u001cHOQ1tK\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011A\u0001\u0005\u00069\u0001!\t!H\u0001\u001bi\u0016\u001cHOR5fY\u0012<\u0016\u000e\u001e5C_>dW-\u00198Qe\u00164\u0017\u000e\u001f\u000b\u0002=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t!QK\\5uQ\tYR\u0005\u0005\u0002'[5\tqE\u0003\u0002)S\u0005\u0019\u0011\r]5\u000b\u0005)Z\u0013a\u00026va&$XM\u001d\u0006\u0003Y1\tQA[;oSRL!AL\u0014\u0003\tQ+7\u000f\u001e\u0005\u0006a\u0001!\t!H\u0001\u0014i\u0016\u001cHOT8o\u0003N\u001c\u0017.\u001b'ji\u0016\u0014\u0018\r\u001c\u0015\u0003_\u0015BQa\r\u0001\u0005\u0002u\tq\u0002^3ti\u0012{WO\u00197f#V|G/\u001a\u0015\u0003e\u0015BQA\u000e\u0001\u0005\u0002u\t!\u0003^3tiN#(/\u001b8h\u0019&$XM]1mg\"\u0012Q'\n\u0005\u0006s\u0001!\tEO\u0001\nMVt7\r^5p]N,\u0012a\u000f\t\u0005y\r3\u0015J\u0004\u0002>\u0003B\u0011a\bI\u0007\u0002\u007f)\u0011\u0001ID\u0001\u0007yI|w\u000e\u001e \n\u0005\t\u0003\u0013A\u0002)sK\u0012,g-\u0003\u0002E\u000b\n\u0019Q*\u00199\u000b\u0005\t\u0003\u0003C\u0001\u001fH\u0013\tAUI\u0001\u0004TiJLgn\u001a\t\u0003\u00152k\u0011a\u0013\u0006\u0003s\u0019I!!T&\u0003\u001dM\u001b\u0017\r\\1s\rVt7\r^5p]\")q\n\u0001C!!\u0006AA/Z:u\t\u0006$\u0018-F\u0001R!\t\u0011V+D\u0001T\u0015\t!\u0006\"A\u0003usB,7/\u0003\u0002W'\n\u0019!k\\<\t\u000ba\u0003A\u0011I-\u0002\u0011QL\b/Z%oM>,\u0012A\u0017\t\u00037\u0006l\u0011\u0001\u0018\u0006\u0003;z\u000b\u0011\u0002^=qKV$\u0018\u000e\\:\u000b\u0005}\u0003\u0017\u0001\u00026bm\u0006T!\u0001\u000b\u0005\n\u0005\td&a\u0003*poRK\b/Z%oM>\u0004")
public class LiteralTest
extends ExpressionTestBase {
    @Test
    public void testFieldWithBooleanPrefix() {
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "trUeX")), "trUeX", "trUeX_value");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "FALSE_A")), "FALSE_A", "FALSE_A_value");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "FALSE_AB")), "FALSE_AB", "FALSE_AB_value");
        this.testAllApis(package$.MODULE$.boolean2Literal(true), "trUe", "TRUE");
        this.testAllApis(package$.MODULE$.boolean2Literal(false), "FALSE", "FALSE");
    }

    @Test
    public void testNonAsciiLiteral() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).like((Object)package$.MODULE$.string2Literal("%\u6d4b\u8bd5%")), "f4 LIKE '%\u6d4b\u8bd5%'", "TRUE");
        this.testAllApis(package$.MODULE$.string2Literal("\u0410\u0431\u0432\u0433\u0434\u0435\u8c22\u8c22"), "'\u0410\u0431\u0432\u0433\u0434\u0435' || '\u8c22\u8c22'", "\u0410\u0431\u0432\u0433\u0434\u0435\u8c22\u8c22");
    }

    @Test
    public void testDoubleQuote() {
        String hello = "\"<hello>\"";
        this.testAllApis(package$.MODULE$.ScalarFunctionCall((ScalarFunction)Func3$.MODULE$).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(42), package$.MODULE$.string2Literal(hello)})), new StringBuilder(13).append("Func3(42, '").append(hello).append("')").toString(), new StringBuilder(7).append("42 and ").append(hello).toString());
    }

    @Test
    public void testStringLiterals() {
        this.testAllApis(package$.MODULE$.string2Literal(">\n<"), "'>\n<'", ">\n<");
        this.testAllApis(package$.MODULE$.string2Literal(">\u263a<"), "'>\u263a<'", ">\u263a<");
        this.testAllApis(package$.MODULE$.string2Literal(">\\<"), "'>\\<'", ">\\<");
        this.testAllApis(package$.MODULE$.string2Literal(">'<"), "'>''<'", ">'<");
        this.testAllApis(package$.MODULE$.string2Literal(" "), "' '", " ");
        this.testAllApis(package$.MODULE$.string2Literal(""), "''", "");
        this.testAllApis(package$.MODULE$.string2Literal(">foo([\\w]+)<"), "'>foo([\\w]+)<'", ">foo([\\w]+)<");
        this.testAllApis(package$.MODULE$.string2Literal(">\\'\n<"), "'>\\''\n<'", ">\\'\n<");
        this.testAllApis(package$.MODULE$.string2Literal("It's me."), "'It''s me.'", "It's me.");
        this.testSqlApi("U&'>\\263A<'", ">\u263a<");
        this.testSqlApi("U&'>#263A<' UESCAPE '#'", ">\u263a<");
        this.testSqlApi("'>\\\\<'", ">\\\\<");
    }

    @Override
    public Map<String, ScalarFunction> functions() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Func3"), (Object)Func3$.MODULE$)}));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Row testData() {
        void var1_1;
        Row testData = new Row(4);
        testData.setField(0, (Object)"trUeX_value");
        testData.setField(1, (Object)"FALSE_A_value");
        testData.setField(2, (Object)"FALSE_AB_value");
        testData.setField(3, (Object)"\u8fd9\u662f\u4e2a\u6d4b\u8bd5\u5b57\u7b26\u4e32");
        return var1_1;
    }

    @Override
    public RowTypeInfo typeInfo() {
        return new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.STRING, Types.STRING, Types.STRING, Types.STRING}), (String[])((Object[])new String[]{"trUeX", "FALSE_A", "FALSE_AB", "f4"}));
    }

    public LiteralTest() {
        super(ExpressionTestBase$.MODULE$.$lessinit$greater$default$1());
    }
}

