/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.time.LocalDateTime;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.MapTypeTestBase;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.types.DataType;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u001f\tYQ*\u00199UsB,G+Z:u\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003\u001d\u0001H.\u00198oKJT!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\u00111CA\u0001\u0006kRLGn]\u0005\u0003+I\u0011q\"T1q)f\u0004X\rV3ti\n\u000b7/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAQ\u0001\b\u0001\u0005\u0002u\t1\u0004^3ti&s\u0007/\u001e;UsB,w)\u001a8fe\u0006d\u0017N_1uS>tG#\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\tUs\u0017\u000e\u001e\u0015\u00037\u0015\u0002\"AJ\u0017\u000e\u0003\u001dR!\u0001K\u0015\u0002\u0007\u0005\u0004\u0018N\u0003\u0002+W\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0017\r\u0003\u0015QWO\\5u\u0013\tqsE\u0001\u0003UKN$\b\"\u0002\u0019\u0001\t\u0003i\u0012\u0001\u0003;fgRLE/Z7)\u0005=*\u0003\"B\u001a\u0001\t\u0003i\u0012A\u0004;fgRl\u0015\r\u001d'ji\u0016\u0014\u0018\r\u001c\u0015\u0003e\u0015BQA\u000e\u0001\u0005\u0002u\tA\u0002^3ti6\u000b\u0007OR5fY\u0012D#!N\u0013\t\u000be\u0002A\u0011A\u000f\u0002#Q,7\u000f^'ba>\u0003XM]1uS>t7\u000f\u000b\u00029K!)A\b\u0001C\u0001;\u0005\u0011B/Z:u\u001b\u0006\u0004H+\u001f9f\u0007\u0006\u001cH/\u001b8hQ\tYT\u0005")
public class MapTypeTest
extends MapTypeTestBase {
    @Test
    public void testInputTypeGeneralization() {
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.double2Literal(1.0), package$.MODULE$.string2Literal("ABC"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "MAP[CAST(1 AS DOUBLE), 'ABC']", "{1.0=ABC}");
    }

    @Test
    public void testItem() {
        this.testSqlApi("f0['map is null']", "NULL");
        this.testSqlApi("f1['map is empty']", "NULL");
        this.testSqlApi("f2['b']", "13");
        this.testSqlApi("f3[1]", "NULL");
        this.testSqlApi("f3[12]", "a");
        this.testSqlApi("f2[f3[12]]", "12");
    }

    @Test
    public void testMapLiteral() {
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.int2Literal(1), package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "MAP[1, 1]", "{1=1}");
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.boolean2Literal(true), package$.MODULE$.boolean2Literal(true), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map[TRUE, TRUE]", "{TRUE=TRUE}");
        this.testTableApi(package$.MODULE$.map(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(1)), package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(1)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "{1=1}");
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.map(package$.MODULE$.int2Literal(1), package$.MODULE$.int2Literal(2), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), package$.MODULE$.map(package$.MODULE$.int2Literal(3), package$.MODULE$.int2Literal(4), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "MAP[MAP[1, 2], MAP[3, 4]]", "{{1=2}={3=4}}");
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.int2Literal(1), package$.MODULE$.nullOf(DataTypes.INT()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map[1, NULLIF(1,1)]", "{1=NULL}");
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.int2Literal(1), package$.MODULE$.long2Literal(2L), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "MAP[1, CAST(2 AS BIGINT)]", "{1=2}");
        this.testAllApis(package$.MODULE$.map((Expression)ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localDate("1985-04-11")), (Expression)ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localTime("14:15:16")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "MAP[DATE '1985-04-11', TIME '14:15:16']", "{1985-04-11=14:15:16}");
        this.testTableApi(package$.MODULE$.map((Expression)ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localTime("14:15:16")), (Expression)ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localDateTime("1985-04-11 14:15:16")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "{14:15:16=1985-04-11 14:15:16}");
        this.testSqlApi("MAP[TIME '14:15:16', TIMESTAMP '1985-04-11 14:15:16']", "{14:15:16=1985-04-11 14:15:16}");
        this.testAllApis(package$.MODULE$.map((Expression)ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localTime("14:15:16")), (Expression)ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localDateTime("1985-04-11 14:15:16.123")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "MAP[TIME '14:15:16', TIMESTAMP '1985-04-11 14:15:16.123']", "{14:15:16=1985-04-11 14:15:16.123}");
        this.testTableApi(package$.MODULE$.map((Expression)ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localTime("14:15:16")), (Expression)ApiExpressionUtils.valueLiteral((Object)LocalDateTime.of(1985, 4, 11, 14, 15, 16, 123456000)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "{14:15:16=1985-04-11 14:15:16.123456}");
        this.testSqlApi("MAP[TIME '14:15:16', TIMESTAMP '1985-04-11 14:15:16.123456']", "{14:15:16=1985-04-11 14:15:16.123456}");
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(2.0002)), package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(2.0003)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "MAP[CAST(2.0002 AS DECIMAL(5, 4)), CAST(2.0003 AS DECIMAL(5, 4))]", "{2.0002=2.0003}");
        this.testSqlApi("MAP['k1', CAST(1 AS DOUBLE)]", "{k1=1.0}");
    }

    @Test
    public void testMapField() {
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "MAP[f4, f5]", "{foo=12}");
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "MAP[f4, f1]", "{foo={}}");
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "MAP[f2, f3]", "{{a=12, b=13}={12=a, 13=b}}");
        this.testAllApis(package$.MODULE$.map((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).at((Object)package$.MODULE$.string2Literal("a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "MAP[f1['a'], f5]", "{NULL=12}");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")), "f1", "{}");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), "f2", "{a=12, b=13}");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at((Object)package$.MODULE$.string2Literal("a")), "f2['a']", "12");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).at((Object)package$.MODULE$.int2Literal(12)), "f3[12]", "a");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations(package$.MODULE$.map(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]))).at((Object)package$.MODULE$.string2Literal("foo"))).at((Object)package$.MODULE$.int2Literal(13)), "MAP[f4, f3]['foo'][13]", "b");
    }

    @Test
    public void testMapOperations() {
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))), "f1 = f2", "FALSE");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f3 = f7", "TRUE");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).$eq$eq$eq((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at((Object)package$.MODULE$.string2Literal("a"))), "f5 = f2['a']", "TRUE");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9"))), "f8 = f9", "TRUE");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11"))), "f10 = f11", "TRUE");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9"))), "f8 <> f9", "FALSE");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10")).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11"))), "f10 <> f11", "FALSE");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).at((Object)package$.MODULE$.string2Literal("map is null")), "f0['map is null']", "NULL");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).at((Object)package$.MODULE$.string2Literal("map is empty")), "f1['map is empty']", "NULL");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at((Object)package$.MODULE$.string2Literal("b")), "f2['b']", "13");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).at((Object)package$.MODULE$.int2Literal(1)), "f3[1]", "NULL");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).at((Object)package$.MODULE$.int2Literal(12)), "f3[12]", "a");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).cardinality(), "CARDINALITY(f3)", "2");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at((Object)package$.MODULE$.string2Literal("a"))).isNotNull(), "f2['a'] IS NOT NULL", "TRUE");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at((Object)package$.MODULE$.string2Literal("a"))).isNull(), "f2['a'] IS NULL", "FALSE");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at((Object)package$.MODULE$.string2Literal("c"))).isNotNull(), "f2['c'] IS NOT NULL", "FALSE");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at((Object)package$.MODULE$.string2Literal("c"))).isNull(), "f2['c'] IS NULL", "TRUE");
    }

    @Test
    public void testMapTypeCasting() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).cast(DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT())), "{a=12, b=13}");
    }
}

