/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.TimeZone;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.expressions.DateDiffFun$;
import org.apache.flink.table.planner.expressions.NonDeterministicTest$;
import org.apache.flink.table.planner.expressions.TimeDiffFun$;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase;
import org.apache.flink.table.planner.utils.InternalConfigOptions;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001=\u0011ACT8o\t\u0016$XM]7j]&\u001cH/[2UKN$(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011a\u00029mC:tWM\u001d\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\u0005\u0005)Q\u000f^5mg&\u0011QC\u0005\u0002\u0013\u000bb\u0004(/Z:tS>tG+Z:u\u0005\u0006\u001cX\r\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003-I7o\u0015;sK\u0006l\u0017N\\4\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\u000f\t{w\u000e\\3b]\")q\u0004\u0001C\u0001A\u00051A(\u001b8jiz\"\"!I\u0012\u0011\u0005\t\u0002Q\"\u0001\u0002\t\u000b]q\u0002\u0019\u0001\r\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002CQ,7\u000f\u001e+f[B|'/\u00197Gk:\u001cG/[8og&s7\u000b\u001e:fC6lu\u000eZ3\u0015\u0003\u001d\u0002\"!\u0007\u0015\n\u0005%R\"\u0001B+oSRD#\u0001J\u0016\u0011\u00051\u001aT\"A\u0017\u000b\u00059z\u0013aA1qS*\u0011\u0001'M\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0011D\"A\u0003kk:LG/\u0003\u00025[\taA+Z:u)\u0016l\u0007\u000f\\1uK\")a\u0007\u0001C\u0001M\u0005\u0001C/Z:u)\u0016l\u0007o\u001c:bY\u001a+hn\u0019;j_:\u001c\u0018J\u001c\"bi\u000eDWj\u001c3fQ\t)4\u0006C\u0003:\u0001\u0011\u0005a%A\u0016uKN$8)\u001e:sK:$(k\\<US6,7\u000f^1na\u001a+hn\u0019;j_:\u001c\u0018J\u001c\"bi\u000eDWj\u001c3fQ\tA4\u0006C\u0003=\u0001\u0011\u0005a%\u0001\u000euKN$H+Z7q_J\fGNR;oGRLwN\\:J]V#6\t\u000b\u0002<W!)q\b\u0001C\u0001M\u0005yB/Z:u)\u0016l\u0007o\u001c:bY\u001a+hn\u0019;j_:\u001c\u0018J\\*iC:<\u0007.Y5)\u0005yZ\u0003\"\u0002\"\u0001\t\u0013\u0019\u0015\u0001F:fi\u0016\u0003xn\u00195B]\u0012dunY1m)&lW\r\u0006\u0002(\t\")Q)\u0011a\u0001\r\u00061!p\u001c8f\u0013\u0012\u0004\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\tQLW.\u001a\u0006\u0002\u0017\u0006!!.\u0019<b\u0013\ti\u0005J\u0001\u0004[_:,\u0017\n\u001a\u0005\u0006\u001f\u0002!I\u0001U\u0001\u0016i\u0016\u001cH\u000fV3na>\u0014\u0018\r\u001c+j[\u0016\u001cH/Y7q)\t9\u0013\u000bC\u0003F\u001d\u0002\u0007a\tC\u0003T\u0001\u0011\u0005a%\u0001\u0005uKN$X+V%EQ\t\u00116\u0006C\u0003W\u0001\u0011\u0005a%\u0001\u0005uKN$(+\u00198eQ\t)6\u0006C\u0003Z\u0001\u0011\u0005#,\u0001\u0005uKN$H)\u0019;b+\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u00010\t\u0003\u0015!\u0018\u0010]3t\u0013\t\u0001WLA\u0002S_^DQA\u0019\u0001\u0005B\r\f\u0001\u0002^=qK&sgm\\\u000b\u0002IB\u0011QM[\u0007\u0002M*\u0011q\r[\u0001\nif\u0004X-\u001e;jYNT!aS5\u000b\u00059B\u0011BA6g\u0005-\u0011vn\u001e+za\u0016LeNZ8\t\u000b5\u0004A\u0011\t8\u0002\u0013\u0019,hn\u0019;j_:\u001cX#A8\u0011\tA<(0 \b\u0003cV\u0004\"A\u001d\u000e\u000e\u0003MT!\u0001\u001e\b\u0002\rq\u0012xn\u001c;?\u0013\t1($\u0001\u0004Qe\u0016$WMZ\u0005\u0003qf\u00141!T1q\u0015\t1(\u0004\u0005\u0002qw&\u0011A0\u001f\u0002\u0007'R\u0014\u0018N\\4\u0011\u0007y\f\t!D\u0001\u0000\u0015\tig!C\u0002\u0002\u0004}\u0014abU2bY\u0006\u0014h)\u001e8di&|g\u000eK\u0004\u0001\u0003\u000f\t\u0019\"!\u0006\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004.\u0003%)\u0007\u0010^3og&|g.\u0003\u0003\u0002\u0012\u0005-!AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\u0012\u0011qC\u0012\u0003\u00033\u0001B!a\u0007\u0002,5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#A\u0007qCJ\fW.\u001a;fe&TX\r\u001a\u0006\u0005\u0003G\t)#\u0001\u0006fqR,gn]5p]NT1AMA\u0014\u0015\r\tI\u0003C\u0001\ni\u0016\u001cH/\u001e;jYNLA!!\f\u0002\u001e\tQ\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;FqR,gn]5p]\u001e9\u0011\u0011\u0007\u0002\t\u0002\u0005M\u0012\u0001\u0006(p]\u0012+G/\u001a:nS:L7\u000f^5d)\u0016\u001cH\u000fE\u0002#\u0003k1a!\u0001\u0002\t\u0002\u0005]2\u0003BA\u001b\u0003s\u00012!GA\u001e\u0013\r\tiD\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000f}\t)\u0004\"\u0001\u0002BQ\u0011\u00111\u0007\u0005\t\u0003\u000b\n)\u0004\"\u0001\u0002H\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\u0005%\u0003#BA&\u0003#BRBAA'\u0015\r\tyES\u0001\u0005kRLG.\u0003\u0003\u0002T\u00055#AC\"pY2,7\r^5p]\"B\u00111IA,\u0003;\ny\u0006\u0005\u0003\u0002\u001c\u0005e\u0013\u0002BA.\u0003;\u0011!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\u0005\u0005\u0014\u0001D5t'R\u0014X-Y7>wBj\b")
public class NonDeterministicTest
extends ExpressionTestBase {
    private final boolean isStreaming;

    @Parameters(name="isStream={0}")
    public static Collection<Object> parameters() {
        return NonDeterministicTest$.MODULE$.parameters();
    }

    @TestTemplate
    public void testTemporalFunctionsInStreamMode() {
        Assumptions.assumeThat((boolean)this.isStreaming).isTrue();
        GeneratedFunction<MapFunction<RowData, BinaryRowData>> temporalFunctions = this.getCodeGenFunctions((List<String>)new .colon.colon((Object)"CURRENT_DATE", (List)new .colon.colon((Object)"CURRENT_TIME", (List)new .colon.colon((Object)"CURRENT_TIMESTAMP", (List)new .colon.colon((Object)"CURRENT_ROW_TIMESTAMP()", (List)new .colon.colon((Object)"NOW()", (List)new .colon.colon((Object)"LOCALTIME", (List)new .colon.colon((Object)"LOCALTIMESTAMP", (List)Nil$.MODULE$))))))));
        List<String> round1 = this.evaluateFunctionResult(temporalFunctions);
        Thread.sleep(1000L);
        List<String> round2 = this.evaluateFunctionResult(temporalFunctions);
        Assertions.assertThat((int)round2.size()).isEqualTo(round2.size());
        ((List)((IterableLike)round1.zip(round2, List$.MODULE$.canBuildFrom())).zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            NonDeterministicTest.$anonfun$testTemporalFunctionsInStreamMode$1(x0$1);
            return BoxedUnit.UNIT;
        });
        int currentTimeStampIndex = 2;
        int currentRowTimestampIndex = 3;
        Assertions.assertThat((String)((String)round1.apply(currentTimeStampIndex))).isEqualTo((String)round1.apply(currentRowTimestampIndex));
        Assertions.assertThat((String)((String)round2.apply(currentTimeStampIndex))).isEqualTo((String)round2.apply(currentRowTimestampIndex));
    }

    @TestTemplate
    public void testTemporalFunctionsInBatchMode() {
        Assumptions.assumeThat((boolean)this.isStreaming).isFalse();
        ZoneId zoneId = ZoneId.of("Asia/Shanghai");
        this.tableConfig().setLocalTimeZone(zoneId);
        this.tableConfig().set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
        this.tableConfig().set(InternalConfigOptions.TABLE_QUERY_START_EPOCH_TIME, (Object)BoxesRunTime.boxToLong((long)1123L));
        this.tableConfig().set(InternalConfigOptions.TABLE_QUERY_START_LOCAL_TIME, (Object)BoxesRunTime.boxToLong((long)(1123L + (long)TimeZone.getTimeZone(zoneId).getOffset(1123L))));
        GeneratedFunction<MapFunction<RowData, BinaryRowData>> temporalFunctions = this.getCodeGenFunctions((List<String>)new .colon.colon((Object)"CURRENT_DATE", (List)new .colon.colon((Object)"CURRENT_TIME", (List)new .colon.colon((Object)"CURRENT_TIMESTAMP", (List)new .colon.colon((Object)"NOW()", (List)new .colon.colon((Object)"LOCALTIME", (List)new .colon.colon((Object)"LOCALTIMESTAMP", (List)Nil$.MODULE$)))))));
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01", "08:00:01", "1970-01-01 08:00:01.123", "1970-01-01 08:00:01.123", "08:00:01", "1970-01-01 08:00:01.123"}));
        List<String> result = this.evaluateFunctionResult(temporalFunctions);
        Assertions.assertThat((Object)result.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.toList().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testCurrentRowTimestampFunctionsInBatchMode() {
        Assumptions.assumeThat((boolean)this.isStreaming).isFalse();
        GeneratedFunction<MapFunction<RowData, BinaryRowData>> temporalFunctions = this.getCodeGenFunctions((List<String>)new .colon.colon((Object)"CURRENT_ROW_TIMESTAMP()", (List)Nil$.MODULE$));
        List<String> round1 = this.evaluateFunctionResult(temporalFunctions);
        Thread.sleep(1000L);
        List<String> round2 = this.evaluateFunctionResult(temporalFunctions);
        Assumptions.assumeThat((int)round2.size()).isEqualTo(round1.size());
        ((List)round1.zip(round2, List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            NonDeterministicTest.$anonfun$testCurrentRowTimestampFunctionsInBatchMode$1(x0$2);
            return BoxedUnit.UNIT;
        });
    }

    @TestTemplate
    public void testTemporalFunctionsInUTC() {
        this.testTemporalTimestamp(ZoneId.of("UTC"));
    }

    @TestTemplate
    public void testTemporalFunctionsInShanghai() {
        this.testTemporalTimestamp(ZoneId.of("Asia/Shanghai"));
    }

    private void setEpochAndLocalTime(ZoneId zoneId) {
        this.tableConfig().setLocalTimeZone(zoneId);
        Long epochTime = Predef$.MODULE$.long2Long(System.currentTimeMillis());
        this.tableConfig().set(InternalConfigOptions.TABLE_QUERY_START_EPOCH_TIME, (Object)epochTime);
        Long localTime = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(epochTime) + (long)TimeZone.getTimeZone(TableConfigUtils.getLocalTimeZone((ReadableConfig)this.tableConfig())).getOffset(Predef$.MODULE$.Long2long(epochTime)));
        this.tableConfig().set(InternalConfigOptions.TABLE_QUERY_START_LOCAL_TIME, (Object)localTime);
    }

    private void testTemporalTimestamp(ZoneId zoneId) {
        this.setEpochAndLocalTime(zoneId);
        LocalDateTime localDateTime = LocalDateTime.now(zoneId);
        String formattedLocalTime = localDateTime.toLocalTime().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        String formattedLocalDateTime = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String formattedCurrentDate = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String formattedCurrentTime = localDateTime.toLocalTime().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        String formattedCurrentTimestamp = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.testSqlApi(new StringBuilder(37).append("TIME_SUB(LOCALTIME, TIME '").append(formattedLocalTime).append("') <= 60000").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(57).append("TIMESTAMPDIFF(SECOND, TIMESTAMP '").append(formattedLocalDateTime).append("', LOCALTIMESTAMP) <= 60").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(36).append("DATE_SUB(CURRENT_DATE, DATE '").append(formattedCurrentDate).append("') >= 0").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(40).append("TIME_SUB(CURRENT_TIME, TIME '").append(formattedCurrentTime).append("') <= 60000").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(48).append("TIMESTAMPDIFF(SECOND, ").append(this.timestampLtz(formattedCurrentTimestamp)).append(", CURRENT_TIMESTAMP) <= 60").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(36).append("TIMESTAMPDIFF(SECOND, ").append(this.timestampLtz(formattedCurrentTimestamp)).append(", NOW()) <= 60").toString(), "TRUE");
        this.testSqlApi(new StringBuilder(22).append("TIMESTAMPDIFF(SECOND, ").append(new StringBuilder(32).append(this.timestampLtz(formattedCurrentTimestamp)).append(", CURRENT_ROW_TIMESTAMP()) <= 60").toString()).toString(), "TRUE");
    }

    @TestTemplate
    public void testUUID() {
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.uuid()).charLength(), "CHARACTER_LENGTH(UUID())", "36");
    }

    @TestTemplate
    public void testRand() {
        this.testSqlApi("RAND() <> RAND() or RAND() = RAND()", "TRUE");
        this.testSqlApi("RAND(1) <> RAND(1) or RAND(1) = RAND(1)", "TRUE");
        this.testSqlApi("RAND_INTEGER(10) <> RAND_INTEGER(10) or RAND_INTEGER(10) = RAND_INTEGER(10)", "TRUE");
    }

    @Override
    public Row testData() {
        return new Row(0);
    }

    @Override
    public RowTypeInfo typeInfo() {
        return new RowTypeInfo(new TypeInformation[0]);
    }

    @Override
    public Map<String, ScalarFunction> functions() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TIME_SUB"), (Object)TimeDiffFun$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DATE_SUB"), (Object)DateDiffFun$.MODULE$)}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$testTemporalFunctionsInStreamMode$1(Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        int index = tuple2._2$mcI$sp();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        String result1 = (String)tuple22._1();
        String result2 = (String)tuple22._2();
        if (result1 == null) throw new MatchError((Object)tuple2);
        String string = result1;
        if (result2 == null) throw new MatchError((Object)tuple2);
        String string2 = result2;
        int n = index;
        if (n == 0) {
            Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(string)).$less$eq((Object)string2));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(string)).$less((Object)string2));
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$testCurrentRowTimestampFunctionsInBatchMode$1(Tuple2 x0$2) {
        String string;
        String result2;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$2;
                if (tuple2 == null) break block2;
                String result1 = (String)tuple2._1();
                result2 = (String)tuple2._2();
                if (result1 == null) break block2;
                string = result1;
                if (result2 != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        String string2 = result2;
        Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(string)).$less((Object)string2));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public NonDeterministicTest(boolean isStreaming) {
        this.isStreaming = isStreaming;
        super(isStreaming);
    }
}

