/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Locale;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase$;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0001\u0003\u0001=\u0011\u0011\u0003V3na>\u0014\u0018\r\u001c+za\u0016\u001cH+Z:u\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003\u001d\u0001H.\u00198oKJT!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\u00111CA\u0001\u0006kRLGn]\u0005\u0003+I\u0011!#\u0012=qe\u0016\u001c8/[8o)\u0016\u001cHOQ1tK\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011A\u0001\u0005\u00069\u0001!\t!H\u0001\u0016i\u0016\u001cH\u000fV5nKB{\u0017N\u001c;MSR,'/\u00197t)\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSRD#aG\u0013\u0011\u0005\u0019jS\"A\u0014\u000b\u0005!J\u0013aA1qS*\u0011!fK\u0001\bUV\u0004\u0018\u000e^3s\u0015\taC\"A\u0003kk:LG/\u0003\u0002/O\t!A+Z:u\u0011\u0015\u0001\u0004\u0001\"\u0001\u001e\u0003a!Xm\u001d;US6,\u0017J\u001c;feZ\fG\u000eT5uKJ\fGn\u001d\u0015\u0003_\u0015BQa\r\u0001\u0005\u0002u\t!\u0003^3tiRKW.\u001a)pS:$\u0018J\u001c9vi\"\u0012!'\n\u0005\u0006m\u0001!\t!H\u0001\u0016i\u0016\u001cH\u000fV5nK&sG/\u001a:wC2Le\u000e];uQ\t)T\u0005C\u0003:\u0001\u0011\u0005Q$\u0001\u000buKN$H+[7f!>Lg\u000e^\"bgRLgn\u001a\u0015\u0003q\u0015BQ\u0001\u0010\u0001\u0005\u0002u\t\u0011\u0004^3tiRKW.Z:uC6\u0004H\n\u001e>DCN$\u0018J\\+U\u0007\"\u00121(\n\u0005\u0006\u007f\u0001!\t!H\u0001\u001fi\u0016\u001cH\u000fV5nKN$\u0018-\u001c9Mij\u001c\u0015m\u001d;J]NC\u0017M\\4iC&D#AP\u0013\t\u000b\t\u0003A\u0011A\u000f\u0002YQ,7\u000f^%om\u0006d\u0017\u000eZ\"bgR\u0014U\r^<fK:tU/\\3sS\u000e\fe\u000e\u001a+j[\u0016\u001cH/Y7q\u0019RT\bFA!&\u0011\u0015)\u0005\u0001\"\u0001\u001e\u0003%\"Xm\u001d;J]Z\fG.\u001b3DCN$()\u001a;xK\u0016tg*^7fe&\u001c\u0017I\u001c3US6,7\u000f^1na\"\u0012A)\n\u0005\u0006\u0011\u0002!\t!H\u0001\u0018i\u0016\u001cH\u000fV5nK&sG/\u001a:wC2\u001c\u0015m\u001d;j]\u001eD#aR\u0013\t\u000b-\u0003A\u0011A\u000f\u0002/Q,7\u000f\u001e+j[\u0016\u0004v.\u001b8u\u0007>l\u0007/\u0019:jg>t\u0007F\u0001&&\u0011\u0015q\u0005\u0001\"\u0001\u001e\u0003i!Xm\u001d;US6,\u0017J\u001c;feZ\fG.\u0011:ji\"lW\r^5dQ\tiU\u0005C\u0003R\u0001\u0011\u0005Q$\u0001\u000buKN$8+\u001a7fGRtU\u000f\u001c7WC2,Xm\u001d\u0015\u0003!\u0016BQ\u0001\u0016\u0001\u0005\u0002u\ta\u0003^3tiR+W\u000e]8sC2tU\u000f\u001c7WC2,Xm\u001d\u0015\u0003'\u0016BQa\u0016\u0001\u0005\u0002u\ta\u0002^3ti\u0012\u000bG/\u001a$pe6\fG\u000f\u000b\u0002WK!)!\f\u0001C\u0001;\u00051B/Z:u\t\u0006$XMR8s[\u0006$8\u000b[1oO\"\f\u0017\u000e\u000b\u0002ZK!)Q\f\u0001C\u0001;\u0005AB/Z:u\t\u0006$XMR8s[\u0006$Hj\\:B]\u001e,G.Z:)\u0005q+\u0003\"\u00021\u0001\t\u0003i\u0012a\u0004;fgR$\u0015\r^3B]\u0012$\u0016.\\3)\u0005}+\u0003\"B2\u0001\t\u0003i\u0012\u0001\u0006;fgR$V-\u001c9pe\u0006d7\u000b[1oO\"\f\u0017\u000e\u000b\u0002cK!)a\r\u0001C\u0001;\u0005QB/Z:u\t\u0006LH.[4iiN\u000bg/\u001b8h)&lWMW8oK\"\u0012Q-\n\u0005\u0006S\u0002!\t!H\u0001\u001ci\u0016\u001cH\u000fS8veVs\u0017\u000e\u001e*b]\u001e|wN\u001c+j[\u0016TvN\\3)\u0005!,\u0003\"\u00027\u0001\t\u0003i\u0012!\u0005;fgRtU\u000f\u001c7bE2,7)Y:fg\"\u00121.\n\u0005\u0006_\u0002!\t!H\u0001\u0015i\u0016\u001cH/\u00138wC2LG-\u00138qkR\u001c\u0015m]3)\u00059,\u0003\"\u0002:\u0001\t\u0003i\u0012!\t;fgR$\u0016\u0010]3J]\u001a,'/\u001a8dK^KG\u000f[%om\u0006d\u0017\u000eZ%oaV$\bFA9&\u0011\u0015)\b\u0001\"\u0001\u001e\u00035!Xm\u001d;D_:4XM\u001d;U5\"\u0012A/\n\u0005\u0006q\u0002!\t!H\u0001\u0011i\u0016\u001cHO\u0012:p[Vs\u0017\u000e\u001f+j[\u0016D#a^\u0013\t\u000bm\u0004A\u0011A\u000f\u0002/Q,7\u000f\u001e$s_6,f.\u001b=US6,\u0017J\u001c+pWf|\u0007F\u0001>&\u0011\u0015q\b\u0001\"\u0001\u001e\u0003E!Xm\u001d;V]&DH+[7fgR\fW\u000e\u001d\u0015\u0003{\u0016Ba!a\u0001\u0001\t\u0003i\u0012\u0001\u0007;fgR,f.\u001b=US6,7\u000f^1na&sGk\\6z_\"\u001a\u0011\u0011A\u0013\t\r\u0005%\u0001\u0001\"\u0001\u001e\u0003!\"Xm\u001d;U_RKW.Z*uC6\u0004h)\u001e8di&|gnV5uQ\"Kw\r\u001b)sK\u000eL7/[8oQ\r\t9!\n\u0005\u0007\u0003\u001f\u0001A\u0011A\u000f\u00025Q,7\u000f\u001e%jO\"\u0004&/Z2jg&|g\u000eV5nKN$\u0018-\u001c9)\u0007\u00055Q\u0005\u0003\u0004\u0002\u0016\u0001!\t!H\u0001\u001bi\u0016\u001cH\u000fV8US6,7\u000f^1na2#(p\u00155b]\u001eD\u0017-\u001b\u0015\u0004\u0003')\u0003BBA\u000e\u0001\u0011\u0005Q$A\u000buKN$Hk\u001c+j[\u0016\u001cH/Y7q\u0019RTX\u000bV\")\u0007\u0005eQ\u0005\u0003\u0004\u0002\"\u0001!\t!H\u0001\u001ei\u0016\u001cHOQ8v]\u0012\f'/\u001f$peR{G+[7fgR\fW\u000e\u001d'uu\"\u001a\u0011qD\u0013\t\r\u0005\u001d\u0002\u0001\"\u0001\u001e\u0003e!Xm\u001d;J]Z\fG.\u001b3U_RKW.Z:uC6\u0004H\n\u001e>)\u0007\u0005\u0015R\u0005\u0003\u0004\u0002.\u0001!\t!H\u0001\u0012i\u0016\u001cH\u000fV5nKN$\u0018-\u001c9ES\u001a4\u0007fAA\u0016K!1\u00111\u0007\u0001\u0005\u0002u\t!\u0004^3tiRKW.Z:uC6\u0004H\n\u001e>Be&$\b.\\3uS\u000eD3!!\r&\u0011\u0019\tI\u0004\u0001C\u0001;\u0005\tC/Z:u\u0013:4\u0018\r\\5e)&lWm\u001d;b[BdEO_!sSRDW.\u001a;jG\"\u001a\u0011qG\u0013\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B\u0005AA/Z:u\t\u0006$\u0018-\u0006\u0002\u0002DA!\u0011QIA&\u001b\t\t9EC\u0002\u0002J!\tQ\u0001^=qKNLA!!\u0014\u0002H\t\u0019!k\\<\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T\u0005aA/Z:u\t\u0006$\u0018\rV=qKV\u0011\u0011Q\u000b\t\u0005\u0003/\nY&\u0004\u0002\u0002Z)\u0019\u0011\u0011\n\u0004\n\t\u0005u\u0013\u0011\f\u0002\t\t\u0006$\u0018\rV=qK\"9\u0011\u0011\r\u0001\u0005B\u0005\r\u0014aE2p]R\f\u0017N\\:MK\u001e\f7-\u001f+za\u0016\u001cXCAA3!\ry\u0012qM\u0005\u0004\u0003S\u0002#a\u0002\"p_2,\u0017M\u001c")
public class TemporalTypesTest
extends ExpressionTestBase {
    @Test
    public void testTimePointLiterals() {
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("1990-10-14").toDate(), "DATE '1990-10-14'", "1990-10-14");
        this.testTableApi(package$.MODULE$.localDate2Literal(DateTimeTestUtil$.MODULE$.localDate("2040-09-11")), "2040-09-11");
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("1500-04-30").cast(DataTypes.DATE()), "CAST('1500-04-30' AS DATE)", "1500-04-30");
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("15:45:59").toTime(), "TIME '15:45:59'", "15:45:59");
        this.testTableApi(package$.MODULE$.localTime2Literal(DateTimeTestUtil$.MODULE$.localTime("00:00:00")), "00:00:00");
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("1:30:00").cast(DataTypes.TIME()), "CAST('1:30:00' AS TIME)", "01:30:00");
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("1990-10-14 23:00:00.123").toTimestamp(), "TIMESTAMP '1990-10-14 23:00:00.123'", "1990-10-14 23:00:00.123");
        this.testTableApi(package$.MODULE$.localDateTime2Literal(DateTimeTestUtil$.MODULE$.localDateTime("2040-09-11 00:00:00.000")), "2040-09-11 00:00:00");
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("1500-04-30 12:00:00").cast(DataTypes.TIMESTAMP((int)3)), "CAST('1500-04-30 12:00:00' AS TIMESTAMP(3))", "1500-04-30 12:00:00.000");
        this.testSqlApi("TIMESTAMP '1500-04-30 12:00:00.123456789'", "1500-04-30 12:00:00.123456789");
        this.testSqlApi("TIMESTAMP '1500-04-30 12:00:00.12345678'", "1500-04-30 12:00:00.12345678");
        this.testSqlApi("TIMESTAMP '1500-04-30 12:00:00.123456'", "1500-04-30 12:00:00.123456");
        this.testSqlApi("TIMESTAMP '1500-04-30 12:00:00.1234'", "1500-04-30 12:00:00.1234");
        this.testSqlApi("CAST('1500-04-30 12:00:00.123456789' AS TIMESTAMP(9))", "1500-04-30 12:00:00.123456789");
        this.testSqlApi("CAST('1500-04-30 12:00:00.123456789' AS TIMESTAMP)", "1500-04-30 12:00:00.123456");
        this.testSqlApi("CAST('1999-9-10 05:20:10.123456' AS TIMESTAMP)", "1999-09-10 05:20:10.123456");
        this.testSqlApi("CAST('1999-9-10' AS TIMESTAMP)", "1999-09-10 00:00:00.000000");
    }

    @Test
    public void testTimeIntervalLiterals() {
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(1).year(), "INTERVAL '1' YEAR", "+1-00");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(1).month(), "INTERVAL '1' MONTH", "+0-01");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(12).days(), "INTERVAL '12' DAY", "+12 00:00:00.000");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(1).hour(), "INTERVAL '1' HOUR", "+0 01:00:00.000");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(3).minutes(), "INTERVAL '3' MINUTE", "+0 00:03:00.000");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(3).seconds(), "INTERVAL '3' SECOND", "+0 00:00:03.000");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(3).millis(), "INTERVAL '0.003' SECOND", "+0 00:00:00.003");
    }

    @Test
    public void testTimePointInput() {
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), "f0", "1990-10-14");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")), "f1", "10:20:45");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), "f2", "1990-10-14 10:20:45.123");
    }

    @Test
    public void testTimeIntervalInput() {
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9")), "f9", "+2-00");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10")), "f10", "+0 00:00:12.000");
    }

    @Test
    public void testTimePointCasting() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).cast(DataTypes.TIMESTAMP((int)3)), "CAST(f0 AS TIMESTAMP(3))", "1990-10-14 00:00:00.000");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).cast(DataTypes.TIMESTAMP((int)3)), "CAST(f1 AS TIMESTAMP(3))", "1970-01-01 10:20:45.000");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).cast(DataTypes.DATE()), "CAST(f2 AS DATE)", "1990-10-14");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).cast(DataTypes.TIME()), "CAST(f2 AS TIME)", "10:20:45");
    }

    @Test
    public void testTimestampLtzCastInUTC() {
        this.tableConfig().setLocalTimeZone(ZoneId.of("UTC"));
        this.testSqlApi("CAST(f0 AS TIMESTAMP_LTZ(3))", "1990-10-14 00:00:00.000");
        this.testSqlApi("CAST(f1 AS TIMESTAMP_LTZ(3))", "1970-01-01 10:20:45.000");
        this.testSqlApi(new StringBuilder(14).append("CAST(").append(this.timestampLtz("2018-03-14 01:02:03")).append(" AS TIME)").toString(), "01:02:03");
        this.testSqlApi(new StringBuilder(14).append("CAST(").append(this.timestampLtz("2018-03-14 01:02:03")).append(" AS DATE)").toString(), "2018-03-14");
    }

    @Test
    public void testTimestampLtzCastInShanghai() {
        this.tableConfig().setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        this.testSqlApi("CAST(f0 AS TIMESTAMP_LTZ(3))", "1990-10-14 00:00:00.000");
        this.testSqlApi("CAST(f1 AS TIMESTAMP_LTZ(3))", "1970-01-01 10:20:45.000");
        this.testSqlApi("CAST(f2 AS TIMESTAMP_LTZ(3))", "1990-10-14 10:20:45.123");
        this.testSqlApi(new StringBuilder(14).append("CAST(").append(this.timestampLtz("2018-03-14 01:02:03")).append(" AS TIME)").toString(), "01:02:03");
        this.testSqlApi(new StringBuilder(14).append("CAST(").append(this.timestampLtz("2018-03-14 01:02:03")).append(" AS DATE)").toString(), "2018-03-14");
        this.testSqlApi(new StringBuilder(22).append("CAST(").append(this.timestampLtz("2018-03-14 01:02:03")).append(" AS TIMESTAMP(3))").toString(), "2018-03-14 01:02:03.000");
        this.testSqlApi(new StringBuilder(26).append("CAST(").append(this.timestampLtz("1970-01-01 08:00:01.123456")).append(" AS TIMESTAMP_LTZ(3))").toString(), "1970-01-01 08:00:01.123");
        this.testSqlApi(new StringBuilder(26).append("CAST(").append(this.timestampLtz("1970-01-01 08:00:01.123456")).append(" AS TIMESTAMP_LTZ(6))").toString(), "1970-01-01 08:00:01.123456");
        this.testSqlApi(new StringBuilder(26).append("CAST(").append(this.timestampLtz("1970-01-01 08:00:01.123456")).append(" AS TIMESTAMP_LTZ(9))").toString(), "1970-01-01 08:00:01.123456000");
    }

    @Test
    public void testInvalidCastBetweenNumericAndTimestampLtz() {
        String castFromTimestampLtzExceptionMsg = "The cast from TIMESTAMP_LTZ type to NUMERIC type is not allowed.";
        String castToTimestampLtzExceptionMsg = "The cast from NUMERIC type to TIMESTAMP_LTZ type is not allowed. It's recommended to use TO_TIMESTAMP_LTZ(numeric_col, precision) instead.";
        this.testExpectedSqlException("CAST(CAST(100 AS TINYINT) AS TIMESTAMP_LTZ(3))", castToTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(100 AS SMALLINT) AS TIMESTAMP_LTZ(3))", castToTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(100 AS TIMESTAMP_LTZ(3))", castToTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(100 AS BIGINT) AS TIMESTAMP_LTZ(3))", castToTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(100.01 AS FLOAT) AS TIMESTAMP_LTZ(3))", castToTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(100.123 AS DOUBLE) AS TIMESTAMP_LTZ(3))", castToTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(100.1234 as DECIMAL(38, 18)) AS TIMESTAMP_LTZ(3))", castToTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException(new StringBuilder(17).append("CAST(").append(this.timestampLtz("1970-01-01 08:02:03.123")).append(" AS TINYINT)").toString(), castFromTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException(new StringBuilder(18).append("CAST(").append(this.timestampLtz("1970-01-01 08:02:03.123")).append(" AS SMALLINT)").toString(), castFromTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException(new StringBuilder(13).append("CAST(").append(this.timestampLtz("1970-01-01 08:02:03.123")).append(" AS INT)").toString(), castFromTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException(new StringBuilder(16).append("CAST(").append(this.timestampLtz("1970-01-01 08:02:03.123")).append(" AS BIGINT)").toString(), castFromTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException(new StringBuilder(15).append("CAST(").append(this.timestampLtz("1970-01-01 08:02:03.123")).append(" AS FLOAT)").toString(), castFromTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException(new StringBuilder(16).append("CAST(").append(this.timestampLtz("1970-01-01 08:02:03.123")).append(" AS DOUBLE)").toString(), castFromTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException(new StringBuilder(24).append("CAST(").append(this.timestampLtz("1970-01-01 08:02:03.123")).append(" AS DECIMAL(38, 3))").toString(), castFromTimestampLtzExceptionMsg, this.testExpectedSqlException$default$3());
    }

    @Test
    public void testInvalidCastBetweenNumericAndTimestamp() {
        String castFromTimestampExceptionMsg = "The cast from TIMESTAMP type to NUMERIC type is not allowed. It's recommended to use UNIX_TIMESTAMP(CAST(timestamp_col AS STRING)) instead.";
        String castToTimestampExceptionMsg = "The cast from NUMERIC type to TIMESTAMP type is not allowed. It's recommended to use TO_TIMESTAMP(FROM_UNIXTIME(numeric_col)) instead, note the numeric is in seconds.";
        this.testExpectedSqlException("CAST(CAST(123 as TINYINT) AS TIMESTAMP)", castToTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(123 AS SMALLINT) AS TIMESTAMP)", castToTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(123 AS INT) AS TIMESTAMP)", castToTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(123 AS BIGINT) AS TIMESTAMP)", castToTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(123 AS FLOAT) AS TIMESTAMP)", castToTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(123 AS DOUBLE) AS TIMESTAMP)", castToTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(CAST(123 as DECIMAL(5, 2)) AS TIMESTAMP)", castToTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(TIMESTAMP '1970-01-01 00:02:03' AS TINYINT)", castFromTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(TIMESTAMP '1970-01-01 00:02:03' AS SMALLINT)", castFromTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(TIMESTAMP '1970-01-01 00:02:03' AS INT)", castFromTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(TIMESTAMP '1970-01-01 00:02:03' AS BIGINT)", castFromTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(TIMESTAMP '1970-01-01 00:02:03' AS FLOAT)", castFromTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(TIMESTAMP '1970-01-01 00:02:03' AS DOUBLE)", castFromTimestampExceptionMsg, this.testExpectedSqlException$default$3());
        this.testExpectedSqlException("CAST(TIMESTAMP '1970-01-01 00:02:03' AS DECIMAL(5, 2))", castFromTimestampExceptionMsg, this.testExpectedSqlException$default$3());
    }

    @Test
    public void testTimeIntervalCasting() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).cast(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())), "+1000-00");
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).cast(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MINUTE())), "+16979 07:23:33.000");
    }

    @Test
    public void testTimePointComparison() {
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$less(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3"))), "f0 < f3", "FALSE");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$less(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4"))), "f0 < f4", "TRUE");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$less(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5"))), "f1 < f5", "FALSE");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).cast(DataTypes.TIMESTAMP((int)3))).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))), "CAST(f0 AS TIMESTAMP(9)) <> f2", "TRUE");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).cast(DataTypes.TIMESTAMP((int)9))).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6"))), "CAST(f0 AS TIMESTAMP(9)) = f6", "TRUE");
    }

    @Test
    public void testTimeIntervalArithmetic() {
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(12).months()).$less((Expression)package$.MODULE$.LiteralIntExpression(24).months()), "INTERVAL '12' MONTH < INTERVAL '24' MONTH", "TRUE");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(8).years()).$eq$eq$eq((Expression)package$.MODULE$.LiteralIntExpression(8).years()), "INTERVAL '8' YEAR = INTERVAL '8' YEAR", "TRUE");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(8).millis()).$greater((Expression)package$.MODULE$.LiteralIntExpression(10).millis()), "INTERVAL '0.008' SECOND > INTERVAL '0.010' SECOND", "FALSE");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(8).millis()).$eq$eq$eq((Expression)package$.MODULE$.LiteralIntExpression(8).millis()), "INTERVAL '0.008' SECOND = INTERVAL '0.008' SECOND", "TRUE");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(8).years()).$plus((Expression)package$.MODULE$.LiteralIntExpression(10).months()), "INTERVAL '8' YEAR + INTERVAL '10' MONTH", "+8-10");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(2).years()).$minus((Expression)package$.MODULE$.LiteralIntExpression(12).months()), "INTERVAL '2' YEAR - INTERVAL '12' MONTH", "+1-00");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(-2).years(), "-INTERVAL '2' YEAR", "-2-00");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(8).hours()).$plus((Expression)package$.MODULE$.LiteralIntExpression(10).minutes())).$plus((Expression)package$.MODULE$.LiteralIntExpression(12).seconds())).$plus((Expression)package$.MODULE$.LiteralIntExpression(5).millis()), "INTERVAL '8' HOUR + INTERVAL '10' MINUTE + INTERVAL '12.005' SECOND", "+0 08:10:12.005");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(1).minute()).$minus((Expression)package$.MODULE$.LiteralIntExpression(10).seconds()), "INTERVAL '1' MINUTE - INTERVAL '10' SECOND", "+0 00:00:50.000");
        this.testAllApis((Expression)package$.MODULE$.LiteralIntExpression(-10).seconds(), "-INTERVAL '10' SECOND", "-0 00:00:10.000");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$plus((Expression)package$.MODULE$.LiteralIntExpression(2).days()), "f0 + INTERVAL '2' DAY", "1990-10-16");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(30).days()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0"))), "INTERVAL '30' DAY + f0", "1990-11-13");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$plus((Expression)package$.MODULE$.LiteralIntExpression(2).months()), "f0 + INTERVAL '2' MONTH", "1990-12-14");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(2).months()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0"))), "INTERVAL '2' MONTH + f0", "1990-12-14");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$plus((Expression)package$.MODULE$.LiteralIntExpression(12).hours()), "f1 + INTERVAL '12' HOUR", "22:20:45");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(12).hours()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "INTERVAL '12' HOUR + f1", "22:20:45");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$plus((Expression)package$.MODULE$.LiteralIntExpression(10).days())).$plus((Expression)package$.MODULE$.LiteralIntExpression(4).millis()), "f2 + INTERVAL '10 00:00:00.004' DAY TO SECOND", "1990-10-24 10:20:45.127");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(10).days()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")))).$plus((Expression)package$.MODULE$.LiteralIntExpression(4).millis()), "INTERVAL '10 00:00:00.004' DAY TO SECOND + f2", "1990-10-24 10:20:45.127");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$plus((Expression)package$.MODULE$.LiteralIntExpression(10).years()), "f2 + INTERVAL '10' YEAR", "2000-10-14 10:20:45.123");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(10).years()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))), "INTERVAL '10' YEAR + f2", "2000-10-14 10:20:45.123");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$minus((Expression)package$.MODULE$.LiteralIntExpression(2).days()), "f0 - INTERVAL '2' DAY", "1990-10-12");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(-30).days()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0"))), "INTERVAL '-30' DAY + f0", "1990-09-14");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$minus((Expression)package$.MODULE$.LiteralIntExpression(2).months()), "f0 - INTERVAL '2' MONTH", "1990-08-14");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(-2).months()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0"))), "-INTERVAL '2' MONTH + f0", "1990-08-14");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$minus((Expression)package$.MODULE$.LiteralIntExpression(12).hours()), "f1 - INTERVAL '12' HOUR", "22:20:45");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(-12).hours()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "INTERVAL '-12' HOUR + f1", "22:20:45");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$minus((Expression)package$.MODULE$.LiteralIntExpression(10).days())).$minus((Expression)package$.MODULE$.LiteralIntExpression(4).millis()), "f2 - INTERVAL '10 00:00:00.004' DAY TO SECOND", "1990-10-04 10:20:45.119");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(-10).days()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")))).$minus((Expression)package$.MODULE$.LiteralIntExpression(4).millis()), "INTERVAL '-10 00:00:00.004' DAY TO SECOND + f2", "1990-10-04 10:20:45.119");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$minus((Expression)package$.MODULE$.LiteralIntExpression(10).years()), "f2 - INTERVAL '10' YEAR", "1980-10-14 10:20:45.123");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(-10).years()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))), "INTERVAL '-10' YEAR + f2", "1980-10-14 10:20:45.123");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9")).cast((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).bridgedTo(Integer.class))).unary_$minus(), "-CAST(f9 AS INTERVAL MONTH)", "-2-00");
        this.testAllApis(package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10")).cast((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)3)).bridgedTo(Long.class))).unary_$minus(), "-CAST(f10 AS INTERVAL SECOND(3))", "-0 00:00:12.000");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$plus((Expression)package$.MODULE$.LiteralIntExpression(2).days())).$plus((Expression)package$.MODULE$.LiteralIntExpression(1).month()), "f0 + INTERVAL '2' DAY + INTERVAL '1' MONTH", "1990-11-16");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$minus((Expression)package$.MODULE$.LiteralIntExpression(2).days())).$minus((Expression)package$.MODULE$.LiteralIntExpression(1).month()), "f0 - INTERVAL '2' DAY - INTERVAL '1' MONTH", "1990-09-12");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$plus((Expression)package$.MODULE$.LiteralIntExpression(2).days())).$plus((Expression)package$.MODULE$.LiteralIntExpression(1).month()), "f2 + INTERVAL '2' DAY + INTERVAL '1' MONTH", "1990-11-16 10:20:45.123");
        this.testAllApis(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$minus((Expression)package$.MODULE$.LiteralIntExpression(2).days())).$minus((Expression)package$.MODULE$.LiteralIntExpression(1).month()), "f2 - INTERVAL '2' DAY - INTERVAL '1' MONTH", "1990-09-12 10:20:45.123");
    }

    @Test
    public void testSelectNullValues() {
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")), "f11", "NULL");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f12")), "f12", "NULL");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f13")), "f13", "NULL");
    }

    @Test
    public void testTemporalNullValues() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f13")).extract(TimeIntervalUnit.HOUR), "extract(HOUR FROM f13)", "NULL");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f13")).floor(TimeIntervalUnit.HOUR), "FLOOR(f13 TO HOUR)", "NULL");
        this.testSqlApi("TO_TIMESTAMP(SUBSTRING('', 2, -1))", "NULL");
        this.testSqlApi("TO_TIMESTAMP(f14, 'yyyy-MM-dd')", "NULL");
    }

    @Test
    public void testDateFormat() {
        this.tableConfig().setLocalTimeZone(ZoneId.of("UTC"));
        this.testSqlApi("DATE_FORMAT('2018-03-14 01:02:03', 'yyyy/MM/dd HH:mm:ss')", "2018/03/14 01:02:03");
        this.testAllApis(package$.MODULE$.dateFormat(package$.MODULE$.string2Literal("2018-03-14 01:02:03"), package$.MODULE$.string2Literal("yyyy/MM/dd HH:mm:ss")), "DATE_FORMAT('2018-03-14 01:02:03', 'yyyy/MM/dd HH:mm:ss')", "2018/03/14 01:02:03");
        this.testSqlApi("DATE_FORMAT(TIMESTAMP '2018-03-14 01:02:03.123456', 'yyyy/MM/dd HH:mm:ss.SSSSSS')", "2018/03/14 01:02:03.123456");
        this.testSqlApi(new StringBuilder(36).append("DATE_FORMAT(").append(this.timestampLtz("2018-03-14 01:02:03")).append(", 'yyyy-MM-dd HH:mm:ss')").toString(), "2018-03-14 01:02:03");
        this.testSqlApi(new StringBuilder(43).append("DATE_FORMAT(").append(this.timestampLtz("2018-03-14 01:02:03.123456")).append(", 'yyyy-MM-dd HH:mm:ss.SSSSSS')").toString(), "2018-03-14 01:02:03.123456");
    }

    @Test
    public void testDateFormatShanghai() {
        this.tableConfig().setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        this.testSqlApi("DATE_FORMAT('2018-03-14 01:02:03', 'yyyy/MM/dd HH:mm:ss')", "2018/03/14 01:02:03");
        this.testSqlApi("DATE_FORMAT(TIMESTAMP '2018-03-14 01:02:03.123456', 'yyyy/MM/dd HH:mm:ss.SSSSSS')", "2018/03/14 01:02:03.123456");
        this.testSqlApi(new StringBuilder(36).append("DATE_FORMAT(").append(this.timestampLtz("2018-03-14 01:02:03")).append(", 'yyyy-MM-dd HH:mm:ss')").toString(), "2018-03-14 01:02:03");
        this.testSqlApi(new StringBuilder(43).append("DATE_FORMAT(").append(this.timestampLtz("2018-03-14 01:02:03.123456")).append(", 'yyyy-MM-dd HH:mm:ss.SSSSSS')").toString(), "2018-03-14 01:02:03.123456");
    }

    @Test
    public void testDateFormatLosAngeles() {
        this.tableConfig().setLocalTimeZone(ZoneId.of("America/Los_Angeles"));
        this.testSqlApi("DATE_FORMAT('2018-03-14 01:02:03', 'yyyy/MM/dd HH:mm:ss')", "2018/03/14 01:02:03");
        this.testSqlApi("DATE_FORMAT(TIMESTAMP '2018-03-14 01:02:03.123456', 'yyyy/MM/dd HH:mm:ss.SSSSSS')", "2018/03/14 01:02:03.123456");
        this.testSqlApi(new StringBuilder(36).append("DATE_FORMAT(").append(this.timestampLtz("2018-03-14 01:02:03")).append(", 'yyyy-MM-dd HH:mm:ss')").toString(), "2018-03-14 01:02:03");
        this.testSqlApi(new StringBuilder(43).append("DATE_FORMAT(").append(this.timestampLtz("2018-03-14 01:02:03.123456")).append(", 'yyyy-MM-dd HH:mm:ss.SSSSSS')").toString(), "2018-03-14 01:02:03.123456");
    }

    @Test
    public void testDateAndTime() {
        this.testSqlApi("DATE '2018-03-14'", "2018-03-14");
        this.testSqlApi("TIME '19:01:02.123'", "19:01:02");
        this.testSqlApi("CAST('12:44:31' AS TIME)", "12:44:31");
        this.testSqlApi("CAST('2018-03-18' AS DATE)", "2018-03-18");
        this.testSqlApi("TIME '12:44:31'", "12:44:31");
        this.testAllApis(package$.MODULE$.toDate(package$.MODULE$.string2Literal("2018-03-18"), package$.MODULE$.string2Literal("yyyy-MM-dd")), "TO_DATE('2018-03-18')", "2018-03-18");
        this.testAllApis(package$.MODULE$.toTimestamp(package$.MODULE$.string2Literal("1970-01-01 08:01:40")), "TO_TIMESTAMP('1970-01-01 08:01:40')", "1970-01-01 08:01:40.000");
        this.testAllApis(package$.MODULE$.toTimestamp(package$.MODULE$.string2Literal("1970-01-01 08:01:40"), package$.MODULE$.string2Literal("yyyy-MM-dd HH:mm:ss")), "TO_TIMESTAMP('1970-01-01 08:01:40', 'yyyy-MM-dd HH:mm:ss')", "1970-01-01 08:01:40.000");
        this.testSqlApi("EXTRACT(HOUR FROM TIME '06:07:08')", "6");
        this.testSqlApi("EXTRACT(MINUTE FROM TIME '06:07:08')", "7");
        this.testSqlApi("EXTRACT(HOUR FROM CAST('06:07:08' AS TIME))", "6");
        this.testSqlApi("EXTRACT(DAY FROM CAST('2018-03-18' AS DATE))", "18");
        this.testSqlApi("EXTRACT(DAY FROM DATE '2018-03-18')", "18");
        this.testSqlApi("EXTRACT(DAY FROM TO_DATE('2018-03-18'))", "18");
        this.testSqlApi("EXTRACT(MONTH FROM TO_DATE('2018-01-01'))", "1");
        this.testSqlApi("EXTRACT(YEAR FROM TO_DATE('2018-01-01'))", "2018");
        this.testSqlApi("EXTRACT(QUARTER FROM TO_DATE('2018-01-01'))", "1");
        this.testSqlApi("EXTRACT(EPOCH FROM TO_DATE('2018-01-01'))", "1514764800");
    }

    @Test
    public void testTemporalShanghai() {
        this.tableConfig().setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        this.testSqlApi(this.timestampLtz("2018-03-14 19:01:02.123"), "2018-03-14 19:01:02.123");
        this.testSqlApi(this.timestampLtz("2018-03-14 19:00:00.010"), "2018-03-14 19:00:00.010");
        this.testSqlApi(new StringBuilder(6).append(this.timestampLtz("2018-03-14 19:00:00.010")).append(" > ").append("f25").toString(), "TRUE");
        this.testSqlApi(String.valueOf(this.timestampLtz("2018-03-14 01:02:03.123456789", 9)), "2018-03-14 01:02:03.123456789");
        this.testSqlApi(String.valueOf(this.timestampLtz("2018-03-14 01:02:03.123456", 6)), "2018-03-14 01:02:03.123456");
        this.testSqlApi("DATE_FORMAT('2018-03-14 01:02:03', 'yyyy/MM/dd HH:mm:ss')", "2018/03/14 01:02:03");
        this.testSqlApi(new StringBuilder(36).append("DATE_FORMAT(").append(this.timestampLtz("2018-03-14 01:02:03")).append(", 'yyyy-MM-dd HH:mm:ss')").toString(), "2018-03-14 01:02:03");
        String extractT1 = this.timestampLtz("2018-03-20 07:59:59");
        this.testSqlApi(new StringBuilder(18).append("EXTRACT(DAY FROM ").append(extractT1).append(")").toString(), "20");
        this.testSqlApi(new StringBuilder(19).append("EXTRACT(HOUR FROM ").append(extractT1).append(")").toString(), "7");
        this.testSqlApi(new StringBuilder(20).append("EXTRACT(MONTH FROM ").append(extractT1).append(")").toString(), "3");
        this.testSqlApi(new StringBuilder(19).append("EXTRACT(YEAR FROM ").append(extractT1).append(")").toString(), "2018");
        this.testSqlApi(new StringBuilder(21).append("EXTRACT(ISODOW FROM ").append(extractT1).append(")").toString(), "2");
        this.testSqlApi(new StringBuilder(22).append("EXTRACT(ISOYEAR FROM ").append(extractT1).append(")").toString(), "2018");
        this.testSqlApi(new StringBuilder(21).append("EXTRACT(DECADE FROM ").append(extractT1).append(")").toString(), "201");
        this.testSqlApi(new StringBuilder(22).append("EXTRACT(CENTURY FROM ").append(extractT1).append(")").toString(), "21");
        this.testSqlApi(new StringBuilder(25).append("EXTRACT(MILLENNIUM FROM ").append(extractT1).append(")").toString(), "3");
        this.testSqlApi("EXTRACT(DAY FROM INTERVAL '19 12:10:10.123' DAY TO SECOND(3))", "19");
        this.testSqlApi("EXTRACT(HOUR FROM TIME '01:02:03')", "1");
        this.testSqlApi("EXTRACT(DAY FROM INTERVAL '19 12:10:10.123' DAY TO SECOND(3))", "19");
        this.testSqlApi(new StringBuilder(22).append("EXTRACT(ISOYEAR FROM ").append(this.timestampLtz("1900-01-01 00:00:00")).append(")").toString(), "1900");
        this.testSqlApi(new StringBuilder(21).append("EXTRACT(ISODOW FROM ").append(this.timestampLtz("1900-01-01 00:00:00")).append(")").toString(), "1");
        this.testSqlApi(new StringBuilder(22).append("EXTRACT(ISOYEAR FROM ").append(this.timestampLtz("1950-01-01 00:00:00")).append(")").toString(), "1949");
        this.testSqlApi(new StringBuilder(21).append("EXTRACT(ISODOW FROM ").append(this.timestampLtz("1950-01-01 00:00:00")).append(")").toString(), "7");
        this.testSqlApi(new StringBuilder(22).append("EXTRACT(ISOYEAR FROM ").append(this.timestampLtz("1950-01-02 00:00:00")).append(")").toString(), "1950");
        this.testSqlApi(new StringBuilder(21).append("EXTRACT(ISODOW FROM ").append(this.timestampLtz("1950-01-02 00:00:00")).append(")").toString(), "1");
        this.testSqlApi(new StringBuilder(22).append("EXTRACT(ISOYEAR FROM ").append(this.timestampLtz("1970-01-01 00:00:00")).append(")").toString(), "1970");
        this.testSqlApi(new StringBuilder(21).append("EXTRACT(ISODOW FROM ").append(this.timestampLtz("1970-01-01 00:00:00")).append(")").toString(), "4");
        this.testSqlApi(new StringBuilder(22).append("EXTRACT(ISOYEAR FROM ").append(this.timestampLtz("1969-12-31 00:00:00")).append(")").toString(), "1970");
        this.testSqlApi(new StringBuilder(21).append("EXTRACT(ISODOW FROM ").append(this.timestampLtz("1969-12-31 00:00:00")).append(")").toString(), "3");
        this.testSqlApi(new StringBuilder(22).append("EXTRACT(ISOYEAR FROM ").append(this.timestampLtz("1969-12-30 00:00:00")).append(")").toString(), "1970");
        this.testSqlApi(new StringBuilder(21).append("EXTRACT(ISODOW FROM ").append(this.timestampLtz("1969-12-30 00:00:00")).append(")").toString(), "2");
        this.testSqlApi(new StringBuilder(22).append("EXTRACT(ISOYEAR FROM ").append(this.timestampLtz("1969-12-29 00:00:00")).append(")").toString(), "1970");
        this.testSqlApi(new StringBuilder(21).append("EXTRACT(ISODOW FROM ").append(this.timestampLtz("1969-12-29 00:00:00")).append(")").toString(), "1");
        this.testSqlApi(new StringBuilder(22).append("EXTRACT(ISOYEAR FROM ").append(this.timestampLtz("1969-12-28 00:00:00")).append(")").toString(), "1969");
        this.testSqlApi(new StringBuilder(21).append("EXTRACT(ISODOW FROM ").append(this.timestampLtz("1969-12-28 00:00:00")).append(")").toString(), "7");
        this.testSqlApi(new StringBuilder(22).append("EXTRACT(ISOYEAR FROM ").append(this.timestampLtz("2006-01-01 00:00:00")).append(")").toString(), "2005");
        this.testSqlApi(new StringBuilder(21).append("EXTRACT(ISODOW FROM ").append(this.timestampLtz("2006-01-01 00:00:00")).append(")").toString(), "7");
        this.testSqlApi(new StringBuilder(22).append("EXTRACT(ISOYEAR FROM ").append(this.timestampLtz("2006-01-02 00:00:00")).append(")").toString(), "2006");
        this.testSqlApi(new StringBuilder(21).append("EXTRACT(ISODOW FROM ").append(this.timestampLtz("2006-01-02 00:00:00")).append(")").toString(), "1");
        this.testSqlApi(new StringBuilder(22).append("EXTRACT(ISOYEAR FROM ").append(this.timestampLtz("2005-01-01 00:00:00")).append(")").toString(), "2004");
        this.testSqlApi(new StringBuilder(21).append("EXTRACT(ISODOW FROM ").append(this.timestampLtz("2005-01-01 00:00:00")).append(")").toString(), "6");
        this.testSqlApi(new StringBuilder(22).append("EXTRACT(ISOYEAR FROM ").append(this.timestampLtz("2005-01-02 00:00:00")).append(")").toString(), "2004");
        this.testSqlApi(new StringBuilder(21).append("EXTRACT(ISODOW FROM ").append(this.timestampLtz("2005-01-02 00:00:00")).append(")").toString(), "7");
        this.testSqlApi(new StringBuilder(22).append("EXTRACT(ISOYEAR FROM ").append(this.timestampLtz("2005-01-03 00:00:00")).append(")").toString(), "2005");
        this.testSqlApi(new StringBuilder(21).append("EXTRACT(ISODOW FROM ").append(this.timestampLtz("2005-01-03 00:00:00")).append(")").toString(), "1");
        this.testSqlApi(new StringBuilder(20).append("EXTRACT(EPOCH FROM ").append(this.timestampLtz("2021-12-22 12:13:14")).append(")").toString(), "1640175194");
        this.testSqlApi("FLOOR(TIME '12:44:31' TO MINUTE)", "12:44:00");
        this.testSqlApi("FLOOR(TIME '12:44:31' TO HOUR)", "12:00:00");
        this.testSqlApi("CEIL(TIME '12:44:31' TO MINUTE)", "12:45:00");
        this.testSqlApi("CEIL(TIME '12:44:31' TO HOUR)", "13:00:00");
        this.testSqlApi("FLOOR(DATE '2021-02-27' TO DAY)", "2021-02-27");
        this.testSqlApi("FLOOR(DATE '2021-02-27' TO WEEK)", "2021-02-21");
        this.testSqlApi("FLOOR(DATE '2021-03-01' TO WEEK)", "2021-02-28");
        this.testSqlApi("CEIL(DATE '2021-02-27' TO DAY)", "2021-02-28");
        this.testSqlApi("CEIL(DATE '2021-02-27' TO WEEK)", "2021-02-28");
        this.testSqlApi("CEIL(DATE '2021-03-01' TO WEEK)", "2021-03-07");
        this.testSqlApi("CEIL(DATE '2018-01-02' TO DECADE)", "2020-01-01");
        this.testSqlApi("CEIL(DATE '2018-03-27' TO CENTURY)", "2101-01-01");
        this.testSqlApi("CEIL(DATE '2018-01-02' TO MILLENNIUM)", "3001-01-01");
        this.testSqlApi("FLOOR(DATE '2018-07-02' TO DECADE)", "2010-01-01");
        this.testSqlApi("FLOOR(DATE '2018-04-02' TO CENTURY)", "2001-01-01");
        this.testSqlApi("FLOOR(DATE '2018-01-09' TO MILLENNIUM)", "2001-01-01");
        this.testSqlApi("FLOOR(TIMESTAMP '2018-03-20 06:44:31' TO HOUR)", "2018-03-20 06:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2018-03-20 06:44:31' TO DAY)", "2018-03-20 00:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2018-03-20 00:00:00' TO DAY)", "2018-03-20 00:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2021-02-27 00:00:00' TO WEEK)", "2021-02-21 00:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2021-03-01 00:00:00' TO WEEK)", "2021-02-28 00:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2018-04-01 06:44:31' TO MONTH)", "2018-04-01 00:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2018-01-01 06:44:31' TO MONTH)", "2018-01-01 00:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2021-03-21 00:00:00' TO QUARTER)", "2021-01-01 00:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2018-01-02 21:00:01' TO DECADE)", "2010-01-01 00:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2018-01-01 00:00:00' TO DECADE)", "2010-01-01 00:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2018-01-02 21:00:01' TO CENTURY)", "2001-01-01 00:00:00");
        this.testSqlApi("FLOOR(TIMESTAMP '2018-01-02 21:00:01' TO MILLENNIUM)", "2001-01-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-03-20 06:44:31' TO HOUR)", "2018-03-20 07:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-03-20 06:00:00' TO HOUR)", "2018-03-20 06:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-03-20 06:44:31' TO DAY)", "2018-03-21 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-03-01 00:00:00' TO DAY)", "2018-03-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-03-31 00:00:01' TO DAY)", "2018-04-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2021-02-27 00:00:00' TO WEEK)", "2021-02-28 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2021-03-01 00:00:00' TO WEEK)", "2021-03-07 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-03-01 21:00:01' TO MONTH)", "2018-03-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-03-01 00:00:00' TO MONTH)", "2018-03-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-12-02 00:00:00' TO MONTH)", "2019-01-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-01-01 21:00:01' TO YEAR)", "2018-01-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-01-02 21:00:01' TO YEAR)", "2019-01-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2021-03-21 00:00:00' TO QUARTER)", "2021-04-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-01-02 21:00:01' TO DECADE)", "2020-01-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '1999-01-01 00:00:00' TO DECADE)", "2000-01-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-01-02 21:00:01' TO CENTURY)", "2101-01-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '1999-01-01 00:00:00' TO CENTURY)", "2001-01-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '2018-01-02 21:00:01' TO MILLENNIUM)", "3001-01-01 00:00:00");
        this.testSqlApi("CEIL(TIMESTAMP '1999-01-01 00:00:00' TO MILLENNIUM)", "2001-01-01 00:00:00");
        this.testSqlApi(new StringBuilder(15).append("FLOOR(").append(this.timestampLtz("2018-03-20 06:44:31")).append(" TO HOUR)").toString(), "2018-03-20 06:00:00");
        this.testSqlApi(new StringBuilder(14).append("FLOOR(").append(this.timestampLtz("2018-03-20 06:44:31")).append(" TO DAY)").toString(), "2018-03-20 00:00:00");
        this.testSqlApi(new StringBuilder(14).append("FLOOR(").append(this.timestampLtz("2018-03-20 00:00:00")).append(" TO DAY)").toString(), "2018-03-20 00:00:00");
        this.testSqlApi(new StringBuilder(15).append("FLOOR(").append(this.timestampLtz("2021-02-27 00:00:00")).append(" TO WEEK)").toString(), "2021-02-21 00:00:00");
        this.testSqlApi(new StringBuilder(15).append("FLOOR(").append(this.timestampLtz("2021-03-01 00:00:00")).append(" TO WEEK)").toString(), "2021-02-28 00:00:00");
        this.testSqlApi(new StringBuilder(16).append("FLOOR(").append(this.timestampLtz("2018-04-01 06:44:31")).append(" TO MONTH)").toString(), "2018-04-01 00:00:00");
        this.testSqlApi(new StringBuilder(16).append("FLOOR(").append(this.timestampLtz("2018-01-01 06:44:31")).append(" TO MONTH)").toString(), "2018-01-01 00:00:00");
        this.testSqlApi(new StringBuilder(18).append("FLOOR(").append(this.timestampLtz("2018-01-02 21:00:01")).append(" TO QUARTER)").toString(), "2018-01-01 00:00:00");
        this.testSqlApi(new StringBuilder(18).append("FLOOR(").append(this.timestampLtz("2018-05-02 21:00:01")).append(" TO QUARTER)").toString(), "2018-04-01 00:00:00");
        this.testSqlApi(new StringBuilder(17).append("FLOOR(").append(this.timestampLtz("2018-01-02 21:00:01")).append(" TO DECADE)").toString(), "2010-01-01 00:00:00");
        this.testSqlApi(new StringBuilder(18).append("FLOOR(").append(this.timestampLtz("2018-01-02 21:00:01")).append(" TO CENTURY)").toString(), "2001-01-01 00:00:00");
        this.testSqlApi(new StringBuilder(21).append("FLOOR(").append(this.timestampLtz("2018-01-02 21:00:01")).append(" TO MILLENNIUM)").toString(), "2001-01-01 00:00:00");
        this.testSqlApi(new StringBuilder(14).append("CEIL(").append(this.timestampLtz("2018-03-20 06:44:31")).append(" TO HOUR)").toString(), "2018-03-20 07:00:00");
        this.testSqlApi(new StringBuilder(14).append("CEIL(").append(this.timestampLtz("2018-03-20 06:00:00")).append(" TO HOUR)").toString(), "2018-03-20 06:00:00");
        this.testSqlApi(new StringBuilder(13).append("CEIL(").append(this.timestampLtz("2018-03-20 06:44:31")).append(" TO DAY)").toString(), "2018-03-21 00:00:00");
        this.testSqlApi(new StringBuilder(13).append("CEIL(").append(this.timestampLtz("2018-03-1 00:00:00")).append(" TO DAY)").toString(), "2018-03-01 00:00:00");
        this.testSqlApi(new StringBuilder(13).append("CEIL(").append(this.timestampLtz("2018-03-31 00:00:01")).append(" TO DAY)").toString(), "2018-04-01 00:00:00");
        this.testSqlApi(new StringBuilder(14).append("CEIL(").append(this.timestampLtz("2021-02-27 00:00:00")).append(" TO WEEK)").toString(), "2021-02-28 00:00:00");
        this.testSqlApi(new StringBuilder(14).append("CEIL(").append(this.timestampLtz("2021-03-01 00:00:00")).append(" TO WEEK)").toString(), "2021-03-07 00:00:00");
        this.testSqlApi(new StringBuilder(15).append("CEIL(").append(this.timestampLtz("2018-03-01 21:00:01")).append(" TO MONTH)").toString(), "2018-03-01 00:00:00");
        this.testSqlApi(new StringBuilder(15).append("CEIL(").append(this.timestampLtz("2018-03-01 00:00:00")).append(" TO MONTH)").toString(), "2018-03-01 00:00:00");
        this.testSqlApi(new StringBuilder(15).append("CEIL(").append(this.timestampLtz("2018-12-02 00:00:00")).append(" TO MONTH)").toString(), "2019-01-01 00:00:00");
        this.testSqlApi(new StringBuilder(14).append("CEIL(").append(this.timestampLtz("2018-01-01 21:00:01")).append(" TO YEAR)").toString(), "2018-01-01 00:00:00");
        this.testSqlApi(new StringBuilder(14).append("CEIL(").append(this.timestampLtz("2018-01-02 21:00:01")).append(" TO YEAR)").toString(), "2019-01-01 00:00:00");
        this.testSqlApi(new StringBuilder(17).append("CEIL(").append(this.timestampLtz("2018-01-02 21:00:01")).append(" TO QUARTER)").toString(), "2018-04-01 00:00:00");
        this.testSqlApi(new StringBuilder(17).append("CEIL(").append(this.timestampLtz("2018-04-02 21:00:01")).append(" TO QUARTER)").toString(), "2018-07-01 00:00:00");
        this.testSqlApi(new StringBuilder(16).append("CEIL(").append(this.timestampLtz("2018-01-02 21:00:01")).append(" TO DECADE)").toString(), "2020-01-01 00:00:00");
        this.testSqlApi(new StringBuilder(17).append("CEIL(").append(this.timestampLtz("2018-01-02 21:00:01")).append(" TO CENTURY)").toString(), "2101-01-01 00:00:00");
        this.testSqlApi(new StringBuilder(20).append("CEIL(").append(this.timestampLtz("2018-01-02 21:00:01")).append(" TO MILLENNIUM)").toString(), "3001-01-01 00:00:00");
        this.testSqlApi("QUARTER(DATE '2016-04-12')", "2");
        this.testSqlApi("(TIME '2:55:00', INTERVAL '1' HOUR) OVERLAPS (TIME '3:30:00', INTERVAL '2' HOUR)", "TRUE");
        this.testSqlApi("CEIL(f17 TO HOUR)", "1990-10-14 08:00:00.000");
        this.testSqlApi("FLOOR(f17 TO DAY)", "1990-10-14 00:00:00.000");
        this.testSqlApi("TIMESTAMPADD(HOUR, +8, TIMESTAMP '2017-11-29 10:58:58.998')", "2017-11-29 18:58:58.998");
    }

    @Test
    public void testDaylightSavingTimeZone() {
        this.tableConfig().setLocalTimeZone(ZoneId.of("MET"));
        this.testSqlApi("UNIX_TIMESTAMP('2005-03-27 03:00:00')", "1111885200");
        this.testSqlApi("UNIX_TIMESTAMP('2005-03-27 02:00:00')", "1111885200");
        this.testSqlApi("FROM_UNIXTIME(1111885200)", "2005-03-27 03:00:00");
    }

    @Test
    public void testHourUnitRangoonTimeZone() {
        this.tableConfig().setLocalTimeZone(ZoneId.of("Asia/Rangoon"));
        String t1 = this.timestampLtz("2018-03-20 06:10:31");
        String t2 = this.timestampLtz("2018-03-20 06:00:00");
        this.testSqlApi(new StringBuilder(19).append("EXTRACT(HOUR FROM ").append(t1).append(")").toString(), "6");
        this.testSqlApi(new StringBuilder(15).append("FLOOR(").append(t1).append(" TO HOUR)").toString(), "2018-03-20 06:00:00");
        this.testSqlApi(new StringBuilder(15).append("FLOOR(").append(t2).append(" TO HOUR)").toString(), "2018-03-20 06:00:00");
        this.testSqlApi(new StringBuilder(14).append("CEIL(").append(t2).append(" TO HOUR)").toString(), "2018-03-20 06:00:00");
        this.testSqlApi(new StringBuilder(14).append("CEIL(").append(t1).append(" TO HOUR)").toString(), "2018-03-20 07:00:00");
    }

    @Test
    public void testNullableCases() {
        this.testSqlApi("CONVERT_TZ(cast(NULL as varchar), 'UTC', 'Asia/Shanghai')", this.nullable());
        this.testSqlApi("DATE_FORMAT(cast(NULL as varchar), 'yyyy/MM/dd HH:mm:ss')", this.nullable());
        this.testAllApis(package$.MODULE$.fromUnixtime(package$.MODULE$.nullOf(DataTypes.BIGINT())), "FROM_UNIXTIME(cast(NULL as bigInt))", this.nullable());
        this.testSqlApi("TO_DATE(cast(NULL as varchar))", this.nullable());
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.nullOf(DataTypes.BIGINT()), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(cast(NULL as BIGINT), 0)", this.nullable());
    }

    @Test
    public void testInvalidInputCase() {
        String invalidStr = "invalid value";
        this.testSqlApi(new StringBuilder(38).append("DATE_FORMAT('").append(invalidStr).append("', 'yyyy/MM/dd HH:mm:ss')").toString(), this.nullable());
        this.testSqlApi(new StringBuilder(30).append("TO_TIMESTAMP('").append(invalidStr).append("', 'yyyy-MM-dd')").toString(), this.nullable());
        this.testSqlApi(new StringBuilder(11).append("TO_DATE('").append(invalidStr).append("')").toString(), this.nullable());
        this.testSqlApi(new StringBuilder(38).append("CONVERT_TZ('").append(invalidStr).append("', 'UTC', 'Asia/Shanghai')").toString(), this.nullable());
    }

    @Test
    public void testTypeInferenceWithInvalidInput() {
        String invalidStr = "invalid value";
        Seq cases = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(38).append("DATE_FORMAT('").append(invalidStr).append("', 'yyyy/MM/dd HH:mm:ss')").toString(), new StringBuilder(30).append("TO_TIMESTAMP('").append(invalidStr).append("', 'yyyy-MM-dd')").toString(), new StringBuilder(11).append("TO_DATE('").append(invalidStr).append("')").toString(), new StringBuilder(38).append("CONVERT_TZ('").append(invalidStr).append("', 'UTC', 'Asia/Shanghai')").toString()}));
        cases.foreach((Function1 & Serializable & scala.Serializable)caseExpr -> {
            this.testSqlApi(caseExpr, "NULL");
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testConvertTZ() {
        this.testAllApis((Expression)package$.MODULE$.convertTz(package$.MODULE$.string2Literal("2018-03-14 11:00:00"), package$.MODULE$.string2Literal("UTC"), package$.MODULE$.string2Literal("Asia/Shanghai")), "CONVERT_TZ('2018-03-14 11:00:00', 'UTC', 'Asia/Shanghai')", "2018-03-14 19:00:00");
    }

    @Test
    public void testFromUnixTime() {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        String fmt2 = "yyyy-MM-dd HH:mm:ss.SSS";
        SimpleDateFormat sdf2 = new SimpleDateFormat(fmt2, Locale.US);
        String fmt3 = "yy-MM-dd HH-mm-ss";
        SimpleDateFormat sdf3 = new SimpleDateFormat(fmt3, Locale.US);
        this.testAllApis(package$.MODULE$.fromUnixtime(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f21"))), "from_unixtime(f21)", sdf1.format(new Timestamp(44000L)));
        this.testAllApis(package$.MODULE$.fromUnixtime(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f21")), package$.MODULE$.string2Literal(fmt2)), new StringBuilder(22).append("from_unixtime(f21, '").append(fmt2).append("')").toString(), sdf2.format(new Timestamp(44000L)));
        this.testAllApis(package$.MODULE$.fromUnixtime(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f21")), package$.MODULE$.string2Literal(fmt3)), new StringBuilder(22).append("from_unixtime(f21, '").append(fmt3).append("')").toString(), sdf3.format(new Timestamp(44000L)));
        this.testSqlApi("from_unixtime(f22)", sdf1.format(new Timestamp(3000L)));
        this.testSqlApi(new StringBuilder(22).append("from_unixtime(f22, '").append(fmt2).append("')").toString(), sdf2.format(new Timestamp(3000L)));
        this.testSqlApi(new StringBuilder(22).append("from_unixtime(f22, '").append(fmt3).append("')").toString(), sdf3.format(new Timestamp(3000L)));
        this.testSqlApi(new StringBuilder(22).append("from_unixtime(f26, '").append(fmt2).append("')").toString(), sdf2.format(new Timestamp(124000L)));
        this.testSqlApi(new StringBuilder(22).append("from_unixtime(f26, '").append(fmt3).append("')").toString(), sdf3.format(new Timestamp(124000L)));
        this.testSqlApi("from_unixtime(cast(null as int))", "NULL");
    }

    @Test
    public void testFromUnixTimeInTokyo() {
        this.tableConfig().setLocalTimeZone(ZoneId.of("Asia/Tokyo"));
        String fmt = "yy-MM-dd HH-mm-ss";
        this.testSqlApi("from_unixtime(f21)", "1970-01-01 09:00:44");
        this.testSqlApi(new StringBuilder(22).append("from_unixtime(f21, '").append(fmt).append("')").toString(), "70-01-01 09-00-44");
        this.testSqlApi("from_unixtime(f22)", "1970-01-01 09:00:03");
        this.testSqlApi(new StringBuilder(22).append("from_unixtime(f22, '").append(fmt).append("')").toString(), "70-01-01 09-00-03");
    }

    @Test
    public void testUnixTimestamp() {
        Timestamp ts1 = Timestamp.valueOf("2015-07-24 10:00:00.3");
        Timestamp ts2 = Timestamp.valueOf("2015-07-25 02:02:02.2");
        String s1 = "2015/07/24 10:00:00.5";
        String s2 = "2015/07/25 02:02:02.6";
        String ss1 = "2015-07-24 10:00:00";
        String ss2 = "2015-07-25 02:02:02";
        String fmt = "yyyy/MM/dd HH:mm:ss.S";
        this.testAllApis(package$.MODULE$.unixTimestamp(package$.MODULE$.string2Literal(ss1)), new StringBuilder(18).append("UNIX_TIMESTAMP('").append(ss1).append("')").toString(), ((Object)BoxesRunTime.boxToLong((long)(ts1.getTime() / 1000L))).toString());
        this.testAllApis(package$.MODULE$.unixTimestamp(package$.MODULE$.string2Literal(ss2)), new StringBuilder(18).append("UNIX_TIMESTAMP('").append(ss2).append("')").toString(), ((Object)BoxesRunTime.boxToLong((long)(ts2.getTime() / 1000L))).toString());
        this.testAllApis(package$.MODULE$.unixTimestamp(package$.MODULE$.string2Literal(s1), package$.MODULE$.string2Literal(fmt)), new StringBuilder(22).append("UNIX_TIMESTAMP('").append(s1).append("', '").append(fmt).append("')").toString(), ((Object)BoxesRunTime.boxToLong((long)(ts1.getTime() / 1000L))).toString());
        this.testAllApis(package$.MODULE$.unixTimestamp(package$.MODULE$.string2Literal(s2), package$.MODULE$.string2Literal(fmt)), new StringBuilder(22).append("UNIX_TIMESTAMP('").append(s2).append("', '").append(fmt).append("')").toString(), ((Object)BoxesRunTime.boxToLong((long)(ts2.getTime() / 1000L))).toString());
        this.testSqlApi(new StringBuilder(18).append("UNIX_TIMESTAMP('").append(ss1).append("')").toString(), ((Object)BoxesRunTime.boxToLong((long)(ts1.getTime() / 1000L))).toString());
        this.testSqlApi(new StringBuilder(22).append("UNIX_TIMESTAMP('").append(s1).append("', '").append(fmt).append("')").toString(), ((Object)BoxesRunTime.boxToLong((long)(ts1.getTime() / 1000L))).toString());
    }

    @Test
    public void testUnixTimestampInTokyo() {
        this.tableConfig().setLocalTimeZone(ZoneId.of("Asia/Tokyo"));
        this.testSqlApi("UNIX_TIMESTAMP('2015-07-24 10:00:00')", "1437699600");
        this.testSqlApi("UNIX_TIMESTAMP('2015/07/24 10:00:00.5', 'yyyy/MM/dd HH:mm:ss.S')", "1437699600");
    }

    @Test
    public void testToTimeStampFunctionWithHighPrecision() {
        this.testSqlApi("TO_TIMESTAMP('1970-01-01 00:00:00.123456789')", "1970-01-01 00:00:00.123");
        this.testSqlApi("TO_TIMESTAMP('1970-01-01 00:00:00.12345', 'yyyy-MM-dd HH:mm:ss.SSSSS')", "1970-01-01 00:00:00.123");
        this.testSqlApi("TO_TIMESTAMP('20000202 59:59.1234567', 'yyyyMMdd mm:ss.SSSSSSS')", "2000-02-02 00:59:59.123");
        this.testSqlApi("TO_TIMESTAMP('1234567', 'SSSSSSS')", "1970-01-01 00:00:00.123");
    }

    @Test
    public void testHighPrecisionTimestamp() {
        this.testSqlApi("EXTRACT(MILLISECOND FROM TIMESTAMP '1970-01-01 00:00:00.123456789')", "123");
        this.testSqlApi("EXTRACT(MICROSECOND FROM TIMESTAMP '1970-01-01 00:00:00.123456789')", "123456");
        this.testSqlApi("EXTRACT(NANOSECOND FROM TIMESTAMP '1970-01-01 00:00:00.123456789')", "123456789");
        this.testSqlApi(new StringBuilder(26).append("EXTRACT(MILLISECOND FROM ").append(this.timestampLtz("1970-01-01 00:00:00.123456789", 9)).append(")").toString(), "123");
        this.testSqlApi(new StringBuilder(26).append("EXTRACT(MICROSECOND FROM ").append(this.timestampLtz("1970-01-01 00:00:00.123456789", 9)).append(")").toString(), "123456");
        this.testSqlApi(new StringBuilder(25).append("EXTRACT(NANOSECOND FROM ").append(this.timestampLtz("1970-01-01 00:00:00.123456789", 9)).append(")").toString(), "123456789");
        this.testSqlApi("TO_TIMESTAMP('abc')", "NULL");
        this.testSqlApi("TO_TIMESTAMP('2000020210', 'yyyyMMddHH')", "2000-02-02 10:00:00.000");
        this.testSqlApi("CAST(TIMESTAMP '1970-01-01 00:00:00.123456789' AS TIMESTAMP(6))", "1970-01-01 00:00:00.123456");
        this.testSqlApi("CAST(TIMESTAMP '1970-01-01 00:00:00.123456789' AS TIMESTAMP(9))", "1970-01-01 00:00:00.123456789");
        this.testSqlApi("CAST(TIMESTAMP '1970-01-01 00:00:00.123456789' AS TIMESTAMP)", "1970-01-01 00:00:00.123456");
        this.testSqlApi("CAST(TO_TIMESTAMP('1970-01-01 00:00:00.123456789') AS TIMESTAMP(0))", "1970-01-01 00:00:00");
        this.testSqlApi(new StringBuilder(43).append("CAST(").append(this.timestampLtz("1970-01-01 00:00:00.123456789", 9)).append(" ").append("AS TIMESTAMP(6) WITH LOCAL TIME ZONE)").toString(), "1970-01-01 00:00:00.123456");
        this.testSqlApi("CAST(f23 AS TIMESTAMP(6))", "1970-01-01 00:00:00.123456");
        this.testSqlApi("CAST(f23 AS TIMESTAMP(6) WITH LOCAL TIME ZONE)", "1970-01-01 00:00:00.123456");
        this.testSqlApi("CAST(f24 AS TIMESTAMP(6))", "1970-01-01 00:00:00.123456");
        this.testSqlApi("CAST(f24 AS TIMESTAMP(6) WITH LOCAL TIME ZONE)", "1970-01-01 00:00:00.123456");
        this.testSqlApi("TIMESTAMP '1970-02-01 00:00:00.123456789' - INTERVAL '1' MONTH", "1970-01-01 00:00:00.123456789");
        this.testSqlApi("TIMESTAMP '1970-02-01 00:00:00.123456789' + INTERVAL '1' MONTH", "1970-03-01 00:00:00.123456789");
        this.testSqlApi("TIMESTAMP '1970-02-01 00:00:00.123456789' - INTERVAL '1' SECOND", "1970-01-31 23:59:59.123456789");
        this.testSqlApi("TIMESTAMP '1970-02-01 00:00:00.123456789' + INTERVAL '1' SECOND", "1970-02-01 00:00:01.123456789");
        this.testSqlApi("TIMESTAMP '1970-01-01 00:00:00.123456789' > TIMESTAMP '1970-01-01 00:00:00.123456788'", "TRUE");
        this.testSqlApi("TIMESTAMP '1970-01-01 00:00:00.123456788' < TIMESTAMP '1970-01-01 00:00:00.123456789'", "TRUE");
        this.testSqlApi(new StringBuilder(3).append(this.timestampLtz("1970-01-01 00:00:00.123456789", 9)).append(" > ").append(String.valueOf(this.timestampLtz("1970-01-01 00:00:00.123456788", 9))).toString(), "TRUE");
        this.testSqlApi(new StringBuilder(3).append(this.timestampLtz("1970-01-01 00:00:00.123456788", 9)).append(" < ").append(String.valueOf(this.timestampLtz("1970-01-01 00:00:00.123456789", 9))).toString(), "TRUE");
        this.testSqlApi("DATE_FORMAT(TIMESTAMP '1970-01-01 00:00:00.123456789', 'yyyy/MM/dd HH:mm:ss.SSSSSSSSS')", "1970/01/01 00:00:00.123456789");
        this.testSqlApi(new StringBuilder(46).append("DATE_FORMAT(").append(this.timestampLtz("2018-03-14 01:02:03.123456789", 9)).append(", ").append("'yyyy-MM-dd HH:mm:ss.SSSSSSSSS')").toString(), "2018-03-14 01:02:03.123456789");
    }

    @Test
    public void testToTimestampLtzShanghai() {
        this.tableConfig().setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(100), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(100, 0)", "1970-01-01 08:01:40.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(100).cast(DataTypes.TINYINT()), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(CAST(100 AS TINYINT), 0)", "1970-01-01 08:01:40.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(100).cast(DataTypes.BIGINT()), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(CAST(100 AS BIGINT), 0)", "1970-01-01 08:01:40.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralDoubleExpression(100.01).cast(DataTypes.FLOAT()), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(CAST(100.01 AS FLOAT), 0)", "1970-01-01 08:01:40.010");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralDoubleExpression(100.123).cast(DataTypes.DOUBLE()), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(CAST(100.123 AS DOUBLE), 0)", "1970-01-01 08:01:40.123");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(100).cast(DataTypes.DECIMAL((int)38, (int)18)), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(100, 0)", "1970-01-01 08:01:40.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(-100).cast(DataTypes.DECIMAL((int)38, (int)18)), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(-100, 0)", "1970-01-01 07:58:20.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(1234), package$.MODULE$.int2Literal(3)), "TO_TIMESTAMP_LTZ(1234, 3)", "1970-01-01 08:00:01.234");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.double2Literal(0.01), package$.MODULE$.int2Literal(3)), "TO_TIMESTAMP_LTZ(0.01, 3)", "1970-01-01 08:00:00.000");
    }

    @Test
    public void testToTimestampLtzUTC() {
        this.tableConfig().setLocalTimeZone(ZoneId.of("UTC"));
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(100), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(100, 0)", "1970-01-01 00:01:40.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(100), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(100, 0)", "1970-01-01 00:01:40.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(1234), package$.MODULE$.int2Literal(3)), "TO_TIMESTAMP_LTZ(1234, 3)", "1970-01-01 00:00:01.234");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(-100), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(-100, 0)", "1969-12-31 23:58:20.000");
    }

    @Test
    public void testBoundaryForToTimestampLtz() {
        this.tableConfig().setLocalTimeZone(ZoneId.of("UTC"));
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(Integer.MIN_VALUE).cast(DataTypes.INT()), package$.MODULE$.int2Literal(0)), new StringBuilder(38).append("TO_TIMESTAMP_LTZ(CAST(").append(Integer.MIN_VALUE).append(" AS INTEGER), 0)").toString(), "1901-12-13 20:45:52.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(Integer.MAX_VALUE).cast(DataTypes.INT()), package$.MODULE$.int2Literal(0)), new StringBuilder(38).append("TO_TIMESTAMP_LTZ(CAST(").append(Integer.MAX_VALUE).append(" AS INTEGER), 0)").toString(), "2038-01-19 03:14:07.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(-128).cast(DataTypes.TINYINT()), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(CAST(-128 AS TINYINT), 0)", "1969-12-31 23:57:52.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralIntExpression(127).cast(DataTypes.TINYINT()), package$.MODULE$.int2Literal(0)), "TO_TIMESTAMP_LTZ(CAST(127 AS TINYINT), 0)", "1970-01-01 00:02:07.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralLongExpression(Long.MIN_VALUE).cast(DataTypes.BIGINT()), package$.MODULE$.int2Literal(0)), new StringBuilder(37).append("TO_TIMESTAMP_LTZ(CAST(").append(Long.MIN_VALUE).append(" AS BIGINT), 0)").toString(), "NULL");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralLongExpression(Long.MAX_VALUE).cast(DataTypes.BIGINT()), package$.MODULE$.int2Literal(0)), new StringBuilder(37).append("TO_TIMESTAMP_LTZ(CAST(").append(Long.MAX_VALUE).append(" AS BIGINT), 0)").toString(), "NULL");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralFloatExpression(-Float.MAX_VALUE).cast(DataTypes.FLOAT()), package$.MODULE$.int2Literal(0)), new StringBuilder(37).append("TO_TIMESTAMP_LTZ(CAST(-").append(Float.MAX_VALUE).append(" AS FLOAT), 0)").toString(), "NULL");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralFloatExpression(Float.MAX_VALUE).cast(DataTypes.FLOAT()), package$.MODULE$.int2Literal(0)), new StringBuilder(36).append("TO_TIMESTAMP_LTZ(CAST(").append(Float.MAX_VALUE).append(" AS FLOAT), 0)").toString(), "NULL");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralDoubleExpression(-Double.MAX_VALUE).cast(DataTypes.DOUBLE()), package$.MODULE$.int2Literal(0)), new StringBuilder(38).append("TO_TIMESTAMP_LTZ(CAST(-").append((double)Double.MAX_VALUE).append(" AS DOUBLE), 0)").toString(), "NULL");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralDoubleExpression(Double.MAX_VALUE).cast(DataTypes.DOUBLE()), package$.MODULE$.int2Literal(0)), new StringBuilder(37).append("TO_TIMESTAMP_LTZ(CAST(").append((double)Double.MAX_VALUE).append(" AS DOUBLE), 0)").toString(), "NULL");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralDoubleExpression(-Double.MAX_VALUE).cast(DataTypes.DECIMAL((int)38, (int)18)), package$.MODULE$.int2Literal(0)), new StringBuilder(22).append("TO_TIMESTAMP_LTZ(-").append((double)Double.MAX_VALUE).append(", 0)").toString(), "NULL");
        this.testAllApis(package$.MODULE$.toTimestampLtz((Expression)package$.MODULE$.LiteralDoubleExpression(Double.MAX_VALUE).cast(DataTypes.DECIMAL((int)38, (int)18)), package$.MODULE$.int2Literal(0)), new StringBuilder(21).append("TO_TIMESTAMP_LTZ(").append((double)Double.MAX_VALUE).append(", 0)").toString(), "NULL");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.long2Literal(-62167219200000L), package$.MODULE$.int2Literal(3)), "TO_TIMESTAMP_LTZ(-62167219200000, 3)", "0000-01-01 00:00:00.000");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.long2Literal(253402300799999L), package$.MODULE$.int2Literal(3)), "TO_TIMESTAMP_LTZ(253402300799999, 3)", "9999-12-31 23:59:59.999");
    }

    @Test
    public void testInvalidToTimestampLtz() {
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.long2Literal(-62167219200001L), package$.MODULE$.int2Literal(3)), "TO_TIMESTAMP_LTZ(-62167219200001, 3)", "NULL");
        this.testAllApis(package$.MODULE$.toTimestampLtz(package$.MODULE$.long2Literal(253402300800000L), package$.MODULE$.int2Literal(3)), "TO_TIMESTAMP_LTZ(253402300800000, 3)", "NULL");
        this.testExpectedSqlException("TO_TIMESTAMP_LTZ(123)", "Invalid number of arguments to function 'TO_TIMESTAMP_LTZ'. Was expecting 2 arguments", this.testExpectedSqlException$default$3());
        this.testExpectedAllApisException(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(12), package$.MODULE$.int2Literal(1)), "TO_TIMESTAMP_LTZ(12, 1)", "The precision value '1' for function TO_TIMESTAMP_LTZ(numeric, precision) is unsupported, the supported value is '0' for second or '3' for millisecond.", TableException.class);
        this.testExpectedAllApisException(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(1000000000), package$.MODULE$.int2Literal(9)), "TO_TIMESTAMP_LTZ(1000000000, 9)", "The precision value '9' for function TO_TIMESTAMP_LTZ(numeric, precision) is unsupported, the supported value is '0' for second or '3' for millisecond.", TableException.class);
        this.testExpectedSqlException("TO_TIMESTAMP_LTZ('test_string_type', 0)", "Cannot apply 'TO_TIMESTAMP_LTZ' to arguments of type 'TO_TIMESTAMP_LTZ(<CHAR(16)>, <INTEGER>)'. Supported form(s): 'TO_TIMESTAMP_LTZ(<NUMERIC>, <INTEGER>)'", ValidationException.class);
        this.testExpectedTableApiException(package$.MODULE$.toTimestampLtz(package$.MODULE$.string2Literal("test_string_type"), package$.MODULE$.int2Literal(0)), "Unsupported argument type. Expected type of family 'NUMERIC' but actual type was 'CHAR(16) NOT NULL'", this.testExpectedTableApiException$default$3());
        this.testExpectedSqlException("TO_TIMESTAMP_LTZ(123, 'test_string_type')", "Cannot apply 'TO_TIMESTAMP_LTZ' to arguments of type 'TO_TIMESTAMP_LTZ(<INTEGER>, <CHAR(16)>)'. Supported form(s): 'TO_TIMESTAMP_LTZ(<NUMERIC>, <INTEGER>)'", this.testExpectedSqlException$default$3());
        this.testExpectedTableApiException(package$.MODULE$.toTimestampLtz(package$.MODULE$.int2Literal(123), package$.MODULE$.string2Literal("test_string_type")), "Unsupported argument type. Expected type of family 'INTEGER_NUMERIC' but actual type was 'CHAR(16) NOT NULL'", this.testExpectedTableApiException$default$3());
    }

    @Test
    public void testTimestampDiff() {
        this.testSqlApi("TIMESTAMPDIFF(MONTH, TIMESTAMP '2019-09-01 00:00:00', TIMESTAMP '2020-03-01 00:00:00')", "6");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, TIMESTAMP '2019-09-01 00:00:00', TIMESTAMP '2016-08-01 00:00:00')", "-37");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, DATE '2019-09-01', DATE '2020-03-01')", "6");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, DATE '2019-09-01', DATE '2016-08-01')", "-37");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, TIMESTAMP '2021-01-04 00:00:00', DATE '2021-02-04')", "1");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, DATE '2020-01-04', TIMESTAMP '2021-02-04 12:00:00')", "13");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, TIMESTAMP '2021-01-04 00:00:00', TIME '00:00:00')", "-612");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, TIME '00:00:00', TIMESTAMP '2021-02-04 12:00:00')", "613");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, DATE '2021-01-04', TIME '00:00:00')", "-612");
        this.testSqlApi("TIMESTAMPDIFF(MONTH, TIME '00:00:00', DATE '2021-02-04')", "613");
    }

    @Test
    public void testTimestampLtzArithmetic() {
        this.testSqlApi(new StringBuilder(20).append(this.timestampLtz("1970-02-01 00:00:00.123456789")).append(" + INTERVAL '1' YEAR").toString(), "1971-02-01 00:00:00.123456789");
        this.testSqlApi(new StringBuilder(21).append(this.timestampLtz("1970-02-01 00:00:00.123456789")).append(" - INTERVAL '1' MONTH").toString(), "1970-01-01 00:00:00.123456789");
        this.testSqlApi(new StringBuilder(19).append(this.timestampLtz("1970-02-01 00:00:00.123456789")).append(" + INTERVAL '1' DAY").toString(), "1970-02-02 00:00:00.123456789");
        this.testSqlApi(new StringBuilder(20).append(this.timestampLtz("1970-02-01 00:00:00.123456789")).append(" - INTERVAL '1' HOUR").toString(), "1970-01-31 23:00:00.123456789");
        this.testSqlApi(new StringBuilder(22).append(this.timestampLtz("1970-02-01 00:00:00.123456789")).append(" + INTERVAL '1' MINUTE").toString(), "1970-02-01 00:01:00.123456789");
        this.testSqlApi(new StringBuilder(22).append(this.timestampLtz("1970-02-01 00:00:00.123456789")).append(" - INTERVAL '1' SECOND").toString(), "1970-01-31 23:59:59.123456789");
        this.testSqlApi(new StringBuilder(21).append("TIMESTAMPDIFF(YEAR, ").append(this.timestampLtz("1970-01-01 00:00:00.123456789")).append(",").append(new StringBuilder(2).append(" ").append(this.timestampLtz("1971-01-02 01:02:03.123456789")).append(")").toString()).toString(), "1");
        this.testSqlApi(new StringBuilder(22).append("TIMESTAMPDIFF(MONTH, ").append(this.timestampLtz("1970-01-01 00:00:00.123456789")).append(",").append(new StringBuilder(2).append(" ").append(this.timestampLtz("1971-01-02 01:02:03.123456789")).append(")").toString()).toString(), "12");
        this.testSqlApi(new StringBuilder(20).append("TIMESTAMPDIFF(DAY, ").append(this.timestampLtz("1970-01-01 00:00:00.123")).append(",").append(new StringBuilder(2).append(" ").append(this.timestampLtz("1971-01-02 01:02:03.123")).append(")").toString()).toString(), "366");
        this.testSqlApi(new StringBuilder(21).append("TIMESTAMPDIFF(HOUR, ").append(this.timestampLtz("1970-01-01 00:00:00.123")).append(",").append(new StringBuilder(2).append(" ").append(this.timestampLtz("1970-01-01 01:02:03.123")).append(")").toString()).toString(), "1");
        this.testSqlApi(new StringBuilder(23).append("TIMESTAMPDIFF(MINUTE, ").append(this.timestampLtz("1970-01-01 01:02:03.123")).append(",").append(new StringBuilder(2).append(" ").append(this.timestampLtz("1970-01-01 00:00:00")).append(")").toString()).toString(), "-62");
        this.testSqlApi(new StringBuilder(23).append("TIMESTAMPDIFF(SECOND, ").append(this.timestampLtz("1970-01-01 00:00:00.123")).append(",").append(new StringBuilder(2).append(" ").append(this.timestampLtz("1970-01-01 00:02:03.234")).append(")").toString()).toString(), "123");
        this.testSqlApi(new StringBuilder(50).append("TIMESTAMPDIFF(SECOND, CAST(null AS TIMESTAMP_LTZ),").append(new StringBuilder(2).append(" ").append(this.timestampLtz("1970-01-01 00:02:03.234")).append(")").toString()).toString(), "NULL");
    }

    @Test
    public void testInvalidTimestampLtzArithmetic() {
        String exceptionMsg = "TIMESTAMP_LTZ only supports diff between the same type.";
        this.testExpectedSqlException(new StringBuilder(39).append("TIMESTAMPDIFF(MONTH, ").append(this.timestampLtz("1970-01-01 00:00:00.123")).append(", TIME '00:00:01')").toString(), exceptionMsg, CodeGenException.class);
        this.testExpectedSqlException(new StringBuilder(41).append("TIMESTAMPDIFF(MONTH, ").append(this.timestampLtz("1970-01-01 00:00:00.123")).append(", DATE '1970-01-01')").toString(), exceptionMsg, CodeGenException.class);
        this.testExpectedSqlException(new StringBuilder(59).append("TIMESTAMPDIFF(MONTH, ").append(this.timestampLtz("1970-01-01 00:00:00.123")).append(",").append(" TIMESTAMP '1970-01-01 00:00:00.123')").toString(), exceptionMsg, CodeGenException.class);
        this.testExpectedSqlException(new StringBuilder(44).append("TIMESTAMPDIFF(SECOND, ").append(this.timestampLtz("1970-01-01 00:00:00.123")).append(",").append(" TIME '00:00:00.123')").toString(), exceptionMsg, CodeGenException.class);
        this.testExpectedSqlException(new StringBuilder(43).append("TIMESTAMPDIFF(SECOND, ").append(this.timestampLtz("1970-01-01 00:00:00.123")).append(", 'test_string_type')").toString(), "Cannot apply 'TIMESTAMPDIFF' to arguments of type 'TIMESTAMPDIFF(<SYMBOL>, <TIMESTAMP_WITH_LOCAL_TIME_ZONE(3)>, <CHAR(16)>)'. Supported form(s): 'TIMESTAMPDIFF(<ANY>, <DATETIME>, <DATETIME>)'", this.testExpectedSqlException$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Row testData() {
        void var1_1;
        Row testData = new Row(27);
        testData.setField(0, (Object)DateTimeTestUtil$.MODULE$.localDate("1990-10-14"));
        testData.setField(1, (Object)DateTimeTestUtil$.MODULE$.localTime("10:20:45"));
        testData.setField(2, (Object)DateTimeTestUtil$.MODULE$.localDateTime("1990-10-14 10:20:45.123"));
        testData.setField(3, (Object)DateTimeTestUtil$.MODULE$.localDate("1990-10-13"));
        testData.setField(4, (Object)DateTimeTestUtil$.MODULE$.localDate("1990-10-15"));
        testData.setField(5, (Object)DateTimeTestUtil$.MODULE$.localTime("00:00:00"));
        testData.setField(6, (Object)DateTimeTestUtil$.MODULE$.localDateTime("1990-10-14 00:00:00.0"));
        testData.setField(7, (Object)BoxesRunTime.boxToInteger((int)12000));
        testData.setField(8, (Object)BoxesRunTime.boxToLong((long)1467012213000L));
        testData.setField(9, (Object)BoxesRunTime.boxToInteger((int)24));
        testData.setField(10, (Object)BoxesRunTime.boxToLong((long)12000L));
        testData.setField(11, null);
        testData.setField(12, null);
        testData.setField(13, null);
        testData.setField(14, null);
        testData.setField(15, (Object)BoxesRunTime.boxToLong((long)1467012213L));
        testData.setField(16, (Object)DateTimeTestUtil$.MODULE$.localDateTime("1990-10-14 10:20:45.123").atZone(ZoneId.of("UTC")).toInstant());
        testData.setField(17, (Object)DateTimeTestUtil$.MODULE$.localDateTime("1990-10-14 00:00:00.0").atZone(ZoneId.of("UTC")).toInstant());
        testData.setField(18, (Object)Instant.ofEpochMilli(1521025200000L));
        testData.setField(19, (Object)Instant.ofEpochMilli(1520960523000L));
        testData.setField(20, (Object)Instant.ofEpochMilli(1520827201000L));
        testData.setField(21, (Object)BoxesRunTime.boxToLong((long)44L));
        testData.setField(22, (Object)BoxesRunTime.boxToInteger((int)3));
        testData.setField(23, (Object)DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.123456789").atZone(TableConfigUtils.getLocalTimeZone((ReadableConfig)this.tableConfig())).toInstant());
        testData.setField(24, (Object)DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.123456789").atZone(TableConfigUtils.getLocalTimeZone((ReadableConfig)this.tableConfig())).toInstant());
        testData.setField(25, (Object)DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.123456789").toInstant(ZoneOffset.UTC));
        testData.setField(26, (Object)BoxesRunTime.boxToByte((byte)new Integer(124).byteValue()));
        return var1_1;
    }

    public DataType testDataType() {
        return DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.TIME((int)0)), DataTypes.FIELD((String)"f2", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"f3", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"f4", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"f5", (DataType)DataTypes.TIME((int)0)), DataTypes.FIELD((String)"f6", (DataType)DataTypes.TIMESTAMP((int)9)), DataTypes.FIELD((String)"f7", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f8", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f9", (DataType)((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).bridgedTo(Integer.class))), DataTypes.FIELD((String)"f10", (DataType)((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)3)).bridgedTo(Long.class))), DataTypes.FIELD((String)"f11", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"f12", (DataType)DataTypes.TIME((int)0)), DataTypes.FIELD((String)"f13", (DataType)DataTypes.TIMESTAMP((int)9)), DataTypes.FIELD((String)"f14", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f15", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f16", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"f17", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3)), DataTypes.FIELD((String)"f18", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"f19", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"f20", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"f21", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f22", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f23", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"f24", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"f25", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"f26", (DataType)DataTypes.TINYINT())});
    }

    @Override
    public boolean containsLegacyTypes() {
        return false;
    }

    public TemporalTypesTest() {
        super(ExpressionTestBase$.MODULE$.$lessinit$greater$default$1());
    }
}

