/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.validation;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.ArrayTypeTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001#\t9\u0012I\u001d:bsRK\b/\u001a,bY&$\u0017\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\t!B^1mS\u0012\fG/[8o\u0015\t)a!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0004\t\u0003\u001d\u0001H.\u00198oKJT!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0006kRLGn]\u0005\u0003/Q\u0011\u0011#\u0011:sCf$\u0016\u0010]3UKN$()Y:f\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0003\u001f\u0001\u0011\u0005q$\u0001\u000fuKN$\u0018*\u001c9mS\u000eLG\u000fV=qK\u000e\u000b7\u000f^!se\u0006L8+\u001d7\u0015\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012A!\u00168ji\"\u0012Qd\n\t\u0003Q=j\u0011!\u000b\u0006\u0003U-\n1!\u00199j\u0015\taS&A\u0004kkBLG/\u001a:\u000b\u00059r\u0011!\u00026v]&$\u0018B\u0001\u0019*\u0005\u0011!Vm\u001d;\t\u000bI\u0002A\u0011A\u0010\u0002#Q,7\u000f^#naRL\u0018I\u001d:bsN\u000bH\u000e\u000b\u00022O!)Q\u0007\u0001C\u0001?\u0005\u0001B/Z:u\u001dVdG.\u0011:sCf\u001c\u0016\u000f\u001c\u0015\u0003i\u001dBQ\u0001\u000f\u0001\u0005\u0002}\t!\u0004^3ti\u0012KgMZ3sK:$H+\u001f9fg\u0006\u0013(/Y=Tc2D#aN\u0014\t\u000bm\u0002A\u0011A\u0010\u0002'Q,7\u000f^#mK6,g\u000e\u001e(p]\u0006\u0013(/Y=)\u0005i:\u0003\"\u0002 \u0001\t\u0003y\u0012A\u0006;fgR,E.Z7f]RtuN\\!se\u0006L8+\u001d7)\u0005u:\u0003\"B!\u0001\t\u0003y\u0012!\u0007;fgR\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=P]:{g.\u0011:sCfD#\u0001Q\u0014\t\u000b\u0011\u0003A\u0011A\u0010\u00029Q,7\u000f^\"be\u0012Lg.\u00197jif|eNT8o\u0003J\u0014\u0018-_*rY\"\u00121i\n")
public class ArrayTypeValidationTest
extends ArrayTypeTestBase {
    @Test
    public void testImplicitTypeCastArraySql() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("ARRAY['string', 12]", "FAIL"));
    }

    @Test
    public void testEmptyArraySql() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("ARRAY[]", "FAIL"));
    }

    @Test
    public void testNullArraySql() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("ARRAY[NULL]", "FAIL"));
    }

    @Test
    public void testDifferentTypesArraySql() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("ARRAY[1, TRUE]", "FAIL"));
    }

    @Test
    public void testElementNonArray() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).element(), "FAIL"));
    }

    @Test
    public void testElementNonArraySql() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("ELEMENT(f0)", "FAIL"));
    }

    @Test
    public void testCardinalityOnNonArray() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).cardinality(), "FAIL"));
    }

    @Test
    public void testCardinalityOnNonArraySql() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("CARDINALITY(f0)", "FAIL"));
    }
}

