/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.validation;

import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.RowTypeTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001#\t)\"k\\<UsB,g+\u00197jI\u0006$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u000b\u0019\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011!B;uS2\u001c\u0018BA\f\u0015\u0005=\u0011vn\u001e+za\u0016$Vm\u001d;CCN,\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u0015q\u0002\u0001\"\u0001 \u0003A!Xm\u001d;F[B$\u0018PU8x)f\u0004X\rF\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0011)f.\u001b;)\u0005u9\u0003C\u0001\u00150\u001b\u0005I#B\u0001\u0016,\u0003\r\t\u0007/\u001b\u0006\u0003Y5\nqA[;qSR,'O\u0003\u0002/\u001d\u0005)!.\u001e8ji&\u0011\u0001'\u000b\u0002\u0005)\u0016\u001cH\u000fC\u00033\u0001\u0011\u0005q$A\buKN$h*\u001e7m%><H+\u001f9fQ\t\tt\u0005C\u00036\u0001\u0011\u0005q$A\fuKN$8+\u001d7S_^LE\u000e\\3hC2\f5mY3tg\"\u0012Ag\n")
public class RowTypeValidationTest
extends RowTypeTestBase {
    @Test
    public void testEmptyRowType() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.testSqlApi("Row()", "FAIL"));
    }

    @Test
    public void testNullRowType() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testAllApis(package$.MODULE$.string2Literal("FAIL"), "Row(NULL)", "FAIL"));
    }

    @Test
    public void testSqlRowIllegalAccess() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).get("f2"), "f5.f2", "FAIL"));
    }
}

