/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.validation;

import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.TimePointUnit;
import org.apache.flink.table.planner.expressions.utils.ScalarTypesTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001#\ti2kY1mCJ4UO\\2uS>t7OV1mS\u0012\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011aC3yaJ,7o]5p]NT!a\u0002\u0005\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\t)B!A\u0003vi&d7/\u0003\u0002\u0018)\t\u00192kY1mCJ$\u0016\u0010]3t)\u0016\u001cHOQ1tK\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\u0006=\u0001!\taH\u0001\u0010i\u0016\u001cH/\u00138wC2LGMQ5ocQ\t\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0003V]&$\bFA\u000f(!\tAs&D\u0001*\u0015\tQ3&A\u0002ba&T!\u0001L\u0017\u0002\u000f),\b/\u001b;fe*\u0011aFD\u0001\u0006UVt\u0017\u000e^\u0005\u0003a%\u0012A\u0001V3ti\")!\u0007\u0001C\u0001?\u0005yA/Z:u\u0013:4\u0018\r\\5e\u0005&t'\u0007\u000b\u00022O!)Q\u0007\u0001C\u0001?\u0005yA/Z:u\u0013:4\u0018\r\\5e\u0005&t7\u0007\u000b\u00025O!)\u0001\b\u0001C\u0001?\u0005!B/Z:u\u0013:4\u0018\r\\5e)J,hnY1uKFB#aN\u0014\t\u000bm\u0002A\u0011A\u0010\u0002)Q,7\u000f^%om\u0006d\u0017\u000e\u001a+sk:\u001c\u0017\r^33Q\tQt\u0005C\u0003?\u0001\u0011\u0005q$A\u000buKN$\u0018J\u001c<bY&$7+\u001e2tiJLgnZ\u0019)\u0005u:\u0003\"B!\u0001\t\u0003y\u0012!\u0006;fgRLeN^1mS\u0012\u001cVOY:ue&twM\r\u0015\u0003\u0001\u001eBQ\u0001\u0012\u0001\u0005\u0002}\t!\u0006^3tiRKW.Z:uC6\u0004\u0018\t\u001a3XSRDwK]8oORKW.Z:uC6\u0004\u0018J\u001c;feZ\fG\u000e\u000b\u0002DO!)q\t\u0001C\u0001?\u0005AC/Z:u)&lWm\u001d;b[B\fE\rZ,ji\"<&o\u001c8h)&lWm\u001d;b[B4uN]7bi\"\u0012ai\n\u0005\u0006\u0015\u0002!\taH\u0001\"i\u0016\u001cH\u000fV5nKN$\u0018-\u001c9BI\u0012<\u0016\u000e\u001e5Xe>tw-U;b]RLG/\u001f\u0015\u0003\u0013\u001eBQ!\u0014\u0001\u0005\u0002}\tqf]2bY\u0006LeNV1mS\u0012\fG/[8o\u000bb\u001cW\r\u001d;j_:$\u0015N\u001a4fe\u0016tGo\u00149fe\u0006tGm\u001d+fgRD#\u0001T\u0014\t\u000bA\u0003A\u0011A\u0010\u0002=Q,7\u000f\u001e+j[\u0016\u001cH/Y7q\t&4gmV5uQ^\u0013xN\\4US6,\u0007FA((\u0011\u0015\u0019\u0006\u0001\"\u0001 \u0003\u0015\"Xm\u001d;US6,7\u000f^1na\u0012KgMZ,ji\"<&o\u001c8h)&lW-\u00118e+:LG\u000f\u000b\u0002SO!)a\u000b\u0001C\u0001?\u00051B/Z:u\u0013:4\u0018\r\\5e'R\u0014\u0018N\\4U_6\u000b\u0007\u000f\u000b\u0002VO!)\u0011\f\u0001C\u0001?\u0005iA/Z:u\u0013:4\u0018\r\\5e\u0013\u001aD#\u0001W\u0014\t\u000bq\u0003A\u0011A\u0010\u0002'Q,7\u000f^%om\u0006d\u0017\u000e\u001a+p\u0005\u0006\u001cXM\u000e\u001b)\u0005m;\u0003")
public class ScalarFunctionsValidationTest
extends ScalarTypesTestBase {
    @Test
    public void testInvalidBin1() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("BIN(f12)", "101010"));
    }

    @Test
    public void testInvalidBin2() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("BIN(f15)", "101010"));
    }

    @Test
    public void testInvalidBin3() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("BIN(f16)", "101010"));
    }

    @Test
    public void testInvalidTruncate1() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TRUNCATE('abc', 'def')", "FAIL"));
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TRUNCATE(f12, f0)", "FAIL"));
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TRUNCATE(f12,f12)", "FAIL"));
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TRUNCATE(f12, cast(f28 as DOUBLE))", "FAIL"));
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TRUNCATE(f12,f15)", "FAIL"));
    }

    @Test
    public void testInvalidTruncate2() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TRUNCATE('abc')", "FAIL"));
    }

    @Test
    public void testInvalidSubstring1() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi((Expression)package$.MODULE$.LiteralStringExpression("test").substring((Object)package$.MODULE$.LiteralDoubleExpression(2.0).toExpr()), "FAIL"));
    }

    @Test
    public void testInvalidSubstring2() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi((Expression)package$.MODULE$.LiteralStringExpression("test").substring((Object)package$.MODULE$.LiteralStringExpression("test").toExpr()), "FAIL"));
    }

    @Test
    public void testTimestampAddWithWrongTimestampInterval() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.testSqlApi("TIMESTAMPADD(XXX, 1, timestamp '2016-02-24'))", "2016-06-16"));
    }

    @Test
    public void testTimestampAddWithWrongTimestampFormat() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.testSqlApi("TIMESTAMPADD(YEAR, 1, timestamp '2016-02-24'))", "2016-06-16"));
    }

    @Test
    public void testTimestampAddWithWrongQuantity() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TIMESTAMPADD(YEAR, 1.0, timestamp '2016-02-24 12:42:25')", "2016-06-16"));
    }

    @Test
    public void scalaInValidationExceptionDifferentOperandsTest() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).in((Object[])new Expression[]{package$.MODULE$.string2Literal("Hi"), package$.MODULE$.string2Literal("Hello world"), package$.MODULE$.string2Literal("Comment#1")}), "TRUE"));
    }

    @Test
    public void testTimestampDiffWithWrongTime() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi(package$.MODULE$.timestampDiff(TimePointUnit.DAY, package$.MODULE$.string2Literal("2016-02-24"), package$.MODULE$.string2Literal("2016-02-27")), "FAIL"));
    }

    @Test
    public void testTimestampDiffWithWrongTimeAndUnit() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi(package$.MODULE$.timestampDiff(TimePointUnit.MINUTE, package$.MODULE$.string2Literal("2016-02-24"), package$.MODULE$.string2Literal("2016-02-27")), "FAIL"));
    }

    @Test
    public void testInvalidStringToMap() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("STR_TO_MAP('k1:v1;k2:v2', ';')", "EXCEPTION")).withMessageContaining("Invalid number of arguments to function 'STR_TO_MAP'");
    }

    @Test
    public void testInvalidIf() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("IF(f7 > 5, f0, f1)", "FAIL")).withMessageContaining("Cannot apply 'IF' to arguments");
    }

    @Test
    public void testInvalidToBase64() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testSqlApi("TO_BASE64(11)", "FAIL")).withMessageContaining("Cannot apply 'TO_BASE64' to arguments of type 'TO_BASE64(<INTEGER>)'");
    }
}

