/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.validation;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.ScalarOperatorsTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001#\ti2kY1mCJ|\u0005/\u001a:bi>\u00148OV1mS\u0012\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011aC3yaJ,7o]5p]NT!a\u0002\u0005\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\t)B!A\u0003vi&d7/\u0003\u0002\u0018)\t92kY1mCJ|\u0005/\u001a:bi>\u00148\u000fV3ti\n\u000b7/\u001a\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAQA\b\u0001\u0005\u0002}\tq\u0003^3ti&3\u0017J\u001c<bY&$G+\u001f9fgN\u001b\u0017\r\\1\u0015\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012A!\u00168ji\"\u0012Qd\n\t\u0003Q=j\u0011!\u000b\u0006\u0003U-\n1!\u00199j\u0015\taS&A\u0004kkBLG/\u001a:\u000b\u00059r\u0011!\u00026v]&$\u0018B\u0001\u0019*\u0005\u0011!Vm\u001d;\t\u000bI\u0002A\u0011A\u0010\u00029Q,7\u000f^%om\u0006d\u0017\u000eZ*ue&twmQ8na\u0006\u0014\u0018n]8oc!\u0012\u0011g\n\u0005\u0006k\u0001!\taH\u0001\u001di\u0016\u001cH/\u00138wC2LGm\u0015;sS:<7i\\7qCJL7o\u001c83Q\t!t\u0005C\u00039\u0001\u0011\u0005q$A\fuKN$\u0018J\u001c#jM\u001a,'/\u001a8u\u001fB,'/\u00198eg\"\u0012qg\n\u0005\u0006w\u0001!\taH\u0001)i\u0016\u001cHOQ3uo\u0016,gnV5uQ\u0012KgMZ3sK:$x\n]3sC:$G+\u001f9f'\u000e\fG.\u0019\u0015\u0003u\u001dBQA\u0010\u0001\u0005\u0002}\t!\u0006^3tiR+W\u000e]8sC2$\u0016\u0010]3FcV\fGn]%om\u0006d\u0017\u000eZ*ue&tw\rT5uKJ\fG\u000e\u000b\u0002>O\u0001")
public class ScalarOperatorsValidationTest
extends ScalarOperatorsTestBase {
    @Test
    public void testIfInvalidTypesScala() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$amp$amp(package$.MODULE$.boolean2Literal(true))).$qmark(package$.MODULE$.int2Literal(5), package$.MODULE$.string2Literal("false")), "FAIL"));
    }

    @Test
    public void testInvalidStringComparison1() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi(package$.MODULE$.LiteralStringExpression("w").$eq$eq$eq(package$.MODULE$.int2Literal(4)), "FAIL"));
    }

    @Test
    public void testInvalidStringComparison2() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi(package$.MODULE$.LiteralStringExpression("w").$greater(package$.MODULE$.LiteralIntExpression(4).toExpr()), "FAIL"));
    }

    @Test
    public void testInDifferentOperands() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).in((Object[])new Expression[]{package$.MODULE$.string2Literal("Hi"), package$.MODULE$.string2Literal("Hello world"), package$.MODULE$.string2Literal("Comment#1")}), "FAIL"));
    }

    @Test
    public void testBetweenWithDifferentOperandTypeScala() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.testTableApi((Expression)package$.MODULE$.LiteralIntExpression(2).between((Object)package$.MODULE$.int2Literal(1), (Object)package$.MODULE$.string2Literal("a")), "FAIL"));
    }

    @Test
    public void testTemporalTypeEqualsInvalidStringLiteral() {
        this.testExpectedSqlException("f15 = 'invalid'", "Error when casting CHAR(7) NOT NULL to DATE", ValidationException.class);
        this.testExpectedSqlException("'invalid' = f15", "Error when casting CHAR(7) NOT NULL to DATE", ValidationException.class);
        this.testExpectedSqlException("f21 = 'invalid'", "Error when casting CHAR(7) NOT NULL to TIME", ValidationException.class);
        this.testExpectedSqlException("'invalid' = f21", "Error when casting CHAR(7) NOT NULL to TIME", ValidationException.class);
        this.testExpectedSqlException("f22 = 'invalid'", "Error when casting CHAR(7) NOT NULL to TIMESTAMP(6)", ValidationException.class);
        this.testExpectedSqlException("'invalid' = f22", "Error when casting CHAR(7) NOT NULL to TIMESTAMP(6)", ValidationException.class);
    }
}

