/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.factories;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.DefaultCatalogTable;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.TableFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.functions.TableFunction;

public class TableFactoryHarness {
    public static final String IDENTIFIER = "harness";

    public static HarnessTableDescriptor.Builder newBuilder() {
        return new HarnessTableDescriptor.Builder();
    }

    private static abstract class SourceBase
    implements DynamicTableSource {
        private DynamicTableFactory.Context factoryContext;

        private SourceBase() {
        }

        public DynamicTableSource copy() {
            return this;
        }

        public String asSummaryString() {
            return "Unspecified Testing Source";
        }

        public DynamicTableFactory.Context getFactoryContext() {
            return this.factoryContext;
        }
    }

    public static abstract class SinkBase
    implements DynamicTableSink {
        private DynamicTableFactory.Context factoryContext;

        public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
            return ChangelogMode.all();
        }

        public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
            return SinkFunctionProvider.of((SinkFunction)new SinkFunction<RowData>(){

                public void invoke(RowData value, SinkFunction.Context context1) {
                }
            });
        }

        public DynamicTableSink copy() {
            return this;
        }

        public String asSummaryString() {
            return "Unspecified Testing Sink";
        }

        public DynamicTableFactory.Context getFactoryContext() {
            return this.factoryContext;
        }
    }

    public static abstract class LookupSourceBase
    extends SourceBase
    implements LookupTableSource {
        public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext context) {
            return TableFunctionProvider.of((TableFunction)new TableFunction<RowData>(){});
        }
    }

    public static abstract class ScanSourceBase
    extends SourceBase
    implements ScanTableSource {
        private final boolean bounded;

        public ScanSourceBase() {
            this(true);
        }

        public ScanSourceBase(boolean bounded) {
            this.bounded = bounded;
        }

        public ChangelogMode getChangelogMode() {
            return ChangelogMode.insertOnly();
        }

        public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
            return SourceFunctionProvider.of((SourceFunction)new SourceFunction<RowData>(){

                public void run(SourceFunction.SourceContext<RowData> ctx) {
                }

                public void cancel() {
                }
            }, (boolean)this.bounded);
        }
    }

    private static class HarnessCatalogTable
    extends DefaultCatalogTable {
        @Nullable
        private final SourceBase source;
        @Nullable
        private final SinkBase sink;

        public HarnessCatalogTable(CatalogTable parentTable, @Nullable SourceBase source, @Nullable SinkBase sink) {
            super(parentTable.getUnresolvedSchema(), parentTable.getComment(), parentTable.getPartitionKeys(), parentTable.getOptions());
            this.source = source;
            this.sink = sink;
        }

        public CatalogBaseTable copy() {
            return this.copy(this.getOptions());
        }

        public CatalogTable copy(Map<String, String> options) {
            CatalogTable parentTable = CatalogTable.of((Schema)this.getUnresolvedSchema(), (String)this.getComment(), (List)this.getPartitionKeys(), options);
            return new HarnessCatalogTable(parentTable, this.source, this.sink);
        }
    }

    private static class HarnessTableDescriptor
    extends TableDescriptor {
        @Nullable
        private final SourceBase source;
        @Nullable
        private final SinkBase sink;

        private HarnessTableDescriptor(Schema schema, @Nullable SourceBase source, @Nullable SinkBase sink) {
            super(schema, Collections.singletonMap(FactoryUtil.CONNECTOR.key(), TableFactoryHarness.IDENTIFIER), Collections.emptyList(), null);
            this.source = source;
            this.sink = sink;
        }

        public CatalogTable toCatalogTable() {
            return new HarnessCatalogTable(super.toCatalogTable(), this.source, this.sink);
        }

        public TableDescriptor.Builder toBuilder() {
            return new Builder(this).source(this.source).sink(this.sink);
        }

        public static class Builder
        extends TableDescriptor.Builder {
            @Nullable
            private Schema schema;
            @Nullable
            private SourceBase source;
            @Nullable
            private SinkBase sink;

            private Builder() {
            }

            private Builder(TableDescriptor descriptor) {
                super(descriptor);
            }

            public Builder schema(Schema schema) {
                this.schema = schema;
                return this;
            }

            public Builder boundedScanSource() {
                return this.source(new ScanSourceBase(true){});
            }

            public Builder unboundedScanSource() {
                return this.source(new ScanSourceBase(false){});
            }

            public Builder unboundedScanSource(final ChangelogMode changelogMode) {
                return this.source(new ScanSourceBase(false){

                    @Override
                    public ChangelogMode getChangelogMode() {
                        return changelogMode;
                    }
                });
            }

            public Builder lookupSource() {
                return this.source(new LookupSourceBase(){});
            }

            public Builder source(SourceBase source) {
                this.source = source;
                return this;
            }

            public Builder sink() {
                return this.sink(new SinkBase(){});
            }

            public Builder sink(SinkBase sink) {
                this.sink = sink;
                return this;
            }

            public TableDescriptor build() {
                return new HarnessTableDescriptor(this.schema, this.source, this.sink);
            }
        }
    }

    public static class Factory
    implements DynamicTableSourceFactory,
    DynamicTableSinkFactory {
        public String factoryIdentifier() {
            return TableFactoryHarness.IDENTIFIER;
        }

        public Set<ConfigOption<?>> requiredOptions() {
            return Collections.emptySet();
        }

        public Set<ConfigOption<?>> optionalOptions() {
            return Collections.emptySet();
        }

        public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
            FactoryUtil.TableFactoryHelper factoryHelper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
            factoryHelper.validate();
            HarnessCatalogTable catalogTable = (HarnessCatalogTable)context.getCatalogTable().getOrigin();
            if (catalogTable.source == null) {
                throw new ValidationException(String.format("Table '%s' has no source configured.", context.getObjectIdentifier()));
            }
            catalogTable.source.factoryContext = context;
            return catalogTable.source;
        }

        public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
            FactoryUtil.TableFactoryHelper factoryHelper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
            factoryHelper.validate();
            HarnessCatalogTable catalogTable = (HarnessCatalogTable)context.getCatalogTable().getOrigin();
            if (catalogTable.sink == null) {
                throw new ValidationException(String.format("Table '%s' has no sink configured.", context.getObjectIdentifier()));
            }
            catalogTable.sink.factoryContext = context;
            return catalogTable.sink;
        }
    }
}

