/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.factories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;

public class TestTimeTravelCatalog
extends GenericInMemoryCatalog {
    private final Map<ObjectPath, List<Tuple2<Long, CatalogTable>>> timeTravelTables = new HashMap<ObjectPath, List<Tuple2<Long, CatalogTable>>>();

    public TestTimeTravelCatalog(String name) {
        super(name);
    }

    public CatalogBaseTable getTable(ObjectPath tablePath, long timestamp) throws TableNotExistException {
        List<Tuple2<Long, CatalogTable>> tableList;
        Optional<Tuple2> table;
        if (this.timeTravelTables.containsKey(tablePath) && (table = (tableList = this.timeTravelTables.get(tablePath)).stream().filter(t -> (Long)t.f0 <= timestamp).max(Comparator.comparing(t -> (Long)t.f0))).isPresent()) {
            return (CatalogBaseTable)table.get().f1;
        }
        return super.getTable(tablePath);
    }

    public void registerTableForTimeTravel(String tableName, Schema schema, Map<String, String> properties, long timestamp) throws TableAlreadyExistException, DatabaseNotExistException, TableNotExistException {
        CatalogTable catalogTable = CatalogTable.of((Schema)schema, (String)"", Collections.emptyList(), properties, (Long)timestamp);
        ObjectPath objectPath = new ObjectPath(this.getDefaultDatabase(), tableName);
        if (!this.timeTravelTables.containsKey(objectPath)) {
            this.timeTravelTables.put(objectPath, new ArrayList());
        }
        this.timeTravelTables.get(objectPath).add((Tuple2<Long, CatalogTable>)Tuple2.of((Object)timestamp, (Object)catalogTable));
        if (super.tableExists(objectPath)) {
            super.dropTable(objectPath, true);
        }
        super.createTable(objectPath, (CatalogBaseTable)catalogTable, true);
    }
}

