/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;

public class CastFunctionITCase
extends BuiltInFunctionTestBase {
    private static final ZoneId TEST_TZ = ZoneId.of("Asia/Shanghai");
    private static final ZoneOffset TEST_OFFSET = ZoneOffset.ofHoursMinutes(-1, -20);
    private static final byte[] DEFAULT_BINARY = new byte[]{0, 1};
    private static final byte[] DEFAULT_VARBINARY = new byte[]{0, 1, 2};
    private static final byte[] DEFAULT_BYTES = new byte[]{0, 1, 2, 3, 4};
    private static final byte DEFAULT_POSITIVE_TINY_INT = 5;
    private static final byte DEFAULT_NEGATIVE_TINY_INT = -5;
    private static final short DEFAULT_POSITIVE_SMALL_INT = 12345;
    private static final short DEFAULT_NEGATIVE_SMALL_INT = -12345;
    private static final int DEFAULT_POSITIVE_INT = 1234567;
    private static final int DEFAULT_NEGATIVE_INT = -1234567;
    private static final long DEFAULT_POSITIVE_BIGINT = 12345678901L;
    private static final long DEFAULT_NEGATIVE_BIGINT = -12345678901L;
    private static final float DEFAULT_POSITIVE_FLOAT = 123.456f;
    private static final float DEFAULT_NEGATIVE_FLOAT = -123.456f;
    private static final double DEFAULT_POSITIVE_DOUBLE = 123.456789;
    private static final double DEFAULT_NEGATIVE_DOUBLE = -123.456789;
    private static final LocalDate DEFAULT_DATE = LocalDate.parse("2021-09-24");
    private static final LocalTime DEFAULT_TIME = LocalTime.parse("12:34:56.123");
    private static final LocalDateTime DEFAULT_TIMESTAMP = LocalDateTime.parse("2021-09-24T12:34:56.1234567");
    private static final Instant DEFAULT_TIMESTAMP_LTZ = CastFunctionITCase.fromLocalTZ("2021-09-24T22:34:56.1234567");
    private static final Period DEFAULT_INTERVAL_YEAR = Period.of(10, 4, 0);
    private static final Duration DEFAULT_INTERVAL_DAY = Duration.ofHours(12L);
    private static final int[] DEFAULT_ARRAY = new int[]{0, 1, 2};

    @Override
    Configuration getConfiguration() {
        return super.getConfiguration().set(TableConfigOptions.LOCAL_TIME_ZONE, (Object)TEST_TZ.getId());
    }

    @Override
    Stream<BuiltInFunctionTestBase.TestSetSpec> getTestSetSpecs() {
        ArrayList<BuiltInFunctionTestBase.TestSetSpec> specs = new ArrayList<BuiltInFunctionTestBase.TestSetSpec>();
        specs.addAll(CastFunctionITCase.allTypesBasic());
        specs.addAll(CastFunctionITCase.toStringCasts());
        specs.addAll(CastFunctionITCase.decimalCasts());
        specs.addAll(CastFunctionITCase.numericBounds());
        specs.addAll(CastFunctionITCase.constructedTypes());
        return specs.stream();
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> allTypesBasic() {
        return Arrays.asList(CastTestSpecBuilder.testCastTo(DataTypes.BOOLEAN()).fromCase(DataTypes.BOOLEAN(), null, null).failRuntime(DataTypes.CHAR((int)3), "foo", TableException.class).fromCase(DataTypes.CHAR((int)4), "true", true).fromCase(DataTypes.VARCHAR((int)5), "FalsE", false).failRuntime(DataTypes.STRING(), "Apache Flink", TableException.class).fromCase(DataTypes.STRING(), "TRUE", true).failRuntime(DataTypes.STRING(), "", TableException.class).fromCase(DataTypes.BOOLEAN(), true, true).fromCase(DataTypes.BOOLEAN(), false, false).failValidation(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY).failValidation(DataTypes.VARBINARY((int)5), CastFunctionITCase.DEFAULT_VARBINARY).failValidation(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES).failTableApiValidation(DataTypes.DECIMAL((int)4, (int)3), 4.3).fromCase(DataTypes.TINYINT(), (byte)5, true).fromCase(DataTypes.TINYINT(), (byte)-5, true).fromCase(DataTypes.TINYINT(), 0, false).fromCase(DataTypes.SMALLINT(), (short)12345, true).fromCase(DataTypes.SMALLINT(), (short)-12345, true).fromCase(DataTypes.SMALLINT(), 0, false).fromCase(DataTypes.INT(), 1234567, true).fromCase(DataTypes.INT(), -1234567, true).fromCase(DataTypes.INT(), 0, false).fromCase(DataTypes.BIGINT(), 12345678901L, true).fromCase(DataTypes.BIGINT(), -12345678901L, true).fromCase(DataTypes.BIGINT(), 0, false).failTableApiValidation(DataTypes.FLOAT(), -123.456).failTableApiValidation(DataTypes.DOUBLE(), 0).failValidation(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE).failValidation(DataTypes.TIME(), CastFunctionITCase.DEFAULT_TIME).failValidation(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP).failValidation(DataTypes.TIMESTAMP_LTZ(), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), CastFunctionITCase.DEFAULT_INTERVAL_YEAR).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), CastFunctionITCase.DEFAULT_INTERVAL_DAY).failValidation(DataTypes.ARRAY((DataType)DataTypes.INT()), CastFunctionITCase.DEFAULT_ARRAY).build(), CastTestSpecBuilder.testCastTo(DataTypes.BINARY((int)2)).fromCase(DataTypes.BINARY((int)5), null, null).fromCase(DataTypes.CHAR((int)4), "666F", new byte[]{54, 54}).fromCase(DataTypes.VARCHAR((int)8), "666f", new byte[]{54, 54}).fromCase(DataTypes.STRING(), "a", new byte[]{97, 0}).fromCase(DataTypes.VARCHAR((int)4), "FC", new byte[]{70, 67}).fromCase(DataTypes.STRING(), "foobar", new byte[]{102, 111}).failValidation(DataTypes.BOOLEAN(), true).fromCase(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY, CastFunctionITCase.DEFAULT_BINARY).fromCase(DataTypes.VARBINARY((int)3), CastFunctionITCase.DEFAULT_VARBINARY, new byte[]{0, 1}).fromCase(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES, new byte[]{0, 1}).fromCase(DataTypes.BINARY((int)1), new byte[]{111}, new byte[]{111, 0}).fromCase(DataTypes.VARBINARY((int)1), new byte[]{111}, new byte[]{111, 0}).fromCase(DataTypes.BYTES(), new byte[]{11}, new byte[]{11, 0}).failValidation(DataTypes.DECIMAL((int)5, (int)3), 12.345).failValidation(DataTypes.TINYINT(), (byte)-5).failValidation(DataTypes.SMALLINT(), (short)12345).failValidation(DataTypes.INT(), 1234567).failValidation(DataTypes.BIGINT(), 12345678901L).failValidation(DataTypes.FLOAT(), Float.valueOf(123.456f)).failValidation(DataTypes.DOUBLE(), 123.456789).failValidation(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE).failValidation(DataTypes.TIME(), CastFunctionITCase.DEFAULT_TIME).failValidation(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP).failValidation(DataTypes.TIMESTAMP_LTZ(), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), CastFunctionITCase.DEFAULT_INTERVAL_YEAR).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), CastFunctionITCase.DEFAULT_INTERVAL_DAY).failValidation(DataTypes.ARRAY((DataType)DataTypes.INT()), CastFunctionITCase.DEFAULT_ARRAY).build(), CastTestSpecBuilder.testCastTo(DataTypes.VARBINARY((int)4)).fromCase(DataTypes.VARBINARY((int)5), null, null).fromCase(DataTypes.CHAR((int)4), "foo", new byte[]{102, 111, 111, 32}).fromCase(DataTypes.VARCHAR((int)8), "foobar", new byte[]{102, 111, 111, 98}).fromCase(DataTypes.STRING(), "AAbbCcDdEe", new byte[]{65, 65, 98, 98}).failValidation(DataTypes.BOOLEAN(), true).fromCase(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY, CastFunctionITCase.DEFAULT_BINARY).fromCase(DataTypes.VARBINARY((int)3), CastFunctionITCase.DEFAULT_VARBINARY, CastFunctionITCase.DEFAULT_VARBINARY).fromCase(DataTypes.VARBINARY((int)10), CastFunctionITCase.DEFAULT_VARBINARY, CastFunctionITCase.DEFAULT_VARBINARY).fromCase(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES, new byte[]{0, 1, 2, 3}).failValidation(DataTypes.DECIMAL((int)5, (int)3), 12.345).failValidation(DataTypes.TINYINT(), (byte)-5).failValidation(DataTypes.SMALLINT(), (short)12345).failValidation(DataTypes.INT(), 1234567).failValidation(DataTypes.BIGINT(), 12345678901L).failValidation(DataTypes.FLOAT(), Float.valueOf(123.456f)).failValidation(DataTypes.DOUBLE(), 123.456789).failValidation(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE).failValidation(DataTypes.TIME(), CastFunctionITCase.DEFAULT_TIME).failValidation(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP).failValidation(DataTypes.TIMESTAMP_LTZ(), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), CastFunctionITCase.DEFAULT_INTERVAL_YEAR).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), CastFunctionITCase.DEFAULT_INTERVAL_DAY).failValidation(DataTypes.ARRAY((DataType)DataTypes.INT()), CastFunctionITCase.DEFAULT_ARRAY).build(), CastTestSpecBuilder.testCastTo(DataTypes.BYTES()).fromCase(DataTypes.BYTES(), null, null).fromCase(DataTypes.CHAR((int)4), "foo", new byte[]{102, 111, 111, 32}).fromCase(DataTypes.VARCHAR((int)8), "foobar", new byte[]{102, 111, 111, 98, 97, 114}).fromCase(DataTypes.STRING(), "Apache Flink", new byte[]{65, 112, 97, 99, 104, 101, 32, 70, 108, 105, 110, 107}).failValidation(DataTypes.BOOLEAN(), true).fromCase(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY, CastFunctionITCase.DEFAULT_BINARY).fromCase(DataTypes.VARBINARY((int)3), CastFunctionITCase.DEFAULT_VARBINARY, CastFunctionITCase.DEFAULT_VARBINARY).fromCase(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES, CastFunctionITCase.DEFAULT_BYTES).failValidation(DataTypes.DECIMAL((int)5, (int)3), 12.345).failValidation(DataTypes.TINYINT(), (byte)-5).failValidation(DataTypes.SMALLINT(), (short)12345).failValidation(DataTypes.INT(), 1234567).failValidation(DataTypes.BIGINT(), 12345678901L).failValidation(DataTypes.FLOAT(), Float.valueOf(123.456f)).failValidation(DataTypes.DOUBLE(), 123.456789).failValidation(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE).failValidation(DataTypes.TIME(), CastFunctionITCase.DEFAULT_TIME).failValidation(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP).failValidation(DataTypes.TIMESTAMP_LTZ(), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), CastFunctionITCase.DEFAULT_INTERVAL_YEAR).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), CastFunctionITCase.DEFAULT_INTERVAL_DAY).failValidation(DataTypes.ARRAY((DataType)DataTypes.INT()), CastFunctionITCase.DEFAULT_ARRAY).build(), CastTestSpecBuilder.testCastTo(DataTypes.DECIMAL((int)5, (int)3)).fromCase(DataTypes.DECIMAL((int)10, (int)2), null, null).failRuntime(DataTypes.CHAR((int)3), "foo", NumberFormatException.class).failRuntime(DataTypes.VARCHAR((int)5), "Flink", NumberFormatException.class).failRuntime(DataTypes.STRING(), "Apache", NumberFormatException.class).fromCase(DataTypes.STRING(), "1.234", new BigDecimal("1.234")).fromCase(DataTypes.STRING(), "1.2", new BigDecimal("1.200")).fromCase(DataTypes.BOOLEAN(), true, new BigDecimal("1.000")).fromCase(DataTypes.BOOLEAN(), false, new BigDecimal("0.000")).failValidation(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY).failValidation(DataTypes.VARBINARY((int)5), CastFunctionITCase.DEFAULT_VARBINARY).failValidation(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES).fromCase(DataTypes.DECIMAL((int)4, (int)3), 9.87, new BigDecimal("9.870")).fromCase(DataTypes.TINYINT(), -1, new BigDecimal("-1.000")).fromCase(DataTypes.SMALLINT(), 3, new BigDecimal("3.000")).fromCase(DataTypes.INT(), 42, new BigDecimal("42.000")).fromCase(DataTypes.BIGINT(), 8, new BigDecimal("8.000")).fromCase(DataTypes.FLOAT(), -12.345, new BigDecimal("-12.345")).fromCase(DataTypes.DOUBLE(), 12.678, new BigDecimal("12.678")).failValidation(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE).failValidation(DataTypes.TIME(), CastFunctionITCase.DEFAULT_TIME).failValidation(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP).failValidation(DataTypes.TIMESTAMP_LTZ(), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), CastFunctionITCase.DEFAULT_INTERVAL_YEAR).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), CastFunctionITCase.DEFAULT_INTERVAL_DAY).failValidation(DataTypes.ARRAY((DataType)DataTypes.INT()), CastFunctionITCase.DEFAULT_ARRAY).build(), CastTestSpecBuilder.testCastTo(DataTypes.TINYINT()).fromCase(DataTypes.TINYINT(), null, null).failRuntime(DataTypes.CHAR((int)3), "foo", NumberFormatException.class).failRuntime(DataTypes.VARCHAR((int)5), "Flink", NumberFormatException.class).failRuntime(DataTypes.STRING(), "Apache", NumberFormatException.class).fromCase(DataTypes.STRING(), "1.234", (byte)1).fromCase(DataTypes.STRING(), "123", (byte)123).failRuntime(DataTypes.STRING(), "-130", NumberFormatException.class).fromCase(DataTypes.BOOLEAN(), true, (byte)1).fromCase(DataTypes.BOOLEAN(), false, (byte)0).failValidation(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY).failValidation(DataTypes.VARBINARY((int)5), CastFunctionITCase.DEFAULT_VARBINARY).failValidation(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES).fromCase(DataTypes.DECIMAL((int)4, (int)3), 9.87, (byte)9).fromCase(DataTypes.DECIMAL((int)10, (int)3), 9123.87, (byte)-93).fromCase(DataTypes.TINYINT(), (byte)5, (byte)5).fromCase(DataTypes.TINYINT(), (byte)-5, (byte)-5).fromCase(DataTypes.SMALLINT(), 32, (byte)32).fromCase(DataTypes.SMALLINT(), (short)12345, (byte)57).fromCase(DataTypes.SMALLINT(), (short)-12345, (byte)-57).fromCase(DataTypes.INT(), -12, (byte)-12).fromCase(DataTypes.INT(), 1234567, (byte)-121).fromCase(DataTypes.INT(), -1234567, (byte)121).fromCase(DataTypes.BIGINT(), 12345678901L, (byte)53).fromCase(DataTypes.BIGINT(), -12345678901L, (byte)-53).fromCase(DataTypes.FLOAT(), Float.valueOf(123.456f), (byte)123).fromCase(DataTypes.FLOAT(), Float.valueOf(-123.456f), (byte)-123).fromCase(DataTypes.DOUBLE(), 123.456789, (byte)123).fromCase(DataTypes.DOUBLE(), -123.456789, (byte)-123).failValidation(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE).failValidation(DataTypes.TIME(), CastFunctionITCase.DEFAULT_TIME).failValidation(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP).failValidation(DataTypes.TIMESTAMP_LTZ(), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), CastFunctionITCase.DEFAULT_INTERVAL_YEAR).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), CastFunctionITCase.DEFAULT_INTERVAL_DAY).failValidation(DataTypes.ARRAY((DataType)DataTypes.INT()), CastFunctionITCase.DEFAULT_ARRAY).build(), CastTestSpecBuilder.testCastTo(DataTypes.SMALLINT()).fromCase(DataTypes.SMALLINT(), null, null).failRuntime(DataTypes.CHAR((int)3), "foo", NumberFormatException.class).failRuntime(DataTypes.VARCHAR((int)5), "Flink", NumberFormatException.class).failRuntime(DataTypes.STRING(), "Apache", NumberFormatException.class).fromCase(DataTypes.STRING(), "1.234", (short)1).fromCase(DataTypes.STRING(), "123", (short)123).failRuntime(DataTypes.STRING(), "-32769", NumberFormatException.class).fromCase(DataTypes.BOOLEAN(), true, (short)1).fromCase(DataTypes.BOOLEAN(), false, (short)0).failValidation(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY).failValidation(DataTypes.VARBINARY((int)5), CastFunctionITCase.DEFAULT_VARBINARY).failValidation(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES).fromCase(DataTypes.DECIMAL((int)4, (int)3), 9.87, (short)9).fromCase(DataTypes.DECIMAL((int)10, (int)3), 91235.87, (short)25699).fromCase(DataTypes.TINYINT(), (byte)5, (short)5).fromCase(DataTypes.TINYINT(), (byte)-5, (short)-5).fromCase(DataTypes.SMALLINT(), (short)12345, (short)12345).fromCase(DataTypes.SMALLINT(), (short)-12345, (short)-12345).fromCase(DataTypes.SMALLINT(), 32780, (short)-32756).fromCase(DataTypes.INT(), 1234567, (short)-10617).fromCase(DataTypes.INT(), -1234567, (short)10617).fromCase(DataTypes.INT(), -12, (short)-12).fromCase(DataTypes.BIGINT(), 123, (short)123).fromCase(DataTypes.BIGINT(), 12345678901L, (short)7221).fromCase(DataTypes.BIGINT(), -12345678901L, (short)-7221).fromCase(DataTypes.FLOAT(), Float.valueOf(123.456f), (short)123).fromCase(DataTypes.FLOAT(), Float.valueOf(-123.456f), (short)-123).fromCase(DataTypes.FLOAT(), 123456.78, (short)-7616).fromCase(DataTypes.DOUBLE(), 123.456789, (short)123).fromCase(DataTypes.DOUBLE(), -123.456789, (short)-123).fromCase(DataTypes.DOUBLE(), 123456.789, (short)-7616).failValidation(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE).failValidation(DataTypes.TIME(), CastFunctionITCase.DEFAULT_TIME).failValidation(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP).failValidation(DataTypes.TIMESTAMP_LTZ(), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), CastFunctionITCase.DEFAULT_INTERVAL_YEAR).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), CastFunctionITCase.DEFAULT_INTERVAL_DAY).failValidation(DataTypes.ARRAY((DataType)DataTypes.INT()), CastFunctionITCase.DEFAULT_ARRAY).build(), CastTestSpecBuilder.testCastTo(DataTypes.INT()).fromCase(DataTypes.INT(), null, null).failRuntime(DataTypes.CHAR((int)3), "foo", NumberFormatException.class).failRuntime(DataTypes.VARCHAR((int)5), "Flink", NumberFormatException.class).failRuntime(DataTypes.STRING(), "Apache", NumberFormatException.class).fromCase(DataTypes.STRING(), "1.234", 1).fromCase(DataTypes.STRING(), "123", 123).failRuntime(DataTypes.STRING(), "-3276913443134", NumberFormatException.class).fromCase(DataTypes.BOOLEAN(), true, 1).fromCase(DataTypes.BOOLEAN(), false, 0).failValidation(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY).failValidation(DataTypes.VARBINARY((int)5), CastFunctionITCase.DEFAULT_VARBINARY).failValidation(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES).fromCase(DataTypes.DECIMAL((int)4, (int)3), 9.87, 9).fromCase(DataTypes.DECIMAL((int)20, (int)3), 3.27691344313487E12, -146603714).fromCase(DataTypes.TINYINT(), (byte)5, 5).fromCase(DataTypes.TINYINT(), (byte)-5, -5).fromCase(DataTypes.SMALLINT(), (short)12345, 12345).fromCase(DataTypes.SMALLINT(), (short)-12345, -12345).fromCase(DataTypes.INT(), 1234567, 1234567).fromCase(DataTypes.INT(), -1234567, -1234567).fromCase(DataTypes.BIGINT(), 123, 123).fromCase(DataTypes.BIGINT(), 12345678901L, -539222987).fromCase(DataTypes.BIGINT(), -12345678901L, 539222987).fromCase(DataTypes.FLOAT(), Float.valueOf(123.456f), 123).fromCase(DataTypes.FLOAT(), Float.valueOf(-123.456f), -123).fromCase(DataTypes.FLOAT(), Float.valueOf(9.234568E9f), Integer.MAX_VALUE).fromCase(DataTypes.DOUBLE(), 123.456789, 123).fromCase(DataTypes.DOUBLE(), -123.456789, -123).fromCase(DataTypes.DOUBLE(), 9.23456789112345E9, Integer.MAX_VALUE).failValidation(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE).failValidation(DataTypes.TIME(), CastFunctionITCase.DEFAULT_TIME).failValidation(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP).failValidation(DataTypes.TIMESTAMP_LTZ(), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), CastFunctionITCase.DEFAULT_INTERVAL_YEAR).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), CastFunctionITCase.DEFAULT_INTERVAL_DAY).failValidation(DataTypes.ARRAY((DataType)DataTypes.INT()), CastFunctionITCase.DEFAULT_ARRAY).build(), CastTestSpecBuilder.testCastTo(DataTypes.BIGINT()).fromCase(DataTypes.BIGINT(), null, null).failRuntime(DataTypes.CHAR((int)3), "foo", NumberFormatException.class).failRuntime(DataTypes.VARCHAR((int)5), "Flink", NumberFormatException.class).failRuntime(DataTypes.STRING(), "Apache", NumberFormatException.class).fromCase(DataTypes.STRING(), "1.234", 1L).fromCase(DataTypes.STRING(), "123", 123L).fromCase(DataTypes.STRING(), "-3276913443134", -3276913443134L).fromCase(DataTypes.BOOLEAN(), true, 1L).fromCase(DataTypes.BOOLEAN(), false, 0L).failValidation(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY).failValidation(DataTypes.VARBINARY((int)5), CastFunctionITCase.DEFAULT_VARBINARY).failValidation(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES).fromCase(DataTypes.DECIMAL((int)4, (int)3), 9.87, 9L).fromCase(DataTypes.DECIMAL((int)20, (int)3), 3.27691344313487E12, 3276913443134L).fromCase(DataTypes.TINYINT(), (byte)5, 5L).fromCase(DataTypes.TINYINT(), (byte)-5, -5L).fromCase(DataTypes.SMALLINT(), (short)12345, 12345L).fromCase(DataTypes.SMALLINT(), (short)-12345, -12345L).fromCase(DataTypes.INT(), 1234567, 1234567L).fromCase(DataTypes.INT(), -1234567, -1234567L).fromCase(DataTypes.BIGINT(), 12345678901L, 12345678901L).fromCase(DataTypes.BIGINT(), -12345678901L, -12345678901L).fromCase(DataTypes.FLOAT(), Float.valueOf(123.456f), 123L).fromCase(DataTypes.FLOAT(), Float.valueOf(-123.456f), -123L).fromCase(DataTypes.FLOAT(), Float.valueOf(9.234568E9f), 9234568192L).fromCase(DataTypes.DOUBLE(), 123.456789, 123L).fromCase(DataTypes.DOUBLE(), -123.456789, -123L).fromCase(DataTypes.DOUBLE(), 9.23456789112345E9, 9234567891L).failValidation(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE).failValidation(DataTypes.TIME(), CastFunctionITCase.DEFAULT_TIME).failValidation(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP).failValidation(DataTypes.TIMESTAMP_LTZ(), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), CastFunctionITCase.DEFAULT_INTERVAL_YEAR).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), CastFunctionITCase.DEFAULT_INTERVAL_DAY).failValidation(DataTypes.ARRAY((DataType)DataTypes.INT()), CastFunctionITCase.DEFAULT_ARRAY).build(), CastTestSpecBuilder.testCastTo(DataTypes.FLOAT()).fromCase(DataTypes.FLOAT(), null, null).failRuntime(DataTypes.CHAR((int)3), "foo", NumberFormatException.class).failRuntime(DataTypes.VARCHAR((int)5), "Flink", NumberFormatException.class).failRuntime(DataTypes.STRING(), "Apache", NumberFormatException.class).fromCase(DataTypes.STRING(), "1.234", Float.valueOf(1.234f)).fromCase(DataTypes.STRING(), "123", Float.valueOf(123.0f)).fromCase(DataTypes.STRING(), "-3276913443134", Float.valueOf(-3.276914E12f)).fromCase(DataTypes.BOOLEAN(), true, Float.valueOf(1.0f)).fromCase(DataTypes.BOOLEAN(), false, Float.valueOf(0.0f)).failValidation(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY).failValidation(DataTypes.VARBINARY((int)5), CastFunctionITCase.DEFAULT_VARBINARY).failValidation(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES).fromCase(DataTypes.DECIMAL((int)4, (int)3), 9.87, Float.valueOf(9.87f)).fromCase(DataTypes.DECIMAL((int)4, (int)3), 9.87, Float.valueOf(9.87f)).fromCase(DataTypes.DECIMAL((int)20, (int)3), 3.27691344313487E12, Float.valueOf(3.2769135E12f)).fromCase(DataTypes.TINYINT(), (byte)5, Float.valueOf(5.0f)).fromCase(DataTypes.TINYINT(), (byte)-5, Float.valueOf(-5.0f)).fromCase(DataTypes.SMALLINT(), (short)12345, Float.valueOf(12345.0f)).fromCase(DataTypes.SMALLINT(), (short)-12345, Float.valueOf(-12345.0f)).fromCase(DataTypes.INT(), 1234567, Float.valueOf(1234567.0f)).fromCase(DataTypes.INT(), -1234567, Float.valueOf(-1234567.0f)).fromCase(DataTypes.BIGINT(), 12345678901L, Float.valueOf(1.2345679E10f)).fromCase(DataTypes.BIGINT(), -12345678901L, Float.valueOf(-1.2345679E10f)).fromCase(DataTypes.FLOAT(), Float.valueOf(123.456f), Float.valueOf(123.456f)).fromCase(DataTypes.FLOAT(), Float.valueOf(-123.456f), Float.valueOf(-123.456f)).fromCase(DataTypes.FLOAT(), 9.23456789112E9, Float.valueOf(9.234568E9f)).fromCase(DataTypes.DOUBLE(), 123.456789, Float.valueOf(123.45679f)).fromCase(DataTypes.DOUBLE(), -123.456789, Float.valueOf(-123.45679f)).fromCase(DataTypes.DOUBLE(), 1.2392345678911235E12, Float.valueOf(1.2392345E12f)).failValidation(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE).failValidation(DataTypes.TIME(), CastFunctionITCase.DEFAULT_TIME).failValidation(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP).failValidation(DataTypes.TIMESTAMP_LTZ(), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), CastFunctionITCase.DEFAULT_INTERVAL_YEAR).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), CastFunctionITCase.DEFAULT_INTERVAL_DAY).failValidation(DataTypes.ARRAY((DataType)DataTypes.INT()), CastFunctionITCase.DEFAULT_ARRAY).build(), CastTestSpecBuilder.testCastTo(DataTypes.DOUBLE()).fromCase(DataTypes.DOUBLE(), null, null).failRuntime(DataTypes.CHAR((int)3), "foo", NumberFormatException.class).failRuntime(DataTypes.VARCHAR((int)5), "Flink", NumberFormatException.class).failRuntime(DataTypes.STRING(), "Apache", NumberFormatException.class).fromCase(DataTypes.STRING(), "1.234", 1.234).fromCase(DataTypes.STRING(), "123", 123.0).fromCase(DataTypes.STRING(), "-3276913443134", -3.276913443134E12).fromCase(DataTypes.BOOLEAN(), true, 1.0).fromCase(DataTypes.BOOLEAN(), false, 0.0).failValidation(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY).failValidation(DataTypes.VARBINARY((int)5), CastFunctionITCase.DEFAULT_VARBINARY).failValidation(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES).fromCase(DataTypes.DECIMAL((int)4, (int)3), 9.87, 9.87).fromCase(DataTypes.DECIMAL((int)20, (int)3), 3.27691344313487E12, 3.27691344313487E12).fromCase(DataTypes.DECIMAL((int)30, (int)20), new BigDecimal("123456789.123456789123456789"), 1.2345678912345679E8).fromCase(DataTypes.TINYINT(), (byte)5, 5.0).fromCase(DataTypes.TINYINT(), (byte)-5, -5.0).fromCase(DataTypes.SMALLINT(), (short)12345, 12345.0).fromCase(DataTypes.SMALLINT(), (short)-12345, -12345.0).fromCase(DataTypes.INT(), 1234567, 1234567.0).fromCase(DataTypes.INT(), -1234567, -1234567.0).fromCase(DataTypes.BIGINT(), 12345678901L, 1.2345678901E10).fromCase(DataTypes.BIGINT(), -12345678901L, -1.2345678901E10).fromCase(DataTypes.FLOAT(), Float.valueOf(123.456f), 123.456).fromCase(DataTypes.FLOAT(), Float.valueOf(-123.456f), -123.456).fromCase(DataTypes.FLOAT(), 9.23456789112E9, 9.23456789112E9).fromCase(DataTypes.DOUBLE(), 123.456789, 123.456789).fromCase(DataTypes.DOUBLE(), -123.456789, -123.456789).fromCase(DataTypes.DOUBLE(), 1.2392345678911235E12, 1.2392345678911235E12).failValidation(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE).failValidation(DataTypes.TIME(), CastFunctionITCase.DEFAULT_TIME).failValidation(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP).failValidation(DataTypes.TIMESTAMP_LTZ(), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), CastFunctionITCase.DEFAULT_INTERVAL_YEAR).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), CastFunctionITCase.DEFAULT_INTERVAL_DAY).failValidation(DataTypes.ARRAY((DataType)DataTypes.INT()), CastFunctionITCase.DEFAULT_ARRAY).build(), CastTestSpecBuilder.testCastTo(DataTypes.DATE()).fromCase(DataTypes.DATE(), null, null).failRuntime(DataTypes.CHAR((int)3), "foo", DateTimeException.class).failRuntime(DataTypes.VARCHAR((int)5), "Flink", DateTimeException.class).fromCase(DataTypes.STRING(), "123", LocalDate.of(123, 1, 1)).fromCase(DataTypes.STRING(), "2021-09-27", LocalDate.of(2021, 9, 27)).fromCase(DataTypes.STRING(), "2021-09-27 12:34:56.123456789", LocalDate.of(2021, 9, 27)).failRuntime(DataTypes.STRING(), "2021/09/27", DateTimeException.class).failValidation(DataTypes.BOOLEAN(), true).failTableApiValidation(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY).failTableApiValidation(DataTypes.VARBINARY((int)5), CastFunctionITCase.DEFAULT_VARBINARY).failTableApiValidation(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES).failValidation(DataTypes.DECIMAL((int)5, (int)3), 12.345).failValidation(DataTypes.TINYINT(), (byte)5).failValidation(DataTypes.SMALLINT(), (short)12345).failValidation(DataTypes.INT(), 1234567).failValidation(DataTypes.BIGINT(), 12345678901L).failValidation(DataTypes.FLOAT(), Float.valueOf(123.456f)).failValidation(DataTypes.DOUBLE(), 123.456789).fromCase(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE, CastFunctionITCase.DEFAULT_DATE).failValidation(DataTypes.TIME(), CastFunctionITCase.DEFAULT_TIME).fromCase(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP, LocalDate.of(2021, 9, 24)).fromCase(DataTypes.TIMESTAMP((int)4), CastFunctionITCase.DEFAULT_TIMESTAMP, LocalDate.of(2021, 9, 24)).fromCase(DataTypes.TIMESTAMP_LTZ(), CastFunctionITCase.DEFAULT_TIMESTAMP, LocalDate.of(2021, 9, 24)).fromCase(DataTypes.TIMESTAMP_LTZ(), CastFunctionITCase.DEFAULT_TIMESTAMP, LocalDate.of(2021, 9, 24)).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), CastFunctionITCase.DEFAULT_INTERVAL_YEAR).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), CastFunctionITCase.DEFAULT_INTERVAL_DAY).failValidation(DataTypes.ARRAY((DataType)DataTypes.INT()), CastFunctionITCase.DEFAULT_ARRAY).build(), CastTestSpecBuilder.testCastTo(DataTypes.TIME()).fromCase(DataTypes.TIME(), null, null).failRuntime(DataTypes.CHAR((int)3), "foo", DateTimeException.class).failRuntime(DataTypes.VARCHAR((int)5), "Flink", DateTimeException.class).failRuntime(DataTypes.STRING(), "Flink", DateTimeException.class).fromCase(DataTypes.STRING(), "123", LocalTime.of(23, 0, 0)).fromCase(DataTypes.STRING(), "123:45", LocalTime.of(23, 45, 0)).failRuntime(DataTypes.STRING(), "2021-09-27", DateTimeException.class).failRuntime(DataTypes.STRING(), "2021-09-27 12:34:56", DateTimeException.class).fromCase(DataTypes.STRING(), "12:34:56.123456789", LocalTime.of(12, 34, 56, 0)).failRuntime(DataTypes.STRING(), "2021-09-27 12:34:56.123456789", DateTimeException.class).failValidation(DataTypes.BOOLEAN(), true).failTableApiValidation(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY).failTableApiValidation(DataTypes.VARBINARY((int)5), CastFunctionITCase.DEFAULT_VARBINARY).failTableApiValidation(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES).failValidation(DataTypes.DECIMAL((int)5, (int)3), 12.345).failValidation(DataTypes.TINYINT(), (byte)5).failValidation(DataTypes.SMALLINT(), (short)12345).failValidation(DataTypes.INT(), 1234567).failValidation(DataTypes.BIGINT(), 12345678901L).failValidation(DataTypes.FLOAT(), Float.valueOf(123.456f)).failValidation(DataTypes.DOUBLE(), 123.456789).failValidation(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE).fromCase(DataTypes.TIME((int)5), CastFunctionITCase.DEFAULT_TIME, LocalTime.of(12, 34, 56, 0)).fromCase(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP, LocalTime.of(12, 34, 56, 0)).fromCase(DataTypes.TIMESTAMP((int)4), CastFunctionITCase.DEFAULT_TIMESTAMP, LocalTime.of(12, 34, 56, 0)).fromCase(DataTypes.TIMESTAMP_LTZ((int)4), CastFunctionITCase.DEFAULT_TIMESTAMP, LocalTime.of(12, 34, 56, 0)).fromCase(DataTypes.TIMESTAMP_LTZ((int)4), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ, LocalTime.of(7, 54, 56, 0)).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), CastFunctionITCase.DEFAULT_INTERVAL_YEAR).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), CastFunctionITCase.DEFAULT_INTERVAL_DAY).failValidation(DataTypes.ARRAY((DataType)DataTypes.INT()), CastFunctionITCase.DEFAULT_ARRAY).build(), CastTestSpecBuilder.testCastTo(DataTypes.TIMESTAMP((int)9)).fromCase(DataTypes.TIMESTAMP(), null, null).failRuntime(DataTypes.CHAR((int)3), "foo", DateTimeException.class).failRuntime(DataTypes.VARCHAR((int)5), "Flink", DateTimeException.class).failRuntime(DataTypes.STRING(), "123", DateTimeException.class).fromCase(DataTypes.STRING(), "2021-09-27", LocalDateTime.of(2021, 9, 27, 0, 0, 0, 0)).failRuntime(DataTypes.STRING(), "2021/09/27", DateTimeException.class).fromCase(DataTypes.STRING(), "2021-09-27 12:34:56.123456789", LocalDateTime.of(2021, 9, 27, 12, 34, 56, 123456789)).failValidation(DataTypes.BOOLEAN(), true).failTableApiValidation(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY).failTableApiValidation(DataTypes.VARBINARY((int)5), CastFunctionITCase.DEFAULT_VARBINARY).failTableApiValidation(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES).failValidation(DataTypes.DECIMAL((int)5, (int)3), 12.345).failValidation(DataTypes.TINYINT(), (byte)5).failValidation(DataTypes.SMALLINT(), (short)12345).failValidation(DataTypes.INT(), 1234567).failValidation(DataTypes.BIGINT(), 12345678901L).failValidation(DataTypes.FLOAT(), Float.valueOf(123.456f)).failValidation(DataTypes.DOUBLE(), 123.456789).fromCase(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE, LocalDateTime.of(2021, 9, 24, 0, 0, 0, 0)).fromCase(DataTypes.TIME((int)5), CastFunctionITCase.DEFAULT_TIME, LocalDateTime.of(1970, 1, 1, 12, 34, 56, 0)).fromCase(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP, LocalDateTime.of(2021, 9, 24, 12, 34, 56, 123456000)).fromCase(DataTypes.TIMESTAMP((int)8), CastFunctionITCase.DEFAULT_TIMESTAMP, LocalDateTime.of(2021, 9, 24, 12, 34, 56, 123456700)).fromCase(DataTypes.TIMESTAMP((int)4), CastFunctionITCase.DEFAULT_TIMESTAMP, LocalDateTime.of(2021, 9, 24, 12, 34, 56, 123400000)).fromCase(DataTypes.TIMESTAMP_LTZ((int)4), CastFunctionITCase.DEFAULT_TIMESTAMP, LocalDateTime.of(2021, 9, 24, 12, 34, 56, 123400000)).fromCase(DataTypes.TIMESTAMP_LTZ((int)4), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ, LocalDateTime.of(2021, 9, 25, 7, 54, 56, 123400000)).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), CastFunctionITCase.DEFAULT_INTERVAL_YEAR).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), CastFunctionITCase.DEFAULT_INTERVAL_DAY).failValidation(DataTypes.ARRAY((DataType)DataTypes.INT()), CastFunctionITCase.DEFAULT_ARRAY).build(), CastTestSpecBuilder.testCastTo(DataTypes.TIMESTAMP_LTZ((int)9)).fromCase(DataTypes.TIMESTAMP_LTZ(), null, null).failRuntime(DataTypes.CHAR((int)3), "foo", DateTimeParseException.class).failRuntime(DataTypes.VARCHAR((int)5), "Flink", DateTimeParseException.class).failRuntime(DataTypes.STRING(), "Apache", DateTimeParseException.class).fromCase(DataTypes.STRING(), "2021-09-27", CastFunctionITCase.fromLocalToUTC(LocalDateTime.of(2021, 9, 27, 0, 0, 0, 0))).fromCase(DataTypes.STRING(), "2021-09-27 12:34:56.123", CastFunctionITCase.fromLocalToUTC(LocalDateTime.of(2021, 9, 27, 12, 34, 56, 123000000))).fromCase(DataTypes.STRING(), "2021-09-27 12:34:56.123456789", CastFunctionITCase.fromLocalToUTC(LocalDateTime.of(2021, 9, 27, 12, 34, 56, 123456789))).failValidation(DataTypes.BOOLEAN(), true).failTableApiValidation(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY).failTableApiValidation(DataTypes.VARBINARY((int)5), CastFunctionITCase.DEFAULT_VARBINARY).failTableApiValidation(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES).failValidation(DataTypes.DECIMAL((int)5, (int)3), 12.345).failValidation(DataTypes.TINYINT(), (byte)5).failValidation(DataTypes.SMALLINT(), (short)12345).failValidation(DataTypes.INT(), 1234567).failValidation(DataTypes.BIGINT(), 12345678901L).failValidation(DataTypes.FLOAT(), Float.valueOf(123.456f)).failValidation(DataTypes.DOUBLE(), 123.456789).fromCase(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE, CastFunctionITCase.fromLocalToUTC(LocalDateTime.of(2021, 9, 24, 0, 0, 0, 0))).fromCase(DataTypes.TIME((int)5), CastFunctionITCase.DEFAULT_TIME, CastFunctionITCase.fromLocalToUTC(LocalDateTime.of(1970, 1, 1, 12, 34, 56, 0))).fromCase(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP, CastFunctionITCase.fromLocalToUTC(LocalDateTime.of(2021, 9, 24, 12, 34, 56, 123456000))).fromCase(DataTypes.TIMESTAMP((int)8), CastFunctionITCase.DEFAULT_TIMESTAMP, CastFunctionITCase.fromLocalToUTC(LocalDateTime.of(2021, 9, 24, 12, 34, 56, 123456700))).fromCase(DataTypes.TIMESTAMP((int)4), CastFunctionITCase.DEFAULT_TIMESTAMP, CastFunctionITCase.fromLocalToUTC(LocalDateTime.of(2021, 9, 24, 12, 34, 56, 123400000))).fromCase(DataTypes.TIMESTAMP_LTZ((int)4), CastFunctionITCase.DEFAULT_TIMESTAMP, CastFunctionITCase.fromLocalToUTC(LocalDateTime.of(2021, 9, 24, 12, 34, 56, 123400000))).fromCase(DataTypes.TIMESTAMP_LTZ((int)4), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ, CastFunctionITCase.fromLocalToUTC(LocalDateTime.of(2021, 9, 25, 7, 54, 56, 123400000))).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), CastFunctionITCase.DEFAULT_INTERVAL_YEAR).failValidation(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), CastFunctionITCase.DEFAULT_INTERVAL_DAY).failValidation(DataTypes.ARRAY((DataType)DataTypes.INT()), CastFunctionITCase.DEFAULT_ARRAY).build(), CastTestSpecBuilder.testCastTo(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()), null, null).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR()), 0, Period.of(0, 0, 0)).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR()), 11, Period.of(0, 11, 0)).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR()), 84, Period.of(0, 84, 0)).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR()), 89, Period.of(0, 89, 0)).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()), 89, Period.of(0, 89, 0)).build());
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> toStringCasts() {
        return Arrays.asList(CastTestSpecBuilder.testCastTo(DataTypes.CHAR((int)3)).fromCase(DataTypes.CHAR((int)5), null, null).fromCase(DataTypes.CHAR((int)3), "foo", "foo").fromCase(DataTypes.VARCHAR((int)3), "foo", "foo").fromCase(DataTypes.VARCHAR((int)5), "foo", "foo").fromCase(DataTypes.STRING(), "abcdef", "abc").fromCase(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE, "202").build(), CastTestSpecBuilder.testCastTo(DataTypes.CHAR((int)5)).fromCase(DataTypes.CHAR((int)5), null, null).fromCase(DataTypes.CHAR((int)3), "foo", "foo  ").build(), CastTestSpecBuilder.testCastTo(DataTypes.VARCHAR((int)3)).fromCase(DataTypes.VARCHAR((int)5), null, null).fromCase(DataTypes.CHAR((int)3), "foo", "foo").fromCase(DataTypes.CHAR((int)4), "foo", "foo").fromCase(DataTypes.VARCHAR((int)3), "foo", "foo").fromCase(DataTypes.VARCHAR((int)5), "foo", "foo").fromCase(DataTypes.STRING(), "abcdef", "abc").build(), CastTestSpecBuilder.testCastTo(DataTypes.STRING()).fromCase(DataTypes.STRING(), null, null).fromCase(DataTypes.CHAR((int)3), "foo", "foo").fromCase(DataTypes.CHAR((int)5), "foo", "foo  ").fromCase(DataTypes.VARCHAR((int)5), "Flink", "Flink").fromCase(DataTypes.VARCHAR((int)10), "Flink", "Flink").fromCase(DataTypes.STRING(), "Apache Flink", "Apache Flink").fromCase(DataTypes.STRING(), null, null).fromCase(DataTypes.BOOLEAN(), true, "TRUE").fromCase(DataTypes.BINARY((int)2), CastFunctionITCase.DEFAULT_BINARY, "\u0000\u0001").fromCase(DataTypes.BINARY((int)3), CastFunctionITCase.DEFAULT_BINARY, "\u0000\u0001\u0000").fromCase(DataTypes.VARBINARY((int)3), CastFunctionITCase.DEFAULT_VARBINARY, "\u0000\u0001\u0002").fromCase(DataTypes.VARBINARY((int)5), CastFunctionITCase.DEFAULT_VARBINARY, "\u0000\u0001\u0002").fromCase(DataTypes.BYTES(), CastFunctionITCase.DEFAULT_BYTES, "\u0000\u0001\u0002\u0003\u0004").fromCase(DataTypes.DECIMAL((int)4, (int)3), 9.87, "9.870").fromCase(DataTypes.DECIMAL((int)10, (int)5), 1, "1.00000").fromCase(DataTypes.TINYINT(), (byte)5, String.valueOf(5)).fromCase(DataTypes.TINYINT(), (byte)-5, String.valueOf(-5)).fromCase(DataTypes.SMALLINT(), (short)12345, String.valueOf(12345)).fromCase(DataTypes.SMALLINT(), (short)-12345, String.valueOf(-12345)).fromCase(DataTypes.INT(), 1234567, String.valueOf(1234567)).fromCase(DataTypes.INT(), -1234567, String.valueOf(-1234567)).fromCase(DataTypes.BIGINT(), 12345678901L, String.valueOf(12345678901L)).fromCase(DataTypes.BIGINT(), -12345678901L, String.valueOf(-12345678901L)).fromCase(DataTypes.FLOAT(), Float.valueOf(123.456f), String.valueOf(123.456f)).fromCase(DataTypes.FLOAT(), Float.valueOf(-123.456f), String.valueOf(-123.456f)).fromCase(DataTypes.DOUBLE(), 123.456789, String.valueOf(123.456789)).fromCase(DataTypes.DOUBLE(), -123.456789, String.valueOf(-123.456789)).fromCase(DataTypes.DATE(), CastFunctionITCase.DEFAULT_DATE, "2021-09-24").fromCase(DataTypes.TIME((int)5), CastFunctionITCase.DEFAULT_TIME, "12:34:56").fromCase(DataTypes.TIMESTAMP(), CastFunctionITCase.DEFAULT_TIMESTAMP, "2021-09-24 12:34:56.123456").fromCase(DataTypes.TIMESTAMP((int)9), CastFunctionITCase.DEFAULT_TIMESTAMP, "2021-09-24 12:34:56.123456700").fromCase(DataTypes.TIMESTAMP((int)4), CastFunctionITCase.DEFAULT_TIMESTAMP, "2021-09-24 12:34:56.1234").fromCase(DataTypes.TIMESTAMP((int)3), LocalDateTime.parse("2021-09-24T12:34:56.1"), "2021-09-24 12:34:56.100").fromCase((DataType)DataTypes.TIMESTAMP((int)4).nullable(), null, null).fromCase(DataTypes.TIMESTAMP_LTZ((int)5), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ, "2021-09-25 07:54:56.12345").fromCase(DataTypes.TIMESTAMP_LTZ((int)9), CastFunctionITCase.DEFAULT_TIMESTAMP_LTZ, "2021-09-25 07:54:56.123456700").fromCase(DataTypes.TIMESTAMP_LTZ((int)3), CastFunctionITCase.fromLocalTZ("2021-09-24T22:34:56.1"), "2021-09-25 07:54:56.100").fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR()), 84, "+7-00").fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()), 5, "+0-05").fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()), 123, "+10-03").fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()), 12334, "+1027-10").fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY()), 10, "+0 00:00:00.010").fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY()), 123456789L, "+1 10:17:36.789").fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY()), Duration.ofHours(36L), "+1 12:00:00.000").fromCase(DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().nullable())), new Integer[]{null, 456}, "[NULL, 456]").fromCase(DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())), CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)"a", (Object)-123)}), "{a=-10-03}").fromCase(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.INT().nullable())), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}), Row.of((Object[])new Object[]{null, "abc"}), "(NULL, abc)").build());
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> decimalCasts() {
        return Collections.singletonList(CastTestSpecBuilder.testCastTo(DataTypes.DECIMAL((int)8, (int)4)).fromCase(DataTypes.STRING(), null, null).fromCase(DataTypes.DOUBLE(), 3.123456, new BigDecimal("3.1235")).fromCase(DataTypes.DECIMAL((int)10, (int)8), 12.34561234, new BigDecimal("12.3456")).fromCase(DataTypes.INT(), 12345, null).fromCase(DataTypes.FLOAT(), 12345.678912, null).failRuntime(DataTypes.STRING(), "12345.6789", NumberFormatException.class).build());
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> numericBounds() {
        return Arrays.asList(CastTestSpecBuilder.testCastTo(DataTypes.TINYINT()).fromCase(DataTypes.TINYINT(), (byte)-128, (byte)-128).fromCase(DataTypes.TINYINT(), (byte)127, (byte)127).fromCase(DataTypes.TINYINT(), (byte)127, (byte)127).fromCase(DataTypes.TINYINT(), (byte)-128, (byte)-128).build(), CastTestSpecBuilder.testCastTo(DataTypes.SMALLINT()).fromCase(DataTypes.SMALLINT(), (short)Short.MIN_VALUE, (short)Short.MIN_VALUE).fromCase(DataTypes.SMALLINT(), (short)Short.MAX_VALUE, (short)Short.MAX_VALUE).fromCase(DataTypes.SMALLINT(), (short)Short.MAX_VALUE, (short)Short.MAX_VALUE).fromCase(DataTypes.SMALLINT(), (short)Short.MIN_VALUE, (short)Short.MIN_VALUE).build(), CastTestSpecBuilder.testCastTo(DataTypes.INT()).fromCase(DataTypes.INT(), Integer.MIN_VALUE, Integer.MIN_VALUE).fromCase(DataTypes.INT(), Integer.MAX_VALUE, Integer.MAX_VALUE).fromCase(DataTypes.INT(), Integer.MAX_VALUE, Integer.MAX_VALUE).fromCase(DataTypes.INT(), Integer.MIN_VALUE, Integer.MIN_VALUE).build(), CastTestSpecBuilder.testCastTo(DataTypes.BIGINT()).fromCase(DataTypes.BIGINT(), Long.MIN_VALUE, Long.MIN_VALUE).fromCase(DataTypes.BIGINT(), Long.MAX_VALUE, Long.MAX_VALUE).fromCase(DataTypes.BIGINT(), Long.MAX_VALUE, Long.MAX_VALUE).fromCase(DataTypes.BIGINT(), Long.MIN_VALUE, Long.MIN_VALUE).build(), CastTestSpecBuilder.testCastTo(DataTypes.FLOAT()).fromCase(DataTypes.DOUBLE(), -1.7976931348623157E308, Float.valueOf(Float.NEGATIVE_INFINITY)).build(), CastTestSpecBuilder.testCastTo(DataTypes.DECIMAL((int)38, (int)0)).fromCase(DataTypes.TINYINT(), (byte)127, BigDecimal.valueOf(127L)).fromCase(DataTypes.TINYINT(), (byte)-128, BigDecimal.valueOf(-128L)).fromCase(DataTypes.SMALLINT(), (short)Short.MAX_VALUE, BigDecimal.valueOf(32767L)).fromCase(DataTypes.SMALLINT(), (short)Short.MIN_VALUE, BigDecimal.valueOf(-32768L)).fromCase(DataTypes.INT(), Integer.MAX_VALUE, BigDecimal.valueOf(Integer.MAX_VALUE)).fromCase(DataTypes.INT(), Integer.MIN_VALUE, BigDecimal.valueOf(Integer.MIN_VALUE)).fromCase(DataTypes.BIGINT(), Long.MAX_VALUE, BigDecimal.valueOf(Long.MAX_VALUE)).fromCase(DataTypes.BIGINT(), Long.MIN_VALUE, BigDecimal.valueOf(Long.MIN_VALUE)).build(), CastTestSpecBuilder.testCastTo(DataTypes.DECIMAL((int)38, (int)32)).fromCase(DataTypes.FLOAT(), Float.valueOf(-3.4028235E38f), null).fromCase(DataTypes.FLOAT(), Float.valueOf(Float.MAX_VALUE), null).fromCase(DataTypes.DOUBLE(), -1.7976931348623157E308, null).fromCase(DataTypes.DOUBLE(), Double.MAX_VALUE, null).build());
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> constructedTypes() {
        return Arrays.asList(CastTestSpecBuilder.testCastTo(DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING())).fromCase(DataTypes.MAP((DataType)DataTypes.FLOAT(), (DataType)DataTypes.DOUBLE()), null, null).fromCase(DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.INT()), Collections.singletonMap(1, 2), Collections.singletonMap("1", "2")).build(), CastTestSpecBuilder.testCastTo(DataTypes.ARRAY((DataType)DataTypes.INT())).fromCase(DataTypes.ARRAY((DataType)DataTypes.INT()), null, null).fromCase(DataTypes.ARRAY((DataType)DataTypes.STRING()), new String[]{"1", "2", "3"}, new Integer[]{1, 2, 3}).fromCase(DataTypes.ARRAY((DataType)DataTypes.INT()), new int[]{1, 2, 3}, new Integer[]{1, 2, 3}).build(), CastTestSpecBuilder.testCastTo(DataTypes.ARRAY((DataType)((DataType)DataTypes.STRING().nullable()))).fromCase(DataTypes.ARRAY((DataType)((DataType)DataTypes.TIMESTAMP((int)4).nullable())), new LocalDateTime[]{LocalDateTime.parse("2021-09-24T12:34:56.123456"), null, LocalDateTime.parse("2021-09-24T14:34:56.123456")}, new String[]{"2021-09-24 12:34:56.1234", null, "2021-09-24 14:34:56.1234"}).build(), CastTestSpecBuilder.testCastTo(DataTypes.ARRAY((DataType)((DataType)DataTypes.BIGINT().nullable()))).fromCase(DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().nullable())), new Integer[]{1, null, 2}, new Long[]{1L, null, 2L}).build(), CastTestSpecBuilder.testCastTo(DataTypes.ARRAY((DataType)((DataType)DataTypes.BIGINT().notNull()))).fromCase(DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull())), new Integer[]{1, 2}, new Long[]{1L, 2L}).build(), CastTestSpecBuilder.testCastTo(DataTypes.ARRAY((DataType)((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.STRING()}).notNull()))).fromCase(DataTypes.ARRAY((DataType)((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.VARCHAR((int)4)}).notNull())), new Row[]{Row.of((Object[])new Object[]{1, "two"}), Row.of((Object[])new Object[]{3, "four"})}, new Row[]{Row.of((Object[])new Object[]{1, "two"}), Row.of((Object[])new Object[]{3, "four"})}).build(), CastTestSpecBuilder.testCastTo(DataTypes.MAP((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT()}), (DataType)DataTypes.STRING())).fromCase(DataTypes.MAP((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT()}), (DataType)DataTypes.VARCHAR((int)4)), CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)Row.of((Object[])new Object[]{1}), (Object)"two"), CollectionUtil.entry((Object)Row.of((Object[])new Object[]{3}), (Object)"four")}), CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)Row.of((Object[])new Object[]{1}), (Object)"two"), CollectionUtil.entry((Object)Row.of((Object[])new Object[]{3}), (Object)"four")})).build(), CastTestSpecBuilder.testCastTo(DataTypes.ROW((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.BIGINT(), DataTypes.STRING(), DataTypes.ARRAY((DataType)DataTypes.STRING())})).fromCase(DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.TIME(), DataTypes.ARRAY((DataType)DataTypes.CHAR((int)1))}), Row.of((Object[])new Object[]{10, null, CastFunctionITCase.DEFAULT_TIME, new String[]{"a", "b", "c"}}), Row.of((Object[])new Object[]{10L, null, "12:34:56", new String[]{"a", "b", "c"}})).build());
    }

    private static Instant fromLocalToUTC(LocalDateTime localDateTime) {
        return localDateTime.atZone(TEST_TZ).toInstant();
    }

    private static Instant fromLocalTZ(String str) {
        return LocalDateTime.parse(str).toInstant(TEST_OFFSET);
    }

    private static boolean isTimestampLtzToNumeric(LogicalType srcType, LogicalType trgType) {
        return srcType.is(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE) && trgType.is(LogicalTypeFamily.NUMERIC);
    }

    private static boolean isNumericToTimestamp(LogicalType srcType, LogicalType trgType) {
        return srcType.is(LogicalTypeFamily.NUMERIC) && trgType.is(LogicalTypeFamily.TIMESTAMP);
    }

    private static boolean isTimestampToNumeric(LogicalType srcType, LogicalType trgType) {
        return srcType.is(LogicalTypeFamily.TIMESTAMP) && trgType.is(LogicalTypeFamily.NUMERIC);
    }

    private static class CastTestSpecBuilder {
        private BuiltInFunctionTestBase.TestSetSpec testSetSpec;
        private DataType targetType;
        private final List<Object> columnData = new ArrayList<Object>();
        private final List<DataType> columnTypes = new ArrayList<DataType>();
        private final List<Object> expectedValues = new ArrayList<Object>();
        private final List<TestType> testTypes = new ArrayList<TestType>();

        private CastTestSpecBuilder() {
        }

        private static CastTestSpecBuilder testCastTo(DataType targetType) {
            CastTestSpecBuilder tsb = new CastTestSpecBuilder();
            tsb.targetType = targetType;
            tsb.testSetSpec = BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.CAST, "To " + targetType.toString());
            return tsb;
        }

        private CastTestSpecBuilder fromCase(DataType dataType, Object src, Object target) {
            this.testTypes.add(TestType.RESULT);
            this.columnTypes.add(dataType);
            this.columnData.add(src);
            this.expectedValues.add(target);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)LogicalTypeCasts.supportsExplicitCast((LogicalType)dataType.getLogicalType(), (LogicalType)this.targetType.getLogicalType())).as("Should support explicit casting", new Object[0])).isTrue();
            return this;
        }

        private CastTestSpecBuilder failTableApiValidation(DataType dataType, Object src) {
            return this.failValidation(TestType.ERROR_TABLE_API, dataType, src);
        }

        private CastTestSpecBuilder failSqlValidation(DataType dataType, Object src) {
            return this.failValidation(TestType.ERROR_TABLE_API, dataType, src);
        }

        private CastTestSpecBuilder failValidation(DataType dataType, Object src) {
            this.failValidation(TestType.ERROR_TABLE_API, dataType, src);
            return this.failValidation(TestType.ERROR_SQL, dataType, src);
        }

        private CastTestSpecBuilder failRuntime(DataType dataType, Object src, Class<? extends Throwable> failureClass) {
            this.testTypes.add(TestType.ERROR_RUNTIME);
            this.columnTypes.add(dataType);
            this.columnData.add(src);
            this.expectedValues.add(failureClass);
            return this;
        }

        private CastTestSpecBuilder failValidation(TestType type, DataType dataType, Object src) {
            this.testTypes.add(type);
            this.columnTypes.add(dataType);
            this.columnData.add(src);
            return this;
        }

        private BuiltInFunctionTestBase.TestSetSpec build() {
            ArrayList<BuiltInFunctionTestBase.ResultSpec> testSpecs = new ArrayList<BuiltInFunctionTestBase.ResultSpec>(this.columnData.size());
            int idxOffset = 0;
            block6: for (int i = 0; i < this.columnData.size(); ++i) {
                String colName = "f" + i;
                LogicalType colType = this.columnTypes.get(i).getLogicalType();
                switch (this.testTypes.get(i)) {
                    case ERROR_TABLE_API: {
                        String errorMsg = this.specificErrorMsg(colType, String.format("Invalid function call:%ncast(" + this.columnTypes.get(i).toString() + ", " + this.targetType.toString() + ")", new Object[0]));
                        this.testSetSpec.testTableApiValidationError((Expression)Expressions.$((String)colName).cast(this.targetType), errorMsg);
                        ++idxOffset;
                        continue block6;
                    }
                    case ERROR_SQL: {
                        String errorMsg = this.specificErrorMsg(colType, "Cast function cannot convert value of type ");
                        this.testSetSpec.testSqlValidationError("CAST(" + colName + " AS " + this.targetType.toString() + ")", errorMsg);
                        ++idxOffset;
                        continue block6;
                    }
                    case ERROR_RUNTIME: {
                        Class throwableClazz = (Class)this.expectedValues.get(i - idxOffset);
                        this.testSetSpec.testSqlRuntimeError("CAST(" + colName + " AS " + this.targetType.toString() + ")", throwableClazz);
                        this.testSetSpec.testTableApiRuntimeError((Expression)Expressions.$((String)colName).cast(this.targetType), throwableClazz);
                        continue block6;
                    }
                    case RESULT: {
                        testSpecs.add(BuiltInFunctionTestBase.resultSpec((Expression)Expressions.$((String)colName).cast(this.targetType), "CAST(" + colName + " AS " + this.targetType.toString() + ")", this.expectedValues.get(i - idxOffset), this.targetType));
                    }
                }
            }
            this.testSetSpec.onFieldsWithData(this.columnData.toArray()).andDataTypes(this.columnTypes.toArray(new AbstractDataType[0])).testResult(testSpecs.toArray(new BuiltInFunctionTestBase.ResultSpec[0]));
            return this.testSetSpec;
        }

        private String specificErrorMsg(LogicalType colType, String defaultMsg) {
            if (CastFunctionITCase.isTimestampLtzToNumeric(colType, this.targetType.getLogicalType())) {
                return "The cast from TIMESTAMP_LTZ type to NUMERIC type is not allowed.";
            }
            if (CastFunctionITCase.isNumericToTimestamp(colType, this.targetType.getLogicalType())) {
                return "type is not allowed. It's recommended to use TO_TIMESTAMP";
            }
            if (CastFunctionITCase.isTimestampToNumeric(colType, this.targetType.getLogicalType())) {
                return "type is not allowed. It's recommended to use UNIX_TIMESTAMP(CAST(timestamp_col AS STRING)) instead.";
            }
            return defaultMsg;
        }

        private static enum TestType {
            RESULT,
            ERROR_SQL,
            ERROR_TABLE_API,
            ERROR_RUNTIME;

        }
    }
}

