/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.runtime.operators.sink.TestSinkV2;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkV2Provider;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.planner.factories.TableFactoryHarness;
import org.apache.flink.table.runtime.typeutils.ArrayDataSerializer;
import org.apache.flink.table.runtime.typeutils.MapDataSerializer;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.testutils.junit.SharedObjectsExtension;
import org.apache.flink.testutils.junit.SharedReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class HashcodeITCase {
    @RegisterExtension
    private static final MiniClusterExtension MINI_CLUSTER_EXTENSION = new MiniClusterExtension();
    @RegisterExtension
    private final SharedObjectsExtension sharedObjects = SharedObjectsExtension.create();

    @Test
    void testStreamRecordTimestampInserterSinkRuntimeProvider() throws ExecutionException, InterruptedException {
        TableEnvironment tableEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
        SharedReference results = this.sharedObjects.add(new ArrayList());
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).column("f1", DataTypes.STRING().bridgedTo(StringData.class)).column("f2", DataTypes.ARRAY((DataType)DataTypes.INT()).bridgedTo(ArrayData.class)).column("f3", DataTypes.MAP((DataType)DataTypes.DOUBLE(), (DataType)DataTypes.BIGINT()).bridgedTo(MapData.class)).build()).source(new TestSource()).build();
        TableDescriptor sinkDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("arrayOfHashcodes", (AbstractDataType)DataTypes.ARRAY((DataType)DataTypes.INT())).build()).sink(this.buildRuntimeSinkProvider(new TestWriter(results))).build();
        tableEnv.createTable("T1", sourceDescriptor);
        tableEnv.createTable("T2", sinkDescriptor);
        String sqlStmt = "INSERT INTO T2 SELECT array[$HASHCODE$1(f0), $HASHCODE$1(f1), $HASHCODE$1(f2), $HASHCODE$1(f3)] FROM T1";
        tableEnv.executeSql("INSERT INTO T2 SELECT array[$HASHCODE$1(f0), $HASHCODE$1(f1), $HASHCODE$1(f2), $HASHCODE$1(f3)] FROM T1").await();
        List data = ((List)results.get()).stream().map(d -> d.getArray(0).toIntArray()).collect(Collectors.toList());
        Assertions.assertThat(data).containsExactly((Object[])new int[][]{{42, 454226189, 2306, -2138406827}});
    }

    private TableFactoryHarness.SinkBase buildRuntimeSinkProvider(final TestSinkV2.DefaultSinkWriter<RowData> writer) {
        return new TableFactoryHarness.SinkBase(){

            @Override
            public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
                TestSinkV2 sink = TestSinkV2.newBuilder().setWriter(writer).build();
                return SinkV2Provider.of((Sink)sink);
            }
        };
    }

    private static class TestSourceFunction
    implements SourceFunction<RowData> {
        public void run(SourceFunction.SourceContext<RowData> ctx) {
            BinaryRowData row = new BinaryRowData(4);
            BinaryRowWriter writer = new BinaryRowWriter(row);
            writer.writeInt(0, 42);
            writer.writeString(1, (StringData)new BinaryStringData("ABCD"));
            BinaryArrayData array = new BinaryArrayData();
            BinaryArrayWriter arrayWriter = new BinaryArrayWriter(array, 2, 4);
            arrayWriter.writeInt(0, 42);
            arrayWriter.writeInt(1, 43);
            arrayWriter.complete();
            writer.writeArray(2, (ArrayData)array, new ArrayDataSerializer((LogicalType)new IntType()));
            BinaryArrayData keys = new BinaryArrayData();
            BinaryArrayData values = new BinaryArrayData();
            BinaryArrayWriter keysWriter = new BinaryArrayWriter(keys, 2, 8);
            BinaryArrayWriter valuesWriter = new BinaryArrayWriter(values, 2, 8);
            keysWriter.writeDouble(0, 42.0);
            valuesWriter.writeLong(0, 42L);
            keysWriter.writeDouble(1, 43.0);
            valuesWriter.writeLong(1, 43L);
            keysWriter.complete();
            valuesWriter.complete();
            writer.writeMap(3, (MapData)BinaryMapData.valueOf((BinaryArrayData)keys, (BinaryArrayData)values), new MapDataSerializer((LogicalType)new DoubleType(), (LogicalType)new BigIntType()));
            writer.complete();
            ctx.collect((Object)row);
            ctx.close();
        }

        public void cancel() {
        }
    }

    private static class TestSource
    extends TableFactoryHarness.ScanSourceBase {
        private TestSource() {
            super(false);
        }

        @Override
        public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext context) {
            return SourceFunctionProvider.of((SourceFunction)new TestSourceFunction(), (boolean)false);
        }
    }

    private static class TestWriter
    extends TestSinkV2.DefaultSinkWriter<RowData> {
        private final SharedReference<List<RowData>> results;

        private TestWriter(SharedReference<List<RowData>> results) {
            this.results = results;
        }

        public void write(RowData element, SinkWriter.Context context) {
            this.results.applySync(r -> r.add(element));
            super.write((Object)element, context);
        }
    }
}

