/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class ImplicitConversionEqualsFunctionITCase
extends BuiltInFunctionTestBase {
    private static final byte TINY_INT_DATA = 1;
    private static final short SMALL_INT_DATA = 1;
    private static final int INT_DATA = 1;
    private static final long BIG_INT_DATA = 1L;
    private static final float FLOAT_DATA = 1.0f;
    private static final double DOUBLE_DATA = 1.0;
    private static final BigDecimal DECIMAL_DATA = new BigDecimal(1);
    private static final String DATE_DATA = "2001-01-01";
    private static final String TIME_DATA = "00:00:00";
    private static final String TIMESTAMP_DATA = "2001-01-01 00:00:00";
    private static final String STRING_DATA_EQUALS_NUMERIC = "1";
    private static final String STRING_DATA_EQUALS_DATE = "2001-01-01";
    private static final String STRING_DATA_EQUALS_TIME = "00:00:00";
    private static final String STRING_DATA_EQUALS_TIMESTAMP = "2001-01-01 00:00:00";

    ImplicitConversionEqualsFunctionITCase() {
    }

    @Override
    Stream<BuiltInFunctionTestBase.TestSetSpec> getTestSetSpecs() {
        ArrayList<BuiltInFunctionTestBase.TestSetSpec> specs = new ArrayList<BuiltInFunctionTestBase.TestSetSpec>();
        specs.addAll(ImplicitConversionEqualsFunctionITCase.implicitConversionBetweenNumeric());
        specs.addAll(ImplicitConversionEqualsFunctionITCase.implicitConversionBetweenTimeAndString());
        specs.addAll(ImplicitConversionEqualsFunctionITCase.unsupportedImplicitConversionBetweenNumericAndString());
        return specs.stream();
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> implicitConversionBetweenNumeric() {
        return Arrays.asList(TypeConversionTestBuilder.left(DataTypes.TINYINT(), (byte)1).right(DataTypes.TINYINT(), (byte)1).right(DataTypes.SMALLINT(), (short)1).right(DataTypes.INT(), 1).right(DataTypes.BIGINT(), 1L).right(DataTypes.FLOAT(), Float.valueOf(1.0f)).right(DataTypes.DOUBLE(), 1.0).right(DataTypes.DECIMAL((int)1, (int)0), ImplicitConversionEqualsFunctionITCase.DECIMAL_DATA).build(), TypeConversionTestBuilder.left(DataTypes.SMALLINT(), (short)1).right(DataTypes.SMALLINT(), (short)1).right(DataTypes.INT(), 1).right(DataTypes.BIGINT(), 1L).right(DataTypes.FLOAT(), Float.valueOf(1.0f)).right(DataTypes.DOUBLE(), 1.0).right(DataTypes.DECIMAL((int)1, (int)0), ImplicitConversionEqualsFunctionITCase.DECIMAL_DATA).build(), TypeConversionTestBuilder.left(DataTypes.INT(), 1).right(DataTypes.INT(), 1).right(DataTypes.BIGINT(), 1L).right(DataTypes.FLOAT(), Float.valueOf(1.0f)).right(DataTypes.DOUBLE(), 1.0).right(DataTypes.DECIMAL((int)1, (int)0), ImplicitConversionEqualsFunctionITCase.DECIMAL_DATA).build(), TypeConversionTestBuilder.left(DataTypes.BIGINT(), 1L).right(DataTypes.BIGINT(), 1L).right(DataTypes.FLOAT(), Float.valueOf(1.0f)).right(DataTypes.DOUBLE(), 1.0).right(DataTypes.DECIMAL((int)1, (int)0), ImplicitConversionEqualsFunctionITCase.DECIMAL_DATA).build(), TypeConversionTestBuilder.left(DataTypes.FLOAT(), Float.valueOf(1.0f)).right(DataTypes.FLOAT(), Float.valueOf(1.0f)).right(DataTypes.DOUBLE(), 1.0).right(DataTypes.DECIMAL((int)1, (int)0), ImplicitConversionEqualsFunctionITCase.DECIMAL_DATA).build(), TypeConversionTestBuilder.left(DataTypes.DOUBLE(), 1.0).right(DataTypes.DOUBLE(), 1.0).right(DataTypes.DECIMAL((int)1, (int)0), ImplicitConversionEqualsFunctionITCase.DECIMAL_DATA).build());
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> implicitConversionBetweenTimeAndString() {
        return Arrays.asList(TypeConversionTestBuilder.left(DataTypes.DATE(), "2001-01-01").right(DataTypes.DATE(), "2001-01-01").right(DataTypes.STRING(), "2001-01-01").build(), TypeConversionTestBuilder.left(DataTypes.TIME(), "00:00:00").right(DataTypes.STRING(), "00:00:00").build(), TypeConversionTestBuilder.left(DataTypes.TIMESTAMP(), "2001-01-01 00:00:00").right(DataTypes.STRING(), "2001-01-01 00:00:00").build());
    }

    private static List<BuiltInFunctionTestBase.TestSetSpec> unsupportedImplicitConversionBetweenNumericAndString() {
        return Collections.singletonList(TypeConversionTestBuilder.left(DataTypes.STRING(), STRING_DATA_EQUALS_NUMERIC).right(DataTypes.STRING(), STRING_DATA_EQUALS_NUMERIC).fail(DataTypes.TINYINT(), (byte)1).fail(DataTypes.SMALLINT(), (short)1).fail(DataTypes.INT(), 1).fail(DataTypes.BIGINT(), 1L).fail(DataTypes.FLOAT(), Float.valueOf(1.0f)).fail(DataTypes.DOUBLE(), 1.0).fail(DataTypes.DECIMAL((int)1, (int)0), ImplicitConversionEqualsFunctionITCase.DECIMAL_DATA).build());
    }

    static class TypeConversionTestBuilder {
        private DataType leftType;
        private Object leftValue;
        private final List<Object> rightDataOnSuccess = new ArrayList<Object>();
        private final List<DataType> rightTypesOnSuccess = new ArrayList<DataType>();
        private final List<Object> rightDataOnFailure = new ArrayList<Object>();
        private final List<DataType> rightTypesOnFailure = new ArrayList<DataType>();

        TypeConversionTestBuilder() {
        }

        private static TypeConversionTestBuilder left(DataType leftType, Object leftValue) {
            TypeConversionTestBuilder builder = new TypeConversionTestBuilder();
            builder.leftType = leftType;
            builder.leftValue = leftValue;
            return builder;
        }

        private TypeConversionTestBuilder right(DataType rightType, Object rightValue) {
            this.rightTypesOnSuccess.add(rightType);
            this.rightDataOnSuccess.add(rightValue);
            return this;
        }

        private TypeConversionTestBuilder fail(DataType rightType, Object rightValue) {
            this.rightTypesOnFailure.add(rightType);
            this.rightDataOnFailure.add(rightValue);
            return this;
        }

        private BuiltInFunctionTestBase.TestSetSpec build() {
            DataType rightType;
            String rightColumnName;
            int i;
            int columnBaseIdx = 0;
            String leftColumnName = "f" + columnBaseIdx;
            ++columnBaseIdx;
            BuiltInFunctionTestBase.TestSetSpec testSetSpec = BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.EQUALS, "left: " + this.leftType.toString());
            ArrayList<Object> allData = new ArrayList<Object>();
            allData.add(this.leftValue);
            allData.addAll(this.rightDataOnSuccess);
            allData.addAll(this.rightDataOnFailure);
            ArrayList<DataType> allTypes = new ArrayList<DataType>();
            allTypes.add(this.leftType);
            allTypes.addAll(this.rightTypesOnSuccess);
            allTypes.addAll(this.rightTypesOnFailure);
            testSetSpec.onFieldsWithData(allData.toArray()).andDataTypes(allTypes.toArray(new AbstractDataType[0]));
            for (i = 0; i < this.rightTypesOnSuccess.size(); ++i) {
                rightColumnName = "f" + (i + columnBaseIdx);
                rightType = this.rightTypesOnSuccess.get(i);
                testSetSpec.testSqlResult(String.format("CAST(%s AS %s) = CAST(%s AS %s)", leftColumnName, this.leftType.toString(), rightColumnName, rightType), true, (AbstractDataType<?>)DataTypes.BOOLEAN());
            }
            columnBaseIdx += this.rightTypesOnSuccess.size();
            for (i = 0; i < this.rightTypesOnFailure.size(); ++i) {
                rightColumnName = "f" + (i + columnBaseIdx);
                rightType = this.rightTypesOnFailure.get(i);
                String exceptionMsg = this.getImplicitConversionFromStringExceptionMsg(rightType.getLogicalType().getTypeRoot());
                testSetSpec.testSqlValidationError(String.format("CAST(%s AS %s) = CAST(%s AS %s)", leftColumnName, this.leftType.toString(), rightColumnName, rightType), exceptionMsg);
            }
            return testSetSpec;
        }

        private String getImplicitConversionFromStringExceptionMsg(LogicalTypeRoot rightType) {
            return String.format("implicit type conversion between VARCHAR and %s is not supported now", rightType.toString());
        }
    }
}

