/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;

public class MapFunctionITCase
extends BuiltInFunctionTestBase {
    private static final LocalDate TEST_DATE_1 = LocalDate.of(1985, 11, 4);
    private static final LocalDate TEST_DATE_2 = LocalDate.of(2018, 7, 26);
    private static final LocalTime TEST_TIME_1 = LocalTime.of(17, 18, 19);
    private static final LocalTime TEST_TIME_2 = LocalTime.of(14, 15, 16);
    private static final LocalDateTime TEST_DATE_TIME_1 = LocalDateTime.of(1985, 11, 4, 17, 18, 19);
    private static final LocalDateTime TEST_DATE_TIME_2 = LocalDateTime.of(2018, 7, 26, 14, 15, 16);
    private static final String A = "a";
    private static final String B = "b";
    private static final int INTERVAL_1 = -123;
    private static final Integer INTERVAL_NULL = null;

    @Override
    Stream<BuiltInFunctionTestBase.TestSetSpec> getTestSetSpecs() {
        return Stream.of(this.mapTestCases(), this.mapKeysTestCases(), this.mapValuesTestCases(), this.mapEntriesTestCases(), this.mapFromArraysTestCases()).flatMap(s -> s);
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> mapTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.MAP).onFieldsWithData(1, 2, 3, 4, new BigDecimal("1.2345"), new BigDecimal("1.2346"), true).andDataTypes(DataTypes.INT().notNull(), DataTypes.INT().notNull(), DataTypes.INT().notNull(), DataTypes.INT().notNull(), DataTypes.DECIMAL((int)10, (int)4).notNull(), DataTypes.DECIMAL((int)10, (int)4).notNull(), DataTypes.BOOLEAN().notNull()).testResult(MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f0"), (Object[])new Object[]{Expressions.$((String)"f0"), Expressions.$((String)"f1")}), "MAP[f0, f1]", Collections.singletonMap(1, 2), DataTypes.MAP((DataType)((DataType)DataTypes.INT().notNull()), (DataType)((DataType)DataTypes.INT().notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f4"), (Object)Expressions.$((String)"f5"), (Object[])new Object[0]), "MAP[f4, f5]", Collections.singletonMap(new BigDecimal("1.2345"), new BigDecimal("1.2346")), DataTypes.MAP((DataType)((DataType)DataTypes.DECIMAL((int)10, (int)4).notNull()), (DataType)((DataType)DataTypes.DECIMAL((int)10, (int)4).notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f0").plus((Object)Expressions.$((String)"f1")), (Object)Expressions.$((String)"f2").times((Object)Expressions.$((String)"f2")), (Object[])new Object[]{Expressions.$((String)"f2").minus((Object)Expressions.$((String)"f1")), Expressions.$((String)"f3").minus((Object)Expressions.$((String)"f0"))}), "MAP[f0 + f1, f2 * f2, f2 - f1, f3 - f0]", CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)3, (Object)9), CollectionUtil.entry((Object)1, (Object)3)}), DataTypes.MAP((DataType)((DataType)DataTypes.INT().notNull()), (DataType)((DataType)DataTypes.INT().notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1").cast((DataType)DataTypes.BIGINT().notNull()), (Object[])new Object[]{Expressions.$((String)"f2"), Expressions.$((String)"f3").cast((DataType)DataTypes.BIGINT().notNull())}), "MAP[f0, CAST(f1 AS BIGINT), f2, CAST(f3 AS BIGINT)]", CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)1, (Object)2L), CollectionUtil.entry((Object)3, (Object)4L)}), DataTypes.MAP((DataType)((DataType)DataTypes.INT().notNull()), (DataType)((DataType)DataTypes.BIGINT().notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f6"), (Object)Expressions.$((String)"f6"), (Object[])new Object[0]), "MAP[f6, f6]", Collections.singletonMap(true, true), DataTypes.MAP((DataType)((DataType)DataTypes.BOOLEAN().notNull()), (DataType)((DataType)DataTypes.BOOLEAN().notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1").cast((DataType)DataTypes.DOUBLE().notNull()), (Object[])new Object[]{Expressions.$((String)"f2"), Expressions.$((String)"f3").cast((DataType)DataTypes.FLOAT().notNull())}), "MAP[f0, CAST(f1 AS DOUBLE), f2, CAST(f3 AS FLOAT)]", CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)1, (Object)2.0), CollectionUtil.entry((Object)3, (Object)4.0)}), DataTypes.MAP((DataType)((DataType)DataTypes.INT().notNull()), (DataType)((DataType)DataTypes.DOUBLE().notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f4"), (Object)Expressions.$((String)"f5"), (Object[])new Object[0]), "MAP[f4, f5]", Collections.singletonMap(new BigDecimal("1.2345"), new BigDecimal("1.2346")), DataTypes.MAP((DataType)((DataType)DataTypes.DECIMAL((int)10, (int)4).notNull()), (DataType)((DataType)DataTypes.DECIMAL((int)10, (int)4).notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.map((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1"), (Object[])new Object[0]), (Object)Expressions.map((Object)Expressions.$((String)"f2"), (Object)Expressions.$((String)"f3"), (Object[])new Object[0]), (Object[])new Object[0]), "MAP[MAP[f0, f1], MAP[f2, f3]]", Collections.singletonMap(Collections.singletonMap(1, 2), Collections.singletonMap(3, 4)), DataTypes.MAP((DataType)((DataType)DataTypes.MAP((DataType)((DataType)DataTypes.INT().notNull()), (DataType)((DataType)DataTypes.INT().notNull())).notNull()), (DataType)((DataType)DataTypes.MAP((DataType)((DataType)DataTypes.INT().notNull()), (DataType)((DataType)DataTypes.INT().notNull())).notNull())).notNull())), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.MAP).onFieldsWithData(TEST_DATE_1, TEST_DATE_2, TEST_TIME_1, TEST_TIME_2, TEST_DATE_TIME_1, TEST_DATE_TIME_2).andDataTypes(DataTypes.DATE().notNull(), DataTypes.DATE().notNull(), DataTypes.TIME().notNull(), DataTypes.TIME().notNull(), DataTypes.TIMESTAMP().notNull(), DataTypes.TIMESTAMP().notNull()).testResult(MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f2"), (Object[])new Object[]{Expressions.$((String)"f1"), Expressions.$((String)"f3")}), "MAP[f0, f2, f1, f3]", CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)TEST_DATE_1, (Object)TEST_TIME_1), CollectionUtil.entry((Object)TEST_DATE_2, (Object)TEST_TIME_2)}), DataTypes.MAP((DataType)((DataType)DataTypes.DATE().notNull()), (DataType)((DataType)DataTypes.TIME().notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f2"), (Object)Expressions.$((String)"f4"), (Object[])new Object[]{Expressions.$((String)"f3"), Expressions.$((String)"f5")}), "MAP[f2, f4, f3, f5]", CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)TEST_TIME_1, (Object)TEST_DATE_TIME_1), CollectionUtil.entry((Object)TEST_TIME_2, (Object)TEST_DATE_TIME_2)}), DataTypes.MAP((DataType)((DataType)DataTypes.TIME().notNull()), (DataType)((DataType)DataTypes.TIMESTAMP().notNull())).notNull())), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.MAP).onFieldsWithData(A, B, -123, INTERVAL_NULL).andDataTypes(new AbstractDataType[]{DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).nullable()}).testResult(MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f2"), (Object[])new Object[]{Expressions.$((String)"f1"), Expressions.$((String)"f3")}), "MAP[f0, f2, f1, f3]", CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)A, (Object)Period.ofMonths(-123)), CollectionUtil.entry((Object)B, (Object)INTERVAL_NULL)}), DataTypes.MAP((DataType)((DataType)DataTypes.STRING().notNull()), (DataType)((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).nullable())).notNull())));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> mapKeysTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.MAP_KEYS).onFieldsWithData(null, "item", Collections.singletonMap(1, "value"), Collections.singletonMap(new Integer[]{1, 2}, "value")).andDataTypes(new AbstractDataType[]{DataTypes.BOOLEAN().nullable(), DataTypes.STRING(), DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING()), DataTypes.MAP((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()), (DataType)DataTypes.STRING())}).testTableApiValidationError((Expression)Expressions.call((String)"MAP_KEYS", (Object[])new Object[]{Expressions.$((String)"f0"), Expressions.$((String)"f1")}), "Invalid function call:\nMAP_KEYS(BOOLEAN, STRING)").testResult((Expression)Expressions.map((Object)Expressions.$((String)"f0").cast(DataTypes.BOOLEAN()), (Object)Expressions.$((String)"f1").cast(DataTypes.STRING()), (Object[])new Object[0]).mapKeys(), "MAP_KEYS(MAP[CAST(f0 AS BOOLEAN), CAST(f1 AS STRING)])", new Boolean[]{null}, DataTypes.ARRAY((DataType)DataTypes.BOOLEAN()).notNull()).testResult((Expression)Expressions.$((String)"f2").mapKeys(), "MAP_KEYS(f2)", new Integer[]{1}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.INT())).testResult((Expression)Expressions.$((String)"f3").mapKeys(), "MAP_KEYS(f3)", new Integer[][]{{1, 2}}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> mapValuesTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.MAP_VALUES).onFieldsWithData(null, "item", Collections.singletonMap(1, "value1"), Collections.singletonMap(3, Collections.singletonMap(true, "value2"))).andDataTypes(new AbstractDataType[]{DataTypes.BOOLEAN().nullable(), DataTypes.STRING(), DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING()), DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.MAP((DataType)DataTypes.BOOLEAN(), (DataType)DataTypes.STRING()))}).testTableApiValidationError((Expression)Expressions.call((String)"MAP_VALUES", (Object[])new Object[]{Expressions.$((String)"f0"), Expressions.$((String)"f1")}), "Invalid function call:\nMAP_VALUES(BOOLEAN, STRING)").testResult((Expression)Expressions.map((Object)Expressions.$((String)"f1").cast(DataTypes.STRING()), (Object)Expressions.$((String)"f0").cast(DataTypes.BOOLEAN()), (Object[])new Object[0]).mapValues(), "MAP_VALUES(MAP[CAST(f1 AS STRING), CAST(f0 AS BOOLEAN)])", new Boolean[]{null}, DataTypes.ARRAY((DataType)DataTypes.BOOLEAN()).notNull()).testResult((Expression)Expressions.$((String)"f2").mapValues(), "MAP_VALUES(f2)", new String[]{"value1"}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.STRING())).testResult((Expression)Expressions.$((String)"f3").mapValues(), "MAP_VALUES(f3)", new Map[]{Collections.singletonMap(true, "value2")}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.MAP((DataType)DataTypes.BOOLEAN(), (DataType)DataTypes.STRING()))));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> mapEntriesTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.MAP_ENTRIES).onFieldsWithData(null, "item", Collections.singletonMap(1, "value1"), Collections.singletonMap(3, Collections.singletonMap(true, "value2"))).andDataTypes(new AbstractDataType[]{DataTypes.BOOLEAN().nullable(), DataTypes.STRING(), DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING()), DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.MAP((DataType)DataTypes.BOOLEAN(), (DataType)DataTypes.STRING()))}).testTableApiValidationError((Expression)Expressions.call((String)"MAP_ENTRIES", (Object[])new Object[]{Expressions.$((String)"f0"), Expressions.$((String)"f1")}), "Invalid function call:\nMAP_ENTRIES(BOOLEAN, STRING)").testResult((Expression)Expressions.map((Object)Expressions.$((String)"f0").cast(DataTypes.BOOLEAN()), (Object)Expressions.$((String)"f1").cast(DataTypes.STRING()), (Object[])new Object[0]).mapEntries(), "MAP_ENTRIES(MAP[CAST(f0 AS BOOLEAN), CAST(f1 AS STRING)])", new Row[]{Row.of((Object[])new Object[]{null, "item"})}, DataTypes.ARRAY((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"key", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"value", (DataType)DataTypes.STRING())})).notNull()).testResult((Expression)Expressions.$((String)"f2").mapEntries(), "MAP_ENTRIES(f2)", new Row[]{Row.of((Object[])new Object[]{1, "value1"})}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"key", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"value", (DataType)DataTypes.STRING())}))).testResult((Expression)Expressions.$((String)"f3").mapEntries(), "MAP_ENTRIES(f3)", new Row[]{Row.of((Object[])new Object[]{3, Collections.singletonMap(true, "value2")})}, (AbstractDataType<?>)DataTypes.ARRAY((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"key", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"value", (DataType)DataTypes.MAP((DataType)DataTypes.BOOLEAN(), (DataType)DataTypes.STRING()))}))));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> mapFromArraysTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.MAP_FROM_ARRAYS, "Invalid input").onFieldsWithData(null, null, new Integer[]{1}, new Integer[]{1, 2}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.BOOLEAN()), DataTypes.ARRAY((DataType)DataTypes.STRING()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT())}).testTableApiRuntimeError((Expression)Expressions.mapFromArrays((Object)Expressions.$((String)"f2"), (Object)Expressions.$((String)"f3")), "Invalid function MAP_FROM_ARRAYS call:\nThe length of the keys array 1 is not equal to the length of the values array 2").testSqlRuntimeError("MAP_FROM_ARRAYS(array[1, 2, 3], array[1, 2])", "Invalid function MAP_FROM_ARRAYS call:\nThe length of the keys array 3 is not equal to the length of the values array 2").testResult((Expression)Expressions.mapFromArrays((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1")), "MAP_FROM_ARRAYS(f0, f1)", (Object)null, (AbstractDataType<?>)DataTypes.MAP((DataType)DataTypes.BOOLEAN(), (DataType)DataTypes.STRING())), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.MAP_FROM_ARRAYS).onFieldsWithData(new Object[]{new Integer[]{1, 2}, new String[]{"one", "two"}, new Integer[][]{{1, 2}, {3, 4}}}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.STRING()), DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))}).testResult((Expression)Expressions.mapFromArrays((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1")), "MAP_FROM_ARRAYS(f0, f1)", CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)1, (Object)"one"), CollectionUtil.entry((Object)2, (Object)"two")}), (AbstractDataType<?>)DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING())).testTableApiResult((Expression)Expressions.mapFromArrays((Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f2")), CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)"one", (Object)new Integer[]{1, 2}), CollectionUtil.entry((Object)"two", (Object)new Integer[]{3, 4})}), (AbstractDataType<?>)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))));
    }
}

