/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.functions.utils.UserDefinedFunctionUtils;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

abstract class AggFunctionTestBase<IN, T, ACC> {
    AggFunctionTestBase() {
    }

    protected abstract List<List<IN>> getInputValueSets();

    protected abstract List<T> getExpectedResults();

    protected abstract AggregateFunction<T, ACC> getAggregator();

    protected abstract Class<?> getAccClass();

    protected Method getAccumulateFunc() throws NoSuchMethodException {
        return this.getAggregator().getClass().getMethod("accumulate", this.getAccClass(), Object.class);
    }

    protected Method getRetractFunc() throws NoSuchMethodException {
        throw new UnsupportedOperationException("retract is not supported");
    }

    @Test
    void testAccumulateAndRetractWithoutMerge() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        List<List<IN>> inputValueSets = this.getInputValueSets();
        List<T> expectedResults = this.getExpectedResults();
        Preconditions.checkArgument((inputValueSets.size() == expectedResults.size() ? 1 : 0) != 0);
        AggregateFunction<T, ACC> aggregator = this.getAggregator();
        int size = this.getInputValueSets().size();
        for (int i = 0; i < size; ++i) {
            List<IN> inputValues = inputValueSets.get(i);
            T expected = expectedResults.get(i);
            Object acc = aggregator.createAccumulator();
            this.accumulateValues(aggregator, acc, inputValues);
            Object result = aggregator.getValue(acc);
            this.validateResult(expected, result);
            if (!UserDefinedFunctionUtils.ifMethodExistInFunction((String)"retract", aggregator)) continue;
            this.retractValues(acc, inputValues);
            Object expectedAcc = aggregator.createAccumulator();
            this.validateResult(expectedAcc, acc);
        }
    }

    @Test
    void testAggregateWithMerge() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AggregateFunction<T, ACC> aggregator = this.getAggregator();
        if (UserDefinedFunctionUtils.ifMethodExistInFunction((String)"merge", aggregator)) {
            T expected;
            List<IN> inputValues;
            int i;
            Method mergeFunc = aggregator.getClass().getMethod("merge", this.getAccClass(), Iterable.class);
            List<List<IN>> inputValueSets = this.getInputValueSets();
            List<T> expectedResults = this.getExpectedResults();
            Preconditions.checkArgument((inputValueSets.size() == expectedResults.size() ? 1 : 0) != 0);
            int size = this.getInputValueSets().size();
            for (i = 0; i < size; ++i) {
                inputValues = inputValueSets.get(i);
                expected = expectedResults.get(i);
                Tuple2<List<IN>, List<IN>> splitValues = this.splitValues(inputValues);
                List firstValues = (List)splitValues.f0;
                List secondValues = (List)splitValues.f1;
                ArrayList<Object> accumulators = new ArrayList<Object>();
                Object secondAcc = aggregator.createAccumulator();
                this.accumulateValues(aggregator, secondAcc, secondValues);
                accumulators.add(secondAcc);
                Object firstAcc = aggregator.createAccumulator();
                this.accumulateValues(aggregator, firstAcc, firstValues);
                mergeFunc.invoke(aggregator, firstAcc, accumulators);
                Object result = aggregator.getValue(firstAcc);
                this.validateResult(expected, result);
                if (!UserDefinedFunctionUtils.ifMethodExistInFunction((String)"retract", aggregator)) continue;
                this.retractValues(firstAcc, inputValues);
                Object expectedAcc = aggregator.createAccumulator();
                this.validateResult(expectedAcc, firstAcc);
            }
            for (i = 0; i < size; ++i) {
                inputValues = inputValueSets.get(i);
                expected = expectedResults.get(i);
                ArrayList<Object> accumulators = new ArrayList<Object>();
                accumulators.add(aggregator.createAccumulator());
                Object acc = aggregator.createAccumulator();
                this.accumulateValues(aggregator, acc, inputValues);
                mergeFunc.invoke(aggregator, acc, accumulators);
                Object result = aggregator.getValue(acc);
                this.validateResult(expected, result);
            }
        }
    }

    @Test
    void testMergeReservedAccumulator() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AggregateFunction<T, ACC> aggregator = this.getAggregator();
        boolean hasMerge = UserDefinedFunctionUtils.ifMethodExistInFunction((String)"merge", aggregator);
        boolean hasRetract = UserDefinedFunctionUtils.ifMethodExistInFunction((String)"retract", aggregator);
        if (!hasMerge || !hasRetract) {
            return;
        }
        Method mergeFunc = aggregator.getClass().getMethod("merge", this.getAccClass(), Iterable.class);
        List<List<IN>> inputValueSets = this.getInputValueSets();
        int size = this.getInputValueSets().size();
        for (int i = 0; i < size; ++i) {
            List<IN> inputValues = inputValueSets.get(i);
            ArrayList<Object> accumulators = new ArrayList<Object>();
            ArrayList<Object> reversedAccumulators = new ArrayList<Object>();
            Object firstAcc = aggregator.createAccumulator();
            this.accumulateValues(aggregator, firstAcc, inputValues);
            accumulators.add(firstAcc);
            Object retractedAcc = aggregator.createAccumulator();
            this.retractValues(retractedAcc, inputValues);
            reversedAccumulators.add(retractedAcc);
            Object accWithSubset = aggregator.createAccumulator();
            this.accumulateValues(aggregator, accWithSubset, inputValues.subList(0, 2));
            Object expectedValue = aggregator.getValue(accWithSubset);
            Object secondAcc = aggregator.createAccumulator();
            mergeFunc.invoke(aggregator, secondAcc, accumulators);
            mergeFunc.invoke(aggregator, secondAcc, reversedAccumulators);
            mergeFunc.invoke(aggregator, accWithSubset, Collections.singleton(secondAcc));
            Object result = aggregator.getValue(accWithSubset);
            this.validateResult(expectedValue, result);
        }
    }

    @Test
    void testResetAccumulator() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AggregateFunction<T, ACC> aggregator = this.getAggregator();
        if (UserDefinedFunctionUtils.ifMethodExistInFunction((String)"resetAccumulator", aggregator)) {
            Method resetAccFunc = aggregator.getClass().getMethod("resetAccumulator", this.getAccClass());
            List<List<IN>> inputValueSets = this.getInputValueSets();
            List<T> expectedResults = this.getExpectedResults();
            Preconditions.checkArgument((inputValueSets.size() == expectedResults.size() ? 1 : 0) != 0);
            int size = this.getInputValueSets().size();
            for (int i = 0; i < size; ++i) {
                List<IN> inputValues = inputValueSets.get(i);
                Object acc = aggregator.createAccumulator();
                this.accumulateValues(aggregator, acc, inputValues);
                resetAccFunc.invoke(aggregator, acc);
                Object expectedAcc = aggregator.createAccumulator();
                this.validateResult(expectedAcc, acc);
            }
        }
    }

    protected <E> void validateResult(E expected, E result) {
        Assertions.assertThat(result).isEqualTo(expected);
    }

    protected void accumulateValues(AggregateFunction<T, ACC> aggregator, ACC accumulator, List<IN> values) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method accumulateFunc = this.getAccumulateFunc();
        for (IN value : values) {
            if (accumulateFunc.getParameterCount() == 1) {
                accumulateFunc.invoke(aggregator, accumulator);
                continue;
            }
            if (accumulateFunc.getParameterCount() == 2) {
                accumulateFunc.invoke(aggregator, accumulator, value);
                continue;
            }
            throw new TableException("Unsupported now");
        }
    }

    protected void retractValues(ACC accumulator, List<IN> values) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AggregateFunction<T, ACC> aggregator = this.getAggregator();
        Method retractFunc = this.getRetractFunc();
        for (IN value : values) {
            if (retractFunc.getParameterCount() == 1) {
                retractFunc.invoke(aggregator, accumulator);
                continue;
            }
            if (retractFunc.getParameterCount() == 2) {
                retractFunc.invoke(aggregator, accumulator, value);
                continue;
            }
            throw new TableException("Unsupported now");
        }
    }

    protected Tuple2<List<IN>, List<IN>> splitValues(List<IN> values) {
        return this.splitValues(values, values.size() / 2);
    }

    protected Tuple2<List<IN>, List<IN>> splitValues(List<IN> values, int index) {
        int i;
        ArrayList<IN> firstValues = new ArrayList<IN>();
        ArrayList<IN> secondValues = new ArrayList<IN>();
        for (i = 0; i < values.size() && i < index; ++i) {
            firstValues.add(values.get(i));
        }
        if (i < values.size()) {
            secondValues.addAll(values.subList(i, values.size()));
        }
        return new Tuple2(firstValues, secondValues);
    }
}

