/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.functions.aggfunctions.FirstLastValueAggFunctionWithOrderTestBase;
import org.apache.flink.table.runtime.functions.aggregate.LastValueAggFunction;
import org.junit.jupiter.api.Nested;

final class LastValueAggFunctionWithOrderTest {
    LastValueAggFunctionWithOrderTest() {
    }

    static abstract class NumberLastValueAggFunctionWithOrderTestBase<T>
    extends LastValueAggFunctionWithOrderTestBase<T> {
        NumberLastValueAggFunctionWithOrderTestBase() {
        }

        protected abstract T getValue(String var1);

        @Override
        protected List<List<T>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(this.getValue("1"), null, this.getValue("-99"), this.getValue("3"), null, this.getValue("3"), this.getValue("2"), this.getValue("-99")), Arrays.asList(null, null, null, null), Arrays.asList(null, this.getValue("10"), null, this.getValue("5")));
        }

        @Override
        protected List<List<Long>> getInputOrderSets() {
            return Arrays.asList(Arrays.asList(10L, 2L, 5L, 6L, 11L, 3L, 17L, 5L), Arrays.asList(8L, 6L, 9L, 5L), Arrays.asList(null, 6L, 4L, 3L));
        }

        @Override
        protected List<T> getExpectedResults() {
            return Arrays.asList(this.getValue("2"), null, this.getValue("10"));
        }
    }

    static abstract class LastValueAggFunctionWithOrderTestBase<T>
    extends FirstLastValueAggFunctionWithOrderTestBase<T, RowData> {
        LastValueAggFunctionWithOrderTestBase() {
        }

        @Override
        protected Class<?> getAccClass() {
            return RowData.class;
        }
    }

    @Nested
    final class StringLastValueAggFunctionWithOrderTest
    extends LastValueAggFunctionWithOrderTestBase<StringData> {
        StringLastValueAggFunctionWithOrderTest() {
        }

        @Override
        protected List<List<StringData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(StringData.fromString((String)"abc"), StringData.fromString((String)"def"), StringData.fromString((String)"ghi"), null, StringData.fromString((String)"jkl"), null, StringData.fromString((String)"zzz")), Arrays.asList(null, null), Arrays.asList(null, StringData.fromString((String)"a")), Arrays.asList(StringData.fromString((String)"x"), null, StringData.fromString((String)"e")));
        }

        @Override
        protected List<List<Long>> getInputOrderSets() {
            return Arrays.asList(Arrays.asList(10L, 2L, 5L, null, 3L, 1L, 15L), Arrays.asList(6L, 5L), Arrays.asList(8L, 6L), Arrays.asList(6L, 4L, 3L));
        }

        @Override
        protected List<StringData> getExpectedResults() {
            return Arrays.asList(StringData.fromString((String)"zzz"), null, StringData.fromString((String)"a"), StringData.fromString((String)"x"));
        }

        @Override
        protected AggregateFunction<StringData, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.STRING().getLogicalType());
        }
    }

    @Nested
    final class DecimalLastValueAggFunctionWithOrderTest
    extends LastValueAggFunctionWithOrderTestBase<DecimalData> {
        private int precision = 20;
        private int scale = 6;

        DecimalLastValueAggFunctionWithOrderTest() {
        }

        @Override
        protected List<List<DecimalData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(DecimalDataUtils.castFrom((String)"1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"1000.000001", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.998999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"999.999", (int)this.precision, (int)this.scale)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale)));
        }

        @Override
        protected List<List<Long>> getInputOrderSets() {
            return Arrays.asList(Arrays.asList(10L, 2L, 1L, 5L, null, 3L, 1L, 5L, 2L), Arrays.asList(6L, 5L, null, 8L, null), Arrays.asList(8L, 6L));
        }

        @Override
        protected List<DecimalData> getExpectedResults() {
            return Arrays.asList(DecimalDataUtils.castFrom((String)"1", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale));
        }

        @Override
        protected AggregateFunction<DecimalData, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.DECIMAL((int)this.precision, (int)this.scale).getLogicalType());
        }
    }

    @Nested
    final class BooleanLastValueAggFunctionWithOrderTest
    extends LastValueAggFunctionWithOrderTestBase<Boolean> {
        BooleanLastValueAggFunctionWithOrderTest() {
        }

        @Override
        protected List<List<Boolean>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(false, false, false), Arrays.asList(true, true, true), Arrays.asList(true, false, null, true, false, true, null), Arrays.asList(null, null, null), Arrays.asList(null, true));
        }

        @Override
        protected List<List<Long>> getInputOrderSets() {
            return Arrays.asList(Arrays.asList(6L, 2L, 3L), Arrays.asList(1L, 2L, 3L), Arrays.asList(10L, 2L, 5L, 3L, 11L, 7L, 5L), Arrays.asList(6L, 9L, 5L), Arrays.asList(4L, 3L));
        }

        @Override
        protected List<Boolean> getExpectedResults() {
            return Arrays.asList(false, true, false, null, true);
        }

        @Override
        protected AggregateFunction<Boolean, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.BOOLEAN().getLogicalType());
        }
    }

    @Nested
    final class DoubleLastValueAggFunctionWithOrderTest
    extends NumberLastValueAggFunctionWithOrderTestBase<Double> {
        DoubleLastValueAggFunctionWithOrderTest() {
        }

        @Override
        protected Double getValue(String v) {
            return Double.valueOf(v);
        }

        @Override
        protected AggregateFunction<Double, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.DOUBLE().getLogicalType());
        }
    }

    @Nested
    final class FloatLastValueAggFunctionWithOrderTest
    extends NumberLastValueAggFunctionWithOrderTestBase<Float> {
        FloatLastValueAggFunctionWithOrderTest() {
        }

        @Override
        protected Float getValue(String v) {
            return Float.valueOf(v);
        }

        @Override
        protected AggregateFunction<Float, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.FLOAT().getLogicalType());
        }
    }

    @Nested
    final class LongLastValueAggFunctionWithOrderTest
    extends NumberLastValueAggFunctionWithOrderTestBase<Long> {
        LongLastValueAggFunctionWithOrderTest() {
        }

        @Override
        protected Long getValue(String v) {
            return Long.valueOf(v);
        }

        @Override
        protected AggregateFunction<Long, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.BIGINT().getLogicalType());
        }
    }

    @Nested
    final class IntLastValueAggFunctionWithOrderTest
    extends NumberLastValueAggFunctionWithOrderTestBase<Integer> {
        IntLastValueAggFunctionWithOrderTest() {
        }

        @Override
        protected Integer getValue(String v) {
            return Integer.valueOf(v);
        }

        @Override
        protected AggregateFunction<Integer, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.INT().getLogicalType());
        }
    }

    @Nested
    final class ShortLastValueAggFunctionWithOrderTest
    extends NumberLastValueAggFunctionWithOrderTestBase<Short> {
        ShortLastValueAggFunctionWithOrderTest() {
        }

        @Override
        protected Short getValue(String v) {
            return Short.valueOf(v);
        }

        @Override
        protected AggregateFunction<Short, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.SMALLINT().getLogicalType());
        }
    }

    @Nested
    final class ByteLastValueAggFunctionWithOrderTest
    extends NumberLastValueAggFunctionWithOrderTestBase<Byte> {
        ByteLastValueAggFunctionWithOrderTest() {
        }

        @Override
        protected Byte getValue(String v) {
            return Byte.valueOf(v);
        }

        @Override
        protected AggregateFunction<Byte, RowData> getAggregator() {
            return new LastValueAggFunction(DataTypes.TINYINT().getLogicalType());
        }
    }
}

