/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LocalDateSerializer;
import org.apache.flink.api.common.typeutils.base.LocalDateTimeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.data.utils.CastExecutor;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.functions.casting.CastRule;
import org.apache.flink.table.planner.functions.casting.CastRuleProvider;
import org.apache.flink.table.test.TableAssertions;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.utils.DateTimeUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.CONCURRENT)
class CastRulesTest {
    private static final ZoneId CET = ZoneId.of("CET");
    private static final CodeGeneratorContext CTX = new CodeGeneratorContext((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader());
    private static final CastRule.Context CET_CONTEXT = CastRule.Context.create((boolean)false, (boolean)false, (ZoneId)CET, (ClassLoader)Thread.currentThread().getContextClassLoader(), (CodeGeneratorContext)CTX);
    private static final CastRule.Context CET_CONTEXT_LEGACY = CastRule.Context.create((boolean)false, (boolean)true, (ZoneId)CET, (ClassLoader)Thread.currentThread().getContextClassLoader(), (CodeGeneratorContext)CTX);
    private static final byte DEFAULT_POSITIVE_TINY_INT = 5;
    private static final byte DEFAULT_NEGATIVE_TINY_INT = -5;
    private static final short DEFAULT_POSITIVE_SMALL_INT = 12345;
    private static final short DEFAULT_NEGATIVE_SMALL_INT = -12345;
    private static final int DEFAULT_POSITIVE_INT = 1234567;
    private static final int DEFAULT_NEGATIVE_INT = -1234567;
    private static final long DEFAULT_POSITIVE_BIGINT = 12345678901L;
    private static final long DEFAULT_NEGATIVE_BIGINT = -12345678901L;
    private static final float DEFAULT_POSITIVE_FLOAT = 123.456f;
    private static final float DEFAULT_NEGATIVE_FLOAT = -123.456f;
    private static final double DEFAULT_POSITIVE_DOUBLE = 123.456789;
    private static final double DEFAULT_NEGATIVE_DOUBLE = -123.456789;
    private static final int DATE = DateTimeUtils.toInternal((LocalDate)LocalDate.parse("2021-09-24"));
    private static final int TIME = DateTimeUtils.toInternal((LocalTime)LocalTime.parse("12:34:56.12345"));
    private static final StringData DATE_STRING = StringData.fromString((String)"2021-09-24");
    private static final StringData TIME_STRING = StringData.fromString((String)"12:34:56.123");
    private static final TimestampData TIMESTAMP = TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.parse("2021-09-24T12:34:56.123456"));
    private static final TimestampData TIMESTAMP_LTZ = CastRulesTest.timestampDataFromInstant(2022, 1, 4, 12, 34, 56, 123456780);
    private static final StringData TIMESTAMP_STRING = StringData.fromString((String)"2021-09-24 12:34:56.123456");
    private static final StringData TIMESTAMP_STRING_CET = StringData.fromString((String)"2021-09-24 14:34:56.123456");
    private static final DataType MY_STRUCTURED_TYPE = DataTypes.STRUCTURED(MyStructuredType.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)((DataType)DataTypes.BIGINT().notNull())), DataTypes.FIELD((String)"b", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"c", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"d", (DataType)DataTypes.ARRAY((DataType)DataTypes.STRING()))});
    private static final DataType MY_STRUCTURED_TYPE_WITHOUT_IMPLEMENTATION_CLASS = DataTypes.of((LogicalType)StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"a", (String)"b", (String)"c")).attributes(Arrays.asList(new StructuredType.StructuredAttribute("a", ((DataType)DataTypes.BIGINT().notNull()).getLogicalType()), new StructuredType.StructuredAttribute("b", DataTypes.BIGINT().getLogicalType()), new StructuredType.StructuredAttribute("c", DataTypes.STRING().getLogicalType()), new StructuredType.StructuredAttribute("d", DataTypes.ARRAY((DataType)DataTypes.STRING()).getLogicalType()))).build());

    CastRulesTest() {
    }

    Stream<CastTestSpecBuilder> testCases() {
        return Stream.of(CastTestSpecBuilder.testCastTo(DataTypes.TINYINT()).fromCase(DataTypes.TINYINT(), null, null).fail(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), TableException.class).fail(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), TableException.class).fail(DataTypes.STRING(), StringData.fromString((String)"Apache"), TableException.class).fromCase(DataTypes.STRING(), StringData.fromString((String)"1.234"), (byte)1).fromCase(DataTypes.STRING(), StringData.fromString((String)"123"), (byte)123).fromCase(DataTypes.STRING(), StringData.fromString((String)" 123 "), (byte)123).fail(DataTypes.STRING(), StringData.fromString((String)"-130"), TableException.class).fromCase(DataTypes.DECIMAL((int)4, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("9.87"), (int)4, (int)3), (byte)9).fromCase(DataTypes.DECIMAL((int)10, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("9123.87"), (int)10, (int)3), (byte)-93).fromCase(DataTypes.TINYINT(), (byte)5, (byte)5).fromCase(DataTypes.TINYINT(), (byte)-5, (byte)-5).fromCase(DataTypes.SMALLINT(), (short)32, (byte)32).fromCase(DataTypes.SMALLINT(), (short)12345, (byte)57).fromCase(DataTypes.SMALLINT(), (short)-12345, (byte)-57).fromCase(DataTypes.INT(), -12, (byte)-12).fromCase(DataTypes.INT(), 1234567, (byte)-121).fromCase(DataTypes.INT(), -1234567, (byte)121).fromCase(DataTypes.BIGINT(), 12345678901L, (byte)53).fromCase(DataTypes.BIGINT(), -12345678901L, (byte)-53).fromCase(DataTypes.FLOAT(), Float.valueOf(123.456f), (byte)123).fromCase(DataTypes.FLOAT(), Float.valueOf(-123.456f), (byte)-123).fromCase(DataTypes.DOUBLE(), 123.456789, (byte)123).fromCase(DataTypes.DOUBLE(), -123.456789, (byte)-123).fromCase(DataTypes.BOOLEAN(), true, (byte)1).fromCase(DataTypes.BOOLEAN(), false, (byte)0), CastTestSpecBuilder.testCastTo(DataTypes.SMALLINT()).fromCase(DataTypes.SMALLINT(), null, null).fail(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), TableException.class).fail(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), TableException.class).fail(DataTypes.STRING(), StringData.fromString((String)"Apache"), TableException.class).fromCase(DataTypes.STRING(), StringData.fromString((String)"1.234"), (short)1).fromCase(DataTypes.STRING(), StringData.fromString((String)"123"), (short)123).fromCase(DataTypes.STRING(), StringData.fromString((String)" 123 "), (short)123).fail(DataTypes.STRING(), StringData.fromString((String)"-32769"), TableException.class).fromCase(DataTypes.DECIMAL((int)4, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("9.87"), (int)4, (int)3), (short)9).fromCase(DataTypes.DECIMAL((int)10, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("91235.87"), (int)10, (int)3), (short)25699).fromCase(DataTypes.TINYINT(), (byte)5, (short)5).fromCase(DataTypes.TINYINT(), (byte)-5, (short)-5).fromCase(DataTypes.SMALLINT(), (short)12345, (short)12345).fromCase(DataTypes.SMALLINT(), (short)-12345, (short)-12345).fromCase(DataTypes.SMALLINT(), (short)-32756, (short)-32756).fromCase(DataTypes.INT(), 1234567, (short)-10617).fromCase(DataTypes.INT(), -1234567, (short)10617).fromCase(DataTypes.INT(), -12, (short)-12).fromCase(DataTypes.BIGINT(), 123L, (short)123).fromCase(DataTypes.BIGINT(), 12345678901L, (short)7221).fromCase(DataTypes.BIGINT(), -12345678901L, (short)-7221).fromCase(DataTypes.FLOAT(), Float.valueOf(123.456f), (short)123).fromCase(DataTypes.FLOAT(), Float.valueOf(-123.456f), (short)-123).fromCase(DataTypes.FLOAT(), Float.valueOf(123456.78f), (short)-7616).fromCase(DataTypes.DOUBLE(), 123.456789, (short)123).fromCase(DataTypes.DOUBLE(), -123.456789, (short)-123).fromCase(DataTypes.DOUBLE(), 123456.789, (short)-7616).fromCase(DataTypes.BOOLEAN(), true, (short)1).fromCase(DataTypes.BOOLEAN(), false, (short)0), CastTestSpecBuilder.testCastTo(DataTypes.INT()).fail(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), TableException.class).fail(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), TableException.class).fail(DataTypes.STRING(), StringData.fromString((String)"Apache"), TableException.class).fromCase(DataTypes.STRING(), StringData.fromString((String)"1.234"), 1).fromCase(DataTypes.STRING(), StringData.fromString((String)"123"), 123).fromCase(DataTypes.STRING(), StringData.fromString((String)" 123 "), 123).fail(DataTypes.STRING(), StringData.fromString((String)"-3276913443134"), TableException.class).fromCase(DataTypes.DECIMAL((int)4, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("9.87"), (int)4, (int)3), 9).fromCase(DataTypes.DECIMAL((int)20, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("3276913443134.87"), (int)20, (int)3), -146603714).fromCase(DataTypes.TINYINT(), (byte)5, 5).fromCase(DataTypes.TINYINT(), (byte)-5, -5).fromCase(DataTypes.SMALLINT(), (short)12345, 12345).fromCase(DataTypes.SMALLINT(), (short)-12345, -12345).fromCase(DataTypes.INT(), 1234567, 1234567).fromCase(DataTypes.INT(), -1234567, -1234567).fromCase(DataTypes.BIGINT(), 123L, 123).fromCase(DataTypes.BIGINT(), 12345678901L, -539222987).fromCase(DataTypes.BIGINT(), -12345678901L, 539222987).fromCase(DataTypes.FLOAT(), Float.valueOf(123.456f), 123).fromCase(DataTypes.FLOAT(), Float.valueOf(-123.456f), -123).fromCase(DataTypes.FLOAT(), Float.valueOf(9.234568E9f), Integer.MAX_VALUE).fromCase(DataTypes.DOUBLE(), 123.456789, 123).fromCase(DataTypes.DOUBLE(), -123.456789, -123).fromCase(DataTypes.DOUBLE(), 9.23456789112345E9, Integer.MAX_VALUE).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH()), 123, 123).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND()), 123L, 123).fromCase(DataTypes.BOOLEAN(), true, 1).fromCase(DataTypes.BOOLEAN(), false, 0), CastTestSpecBuilder.testCastTo(DataTypes.BIGINT()).fromCase(DataTypes.BIGINT(), null, null).fail(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), TableException.class).fail(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), TableException.class).fail(DataTypes.STRING(), StringData.fromString((String)"Apache"), TableException.class).fromCase(DataTypes.STRING(), StringData.fromString((String)"1.234"), 1L).fromCase(DataTypes.STRING(), StringData.fromString((String)"123"), 123L).fromCase(DataTypes.STRING(), StringData.fromString((String)" 123 "), 123L).fromCase(DataTypes.STRING(), StringData.fromString((String)"-3276913443134"), -3276913443134L).fromCase(DataTypes.DECIMAL((int)4, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("9.87"), (int)4, (int)3), 9L).fromCase(DataTypes.DECIMAL((int)20, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("3276913443134.87"), (int)20, (int)3), 3276913443134L).fromCase(DataTypes.TINYINT(), (byte)5, 5L).fromCase(DataTypes.TINYINT(), (byte)-5, -5L).fromCase(DataTypes.SMALLINT(), (short)12345, 12345L).fromCase(DataTypes.SMALLINT(), (short)-12345, -12345L).fromCase(DataTypes.INT(), 1234567, 1234567L).fromCase(DataTypes.INT(), -1234567, -1234567L).fromCase(DataTypes.BIGINT(), 12345678901L, 12345678901L).fromCase(DataTypes.BIGINT(), -12345678901L, -12345678901L).fromCase(DataTypes.FLOAT(), Float.valueOf(123.456f), 123L).fromCase(DataTypes.FLOAT(), Float.valueOf(-123.456f), -123L).fromCase(DataTypes.FLOAT(), Float.valueOf(9.234568E9f), 9234568192L).fromCase(DataTypes.DOUBLE(), 123.456789, 123L).fromCase(DataTypes.DOUBLE(), -123.456789, -123L).fromCase(DataTypes.DOUBLE(), 9.23456789112345E9, 9234567891L).fromCase(DataTypes.BOOLEAN(), true, 1L).fromCase(DataTypes.BOOLEAN(), false, 0L), CastTestSpecBuilder.testCastTo(DataTypes.FLOAT()).fromCase(DataTypes.FLOAT(), null, null).fail(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), TableException.class).fail(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), TableException.class).fail(DataTypes.STRING(), StringData.fromString((String)"Apache"), TableException.class).fromCase(DataTypes.STRING(), StringData.fromString((String)"1.234"), Float.valueOf(1.234f)).fromCase(DataTypes.STRING(), StringData.fromString((String)"123"), Float.valueOf(123.0f)).fromCase(DataTypes.STRING(), StringData.fromString((String)" 123 "), Float.valueOf(123.0f)).fromCase(DataTypes.STRING(), StringData.fromString((String)"-3276913443134"), Float.valueOf(-3.2769135E12f)).fromCase(DataTypes.DECIMAL((int)4, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("9.87"), (int)4, (int)3), Float.valueOf(9.87f)).fromCase(DataTypes.DECIMAL((int)20, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("3276913443134.87"), (int)20, (int)3), Float.valueOf(3.2769135E12f)).fromCase(DataTypes.TINYINT(), (byte)5, Float.valueOf(5.0f)).fromCase(DataTypes.TINYINT(), (byte)-5, Float.valueOf(-5.0f)).fromCase(DataTypes.SMALLINT(), (short)12345, Float.valueOf(12345.0f)).fromCase(DataTypes.SMALLINT(), (short)-12345, Float.valueOf(-12345.0f)).fromCase(DataTypes.INT(), 1234567, Float.valueOf(1234567.0f)).fromCase(DataTypes.INT(), -1234567, Float.valueOf(-1234567.0f)).fromCase(DataTypes.BIGINT(), 12345678901L, Float.valueOf(1.2345679E10f)).fromCase(DataTypes.BIGINT(), -12345678901L, Float.valueOf(-1.2345679E10f)).fromCase(DataTypes.FLOAT(), Float.valueOf(123.456f), Float.valueOf(123.456f)).fromCase(DataTypes.FLOAT(), Float.valueOf(-123.456f), Float.valueOf(-123.456f)).fromCase(DataTypes.FLOAT(), Float.valueOf(9.234568E9f), Float.valueOf(9.234568E9f)).fromCase(DataTypes.DOUBLE(), 123.456789, Float.valueOf(123.45679f)).fromCase(DataTypes.DOUBLE(), -123.456789, Float.valueOf(-123.45679f)).fromCase(DataTypes.DOUBLE(), 1.2392345678911235E12, Float.valueOf(1.2392345E12f)).fromCase(DataTypes.BOOLEAN(), true, Float.valueOf(1.0f)).fromCase(DataTypes.BOOLEAN(), false, Float.valueOf(0.0f)), CastTestSpecBuilder.testCastTo(DataTypes.DOUBLE()).fromCase(DataTypes.DOUBLE(), null, null).fail(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), TableException.class).fail(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), TableException.class).fail(DataTypes.STRING(), StringData.fromString((String)"Apache"), TableException.class).fromCase(DataTypes.STRING(), StringData.fromString((String)"1.234"), 1.234).fromCase(DataTypes.STRING(), StringData.fromString((String)"123"), 123.0).fromCase(DataTypes.STRING(), StringData.fromString((String)" 123 "), 123.0).fromCase(DataTypes.STRING(), StringData.fromString((String)" .123 "), 0.123).fromCase(DataTypes.STRING(), StringData.fromString((String)"-3276913443134"), -3.276913443134E12).fromCase(DataTypes.DECIMAL((int)4, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("9.87"), (int)4, (int)3), 9.87).fromCase(DataTypes.DECIMAL((int)20, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("3276913443134.87"), (int)20, (int)3), 3.27691344313487E12).fromCase(DataTypes.DECIMAL((int)30, (int)20), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("123456789.123456789123456789"), (int)30, (int)20), 1.2345678912345679E8).fromCase(DataTypes.TINYINT(), (byte)5, 5.0).fromCase(DataTypes.TINYINT(), (byte)-5, -5.0).fromCase(DataTypes.SMALLINT(), (short)12345, 12345.0).fromCase(DataTypes.SMALLINT(), (short)-12345, -12345.0).fromCase(DataTypes.INT(), 1234567, 1234567.0).fromCase(DataTypes.INT(), -1234567, -1234567.0).fromCase(DataTypes.BIGINT(), 12345678901L, 1.2345678901E10).fromCase(DataTypes.BIGINT(), -12345678901L, -1.2345678901E10).fromCase(DataTypes.FLOAT(), Float.valueOf(123.456f), 123.456f).fromCase(DataTypes.FLOAT(), Float.valueOf(-123.456f), -123.456f).fromCase(DataTypes.FLOAT(), Float.valueOf(9.234568E9f), 9.234568192E9).fromCase(DataTypes.DOUBLE(), 123.456789, 123.456789).fromCase(DataTypes.DOUBLE(), -123.456789, -123.456789).fromCase(DataTypes.DOUBLE(), 1.2392345678911235E12, 1.2392345678911235E12).fromCase(DataTypes.BOOLEAN(), true, 1.0).fromCase(DataTypes.BOOLEAN(), false, 0.0), CastTestSpecBuilder.testCastTo(DataTypes.DATE()).fail(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), TableException.class).fail(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), TableException.class).fromCase(DataTypes.STRING(), StringData.fromString((String)"123"), DateTimeUtils.toInternal((LocalDate)LocalDate.of(123, 1, 1))).fromCase(DataTypes.STRING(), StringData.fromString((String)"2021-09-27"), DateTimeUtils.toInternal((LocalDate)LocalDate.of(2021, 9, 27))).fromCase(DataTypes.STRING(), StringData.fromString((String)"2021-09-27 12:34:56.123456789"), DateTimeUtils.toInternal((LocalDate)LocalDate.of(2021, 9, 27))).fail(DataTypes.STRING(), StringData.fromString((String)"2021/09/27"), TableException.class).fromCase(DataTypes.TIMESTAMP((int)9), CastRulesTest.TIMESTAMP, DateTimeUtils.toInternal((LocalDate)LocalDate.of(2021, 9, 24))).fromCase(DataTypes.TIMESTAMP_LTZ((int)8), CastRulesTest.TIMESTAMP_LTZ, DateTimeUtils.toInternal((LocalDate)LocalDate.of(2022, 1, 4))), CastTestSpecBuilder.testCastTo(DataTypes.TIME()).fail(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), TableException.class).fail(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), TableException.class).fromCase(DataTypes.STRING(), StringData.fromString((String)"23"), DateTimeUtils.toInternal((LocalTime)LocalTime.of(23, 0, 0))).fromCase(DataTypes.STRING(), StringData.fromString((String)"23:45"), DateTimeUtils.toInternal((LocalTime)LocalTime.of(23, 45, 0))).fail(DataTypes.STRING(), StringData.fromString((String)"2021-09-27"), TableException.class).fail(DataTypes.STRING(), StringData.fromString((String)"2021-09-27 12:34:56"), TableException.class).fromCase(DataTypes.STRING(), StringData.fromString((String)"12:34:56.123456789"), DateTimeUtils.toInternal((LocalTime)LocalTime.of(12, 34, 56, 123000000))).fail(DataTypes.STRING(), StringData.fromString((String)"2021-09-27 12:34:56.123456789"), TableException.class).fromCase(DataTypes.TIMESTAMP((int)6), CastRulesTest.TIMESTAMP, DateTimeUtils.toInternal((LocalTime)LocalTime.of(12, 34, 56, 123000000))).fromCase(DataTypes.TIMESTAMP_LTZ((int)8), CastRulesTest.TIMESTAMP_LTZ, DateTimeUtils.toInternal((LocalTime)LocalTime.of(11, 34, 56, 123000000))), CastTestSpecBuilder.testCastTo(DataTypes.TIMESTAMP((int)9)).fail(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), TableException.class).fail(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), TableException.class).fail(DataTypes.STRING(), StringData.fromString((String)"123"), TableException.class).fromCase(DataTypes.STRING(), StringData.fromString((String)"2021-09-27"), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 27, 0, 0, 0, 0)).fail(DataTypes.STRING(), StringData.fromString((String)"2021/09/27"), TableException.class).fromCase(DataTypes.STRING(), StringData.fromString((String)"2021-09-27 12:34:56.123"), TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.of(2021, 9, 27, 12, 34, 56, 123000000))).fromCase(DataTypes.STRING(), StringData.fromString((String)"2021-9-1 1:1:1.123"), TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.of(2021, 9, 1, 1, 1, 1, 123000000))).fromCase(DataTypes.STRING(), StringData.fromString((String)"2021-9-01 1:01:10.123"), TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.of(2021, 9, 1, 1, 1, 10, 123000000))).fromCase(DataTypes.STRING(), StringData.fromString((String)"2021-09-1 01:1:01.123"), TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.of(2021, 9, 1, 1, 1, 1, 123000000))).fromCase(DataTypes.STRING(), StringData.fromString((String)"2021-09-27 12:34:56.123400000"), TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.of(2021, 9, 27, 12, 34, 56, 123400000))).fromCase(DataTypes.STRING(), StringData.fromString((String)"2021-09-27 12:34:56.123456789"), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 27, 12, 34, 56, 123456789)).fromCase(DataTypes.DATE(), DateTimeUtils.toInternal((LocalDate)LocalDate.of(2022, 1, 4)), CastRulesTest.timestampDataFromLocalDateTime(2022, 1, 4, 0, 0, 0, 0)).fromCase(DataTypes.TIME((int)5), CastRulesTest.TIME, CastRulesTest.timestampDataFromLocalDateTime(1970, 1, 1, 12, 34, 56, 123000000)).fromCase(DataTypes.TIMESTAMP_LTZ((int)8), CastRulesTest.TIMESTAMP_LTZ, CastRulesTest.timestampDataFromLocalDateTime(2022, 1, 4, 11, 34, 56, 123456780)), CastTestSpecBuilder.testCastTo(DataTypes.TIMESTAMP((int)4)).fromCase(DataTypes.TIMESTAMP((int)2), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 27, 0, 0, 0, 120000000), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 27, 0, 0, 0, 120000000)).fromCase(DataTypes.TIMESTAMP((int)4), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 27, 0, 0, 0, 123400000), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 27, 0, 0, 0, 123400000)).fromCase(DataTypes.TIMESTAMP((int)7), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 27, 0, 0, 0, 123456700), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 27, 0, 0, 0, 123400000)).fromCase(DataTypes.TIMESTAMP_LTZ((int)2), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 0, 0, 0, 120000000), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 26, 22, 0, 0, 120000000)).fromCase(DataTypes.TIMESTAMP_LTZ((int)4), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 0, 0, 0, 123400000), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 26, 22, 0, 0, 123400000)).fromCase(DataTypes.TIMESTAMP_LTZ((int)7), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 0, 0, 0, 123456700), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 26, 22, 0, 0, 123400000)).fromCase(DataTypes.STRING(), StringData.fromString((String)"2021-09-27 12:34:56.123"), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 27, 12, 34, 56, 123000000)).fromCase(DataTypes.STRING(), StringData.fromString((String)"2021-09-27 12:34:56.12345"), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 27, 12, 34, 56, 123400000)), CastTestSpecBuilder.testCastTo(DataTypes.TIMESTAMP_LTZ((int)9)).fail(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), TableException.class).fail(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), TableException.class).fail(DataTypes.STRING(), StringData.fromString((String)"123"), TableException.class).fromCase(DataTypes.STRING(), CastRulesTest.CET_CONTEXT, StringData.fromString((String)"2021-09-27"), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 0, 0, 0, 0)).fromCase(DataTypes.STRING(), CastRulesTest.CET_CONTEXT, StringData.fromString((String)"2021-09-27 12:34:56"), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 12, 34, 56, 0)).fromCase(DataTypes.STRING(), CastRulesTest.CET_CONTEXT, StringData.fromString((String)"2021-09-27 12:34:56.123"), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 12, 34, 56, 123000000)).fromCase(DataTypes.STRING(), CastRulesTest.CET_CONTEXT, StringData.fromString((String)"2021-09-27 12:34:56.1234"), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 12, 34, 56, 123400000)).fromCase(DataTypes.STRING(), CastRulesTest.CET_CONTEXT, StringData.fromString((String)"2021-09-27 12:34:56.123456789"), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 12, 34, 56, 123456789)).fromCase(DataTypes.DATE(), DateTimeUtils.toInternal((LocalDate)LocalDate.of(2022, 1, 4)), CastRulesTest.timestampDataFromInstant(2022, 1, 4, 1, 0, 0, 0)).fromCase(DataTypes.TIME((int)5), CastRulesTest.TIME, CastRulesTest.timestampDataFromInstant(1970, 1, 1, 13, 34, 56, 123000000)).fromCase(DataTypes.TIMESTAMP((int)6), CastRulesTest.TIMESTAMP, CastRulesTest.timestampDataFromInstant(2021, 9, 24, 14, 34, 56, 123456000)), CastTestSpecBuilder.testCastTo(DataTypes.TIMESTAMP_LTZ((int)4)).fromCase(DataTypes.TIMESTAMP((int)2), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 27, 0, 0, 0, 120000000), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 2, 0, 0, 120000000)).fromCase(DataTypes.TIMESTAMP((int)4), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 27, 0, 0, 0, 123400000), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 2, 0, 0, 123400000)).fromCase(DataTypes.TIMESTAMP((int)7), CastRulesTest.timestampDataFromLocalDateTime(2021, 9, 27, 0, 0, 0, 123456700), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 2, 0, 0, 123400000)).fromCase(DataTypes.TIMESTAMP_LTZ((int)2), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 0, 0, 0, 120000000), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 0, 0, 0, 120000000)).fromCase(DataTypes.TIMESTAMP_LTZ((int)4), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 0, 0, 0, 123400000), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 0, 0, 0, 123400000)).fromCase(DataTypes.TIMESTAMP_LTZ((int)7), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 0, 0, 0, 123456700), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 0, 0, 0, 123400000)).fromCase(DataTypes.STRING(), CastRulesTest.CET_CONTEXT, StringData.fromString((String)"2021-09-27 12:34:56.123"), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 12, 34, 56, 123000000)).fromCase(DataTypes.STRING(), CastRulesTest.CET_CONTEXT, StringData.fromString((String)"2021-09-27 12:34:56.12345"), CastRulesTest.timestampDataFromInstant(2021, 9, 27, 12, 34, 56, 123400000)), CastTestSpecBuilder.testCastTo(DataTypes.STRING()).fromCase(DataTypes.STRING(), null, null).fromCase(DataTypes.NULL(), null, BinaryStringDataUtil.NULL_STRING).fromCase(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), StringData.fromString((String)"foo")).fromCase(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), StringData.fromString((String)"Flink")).fromCase(DataTypes.VARCHAR((int)10), StringData.fromString((String)"Flink"), StringData.fromString((String)"Flink")).fromCase(DataTypes.STRING(), StringData.fromString((String)"Apache Flink"), StringData.fromString((String)"Apache Flink")).fromCase(DataTypes.BOOLEAN(), true, StringData.fromString((String)"TRUE")).fromCase(DataTypes.BOOLEAN(), false, StringData.fromString((String)"FALSE")).fromCaseLegacy(DataTypes.BOOLEAN(), true, StringData.fromString((String)"true")).fromCaseLegacy(DataTypes.BOOLEAN(), false, StringData.fromString((String)"false")).fromCase(DataTypes.BINARY((int)2), new byte[]{0, 1}, StringData.fromString((String)"\u0000\u0001")).fromCaseLegacy(DataTypes.BINARY((int)2), new byte[]{0, 1}, StringData.fromString((String)"\u0000\u0001")).fromCase(DataTypes.VARBINARY((int)3), new byte[]{0, 1, 2}, StringData.fromString((String)"\u0000\u0001\u0002")).fromCaseLegacy(DataTypes.VARBINARY((int)3), new byte[]{0, 1, 2}, StringData.fromString((String)"\u0000\u0001\u0002")).fromCaseLegacy(DataTypes.VARBINARY((int)5), new byte[]{102, 111, 111}, StringData.fromString((String)"foo")).fromCaseLegacy(DataTypes.VARBINARY((int)5), new byte[]{102, 111, 111}, StringData.fromString((String)"foo")).fromCaseLegacy(DataTypes.BYTES(), new byte[]{70, 108, 105, 110, 107}, StringData.fromString((String)"Flink")).fromCaseLegacy(DataTypes.BYTES(), new byte[]{70, 108, 105, 110, 107}, StringData.fromString((String)"Flink")).fromCasePrinting(DataTypes.BYTES(), new byte[]{70, 108, 105, 110, 107}, StringData.fromString((String)"x'466c696e6b'")).fromCase(DataTypes.BOOLEAN(), true, StringData.fromString((String)"TRUE")).fromCase(DataTypes.BOOLEAN(), false, StringData.fromString((String)"FALSE")).fromCase(DataTypes.DECIMAL((int)4, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("9.87"), (int)4, (int)3), StringData.fromString((String)"9.870")).fromCase(DataTypes.DECIMAL((int)5, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("9.87"), (int)5, (int)3), StringData.fromString((String)"9.870")).fromCase(DataTypes.TINYINT(), (byte)-125, StringData.fromString((String)"-125")).fromCase(DataTypes.SMALLINT(), (short)Short.MAX_VALUE, StringData.fromString((String)"32767")).fromCase(DataTypes.INT(), -12345678, StringData.fromString((String)"-12345678")).fromCase(DataTypes.BIGINT(), 1234567891234L, StringData.fromString((String)"1234567891234")).fromCase(DataTypes.FLOAT(), Float.valueOf(-123.456f), StringData.fromString((String)"-123.456")).fromCase(DataTypes.DOUBLE(), 12345.678901, StringData.fromString((String)"12345.678901")).fromCase(DataTypes.FLOAT(), Float.valueOf(Float.MAX_VALUE), StringData.fromString((String)String.valueOf(Float.MAX_VALUE))).fromCase(DataTypes.DOUBLE(), Double.MAX_VALUE, StringData.fromString((String)String.valueOf(Double.MAX_VALUE))).fromCase(DataTypes.STRING(), StringData.fromString((String)"Hello"), StringData.fromString((String)"Hello")).fromCase(DataTypes.TIMESTAMP(), CastRulesTest.TIMESTAMP, CastRulesTest.TIMESTAMP_STRING).fromCase(DataTypes.TIMESTAMP((int)9), CastRulesTest.TIMESTAMP, StringData.fromString((String)"2021-09-24 12:34:56.123456000")).fromCase(DataTypes.TIMESTAMP((int)7), CastRulesTest.TIMESTAMP, StringData.fromString((String)"2021-09-24 12:34:56.1234560")).fromCase(DataTypes.TIMESTAMP((int)3), TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.parse("2021-09-24T12:34:56.1")), StringData.fromString((String)"2021-09-24 12:34:56.100")).fromCase(DataTypes.TIMESTAMP_LTZ(), CastRulesTest.CET_CONTEXT, CastRulesTest.TIMESTAMP, CastRulesTest.TIMESTAMP_STRING_CET).fromCase(DataTypes.TIMESTAMP_LTZ((int)9), CastRulesTest.CET_CONTEXT, CastRulesTest.TIMESTAMP, StringData.fromString((String)"2021-09-24 14:34:56.123456000")).fromCase(DataTypes.TIMESTAMP_LTZ((int)7), CastRulesTest.CET_CONTEXT, CastRulesTest.TIMESTAMP, StringData.fromString((String)"2021-09-24 14:34:56.1234560")).fromCase(DataTypes.TIMESTAMP_LTZ((int)3), CastRulesTest.CET_CONTEXT, TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.parse("2021-09-24T12:34:56.1")), StringData.fromString((String)"2021-09-24 14:34:56.100")).fromCase(DataTypes.DATE(), CastRulesTest.DATE, CastRulesTest.DATE_STRING).fromCase(DataTypes.TIME((int)5), CastRulesTest.TIME, CastRulesTest.TIME_STRING).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR()), 84, StringData.fromString((String)"+7-00")).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()), 5, StringData.fromString((String)"+0-05")).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()), 123, StringData.fromString((String)"+10-03")).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()), 12334, StringData.fromString((String)"+1027-10")).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY()), 10L, StringData.fromString((String)"+0 00:00:00.010")).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY()), 123456789L, StringData.fromString((String)"+1 10:17:36.789")).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY()), Duration.ofHours(36L).toMillis(), StringData.fromString((String)"+1 12:00:00.000")).fromCase(DataTypes.ARRAY((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())), new GenericArrayData(new int[]{-123, 123}), StringData.fromString((String)"[-10-03, +10-03]")).fromCase(DataTypes.ARRAY((DataType)DataTypes.INT()), new GenericArrayData(new int[]{-123, 456}), StringData.fromString((String)"[-123, 456]")).fromCase(DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().nullable())), new GenericArrayData((Object[])new Integer[]{null, 456}), StringData.fromString((String)"[NULL, 456]")).fromCaseLegacy(DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().nullable())), new GenericArrayData((Object[])new Integer[]{null, 456}), StringData.fromString((String)"[null, 456]")).fromCase(DataTypes.ARRAY((DataType)DataTypes.INT()), new GenericArrayData((Object[])new Integer[0]), StringData.fromString((String)"[]")).fromCase(DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())), CastRulesTest.mapData(CastRulesTest.entry(StringData.fromString((String)"a"), -123), CastRulesTest.entry(StringData.fromString((String)"b"), 123)), StringData.fromString((String)"{a=-10-03, b=+10-03}")).fromCase(DataTypes.MULTISET((DataType)DataTypes.STRING()), CastRulesTest.mapData(CastRulesTest.entry(StringData.fromString((String)"a"), 1), CastRulesTest.entry(StringData.fromString((String)"b"), 1)), StringData.fromString((String)"{a=1, b=1}")).fromCase(DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).nullable())), CastRulesTest.mapData(CastRulesTest.entry(null, -123), CastRulesTest.entry(StringData.fromString((String)"b"), null)), StringData.fromString((String)"{NULL=-10-03, b=NULL}")).fromCase(DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).nullable())), CastRulesTest.mapData(CastRulesTest.entry(null, null)), StringData.fromString((String)"{NULL=NULL}")).fromCaseLegacy(DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).nullable())), CastRulesTest.mapData(CastRulesTest.entry(null, null)), StringData.fromString((String)"{null=null}")).fromCase(DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())), CastRulesTest.mapData(new Map.Entry[0]), StringData.fromString((String)"{}")).fromCase(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}), GenericRowData.of((Object[])new Object[]{123, StringData.fromString((String)"abc")}), StringData.fromString((String)"(123, abc)")).fromCase(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}), GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"abc"), StringData.fromString((String)"def")}), StringData.fromString((String)"(abc, def)")).fromCaseLegacy(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}), GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"abc"), StringData.fromString((String)"def")}), StringData.fromString((String)"(abc,def)")).fromCase(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.INT().nullable())), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}), GenericRowData.of((Object[])new Object[]{null, StringData.fromString((String)"abc")}), StringData.fromString((String)"(NULL, abc)")).fromCaseLegacy(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.INT().nullable())), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}), GenericRowData.of((Object[])new Object[]{null, StringData.fromString((String)"abc")}), StringData.fromString((String)"(null,abc)")).fromCase(DataTypes.ROW(), GenericRowData.of((Object[])new Object[0]), StringData.fromString((String)"()")).fromCase(DataTypes.RAW(LocalDateTime.class, (TypeSerializer)LocalDateTimeSerializer.INSTANCE), RawValueData.fromObject((Object)LocalDateTime.parse("2020-11-11T18:08:01.123")), StringData.fromString((String)"2020-11-11T18:08:01.123")).fromCase(CastRulesTest.MY_STRUCTURED_TYPE, GenericRowData.of((Object[])new Object[]{10L, null, CastRulesTest.TIME_STRING, new GenericArrayData(new Object[]{StringData.fromString((String)"a"), StringData.fromString((String)"b"), StringData.fromString((String)"c")})}), StringData.fromString((String)"(a=10, b=NULL, c=12:34:56.123, d=[a, b, c])")).fromCase(CastRulesTest.MY_STRUCTURED_TYPE_WITHOUT_IMPLEMENTATION_CLASS, GenericRowData.of((Object[])new Object[]{10L, null, CastRulesTest.TIME_STRING, new GenericArrayData(new Object[]{StringData.fromString((String)"a"), StringData.fromString((String)"b"), StringData.fromString((String)"c")})}), StringData.fromString((String)"(a=10, b=NULL, c=12:34:56.123, d=[a, b, c])")), CastTestSpecBuilder.testCastTo(DataTypes.CHAR((int)6)).fromCase(DataTypes.STRING(), null, BinaryStringData.EMPTY_UTF8).fromCaseLegacy(DataTypes.STRING(), null, BinaryStringData.EMPTY_UTF8).fromCase(DataTypes.CHAR((int)6), StringData.fromString((String)"Apache"), StringData.fromString((String)"Apache")).fromCaseLegacy(DataTypes.CHAR((int)6), StringData.fromString((String)"Apache"), StringData.fromString((String)"Apache")).fromCase(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), StringData.fromString((String)"Flink ")).fromCaseLegacy(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), StringData.fromString((String)"Flink")).fromCase(DataTypes.STRING(), StringData.fromString((String)"foo"), StringData.fromString((String)"foo   ")).fromCaseLegacy(DataTypes.STRING(), StringData.fromString((String)"foo"), StringData.fromString((String)"foo")).fromCase(DataTypes.BOOLEAN(), true, StringData.fromString((String)"TRUE  ")).fromCaseLegacy(DataTypes.BOOLEAN(), true, StringData.fromString((String)"true")).fromCase(DataTypes.BOOLEAN(), false, StringData.fromString((String)"FALSE ")).fromCaseLegacy(DataTypes.BOOLEAN(), false, StringData.fromString((String)"false")).fromCase(DataTypes.BINARY((int)1), new byte[]{102}, StringData.fromString((String)"f     ")).fromCaseLegacy(DataTypes.BINARY((int)1), new byte[]{102}, StringData.fromString((String)"f")).fromCase(DataTypes.VARBINARY((int)1), new byte[]{33}, StringData.fromString((String)"!     ")).fromCaseLegacy(DataTypes.VARBINARY((int)1), new byte[]{33}, StringData.fromString((String)"!")).fromCase(DataTypes.BYTES(), new byte[]{32}, StringData.fromString((String)"      ")).fromCaseLegacy(DataTypes.BYTES(), new byte[]{32}, StringData.fromString((String)" ")).fromCase(DataTypes.TINYINT(), (byte)-125, StringData.fromString((String)"-125  ")).fromCaseLegacy(DataTypes.TINYINT(), (byte)-125, StringData.fromString((String)"-125")).fromCase(DataTypes.SMALLINT(), (short)Short.MAX_VALUE, StringData.fromString((String)"32767 ")).fromCaseLegacy(DataTypes.SMALLINT(), (short)Short.MAX_VALUE, StringData.fromString((String)"32767")).fromCase(DataTypes.INT(), -1234, StringData.fromString((String)"-1234 ")).fromCaseLegacy(DataTypes.INT(), -1234, StringData.fromString((String)"-1234")).fromCase(DataTypes.BIGINT(), 12345L, StringData.fromString((String)"12345 ")).fromCaseLegacy(DataTypes.BIGINT(), 12345L, StringData.fromString((String)"12345")).fromCase(DataTypes.FLOAT(), Float.valueOf(-1.23f), StringData.fromString((String)"-1.23 ")).fromCaseLegacy(DataTypes.FLOAT(), Float.valueOf(-1.23f), StringData.fromString((String)"-1.23")).fromCase(DataTypes.DOUBLE(), 123.4, StringData.fromString((String)"123.4 ")).fromCaseLegacy(DataTypes.DOUBLE(), 123.4, StringData.fromString((String)"123.4")).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR()), 84, StringData.fromString((String)"+7-00 ")).fromCaseLegacy(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR()), 84, StringData.fromString((String)"+7-00")).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()), 5, StringData.fromString((String)"+0-05 ")).fromCaseLegacy(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()), 5, StringData.fromString((String)"+0-05")), CastTestSpecBuilder.testCastTo(DataTypes.CHAR((int)12)).fromCase(DataTypes.BINARY((int)4), new byte[]{1, 11, 111, 2}, StringData.fromString((String)"\u0001\u000bo\u0002        ")).fromCaseLegacy(DataTypes.BINARY((int)4), new byte[]{1, 11, 111, 2}, StringData.fromString((String)"\u0001\u000bo\u0002")).fromCase(DataTypes.VARBINARY((int)4), new byte[]{1, 11, 22}, StringData.fromString((String)"\u0001\u000b\u0016         ")).fromCaseLegacy(DataTypes.VARBINARY((int)4), new byte[]{1, 11, 22}, StringData.fromString((String)"\u0001\u000b\u0016")).fromCase(DataTypes.ARRAY((DataType)DataTypes.INT()), new GenericArrayData(new int[]{-1, 2, 3}), StringData.fromString((String)"[-1, 2, 3]  ")).fromCaseLegacy(DataTypes.ARRAY((DataType)DataTypes.INT()), new GenericArrayData(new int[]{-1, 2, 3}), StringData.fromString((String)"[-1, 2, 3]")).fromCase((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCaseLegacy((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCase(DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()), CastRulesTest.mapData(CastRulesTest.entry(StringData.fromString((String)"a"), 1), CastRulesTest.entry(StringData.fromString((String)"b"), 8)), StringData.fromString((String)"{a=1, b=8}  ")).fromCaseLegacy(DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()), CastRulesTest.mapData(CastRulesTest.entry(StringData.fromString((String)"a"), 1), CastRulesTest.entry(StringData.fromString((String)"b"), 8)), StringData.fromString((String)"{a=1, b=8}")).fromCaseLegacy((DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCase((DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCase(DataTypes.MULTISET((DataType)DataTypes.STRING()), CastRulesTest.mapData(CastRulesTest.entry(StringData.fromString((String)"a"), 1), CastRulesTest.entry(StringData.fromString((String)"b"), 1)), StringData.fromString((String)"{a=1, b=1}  ")).fromCaseLegacy(DataTypes.MULTISET((DataType)DataTypes.STRING()), CastRulesTest.mapData(CastRulesTest.entry(StringData.fromString((String)"a"), 1), CastRulesTest.entry(StringData.fromString((String)"b"), 1)), StringData.fromString((String)"{a=1, b=1}")).fromCase((DataType)DataTypes.MULTISET((DataType)DataTypes.STRING()).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCaseLegacy(DataTypes.MULTISET((DataType)DataTypes.STRING()), null, BinaryStringData.EMPTY_UTF8).fromCase(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}), GenericRowData.of((Object[])new Object[]{123, StringData.fromString((String)"foo")}), StringData.fromString((String)"(123, foo)  ")).fromCaseLegacy(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}), GenericRowData.of((Object[])new Object[]{123, StringData.fromString((String)"foo")}), StringData.fromString((String)"(123,foo)")).fromCase((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCaseLegacy((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCase(DataTypes.RAW(LocalDate.class, (TypeSerializer)LocalDateSerializer.INSTANCE), RawValueData.fromObject((Object)LocalDate.parse("2020-12-09")), StringData.fromString((String)"2020-12-09  ")).fromCaseLegacy(DataTypes.RAW(LocalDate.class, (TypeSerializer)LocalDateSerializer.INSTANCE), RawValueData.fromObject((Object)LocalDate.parse("2020-12-09")), StringData.fromString((String)"2020-12-09")).fromCase((DataType)DataTypes.RAW(LocalDateTime.class, (TypeSerializer)LocalDateTimeSerializer.INSTANCE).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCaseLegacy((DataType)DataTypes.RAW(LocalDateTime.class, (TypeSerializer)LocalDateTimeSerializer.INSTANCE).nullable(), null, BinaryStringData.EMPTY_UTF8), CastTestSpecBuilder.testCastTo(DataTypes.VARCHAR((int)3)).fromCase(DataTypes.STRING(), null, BinaryStringData.EMPTY_UTF8).fromCaseLegacy(DataTypes.STRING(), null, BinaryStringData.EMPTY_UTF8).fromCase(DataTypes.CHAR((int)6), StringData.fromString((String)"Apache"), StringData.fromString((String)"Apa")).fromCaseLegacy(DataTypes.CHAR((int)6), StringData.fromString((String)"Apache"), StringData.fromString((String)"Apache")).fromCase(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), StringData.fromString((String)"Fli")).fromCaseLegacy(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), StringData.fromString((String)"Flink")).fromCase(DataTypes.CHAR((int)2), StringData.fromString((String)"Apache"), StringData.fromString((String)"Apache")).fromCaseLegacy(DataTypes.CHAR((int)2), StringData.fromString((String)"Apache"), StringData.fromString((String)"Apache")).fromCase(DataTypes.VARCHAR((int)2), StringData.fromString((String)"Apache"), StringData.fromString((String)"Apache")).fromCaseLegacy(DataTypes.VARCHAR((int)2), StringData.fromString((String)"Apache"), StringData.fromString((String)"Apache")).fromCase(DataTypes.STRING(), StringData.fromString((String)"Apache Flink"), StringData.fromString((String)"Apa")).fromCaseLegacy(DataTypes.STRING(), StringData.fromString((String)"Apache Flink"), StringData.fromString((String)"Apache Flink")).fromCase(DataTypes.BOOLEAN(), true, StringData.fromString((String)"TRU")).fromCaseLegacy(DataTypes.BOOLEAN(), true, StringData.fromString((String)"true")).fromCase(DataTypes.BOOLEAN(), false, StringData.fromString((String)"FAL")).fromCaseLegacy(DataTypes.BOOLEAN(), false, StringData.fromString((String)"false")).fromCase(DataTypes.BINARY((int)2), new byte[]{0, 1}, StringData.fromString((String)"\u0000\u0001")).fromCaseLegacy(DataTypes.BINARY((int)1), new byte[]{0, 1}, StringData.fromString((String)"\u0000\u0001")).fromCase(DataTypes.BINARY((int)5), new byte[]{0, 1, 2, 3, 4}, StringData.fromString((String)"\u0000\u0001\u0002")).fromCaseLegacy(DataTypes.BINARY((int)5), new byte[]{0, 1, 2, 3, 4}, StringData.fromString((String)"\u0000\u0001\u0002\u0003\u0004")).fromCase(DataTypes.VARBINARY((int)5), new byte[]{0, 1, 2, 3, 4}, StringData.fromString((String)"\u0000\u0001\u0002")).fromCaseLegacy(DataTypes.VARBINARY((int)5), new byte[]{0, 1, 2, 3, 4}, StringData.fromString((String)"\u0000\u0001\u0002\u0003\u0004")).fromCase(DataTypes.BYTES(), new byte[]{0, 1, 2, 3, 4}, StringData.fromString((String)"\u0000\u0001\u0002")).fromCaseLegacy(DataTypes.BYTES(), new byte[]{0, 1, 2, 3, 4}, StringData.fromString((String)"\u0000\u0001\u0002\u0003\u0004")).fromCase(DataTypes.DECIMAL((int)4, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("9.8765"), (int)5, (int)4), StringData.fromString((String)"9.8")).fromCaseLegacy(DataTypes.DECIMAL((int)4, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("9.8765"), (int)5, (int)4), StringData.fromString((String)"9.8765")).fromCase(DataTypes.TINYINT(), (byte)-125, StringData.fromString((String)"-12")).fromCaseLegacy(DataTypes.TINYINT(), (byte)-125, StringData.fromString((String)"-125")).fromCase(DataTypes.SMALLINT(), (short)Short.MAX_VALUE, StringData.fromString((String)"327")).fromCaseLegacy(DataTypes.SMALLINT(), (short)Short.MAX_VALUE, StringData.fromString((String)"32767")).fromCase(DataTypes.INT(), -12345678, StringData.fromString((String)"-12")).fromCaseLegacy(DataTypes.INT(), -12345678, StringData.fromString((String)"-12345678")).fromCase(DataTypes.BIGINT(), 1234567891234L, StringData.fromString((String)"123")).fromCaseLegacy(DataTypes.BIGINT(), 1234567891234L, StringData.fromString((String)"1234567891234")).fromCase(DataTypes.FLOAT(), Float.valueOf(-123.456f), StringData.fromString((String)"-12")).fromCaseLegacy(DataTypes.FLOAT(), Float.valueOf(-123.456f), StringData.fromString((String)"-123.456")).fromCase(DataTypes.DOUBLE(), 12345.678901, StringData.fromString((String)"123")).fromCaseLegacy(DataTypes.DOUBLE(), 12345.678901, StringData.fromString((String)"12345.678901")).fromCase(DataTypes.FLOAT(), Float.valueOf(Float.MAX_VALUE), StringData.fromString((String)"3.4")).fromCaseLegacy(DataTypes.FLOAT(), Float.valueOf(Float.MAX_VALUE), StringData.fromString((String)String.valueOf(Float.MAX_VALUE))).fromCase(DataTypes.DOUBLE(), Double.MAX_VALUE, StringData.fromString((String)"1.7")).fromCaseLegacy(DataTypes.DOUBLE(), Double.MAX_VALUE, StringData.fromString((String)String.valueOf(Double.MAX_VALUE))).fromCase(DataTypes.TIMESTAMP(), CastRulesTest.TIMESTAMP, StringData.fromString((String)"202")).fromCaseLegacy(DataTypes.TIMESTAMP(), CastRulesTest.TIMESTAMP, CastRulesTest.TIMESTAMP_STRING).fromCase(DataTypes.TIMESTAMP_LTZ(), CastRulesTest.CET_CONTEXT, CastRulesTest.TIMESTAMP, StringData.fromString((String)"202")).fromCase(DataTypes.TIMESTAMP_LTZ(), CastRulesTest.CET_CONTEXT_LEGACY, CastRulesTest.TIMESTAMP, CastRulesTest.TIMESTAMP_STRING_CET).fromCase(DataTypes.DATE(), CastRulesTest.DATE, StringData.fromString((String)"202")).fromCaseLegacy(DataTypes.DATE(), CastRulesTest.DATE, CastRulesTest.DATE_STRING).fromCase(DataTypes.TIME((int)5), CastRulesTest.TIME, StringData.fromString((String)"12:")).fromCaseLegacy(DataTypes.TIME((int)5), CastRulesTest.TIME, CastRulesTest.TIME_STRING).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR()), 84, StringData.fromString((String)"+7-")).fromCaseLegacy(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR()), 84, StringData.fromString((String)"+7-00")).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()), 5, StringData.fromString((String)"+0-")).fromCaseLegacy(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()), 5, StringData.fromString((String)"+0-05")).fromCase(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY()), 10L, StringData.fromString((String)"+0 ")).fromCaseLegacy(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY()), 10L, StringData.fromString((String)"+0 00:00:00.010")).fromCase(DataTypes.ARRAY((DataType)DataTypes.INT()), new GenericArrayData(new int[]{-123, 456}), StringData.fromString((String)"[-1")).fromCaseLegacy(DataTypes.ARRAY((DataType)DataTypes.INT()), new GenericArrayData(new int[]{-123, 456}), StringData.fromString((String)"[-123, 456]")).fromCase((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCaseLegacy((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCase(DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())), CastRulesTest.mapData(CastRulesTest.entry(StringData.fromString((String)"a"), -123), CastRulesTest.entry(StringData.fromString((String)"b"), 123)), StringData.fromString((String)"{a=")).fromCaseLegacy(DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())), CastRulesTest.mapData(CastRulesTest.entry(StringData.fromString((String)"a"), -123), CastRulesTest.entry(StringData.fromString((String)"b"), 123)), StringData.fromString((String)"{a=-10-03, b=+10-03}")).fromCase((DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCaseLegacy((DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCase((DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCase(DataTypes.MULTISET((DataType)DataTypes.STRING()), CastRulesTest.mapData(CastRulesTest.entry(StringData.fromString((String)"a"), 1), CastRulesTest.entry(StringData.fromString((String)"b"), 1)), StringData.fromString((String)"{a=")).fromCaseLegacy(DataTypes.MULTISET((DataType)DataTypes.STRING()), CastRulesTest.mapData(CastRulesTest.entry(StringData.fromString((String)"a"), 1), CastRulesTest.entry(StringData.fromString((String)"b"), 1)), StringData.fromString((String)"{a=1, b=1}")).fromCase((DataType)DataTypes.MULTISET((DataType)DataTypes.STRING()).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCaseLegacy(DataTypes.MULTISET((DataType)DataTypes.STRING()), null, BinaryStringData.EMPTY_UTF8).fromCase(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}), GenericRowData.of((Object[])new Object[]{123, StringData.fromString((String)"abc")}), StringData.fromString((String)"(12")).fromCaseLegacy(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}), GenericRowData.of((Object[])new Object[]{123, StringData.fromString((String)"abc")}), StringData.fromString((String)"(123,abc)")).fromCase((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCaseLegacy((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCase(DataTypes.RAW(LocalDateTime.class, (TypeSerializer)LocalDateTimeSerializer.INSTANCE), RawValueData.fromObject((Object)LocalDateTime.parse("2020-11-11T18:08:01.123")), StringData.fromString((String)"202")).fromCaseLegacy(DataTypes.RAW(LocalDateTime.class, (TypeSerializer)LocalDateTimeSerializer.INSTANCE), RawValueData.fromObject((Object)LocalDateTime.parse("2020-11-11T18:08:01.123")), StringData.fromString((String)"2020-11-11T18:08:01.123")).fromCase((DataType)DataTypes.RAW(LocalDateTime.class, (TypeSerializer)LocalDateTimeSerializer.INSTANCE).nullable(), null, BinaryStringData.EMPTY_UTF8).fromCaseLegacy((DataType)DataTypes.RAW(LocalDateTime.class, (TypeSerializer)LocalDateTimeSerializer.INSTANCE).nullable(), null, BinaryStringData.EMPTY_UTF8), CastTestSpecBuilder.testCastTo(DataTypes.BOOLEAN()).fromCase(DataTypes.BOOLEAN(), null, null).fail(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), TableException.class).fromCase(DataTypes.CHAR((int)4), StringData.fromString((String)"true"), true).fromCase(DataTypes.VARCHAR((int)5), StringData.fromString((String)"FalsE"), false).fail(DataTypes.STRING(), StringData.fromString((String)"Apache Flink"), TableException.class).fromCase(DataTypes.STRING(), StringData.fromString((String)"TRUE"), true).fail(DataTypes.STRING(), StringData.fromString((String)""), TableException.class).fromCase(DataTypes.DECIMAL((int)5, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("0.000"), (int)5, (int)3), false).fromCase(DataTypes.DECIMAL((int)4, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("1.987"), (int)4, (int)3), true).fromCase(DataTypes.TINYINT(), (byte)5, true).fromCase(DataTypes.TINYINT(), (byte)-5, true).fromCase(DataTypes.TINYINT(), (byte)0, false).fromCase(DataTypes.SMALLINT(), (short)12345, true).fromCase(DataTypes.SMALLINT(), (short)-12345, true).fromCase(DataTypes.SMALLINT(), (short)0, false).fromCase(DataTypes.INT(), 1234567, true).fromCase(DataTypes.INT(), -1234567, true).fromCase(DataTypes.INT(), 0, false).fromCase(DataTypes.BIGINT(), 12345678901L, true).fromCase(DataTypes.BIGINT(), -12345678901L, true).fromCase(DataTypes.BIGINT(), 0L, false).fromCase(DataTypes.FLOAT(), Float.valueOf(0.0f), false).fromCase(DataTypes.FLOAT(), Float.valueOf(1.1234f), true).fromCase(DataTypes.DOUBLE(), 0.0, false).fromCase(DataTypes.DOUBLE(), -0.12345678, true), CastTestSpecBuilder.testCastTo(DataTypes.BINARY((int)4)).fromCase(DataTypes.CHAR((int)4), StringData.fromString((String)"66"), new byte[]{54, 54, 0, 0}).fromCaseLegacy(DataTypes.CHAR((int)4), StringData.fromString((String)"66"), new byte[]{54, 54}).fromCase(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), new byte[]{102, 111, 111, 0}).fromCaseLegacy(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), new byte[]{102, 111, 111}).fromCase(DataTypes.CHAR((int)10), StringData.fromString((String)"66A2"), new byte[]{54, 54, 65, 50}).fromCaseLegacy(DataTypes.CHAR((int)10), StringData.fromString((String)"66A2"), new byte[]{54, 54, 65, 50}).fromCase(DataTypes.CHAR((int)1), StringData.fromString((String)"f"), new byte[]{102, 0, 0, 0}).fromCaseLegacy(DataTypes.CHAR((int)1), StringData.fromString((String)"f"), new byte[]{102}).fromCase(DataTypes.CHAR((int)16), StringData.fromString((String)"12f4aBc7"), new byte[]{49, 50, 102, 52}).fromCase(DataTypes.CHAR((int)3), StringData.fromString((String)"A f "), new byte[]{65, 32, 102, 32}).fromCase(DataTypes.VARCHAR((int)8), StringData.fromString((String)"bAC"), new byte[]{98, 65, 67, 0}).fromCase(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), new byte[]{70, 108, 105, 110}).fromCaseLegacy(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), new byte[]{70, 108, 105, 110, 107}).fromCase(DataTypes.STRING(), StringData.fromString((String)"Apache"), new byte[]{65, 112, 97, 99}).fromCaseLegacy(DataTypes.STRING(), StringData.fromString((String)"Apache"), new byte[]{65, 112, 97, 99, 104, 101}).fromCase(DataTypes.BINARY((int)2), new byte[]{1, 2}, new byte[]{1, 2, 0, 0}).fromCaseLegacy(DataTypes.BINARY((int)2), new byte[]{1, 2}, new byte[]{1, 2}).fromCase(DataTypes.VARBINARY((int)3), new byte[]{1, 2, 3}, new byte[]{1, 2, 3, 0}).fromCaseLegacy(DataTypes.VARBINARY((int)3), new byte[]{1, 2, 3}, new byte[]{1, 2, 3}).fromCase(DataTypes.BYTES(), new byte[]{1, 2, 3}, new byte[]{1, 2, 3, 0}).fromCaseLegacy(DataTypes.BYTES(), new byte[]{1, 2, 3}, new byte[]{1, 2, 3}), CastTestSpecBuilder.testCastTo(DataTypes.VARBINARY((int)4)).fromCase(DataTypes.CHAR((int)4), StringData.fromString((String)"c9"), new byte[]{99, 57}).fromCaseLegacy(DataTypes.CHAR((int)4), StringData.fromString((String)"c9"), new byte[]{99, 57}).fromCase(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), new byte[]{102, 111, 111}).fromCaseLegacy(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), new byte[]{102, 111, 111}).fromCase(DataTypes.VARCHAR((int)8), StringData.fromString((String)"7de2"), new byte[]{55, 100, 101, 50}).fromCaseLegacy(DataTypes.VARCHAR((int)8), StringData.fromString((String)"7de2"), new byte[]{55, 100, 101, 50}).fromCase(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), new byte[]{70, 108, 105, 110}).fromCaseLegacy(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), new byte[]{70, 108, 105, 110, 107}).fromCase(DataTypes.STRING(), StringData.fromString((String)"12F4a bC7"), new byte[]{49, 50, 70, 52}).fromCaseLegacy(DataTypes.STRING(), StringData.fromString((String)"12F4a bC7"), new byte[]{49, 50, 70, 52, 97, 32, 98, 67, 55}).fromCaseLegacy(DataTypes.STRING(), StringData.fromString((String)"Apache"), new byte[]{65, 112, 97, 99, 104, 101}).fromCase(DataTypes.BINARY((int)2), new byte[]{1, 2, 3, 4, 5}, new byte[]{1, 2, 3, 4, 5}).fromCaseLegacy(DataTypes.BINARY((int)2), new byte[]{1, 2, 3, 4, 5}, new byte[]{1, 2, 3, 4, 5}).fromCase(DataTypes.VARBINARY((int)2), new byte[]{1, 2, 3, 4, 5}, new byte[]{1, 2, 3, 4, 5}).fromCaseLegacy(DataTypes.VARBINARY((int)2), new byte[]{1, 2, 3, 4, 5}, new byte[]{1, 2, 3, 4, 5}), CastTestSpecBuilder.testCastTo(DataTypes.BYTES()).fromCase(DataTypes.CHAR((int)4), StringData.fromString((String)"9C"), new byte[]{57, 67}).fromCaseLegacy(DataTypes.CHAR((int)4), StringData.fromString((String)"9C"), new byte[]{57, 67}).fromCase(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), new byte[]{102, 111, 111}).fromCaseLegacy(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), new byte[]{102, 111, 111}).fromCase(DataTypes.VARCHAR((int)8), StringData.fromString((String)"3ee3"), new byte[]{51, 101, 101, 51}).fromCaseLegacy(DataTypes.VARCHAR((int)8), StringData.fromString((String)"3ee3"), new byte[]{51, 101, 101, 51}).fromCase(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), new byte[]{70, 108, 105, 110, 107}).fromCaseLegacy(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), new byte[]{70, 108, 105, 110, 107}).fromCase(DataTypes.STRING(), StringData.fromString((String)"AAbb Cc Dd"), new byte[]{65, 65, 98, 98, 32, 67, 99, 32, 68, 100}).fromCaseLegacy(DataTypes.STRING(), StringData.fromString((String)"AAbb Cc Dd"), new byte[]{65, 65, 98, 98, 32, 67, 99, 32, 68, 100}).fromCase(DataTypes.STRING(), StringData.fromString((String)"Apache"), new byte[]{65, 112, 97, 99, 104, 101}).fromCaseLegacy(DataTypes.STRING(), StringData.fromString((String)"Apache"), new byte[]{65, 112, 97, 99, 104, 101}), CastTestSpecBuilder.testCastTo(DataTypes.DECIMAL((int)5, (int)3)).fail(DataTypes.CHAR((int)3), StringData.fromString((String)"foo"), TableException.class).fail(DataTypes.VARCHAR((int)5), StringData.fromString((String)"Flink"), TableException.class).fail(DataTypes.STRING(), StringData.fromString((String)"Apache"), TableException.class).fromCase(DataTypes.STRING(), StringData.fromString((String)"1.234"), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("1.234"), (int)5, (int)3)).fromCase(DataTypes.STRING(), StringData.fromString((String)"1.2"), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("1.200"), (int)5, (int)3)).fromCase(DataTypes.STRING(), StringData.fromString((String)" 1.2 "), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("1.200"), (int)5, (int)3)).fromCase(DataTypes.STRING(), StringData.fromString((String)" .2 "), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("0.200"), (int)5, (int)3)).fromCase(DataTypes.DECIMAL((int)4, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("9.87"), (int)4, (int)3), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("9.870"), (int)5, (int)3)).fromCase(DataTypes.TINYINT(), (byte)-1, DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("-1.000"), (int)5, (int)3)).fromCase(DataTypes.SMALLINT(), (short)3, DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("3.000"), (int)5, (int)3)).fromCase(DataTypes.INT(), 42, DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("42.000"), (int)5, (int)3)).fromCase(DataTypes.BIGINT(), 8L, DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("8.000"), (int)5, (int)3)).fromCase(DataTypes.FLOAT(), Float.valueOf(-12.345f), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("-12.345"), (int)5, (int)3)).fromCase(DataTypes.DOUBLE(), 12.678, DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("12.678"), (int)5, (int)3)).fromCase(DataTypes.BOOLEAN(), true, DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)5, (int)3)).fromCase(DataTypes.BOOLEAN(), false, DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ZERO, (int)5, (int)3)), CastTestSpecBuilder.testCastTo(DataTypes.ARRAY((DataType)((DataType)DataTypes.STRING().nullable()))).fromCase(DataTypes.ARRAY((DataType)((DataType)DataTypes.TIMESTAMP().nullable())), new GenericArrayData(new Object[]{CastRulesTest.TIMESTAMP, null, TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.parse("2021-09-24T14:34:56.123456"))}), new GenericArrayData(new Object[]{CastRulesTest.TIMESTAMP_STRING, null, StringData.fromString((String)"2021-09-24 14:34:56.123456")})), CastTestSpecBuilder.testCastTo(DataTypes.ARRAY((DataType)((DataType)DataTypes.BIGINT().nullable()))).fromCase(DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().nullable())), new GenericArrayData((Object[])new Integer[]{1, null, 2}), new GenericArrayData((Object[])new Long[]{1L, null, 2L})), CastTestSpecBuilder.testCastTo(DataTypes.ARRAY((DataType)((DataType)DataTypes.BIGINT().notNull()))).fromCase(DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull())), new GenericArrayData(new int[]{1, 2}), new GenericArrayData(new long[]{1L, 2L})), CastTestSpecBuilder.testCastTo(DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.BIGINT().notNull())))).fail(DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().nullable()))), new GenericArrayData((Object[])new GenericArrayData[]{new GenericArrayData((Object[])new Integer[]{1, 2, null}), new GenericArrayData((Object[])new Integer[]{3})}), NullPointerException.class).fromCase(DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().nullable()))), new GenericArrayData((Object[])new GenericArrayData[]{new GenericArrayData((Object[])new Integer[]{1, 2}), new GenericArrayData((Object[])new Integer[]{3})}), new GenericArrayData((Object[])new GenericArrayData[]{new GenericArrayData((Object[])new Long[]{1L, 2L}), new GenericArrayData((Object[])new Long[]{3L})})), CastTestSpecBuilder.testCastTo(DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.DECIMAL((int)10, (int)2).notNull())))).fromCase(DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull()))), new GenericArrayData((Object[])new GenericArrayData[]{new GenericArrayData((Object[])new Integer[]{1, 2}), new GenericArrayData((Object[])new Integer[]{3})}), new GenericArrayData((Object[])new GenericArrayData[]{new GenericArrayData(new Object[]{DecimalData.fromBigDecimal((BigDecimal)BigDecimal.ONE, (int)10, (int)2), DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(2), (int)10, (int)2)}), new GenericArrayData(new Object[]{DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(3), (int)10, (int)2)})})), CastTestSpecBuilder.testCastTo(DataTypes.MAP((DataType)((DataType)DataTypes.DOUBLE().notNull()), (DataType)((DataType)DataTypes.DOUBLE().notNull()))).fromCase(DataTypes.MAP((DataType)((DataType)DataTypes.INT().nullable()), (DataType)((DataType)DataTypes.INT().nullable())), CastRulesTest.mapData(CastRulesTest.entry(1, 2)), CastRulesTest.mapData(CastRulesTest.entry(1.0, 2.0))), CastTestSpecBuilder.testCastTo(DataTypes.MAP((DataType)((DataType)DataTypes.BIGINT().nullable()), (DataType)((DataType)DataTypes.BIGINT().nullable()))).fromCase(DataTypes.MAP((DataType)((DataType)DataTypes.INT().nullable()), (DataType)((DataType)DataTypes.INT().nullable())), CastRulesTest.mapData(CastRulesTest.entry(1, 2)), CastRulesTest.mapData(CastRulesTest.entry(1L, 2L))), CastTestSpecBuilder.testCastTo(DataTypes.MAP((DataType)((DataType)DataTypes.BIGINT().nullable()), (DataType)((DataType)DataTypes.BIGINT().nullable()))).fromCase(DataTypes.MAP((DataType)((DataType)DataTypes.INT().nullable()), (DataType)((DataType)DataTypes.INT().nullable())), CastRulesTest.mapData(CastRulesTest.entry(1, 2), CastRulesTest.entry(null, 3), CastRulesTest.entry(4, null)), CastRulesTest.mapData(CastRulesTest.entry(1L, 2L), CastRulesTest.entry(null, 3L), CastRulesTest.entry(4L, null))), CastTestSpecBuilder.testCastTo(DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.STRING().nullable()))).fromCase(DataTypes.MAP((DataType)((DataType)DataTypes.TIMESTAMP().nullable()), (DataType)((DataType)DataTypes.DOUBLE().nullable())), CastRulesTest.mapData(CastRulesTest.entry(CastRulesTest.TIMESTAMP, 123.456)), CastRulesTest.mapData(CastRulesTest.entry(CastRulesTest.TIMESTAMP_STRING, StringData.fromString((String)"123.456")))), CastTestSpecBuilder.testCastTo(DataTypes.MAP((DataType)((DataType)DataTypes.STRING().notNull()), (DataType)((DataType)DataTypes.STRING().nullable()))).fail(DataTypes.MAP((DataType)((DataType)DataTypes.INT().nullable()), (DataType)((DataType)DataTypes.DOUBLE().nullable())), CastRulesTest.mapData(CastRulesTest.entry(null, 1.0)), NullPointerException.class), CastTestSpecBuilder.testCastTo(DataTypes.MAP((DataType)((DataType)DataTypes.STRING().notNull()), (DataType)((DataType)DataTypes.STRING().notNull()))).fail(DataTypes.MAP((DataType)((DataType)DataTypes.INT().nullable()), (DataType)((DataType)DataTypes.DOUBLE().nullable())), CastRulesTest.mapData(CastRulesTest.entry(123, null)), NullPointerException.class), CastTestSpecBuilder.testCastTo(DataTypes.MULTISET((DataType)((DataType)DataTypes.DOUBLE().notNull()))).fromCase(DataTypes.MULTISET((DataType)((DataType)DataTypes.INT().nullable())), CastRulesTest.mapData(CastRulesTest.entry(1, 1)), CastRulesTest.mapData(CastRulesTest.entry(1.0, 1))), CastTestSpecBuilder.testCastTo(DataTypes.MULTISET((DataType)((DataType)DataTypes.STRING().notNull()))).fromCase(DataTypes.MULTISET((DataType)((DataType)DataTypes.INT().nullable())), CastRulesTest.mapData(CastRulesTest.entry(1, 1)), CastRulesTest.mapData(CastRulesTest.entry(StringData.fromString((String)"1"), 1))), CastTestSpecBuilder.testCastTo(DataTypes.MULTISET((DataType)((DataType)DataTypes.FLOAT().nullable()))).fromCase(DataTypes.MULTISET((DataType)((DataType)DataTypes.INT().nullable())), CastRulesTest.mapData(CastRulesTest.entry(null, 1)), CastRulesTest.mapData(CastRulesTest.entry(null, 1))), CastTestSpecBuilder.testCastTo(DataTypes.MULTISET((DataType)((DataType)DataTypes.STRING().notNull()))).fail(DataTypes.MULTISET((DataType)((DataType)DataTypes.INT().nullable())), CastRulesTest.mapData(CastRulesTest.entry(null, 1)), NullPointerException.class), CastTestSpecBuilder.testCastTo(DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.BIGINT().notNull(), DataTypes.BIGINT(), DataTypes.STRING(), DataTypes.ARRAY((DataType)DataTypes.STRING())})).fromCase(DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.INT().notNull(), DataTypes.INT(), DataTypes.TIME((int)5), DataTypes.ARRAY((DataType)DataTypes.TIMESTAMP())}), GenericRowData.of((Object[])new Object[]{10, null, CastRulesTest.TIME, new GenericArrayData(new Object[]{CastRulesTest.TIMESTAMP, CastRulesTest.TIMESTAMP, CastRulesTest.TIMESTAMP})}), GenericRowData.of((Object[])new Object[]{10L, null, CastRulesTest.TIME_STRING, new GenericArrayData(new Object[]{CastRulesTest.TIMESTAMP_STRING, CastRulesTest.TIMESTAMP_STRING, CastRulesTest.TIMESTAMP_STRING})})).fromCase(DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.INT().notNull(), DataTypes.INT(), DataTypes.DATE(), DataTypes.ARRAY((DataType)DataTypes.STRING()), DataTypes.TIME((int)5)}), GenericRowData.of((Object[])new Object[]{10, 100, CastRulesTest.DATE, new GenericArrayData(new Object[]{StringData.fromString((String)"a"), StringData.fromString((String)"b"), StringData.fromString((String)"c")}), CastRulesTest.TIME}), GenericRowData.of((Object[])new Object[]{10L, 100L, CastRulesTest.DATE_STRING, new GenericArrayData(new Object[]{StringData.fromString((String)"a"), StringData.fromString((String)"b"), StringData.fromString((String)"c")})})), CastTestSpecBuilder.testCastTo(DataTypes.ROW((DataType[])new DataType[]{DataTypes.MAP((DataType)((DataType)DataTypes.BIGINT().notNull()), (DataType)DataTypes.STRING()), DataTypes.MULTISET((DataType)DataTypes.STRING())})).fromCase(DataTypes.ROW((DataType[])new DataType[]{DataTypes.MAP((DataType)((DataType)DataTypes.INT().notNull()), (DataType)DataTypes.INT()), DataTypes.MULTISET((DataType)DataTypes.TIMESTAMP())}), GenericRowData.of((Object[])new Object[]{CastRulesTest.mapData(CastRulesTest.entry(1, 2)), CastRulesTest.mapData(CastRulesTest.entry(CastRulesTest.TIMESTAMP, 1))}), GenericRowData.of((Object[])new Object[]{CastRulesTest.mapData(CastRulesTest.entry(1L, StringData.fromString((String)"2"))), CastRulesTest.mapData(CastRulesTest.entry(CastRulesTest.TIMESTAMP_STRING, 1))})), CastTestSpecBuilder.testCastTo(CastRulesTest.MY_STRUCTURED_TYPE).fromCase(DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.INT().notNull(), DataTypes.INT(), DataTypes.TIME((int)5), DataTypes.ARRAY((DataType)DataTypes.TIMESTAMP())}), GenericRowData.of((Object[])new Object[]{10, null, CastRulesTest.TIME, new GenericArrayData(new Object[]{CastRulesTest.TIMESTAMP, CastRulesTest.TIMESTAMP, CastRulesTest.TIMESTAMP})}), GenericRowData.of((Object[])new Object[]{10L, null, CastRulesTest.TIME_STRING, new GenericArrayData(new Object[]{CastRulesTest.TIMESTAMP_STRING, CastRulesTest.TIMESTAMP_STRING, CastRulesTest.TIMESTAMP_STRING})})));
    }

    @TestFactory
    Stream<DynamicTest> castTests() {
        return DynamicTest.stream(this.testCases().flatMap(rec$ -> ((CastTestSpecBuilder)rec$).toSpecs()), CastTestSpec::toString, CastTestSpec::run);
    }

    private static <K, V> Map.Entry<K, V> entry(K k, V v) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(k, v);
    }

    @SafeVarargs
    private static <K, V> MapData mapData(Map.Entry<K, V> ... entries) {
        if (entries == null) {
            return new GenericMapData(Collections.emptyMap());
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return new GenericMapData(map);
    }

    private static TimestampData timestampDataFromLocalDateTime(int years, int months, int days, int hours, int minutes, int seconds, int nanos) {
        return TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.of(years, months, days, hours, minutes, seconds, nanos));
    }

    private static TimestampData timestampDataFromInstant(int years, int months, int days, int hours, int minutes, int seconds, int nanos) {
        return TimestampData.fromInstant((Instant)LocalDateTime.of(years, months, days, hours, minutes, seconds, nanos).atZone(CET).toInstant());
    }

    private static class CastTestSpecBuilder {
        private DataType targetType;
        private final List<DataType> inputTypes = new ArrayList<DataType>();
        private final List<Consumer<CastExecutor>> assertionExecutors = new ArrayList<Consumer<CastExecutor>>();
        private final List<String> descriptions = new ArrayList<String>();
        private final List<CastRule.Context> castContexts = new ArrayList<CastRule.Context>();

        private CastTestSpecBuilder() {
        }

        private static CastTestSpecBuilder testCastTo(DataType targetType) {
            CastTestSpecBuilder tsb = new CastTestSpecBuilder();
            tsb.targetType = targetType;
            return tsb;
        }

        private CastTestSpecBuilder fromCase(DataType srcDataType, Object src, Object target) {
            return this.fromCase(srcDataType, CastRule.Context.create((boolean)false, (boolean)false, (ZoneId)DateTimeUtils.UTC_ZONE.toZoneId(), (ClassLoader)Thread.currentThread().getContextClassLoader(), (CodeGeneratorContext)CTX), src, target);
        }

        private CastTestSpecBuilder fromCasePrinting(DataType srcDataType, Object src, Object target) {
            return this.fromCase(srcDataType, CastRule.Context.create((boolean)true, (boolean)false, (ZoneId)DateTimeUtils.UTC_ZONE.toZoneId(), (ClassLoader)Thread.currentThread().getContextClassLoader(), (CodeGeneratorContext)CTX), src, target);
        }

        private CastTestSpecBuilder fromCaseLegacy(DataType srcDataType, Object src, Object target) {
            return this.fromCase(srcDataType, CastRule.Context.create((boolean)false, (boolean)true, (ZoneId)DateTimeUtils.UTC_ZONE.toZoneId(), (ClassLoader)Thread.currentThread().getContextClassLoader(), (CodeGeneratorContext)CTX), src, target);
        }

        private CastTestSpecBuilder fromCase(DataType srcDataType, CastRule.Context castContext, Object src, Object target) {
            this.inputTypes.add(srcDataType);
            this.assertionExecutors.add(executor -> {
                TableAssertions.assertThatGenericDataOfType((Object)executor.cast(src), (DataType)this.targetType).isEqualTo(target);
                ((AbstractAssert)TableAssertions.assertThatGenericDataOfType((Object)executor.cast(src), (DataType)this.targetType).as("Error when reusing the rule. Perhaps there is some state that needs to be reset", new Object[0])).isEqualTo(target);
            });
            this.descriptions.add("{" + src + " => " + target + "}");
            this.castContexts.add(castContext);
            return this;
        }

        private CastTestSpecBuilder fail(DataType dataType, Object src, Class<? extends Throwable> exception) {
            return this.fail(dataType, CastRule.Context.create((boolean)false, (boolean)false, (ZoneId)DateTimeUtils.UTC_ZONE.toZoneId(), (ClassLoader)Thread.currentThread().getContextClassLoader(), (CodeGeneratorContext)CTX), src, exception);
        }

        private CastTestSpecBuilder fail(DataType dataType, CastRule.Context castContext, Object src, Class<? extends Throwable> exception) {
            this.inputTypes.add(dataType);
            this.assertionExecutors.add(executor -> {
                AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> executor.cast(src)).isInstanceOf(exception);
            });
            this.descriptions.add("{" + src + " => " + exception.getName() + "}");
            this.castContexts.add(castContext);
            return this;
        }

        private Stream<CastTestSpec> toSpecs() {
            CastTestSpec[] testSpecs = new CastTestSpec[this.assertionExecutors.size()];
            for (int i = 0; i < this.assertionExecutors.size(); ++i) {
                testSpecs[i] = new CastTestSpec(this.inputTypes.get(i), this.targetType, this.assertionExecutors.get(i), this.descriptions.get(i), this.castContexts.get(i));
            }
            return Arrays.stream(testSpecs);
        }
    }

    private static class CastTestSpec {
        private final DataType inputType;
        private final DataType targetType;
        private final Consumer<CastExecutor> assertionExecutor;
        private final String description;
        private final CastRule.Context castContext;

        public CastTestSpec(DataType inputType, DataType targetType, Consumer<CastExecutor> assertionExecutor, String description, CastRule.Context castContext) {
            this.inputType = inputType;
            this.targetType = targetType;
            this.assertionExecutor = assertionExecutor;
            this.description = description;
            this.castContext = castContext;
        }

        public void run() throws Exception {
            CastExecutor executor = CastRuleProvider.create((CastRule.Context)this.castContext, (LogicalType)this.inputType.getLogicalType(), (LogicalType)this.targetType.getLogicalType());
            ((ObjectAssert)Assertions.assertThat((Object)executor).as("Cannot resolve an executor for input " + this.inputType + " and target " + this.targetType, new Object[0])).isNotNull();
            this.assertionExecutor.accept(executor);
        }

        public String toString() {
            return this.inputType + " => " + this.targetType + " " + this.description;
        }
    }

    public static class MyStructuredType {
        public long a;
        public Long b;
        public String c;
        public String[] d;

        public MyStructuredType(long a, Long b, String c, String[] d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public String toString() {
            return "My fancy string representation{a=" + this.a + ", b=" + this.b + ", c='" + this.c + '\'' + ", d=" + Arrays.toString(this.d) + '}';
        }
    }
}

