/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.hint;

import java.util.Collections;
import java.util.HashMap;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.hint.ClearQueryHintsWithInvalidPropagationShuttleTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClearStateTtlHintsWithInvalidPropagationShuttleTest
extends ClearQueryHintsWithInvalidPropagationShuttleTestBase {
    @Override
    TableTestUtil getTableTestUtil() {
        return this.streamTestUtil(TableConfig.getDefault());
    }

    @Override
    boolean isBatchMode() {
        return false;
    }

    @Override
    @BeforeEach
    void before() throws Exception {
        super.before();
        this.enableCapitalize();
    }

    @Test
    void testNoNeedToClearStateTtlHintOnJoin() {
        HashMap<String, String> hintOptions = new HashMap<String, String>();
        hintOptions.put("t1", "1d");
        hintOptions.put("t2", "7d");
        RelHint stateTtlHint = RelHint.builder((String)"StaTe_TtL").hintOptions(hintOptions).build();
        RelHint aliasHint = RelHint.builder((String)"ALIAS").hintOption("t4").build();
        RelNode root = this.builder.scan(new String[]{"t1"}).scan(new String[]{"t2"}).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{stateTtlHint, aliasHint}).scan(new String[]{"t3"}).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).build();
        this.verifyRelPlan(root);
    }

    @Test
    void testClearStateTtlHintOnJoin() {
        HashMap<String, String> hintOptionsInner = new HashMap<String, String>();
        hintOptionsInner.put("t1", "1d");
        hintOptionsInner.put("t2", "7d");
        RelHint stateTtlHintInner = RelHint.builder((String)"StaTe_TtL").hintOptions(hintOptionsInner).build();
        HashMap<String, String> hintOptionsOuter = new HashMap<String, String>();
        hintOptionsOuter.put("t4", "9d");
        hintOptionsOuter.put("t3", "12d");
        RelHint stateTtlHintOuter = RelHint.builder((String)"StAte_tTl").hintOptions(hintOptionsOuter).build();
        RelHint aliasHint = RelHint.builder((String)"ALIAS").hintOption("t4").build();
        RelNode root = this.builder.scan(new String[]{"t1"}).scan(new String[]{"t2"}).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{stateTtlHintInner, aliasHint}).scan(new String[]{"t3"}).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{stateTtlHintOuter}).build();
        this.verifyRelPlan(root);
    }

    @Test
    void testNoNeedToClearStateTtlHintOnAggregate() {
        HashMap<String, String> hintOptions = new HashMap<String, String>();
        hintOptions.put("t4", "1d");
        RelHint stateTtlHint = RelHint.builder((String)"StaTe_TtL").hintOptions(hintOptions).build();
        RelHint aliasHint = RelHint.builder((String)"ALIAS").hintOption("tmp").build();
        RelNode root = this.builder.scan(new String[]{"t4"}).aggregate(this.builder.groupKey(ImmutableBitSet.of((int[])new int[]{0, 1})), Collections.singletonList(this.builder.count(new RexNode[]{this.builder.field(1, 0, "c")}).as("cnt"))).hints(new RelHint[]{stateTtlHint, aliasHint}).project(new RexNode[]{this.builder.field(1, 0, "a"), this.builder.field(1, 0, "cnt")}).aggregate(this.builder.groupKey(ImmutableBitSet.of((int[])new int[]{0})), Collections.singletonList(this.builder.max((RexNode)this.builder.field(1, 0, "cnt")).as("max"))).project(new RexNode[]{this.builder.field(1, 0, "a"), this.builder.field(1, 0, "max")}).build();
        this.verifyRelPlan(root);
    }

    @Test
    void testClearStateTtlHintOnAggregate() {
        HashMap<String, String> hintOptionsInner = new HashMap<String, String>();
        hintOptionsInner.put("t4", "1d");
        RelHint stateTtlHintInner = RelHint.builder((String)"StaTe_TtL").hintOptions(hintOptionsInner).build();
        HashMap<String, String> hintOptionsOuter = new HashMap<String, String>();
        hintOptionsOuter.put("tmp", "2d");
        RelHint stateTtlHintOuter = RelHint.builder((String)"StaTe_TtL").hintOptions(hintOptionsOuter).build();
        RelHint aliasHint = RelHint.builder((String)"ALIAS").hintOption("tmp").build();
        RelNode root = this.builder.scan(new String[]{"t4"}).aggregate(this.builder.groupKey(ImmutableBitSet.of((int[])new int[]{0, 1})), Collections.singletonList(this.builder.count(new RexNode[]{this.builder.field(1, 0, "c")}).as("cnt"))).hints(new RelHint[]{stateTtlHintInner, aliasHint}).project(new RexNode[]{this.builder.field(1, 0, "a"), this.builder.field(1, 0, "cnt")}).aggregate(this.builder.groupKey(ImmutableBitSet.of((int[])new int[]{0})), Collections.singletonList(this.builder.max((RexNode)this.builder.field(1, 0, "cnt")).as("max"))).project(new RexNode[]{this.builder.field(1, 0, "a"), this.builder.field(1, 0, "max")}).hints(new RelHint[]{stateTtlHintOuter}).build();
        this.verifyRelPlan(root);
    }
}

