/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.match;

import java.time.Duration;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.Quantifier;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.apache.flink.table.planner.plan.logical.MatchRecognize;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecMatch;
import org.apache.flink.table.planner.plan.nodes.exec.spec.MatchSpec;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalDataStreamScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalMatch;
import org.apache.flink.table.planner.plan.utils.MatchUtil$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de!B\u0001\u0003\u0003\u0003y!!\u0007)biR,'O\u001c+sC:\u001cH.\u0019;peR+7\u000f\u001e\"bg\u0016T!a\u0001\u0003\u0002\u000b5\fGo\u00195\u000b\u0005\u00151\u0011a\u00029mC:tWM\u001d\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAq\u0001\b\u0001C\u0002\u0013%Q$A\tuKN$H+\u00192mKRK\b/Z%oM>,\u0012A\b\t\u0003?\u0019j\u0011\u0001\t\u0006\u0003C\t\n\u0011\u0002^=qKV$\u0018\u000e\\:\u000b\u0005\r\"\u0013\u0001\u00026bm\u0006T!!\n\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0002(A\tY!k\\<UsB,\u0017J\u001c4p\u0011\u0019I\u0003\u0001)A\u0005=\u0005\u0011B/Z:u)\u0006\u0014G.\u001a+za\u0016LeNZ8!\u0011\u001dY\u0003A1A\u0005\n1\n\u0001\u0003^3tiR\u000b'\r\\3S_^$\u0016\u0010]3\u0016\u00035\u0002\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\u000f1|w-[2bY*\u0011!GB\u0001\u0006if\u0004Xm]\u0005\u0003i=\u0012qAU8x)f\u0004X\r\u0003\u00047\u0001\u0001\u0006I!L\u0001\u0012i\u0016\u001cH\u000fV1cY\u0016\u0014vn\u001e+za\u0016\u0004\u0003b\u0002\u001d\u0001\u0005\u0004%I!O\u0001\ni\u0006\u0014G.\u001a(b[\u0016,\u0012A\u000f\t\u0003w}j\u0011\u0001\u0010\u0006\u0003{y\nA\u0001\\1oO*\t1%\u0003\u0002Ay\t11\u000b\u001e:j]\u001eDaA\u0011\u0001!\u0002\u0013Q\u0014A\u0003;bE2,g*Y7fA!9A\t\u0001b\u0001\n\u0013)\u0015aB2p]R,\u0007\u0010^\u000b\u0002\rB)\u0011cR%R/&\u0011\u0001J\u0005\u0002\u0007)V\u0004H.Z\u001a\u0011\u0005){U\"A&\u000b\u00051k\u0015!\u0002;p_2\u001c(B\u0001(\u000b\u0003\u001d\u0019\u0017\r\\2ji\u0016L!\u0001U&\u0003\u0015I+GNQ;jY\u0012,'\u000f\u0005\u0002S+6\t1K\u0003\u0002U\t\u0005QA-\u001a7fO\u0006$\u0018n\u001c8\n\u0005Y\u001b&a\u0003)mC:tWM\u001d\"bg\u0016\u0004\"\u0001W/\u000e\u0003eS!a\u0005.\u000b\u0005\u0015Z&B\u0001/\t\u0003%\u0019HO]3b[&tw-\u0003\u0002_3\nQ2\u000b\u001e:fC6,\u00050Z2vi&|g.\u00128wSJ|g.\\3oi\"1\u0001\r\u0001Q\u0001\n\u0019\u000b\u0001bY8oi\u0016DH\u000f\t\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u00039\u0019\u0017\r\\2ji\u0016\u0004F.\u00198oKJ,\u0012\u0001\u001a\t\u0003K\u001el\u0011A\u001a\u0006\u0003\u001d\u0012I!\u0001\u001b4\u0003!\u0019c\u0017N\\6QY\u0006tg.\u001a:J[Bd\u0007B\u00026\u0001A\u0003%A-A\bdC2\u001c\u0017\u000e^3QY\u0006tg.\u001a:!\u0011\u001da\u0007A1A\u0005\n5\fa\u0001]1sg\u0016\u0014X#\u00018\u0011\u0005=\u0014X\"\u00019\u000b\u0005E$\u0011!\u00029beN,\u0017BA:q\u00055\u0019\u0015\r\\2ji\u0016\u0004\u0016M]:fe\"1Q\u000f\u0001Q\u0001\n9\fq\u0001]1sg\u0016\u0014\b\u0005C\u0003x\u0001\u0011%\u00010\u0001\bqe\u0016\u0004\u0018M]3D_:$X\r\u001f;\u0015\u0005\u0019K\b\"\u0002>w\u0001\u0004Y\u0018\u0001\u0003;za\u0016LeNZ8\u0011\u000bq\f\u0019!a\u0002\u000e\u0003uT!A`@\u0002\u0011QL\b/Z5oM>T1!!\u0001%\u0003\u0019\u0019w.\\7p]&\u0019\u0011QA?\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:\u0004B!!\u0003\u0002\u000e5\u0011\u00111\u0002\u0006\u0003e!IA!a\u0004\u0002\f\t\u0019!k\\<\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u0005ia/\u001a:jMf\u0004\u0016\r\u001e;fe:$b!a\u0006\u0002\u001e\u0005U\u0002cA\t\u0002\u001a%\u0019\u00111\u0004\n\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003?\t\t\u00021\u0001\u0002\"\u0005qQ.\u0019;dQJ+7m\\4oSj,\u0007\u0003BA\u0012\u0003cqA!!\n\u0002.A\u0019\u0011q\u0005\n\u000e\u0005\u0005%\"bAA\u0016\u001d\u00051AH]8pizJ1!a\f\u0013\u0003\u0019\u0001&/\u001a3fM&\u0019\u0001)a\r\u000b\u0007\u0005=\"\u0003\u0003\u0005\u00028\u0005E\u0001\u0019AA\u001d\u0003!)\u0007\u0010]3di\u0016$\u0007\u0007BA\u001e\u00037\u0002\u0002\"!\u0010\u0002H\u0005-\u0013qK\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u00059\u0001/\u0019;uKJt'bAA#\u0011\u0005\u00191-\u001a9\n\t\u0005%\u0013q\b\u0002\b!\u0006$H/\u001a:o!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)\r\u0005!A-\u0019;b\u0013\u0011\t)&a\u0014\u0003\u000fI{w\u000fR1uCB!\u0011\u0011LA.\u0019\u0001!A\"!\u0018\u00026\u0005\u0005\t\u0011!B\u0001\u0003?\u00121a\u0018\u00132#\u0011\t\t'a\u0013\u0011\u0007E\t\u0019'C\u0002\u0002fI\u0011qAT8uQ&tw\rC\u0004\u0002j\u0001!I!a\u001b\u0002\u000f\r|W\u000e]1sKR1\u0011qCA7\u0003sB\u0001\"a\u000e\u0002h\u0001\u0007\u0011q\u000e\u0019\u0005\u0003c\n)\b\u0005\u0005\u0002>\u0005\u001d\u00131JA:!\u0011\tI&!\u001e\u0005\u0019\u0005]\u0014QNA\u0001\u0002\u0003\u0015\t!a\u0018\u0003\u0007}##\u0007\u0003\u0005\u0002|\u0005\u001d\u0004\u0019AA?\u0003\u0019\t7\r^;bYB\"\u0011qPAB!!\ti$a\u0012\u0002L\u0005\u0005\u0005\u0003BA-\u0003\u0007#A\"!\"\u0002z\u0005\u0005\t\u0011!B\u0001\u0003?\u00121a\u0018\u00134\u0001")
public abstract class PatternTranslatorTestBase {
    private final RowTypeInfo testTableTypeInfo = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO});
    private final RowType testTableRowType = RowType.of((LogicalType[])new LogicalType[]{new IntType()});
    private final String tableName;
    private final Tuple3<RelBuilder, PlannerBase, StreamExecutionEnvironment> context = this.prepareContext((TypeInformation<Row>)this.testTableTypeInfo());
    private final FlinkPlannerImpl calcitePlanner = ((PlannerBase)this.context()._2()).createFlinkPlanner();
    private final CalciteParser parser = ((PlannerBase)this.context()._2()).plannerContext().createCalciteParser();

    private RowTypeInfo testTableTypeInfo() {
        return this.testTableTypeInfo;
    }

    private RowType testTableRowType() {
        return this.testTableRowType;
    }

    private String tableName() {
        return this.tableName;
    }

    private Tuple3<RelBuilder, PlannerBase, StreamExecutionEnvironment> context() {
        return this.context;
    }

    private FlinkPlannerImpl calcitePlanner() {
        return this.calcitePlanner;
    }

    private CalciteParser parser() {
        return this.parser;
    }

    private Tuple3<RelBuilder, PlannerBase, StreamExecutionEnvironment> prepareContext(TypeInformation<Row> typeInfo) {
        org.apache.flink.streaming.api.scala.DataStream dataStreamMock = (org.apache.flink.streaming.api.scala.DataStream)Mockito.mock(org.apache.flink.streaming.api.scala.DataStream.class);
        DataStream jDataStreamMock = (DataStream)Mockito.mock(DataStream.class);
        Mockito.when((Object)dataStreamMock.javaStream()).thenReturn((Object)jDataStreamMock);
        Mockito.when((Object)jDataStreamMock.getType()).thenReturn(typeInfo);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)jDataStreamMock.getId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        TableTestUtil$.MODULE$.createTemporaryView((TableEnvironment)tEnv, this.tableName(), dataStreamMock.javaStream(), (Option<Expression[]>)new Some((Object)new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), TableTestUtil$.MODULE$.createTemporaryView$default$5(), TableTestUtil$.MODULE$.createTemporaryView$default$6());
        PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)tEnv).getPlanner();
        FlinkRelBuilder relBuilder = planner.createRelBuilder();
        relBuilder.scan(new String[]{this.tableName()});
        return new Tuple3((Object)relBuilder, (Object)planner, (Object)env);
    }

    public void verifyPattern(String matchRecognize, Pattern<RowData, ? extends RowData> expected) {
        SqlNode parsed = this.parser().parse(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append("\n                                 |SELECT *\n                                 |FROM ").append(this.tableName()).append("\n                                 |").append(matchRecognize).append("\n                                 |").toString())).stripMargin());
        SqlNode validated = this.calcitePlanner().validate(parsed);
        RelNode converted = this.calcitePlanner().rel((SqlNode)validated).rel;
        PlannerBase plannerBase = (PlannerBase)this.context()._2();
        RelNode optimized = (RelNode)plannerBase.optimize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelNode[]{converted}))).head();
        Object object = !(optimized.getInput(0).getInput(0) instanceof StreamPhysicalDataStreamScan) ? Assertions.fail((String)"Expression is converted into more than a Match operation. Use a different test method.") : BoxedUnit.UNIT;
        StreamPhysicalMatch dataMatch = (StreamPhysicalMatch)optimized;
        Pattern p = (Pattern)CommonExecMatch.translatePattern((MatchSpec)MatchUtil$.MODULE$.createMatchSpec((MatchRecognize)dataMatch.getLogicalMatch()), (ReadableConfig)new Configuration(), (ClassLoader)Thread.currentThread().getContextClassLoader(), (RelBuilder)((RelBuilder)this.context()._1()), (RowType)this.testTableRowType()).f0;
        this.compare(expected, (Pattern<RowData, ? extends RowData>)p);
    }

    private void compare(Pattern<RowData, ? extends RowData> expected, Pattern<RowData, ? extends RowData> actual) {
        Pattern currentLeft = expected;
        Pattern currentRight = actual;
        do {
            boolean sameSkipStrategy;
            String string = currentLeft.getName();
            String string2 = currentRight.getName();
            boolean sameName = !(string != null ? !string.equals(string2) : string2 != null);
            Quantifier quantifier = currentLeft.getQuantifier();
            Quantifier quantifier2 = currentRight.getQuantifier();
            boolean sameQuantifier = !(quantifier != null ? !quantifier.equals(quantifier2) : quantifier2 != null);
            Quantifier.Times times = currentLeft.getTimes();
            Quantifier.Times times2 = currentRight.getTimes();
            boolean sameTimes = !(times != null ? !times.equals(times2) : times2 != null);
            AfterMatchSkipStrategy afterMatchSkipStrategy = currentLeft.getAfterMatchSkipStrategy();
            AfterMatchSkipStrategy afterMatchSkipStrategy2 = currentRight.getAfterMatchSkipStrategy();
            boolean bl = !(afterMatchSkipStrategy != null ? !afterMatchSkipStrategy.equals(afterMatchSkipStrategy2) : afterMatchSkipStrategy2 != null) ? true : (sameSkipStrategy = false);
            boolean sameTimeWindow = currentLeft.getWindowSize().isPresent() && currentRight != null ? ((Duration)currentLeft.getWindowSize().get()).toMillis() == ((Duration)currentRight.getWindowSize().get()).toMillis() : !currentLeft.getWindowSize().isPresent() && !currentRight.getWindowSize().isPresent();
            currentLeft = currentLeft.getPrevious();
            currentRight = currentRight.getPrevious();
            if (!(sameName && sameQuantifier && sameTimes && sameSkipStrategy && sameTimeWindow)) {
                throw new AssertionError((Object)new StringBuilder(48).append("Compiled different pattern. expected: ").append(expected).append(", actual: ").append(actual).toString());
            }
        } while (currentLeft != null);
        if (currentRight != null) {
            throw new AssertionError((Object)new StringBuilder(48).append("Compiled different pattern. expected: ").append(expected).append(", actual: ").append(actual).toString());
        }
    }

    public PatternTranslatorTestBase() {
        this.tableName = "testTable";
    }
}

