/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlTableLike;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.constraint.SqlConstraintEnforcement;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.ddl.constraint.SqlUniqueSpec;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.operations.MergeTableLikeUtil;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MergeTableLikeUtilTest {
    private final FlinkTypeFactory typeFactory = new FlinkTypeFactory(Thread.currentThread().getContextClassLoader(), (RelDataTypeSystem)FlinkTypeSystem.INSTANCE);
    private final SqlValidator sqlValidator = PlannerMocks.create().getPlanner().getOrCreateSqlValidator();
    private final DataTypeFactory dataTypeFactory = new DataTypeFactoryMock();
    private final MergeTableLikeUtil util = new MergeTableLikeUtil(this.sqlValidator, SqlNode::toString, this.dataTypeFactory);

    MergeTableLikeUtilTest() {
    }

    @Test
    void mergePhysicalColumns() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).column("two", (AbstractDataType)DataTypes.STRING()).build();
        List<SqlNode> derivedColumns = Arrays.asList(this.regularColumn("three", DataTypes.INT()), this.regularColumn("four", DataTypes.STRING()));
        Schema mergedSchema = this.util.mergeTables(this.getDefaultMergingStrategies(), sourceSchema, derivedColumns, Collections.emptyList(), null);
        Schema expectedSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).column("two", (AbstractDataType)DataTypes.STRING()).column("three", (AbstractDataType)DataTypes.INT()).column("four", (AbstractDataType)DataTypes.STRING()).build();
        Assertions.assertThat((Object)mergedSchema).isEqualTo((Object)expectedSchema);
    }

    @Test
    void mergeWithIncludeFailsOnDuplicateColumn() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).build();
        List<SqlNode> derivedColumns = Arrays.asList(this.regularColumn("one", DataTypes.INT()), this.regularColumn("four", DataTypes.STRING()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.mergeTables(this.getDefaultMergingStrategies(), sourceSchema, derivedColumns, Collections.emptyList(), null)).isInstanceOf(ValidationException.class)).hasMessage("A column named 'one' already exists in the base table.");
    }

    @Test
    void mergeWithIncludeFailsOnDuplicateRegularColumn() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).build();
        List<SqlNode> derivedColumns = Arrays.asList(this.regularColumn("two", DataTypes.INT()), this.regularColumn("two", DataTypes.INT()), this.regularColumn("four", DataTypes.STRING()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.mergeTables(this.getDefaultMergingStrategies(), sourceSchema, derivedColumns, Collections.emptyList(), null)).isInstanceOf(ValidationException.class)).hasMessage("A regular Column named 'two' already exists in the table.");
    }

    @Test
    void mergeWithIncludeFailsOnDuplicateRegularColumnAndComputeColumn() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).build();
        List<SqlNode> derivedColumns = Arrays.asList(this.regularColumn("two", DataTypes.INT()), this.computedColumn("three", this.plus("two", "3")), this.regularColumn("three", DataTypes.INT()), this.regularColumn("four", DataTypes.STRING()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.mergeTables(this.getDefaultMergingStrategies(), sourceSchema, derivedColumns, Collections.emptyList(), null)).isInstanceOf(ValidationException.class)).hasMessage("A column named 'three' already exists in the table. Duplicate columns exist in the compute column and regular column. ");
    }

    @Test
    void mergeWithIncludeFailsOnDuplicateRegularColumnAndMetadataColumn() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).build();
        List<SqlNode> derivedColumns = Arrays.asList(this.metadataColumn("two", DataTypes.INT(), true), this.computedColumn("three", this.plus("two", "3")), this.regularColumn("two", DataTypes.INT()), this.regularColumn("four", DataTypes.STRING()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.mergeTables(this.getDefaultMergingStrategies(), sourceSchema, derivedColumns, Collections.emptyList(), null)).isInstanceOf(ValidationException.class)).hasMessage("A column named 'two' already exists in the table. Duplicate columns exist in the metadata column and regular column. ");
    }

    @Test
    void mergeGeneratedColumns() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByExpression("two", "one + 1").build();
        List<SqlNode> derivedColumns = Arrays.asList(this.regularColumn("three", DataTypes.INT()), this.computedColumn("four", this.plus("one", "3")));
        Schema mergedSchema = this.util.mergeTables(this.getDefaultMergingStrategies(), sourceSchema, derivedColumns, Collections.emptyList(), null);
        Schema expectedSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByExpression("two", "one + 1").column("three", (AbstractDataType)DataTypes.INT()).columnByExpression("four", "`one` + 3").build();
        Assertions.assertThat((Object)mergedSchema).isEqualTo((Object)expectedSchema);
    }

    @Test
    void mergeMetadataColumns() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByMetadata("two", (AbstractDataType)DataTypes.INT(), false).columnByExpression("c", "ABS(two)").build();
        List<SqlNode> derivedColumns = Arrays.asList(this.regularColumn("three", DataTypes.INT()), this.metadataColumn("four", DataTypes.INT(), true));
        Schema mergedSchema = this.util.mergeTables(this.getDefaultMergingStrategies(), sourceSchema, derivedColumns, Collections.emptyList(), null);
        Schema expectedSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByMetadata("two", (AbstractDataType)DataTypes.INT(), false).columnByExpression("c", "ABS(two)").column("three", (AbstractDataType)DataTypes.INT()).columnByMetadata("four", (AbstractDataType)DataTypes.INT(), true).build();
        Assertions.assertThat((Object)mergedSchema).isEqualTo((Object)expectedSchema);
    }

    @Test
    void mergeIncludingGeneratedColumnsFailsOnDuplicate() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByExpression("two", "one + 1").build();
        List<SqlNode> derivedColumns = Collections.singletonList(this.computedColumn("two", this.plus("one", "3")));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.mergeTables(this.getDefaultMergingStrategies(), sourceSchema, derivedColumns, Collections.emptyList(), null)).isInstanceOf(ValidationException.class)).hasMessage("A generated column named 'two' already exists in the base table. You might want to specify EXCLUDING GENERATED or OVERWRITING GENERATED.");
    }

    @Test
    void mergeIncludingMetadataColumnsFailsOnDuplicate() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByMetadata("two", (AbstractDataType)DataTypes.INT()).build();
        List<SqlNode> derivedColumns = Collections.singletonList(this.metadataColumn("two", DataTypes.INT(), false));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.mergeTables(this.getDefaultMergingStrategies(), sourceSchema, derivedColumns, Collections.emptyList(), null)).isInstanceOf(ValidationException.class)).hasMessage("A metadata column named 'two' already exists in the base table. You might want to specify EXCLUDING METADATA or OVERWRITING METADATA.");
    }

    @Test
    void mergeExcludingGeneratedColumnsDuplicate() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByExpression("two", "one + 1").build();
        List<SqlNode> derivedColumns = Collections.singletonList(this.computedColumn("two", this.plus("one", "3")));
        Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies = this.getDefaultMergingStrategies();
        mergingStrategies.put(SqlTableLike.FeatureOption.GENERATED, SqlTableLike.MergingStrategy.EXCLUDING);
        Schema mergedSchema = this.util.mergeTables(mergingStrategies, sourceSchema, derivedColumns, Collections.emptyList(), null);
        Schema expectedSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByExpression("two", "`one` + 3").build();
        Assertions.assertThat((Object)mergedSchema).isEqualTo((Object)expectedSchema);
    }

    @Test
    void mergeExcludingMetadataColumnsDuplicate() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByMetadata("two", (AbstractDataType)DataTypes.INT()).build();
        List<SqlNode> derivedColumns = Collections.singletonList(this.metadataColumn("two", DataTypes.BOOLEAN(), false));
        Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies = this.getDefaultMergingStrategies();
        mergingStrategies.put(SqlTableLike.FeatureOption.METADATA, SqlTableLike.MergingStrategy.EXCLUDING);
        Schema mergedSchema = this.util.mergeTables(mergingStrategies, sourceSchema, derivedColumns, Collections.emptyList(), null);
        Schema expectedSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByMetadata("two", (AbstractDataType)DataTypes.BOOLEAN()).build();
        Assertions.assertThat((Object)mergedSchema).isEqualTo((Object)expectedSchema);
    }

    @Test
    void mergeOverwritingGeneratedColumnsDuplicate() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByExpression("two", "one + 1").build();
        List<SqlNode> derivedColumns = Collections.singletonList(this.computedColumn("two", this.plus("one", "3")));
        Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies = this.getDefaultMergingStrategies();
        mergingStrategies.put(SqlTableLike.FeatureOption.GENERATED, SqlTableLike.MergingStrategy.OVERWRITING);
        Schema mergedSchema = this.util.mergeTables(mergingStrategies, sourceSchema, derivedColumns, Collections.emptyList(), null);
        Schema expectedSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByExpression("two", "`one` + 3").build();
        Assertions.assertThat((Object)mergedSchema).isEqualTo((Object)expectedSchema);
    }

    @Test
    void mergeOverwritingMetadataColumnsDuplicate() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByMetadata("two", (AbstractDataType)DataTypes.INT()).build();
        List<SqlNode> derivedColumns = Collections.singletonList(this.metadataColumn("two", DataTypes.BOOLEAN(), true));
        Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies = this.getDefaultMergingStrategies();
        mergingStrategies.put(SqlTableLike.FeatureOption.METADATA, SqlTableLike.MergingStrategy.OVERWRITING);
        Schema mergedSchema = this.util.mergeTables(mergingStrategies, sourceSchema, derivedColumns, Collections.emptyList(), null);
        Schema expectedSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByMetadata("two", (AbstractDataType)DataTypes.BOOLEAN(), true).build();
        Assertions.assertThat((Object)mergedSchema).isEqualTo((Object)expectedSchema);
    }

    @Test
    void mergeOverwritingPhysicalColumnWithGeneratedColumn() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).column("two", (AbstractDataType)DataTypes.INT()).build();
        List<SqlNode> derivedColumns = Collections.singletonList(this.computedColumn("two", this.plus("one", "3")));
        Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies = this.getDefaultMergingStrategies();
        mergingStrategies.put(SqlTableLike.FeatureOption.GENERATED, SqlTableLike.MergingStrategy.OVERWRITING);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.mergeTables(mergingStrategies, sourceSchema, derivedColumns, Collections.emptyList(), null)).isInstanceOf(ValidationException.class)).hasMessage("A column named 'two' already exists in the table. Duplicate columns exist in the compute column and regular column. ");
    }

    @Test
    void mergeOverwritingComputedColumnWithMetadataColumn() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByExpression("two", "one + 3").build();
        List<SqlNode> derivedColumns = Collections.singletonList(this.metadataColumn("two", DataTypes.BOOLEAN(), false));
        Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies = this.getDefaultMergingStrategies();
        mergingStrategies.put(SqlTableLike.FeatureOption.METADATA, SqlTableLike.MergingStrategy.OVERWRITING);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.mergeTables(mergingStrategies, sourceSchema, derivedColumns, Collections.emptyList(), null)).isInstanceOf(ValidationException.class)).hasMessage("A column named 'two' already exists in the base table. Metadata columns can only overwrite other metadata columns.");
    }

    @Test
    void mergeWatermarks() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByExpression("two", "one +1").column("timestamp", (AbstractDataType)DataTypes.TIMESTAMP()).watermark("timestamp", "timestamp - INTERVAL '5' SECOND").build();
        List<SqlNode> derivedColumns = Arrays.asList(this.regularColumn("three", DataTypes.INT()), this.computedColumn("four", this.plus("one", "3")));
        Schema mergedSchema = this.util.mergeTables(this.getDefaultMergingStrategies(), sourceSchema, derivedColumns, Collections.emptyList(), null);
        Schema expectedSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).columnByExpression("two", "one +1").column("timestamp", (AbstractDataType)DataTypes.TIMESTAMP()).watermark("timestamp", "timestamp - INTERVAL '5' SECOND").column("three", (AbstractDataType)DataTypes.INT()).columnByExpression("four", "`one` + 3").build();
        Assertions.assertThat((Object)mergedSchema).isEqualTo((Object)expectedSchema);
    }

    @Test
    void mergeIncludingWatermarksFailsOnDuplicate() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).column("timestamp", (AbstractDataType)DataTypes.TIMESTAMP()).watermark("timestamp", "timestamp - INTERVAL '5' SECOND").build();
        List<SqlWatermark> derivedWatermarkSpecs = Collections.singletonList(new SqlWatermark(SqlParserPos.ZERO, this.identifier("timestamp"), this.boundedStrategy("timestamp", "10")));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.mergeTables(this.getDefaultMergingStrategies(), sourceSchema, Collections.emptyList(), derivedWatermarkSpecs, null)).isInstanceOf(ValidationException.class)).hasMessage("There already exists a watermark spec for column 'timestamp' in the base table. You might want to specify EXCLUDING WATERMARKS or OVERWRITING WATERMARKS.");
    }

    @Test
    void mergeExcludingWatermarksDuplicate() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).column("timestamp", (AbstractDataType)DataTypes.TIMESTAMP()).watermark("timestamp", "timestamp - INTERVAL '5' SECOND").build();
        List<SqlWatermark> derivedWatermarkSpecs = Collections.singletonList(new SqlWatermark(SqlParserPos.ZERO, this.identifier("timestamp"), this.boundedStrategy("timestamp", "10")));
        Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies = this.getDefaultMergingStrategies();
        mergingStrategies.put(SqlTableLike.FeatureOption.WATERMARKS, SqlTableLike.MergingStrategy.EXCLUDING);
        Schema mergedSchema = this.util.mergeTables(mergingStrategies, sourceSchema, Collections.emptyList(), derivedWatermarkSpecs, null);
        Schema expectedSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).column("timestamp", (AbstractDataType)DataTypes.TIMESTAMP()).watermark("timestamp", "`timestamp` - INTERVAL '10' SECOND").build();
        Assertions.assertThat((Object)mergedSchema).isEqualTo((Object)expectedSchema);
    }

    @Test
    void mergeOverwritingWatermarksDuplicate() {
        Schema sourceSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).column("timestamp", (AbstractDataType)DataTypes.TIMESTAMP()).watermark("timestamp", "timestamp - INTERVAL '5' SECOND").build();
        List<SqlWatermark> derivedWatermarkSpecs = Collections.singletonList(new SqlWatermark(SqlParserPos.ZERO, this.identifier("timestamp"), this.boundedStrategy("timestamp", "10")));
        Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies = this.getDefaultMergingStrategies();
        mergingStrategies.put(SqlTableLike.FeatureOption.WATERMARKS, SqlTableLike.MergingStrategy.OVERWRITING);
        Schema mergedSchema = this.util.mergeTables(mergingStrategies, sourceSchema, Collections.emptyList(), derivedWatermarkSpecs, null);
        Schema expectedSchema = Schema.newBuilder().column("one", (AbstractDataType)DataTypes.INT()).column("timestamp", (AbstractDataType)DataTypes.TIMESTAMP()).watermark("timestamp", "`timestamp` - INTERVAL '10' SECOND").build();
        Assertions.assertThat((Object)mergedSchema).isEqualTo((Object)expectedSchema);
    }

    @Test
    void mergeConstraintsFromBaseTable() {
        Schema sourceSchema = Schema.newBuilder().column("one", DataTypes.INT().notNull()).column("two", DataTypes.STRING().notNull()).column("three", (AbstractDataType)DataTypes.FLOAT()).primaryKeyNamed("constraint-42", new String[]{"one", "two"}).build();
        Schema mergedSchema = this.util.mergeTables(this.getDefaultMergingStrategies(), sourceSchema, Collections.emptyList(), Collections.emptyList(), null);
        Schema expectedSchema = Schema.newBuilder().column("one", DataTypes.INT().notNull()).column("two", DataTypes.STRING().notNull()).column("three", (AbstractDataType)DataTypes.FLOAT()).primaryKeyNamed("constraint-42", new String[]{"one", "two"}).build();
        Assertions.assertThat((Object)mergedSchema).isEqualTo((Object)expectedSchema);
    }

    @Test
    void mergeConstraintsFromDerivedTable() {
        Schema sourceSchema = Schema.newBuilder().column("one", DataTypes.INT().notNull()).column("two", DataTypes.STRING().notNull()).column("three", (AbstractDataType)DataTypes.FLOAT()).build();
        Schema mergedSchema = this.util.mergeTables(this.getDefaultMergingStrategies(), sourceSchema, Collections.emptyList(), Collections.emptyList(), this.primaryKey("one", "two"));
        Schema expectedSchema = Schema.newBuilder().column("one", DataTypes.INT().notNull()).column("two", DataTypes.STRING().notNull()).column("three", (AbstractDataType)DataTypes.FLOAT()).primaryKeyNamed("PK_one_two", new String[]{"one", "two"}).build();
        Assertions.assertThat((Object)mergedSchema).isEqualTo((Object)expectedSchema);
    }

    @Test
    void mergeIncludingConstraintsFailsOnDuplicate() {
        Schema sourceSchema = Schema.newBuilder().column("one", DataTypes.INT().notNull()).column("two", DataTypes.STRING().notNull()).column("three", (AbstractDataType)DataTypes.FLOAT()).primaryKeyNamed("constraint-42", new String[]{"one", "two"}).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.mergeTables(this.getDefaultMergingStrategies(), sourceSchema, Collections.emptyList(), Collections.emptyList(), this.primaryKey("one", "two"))).isInstanceOf(ValidationException.class)).hasMessage("The base table already has a primary key. You might want to specify EXCLUDING CONSTRAINTS.");
    }

    @Test
    void mergeExcludingConstraintsOnDuplicate() {
        Schema sourceSchema = Schema.newBuilder().column("one", DataTypes.INT().notNull()).column("two", DataTypes.STRING().notNull()).column("three", (AbstractDataType)DataTypes.FLOAT()).primaryKeyNamed("constraint-42", new String[]{"one", "two", "three"}).build();
        Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies = this.getDefaultMergingStrategies();
        mergingStrategies.put(SqlTableLike.FeatureOption.CONSTRAINTS, SqlTableLike.MergingStrategy.EXCLUDING);
        Schema mergedSchema = this.util.mergeTables(mergingStrategies, sourceSchema, Collections.emptyList(), Collections.emptyList(), this.primaryKey("one", "two"));
        Schema expectedSchema = Schema.newBuilder().column("one", DataTypes.INT().notNull()).column("two", DataTypes.STRING().notNull()).column("three", (AbstractDataType)DataTypes.FLOAT()).primaryKeyNamed("PK_one_two", new String[]{"one", "two"}).build();
        Assertions.assertThat((Object)mergedSchema).isEqualTo((Object)expectedSchema);
    }

    @Test
    void mergePartitionsFromBaseTable() {
        List<String> sourcePartitions = Arrays.asList("col1", "col2");
        List mergePartitions = this.util.mergePartitions(this.getDefaultMergingStrategies().get(SqlTableLike.FeatureOption.PARTITIONS), sourcePartitions, Collections.emptyList());
        Assertions.assertThat((List)mergePartitions).isEqualTo(sourcePartitions);
    }

    @Test
    void mergePartitionsFromDerivedTable() {
        List<String> derivedPartitions = Arrays.asList("col1", "col2");
        List mergePartitions = this.util.mergePartitions(this.getDefaultMergingStrategies().get(SqlTableLike.FeatureOption.PARTITIONS), Collections.emptyList(), derivedPartitions);
        Assertions.assertThat((List)mergePartitions).isEqualTo(derivedPartitions);
    }

    @Test
    void mergeIncludingPartitionsFailsOnDuplicate() {
        List<String> sourcePartitions = Arrays.asList("col3", "col4");
        List<String> derivedPartitions = Arrays.asList("col1", "col2");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.mergePartitions(SqlTableLike.MergingStrategy.INCLUDING, sourcePartitions, derivedPartitions)).isInstanceOf(ValidationException.class)).hasMessage("The base table already has partitions defined. You might want to specify EXCLUDING PARTITIONS.");
    }

    @Test
    void mergeExcludingPartitionsOnDuplicate() {
        List<String> sourcePartitions = Arrays.asList("col3", "col4");
        List<String> derivedPartitions = Arrays.asList("col1", "col2");
        List mergedPartitions = this.util.mergePartitions(SqlTableLike.MergingStrategy.EXCLUDING, sourcePartitions, derivedPartitions);
        Assertions.assertThat((List)mergedPartitions).isEqualTo(derivedPartitions);
    }

    @Test
    void mergeOptions() {
        HashMap<String, String> sourceOptions = new HashMap<String, String>();
        sourceOptions.put("offset", "1");
        sourceOptions.put("format", "json");
        HashMap<String, String> derivedOptions = new HashMap<String, String>();
        derivedOptions.put("format.ignore-errors", "true");
        Map mergedOptions = this.util.mergeOptions(this.getDefaultMergingStrategies().get(SqlTableLike.FeatureOption.OPTIONS), sourceOptions, derivedOptions);
        HashMap<String, String> expectedOptions = new HashMap<String, String>();
        expectedOptions.put("offset", "1");
        expectedOptions.put("format", "json");
        expectedOptions.put("format.ignore-errors", "true");
        Assertions.assertThat((Map)mergedOptions).isEqualTo(expectedOptions);
    }

    @Test
    void mergeIncludingOptionsFailsOnDuplicate() {
        HashMap<String, String> sourceOptions = new HashMap<String, String>();
        sourceOptions.put("offset", "1");
        HashMap<String, String> derivedOptions = new HashMap<String, String>();
        derivedOptions.put("offset", "2");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.util.mergeOptions(SqlTableLike.MergingStrategy.INCLUDING, sourceOptions, derivedOptions)).isInstanceOf(ValidationException.class)).hasMessage("There already exists an option ['offset' -> '1']  in the base table. You might want to specify EXCLUDING OPTIONS or OVERWRITING OPTIONS.");
    }

    @Test
    void mergeExcludingOptionsDuplicate() {
        HashMap<String, String> sourceOptions = new HashMap<String, String>();
        sourceOptions.put("offset", "1");
        sourceOptions.put("format", "json");
        HashMap<String, String> derivedOptions = new HashMap<String, String>();
        derivedOptions.put("format", "csv");
        derivedOptions.put("format.ignore-errors", "true");
        Map mergedOptions = this.util.mergeOptions(SqlTableLike.MergingStrategy.EXCLUDING, sourceOptions, derivedOptions);
        HashMap<String, String> expectedOptions = new HashMap<String, String>();
        expectedOptions.put("format", "csv");
        expectedOptions.put("format.ignore-errors", "true");
        Assertions.assertThat((Map)mergedOptions).isEqualTo(expectedOptions);
    }

    @Test
    void mergeOverwritingOptionsDuplicate() {
        HashMap<String, String> sourceOptions = new HashMap<String, String>();
        sourceOptions.put("offset", "1");
        sourceOptions.put("format", "json");
        HashMap<String, String> derivedOptions = new HashMap<String, String>();
        derivedOptions.put("offset", "2");
        derivedOptions.put("format.ignore-errors", "true");
        Map mergedOptions = this.util.mergeOptions(SqlTableLike.MergingStrategy.OVERWRITING, sourceOptions, derivedOptions);
        HashMap<String, String> expectedOptions = new HashMap<String, String>();
        expectedOptions.put("offset", "2");
        expectedOptions.put("format", "json");
        expectedOptions.put("format.ignore-errors", "true");
        Assertions.assertThat((Map)mergedOptions).isEqualTo(expectedOptions);
    }

    @Test
    void defaultMergeStrategies() {
        Map mergingStrategies = this.util.computeMergingStrategies(Collections.emptyList());
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.OPTIONS))).isEqualTo((Object)SqlTableLike.MergingStrategy.OVERWRITING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.PARTITIONS))).isEqualTo((Object)SqlTableLike.MergingStrategy.INCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.CONSTRAINTS))).isEqualTo((Object)SqlTableLike.MergingStrategy.INCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.GENERATED))).isEqualTo((Object)SqlTableLike.MergingStrategy.INCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.WATERMARKS))).isEqualTo((Object)SqlTableLike.MergingStrategy.INCLUDING);
    }

    @Test
    void includingAllMergeStrategyExpansion() {
        List<SqlTableLike.SqlTableLikeOption> inputOptions = Collections.singletonList(new SqlTableLike.SqlTableLikeOption(SqlTableLike.MergingStrategy.INCLUDING, SqlTableLike.FeatureOption.ALL));
        Map mergingStrategies = this.util.computeMergingStrategies(inputOptions);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.OPTIONS))).isEqualTo((Object)SqlTableLike.MergingStrategy.INCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.PARTITIONS))).isEqualTo((Object)SqlTableLike.MergingStrategy.INCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.CONSTRAINTS))).isEqualTo((Object)SqlTableLike.MergingStrategy.INCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.GENERATED))).isEqualTo((Object)SqlTableLike.MergingStrategy.INCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.WATERMARKS))).isEqualTo((Object)SqlTableLike.MergingStrategy.INCLUDING);
    }

    @Test
    void excludingAllMergeStrategyExpansion() {
        List<SqlTableLike.SqlTableLikeOption> inputOptions = Collections.singletonList(new SqlTableLike.SqlTableLikeOption(SqlTableLike.MergingStrategy.EXCLUDING, SqlTableLike.FeatureOption.ALL));
        Map mergingStrategies = this.util.computeMergingStrategies(inputOptions);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.OPTIONS))).isEqualTo((Object)SqlTableLike.MergingStrategy.EXCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.PARTITIONS))).isEqualTo((Object)SqlTableLike.MergingStrategy.EXCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.CONSTRAINTS))).isEqualTo((Object)SqlTableLike.MergingStrategy.EXCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.GENERATED))).isEqualTo((Object)SqlTableLike.MergingStrategy.EXCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.WATERMARKS))).isEqualTo((Object)SqlTableLike.MergingStrategy.EXCLUDING);
    }

    @Test
    void includingAllOverwriteOptionsMergeStrategyExpansion() {
        List<SqlTableLike.SqlTableLikeOption> inputOptions = Arrays.asList(new SqlTableLike.SqlTableLikeOption(SqlTableLike.MergingStrategy.EXCLUDING, SqlTableLike.FeatureOption.ALL), new SqlTableLike.SqlTableLikeOption(SqlTableLike.MergingStrategy.INCLUDING, SqlTableLike.FeatureOption.CONSTRAINTS));
        Map mergingStrategies = this.util.computeMergingStrategies(inputOptions);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.OPTIONS))).isEqualTo((Object)SqlTableLike.MergingStrategy.EXCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.PARTITIONS))).isEqualTo((Object)SqlTableLike.MergingStrategy.EXCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.CONSTRAINTS))).isEqualTo((Object)SqlTableLike.MergingStrategy.INCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.GENERATED))).isEqualTo((Object)SqlTableLike.MergingStrategy.EXCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.METADATA))).isEqualTo((Object)SqlTableLike.MergingStrategy.EXCLUDING);
        Assertions.assertThat((Comparable)((Comparable)mergingStrategies.get(SqlTableLike.FeatureOption.WATERMARKS))).isEqualTo((Object)SqlTableLike.MergingStrategy.EXCLUDING);
    }

    private Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> getDefaultMergingStrategies() {
        return this.util.computeMergingStrategies(Collections.emptyList());
    }

    private SqlNode regularColumn(String name, DataType type) {
        LogicalType logicalType = type.getLogicalType();
        return new SqlTableColumn.SqlRegularColumn(SqlParserPos.ZERO, this.identifier(name), null, SqlTypeUtil.convertTypeToSpec((RelDataType)this.typeFactory.createFieldTypeFromLogicalType(logicalType)).withNullable(Boolean.valueOf(logicalType.isNullable())), null);
    }

    private SqlNode computedColumn(String name, SqlNode expression) {
        return new SqlTableColumn.SqlComputedColumn(SqlParserPos.ZERO, this.identifier(name), null, expression);
    }

    private SqlNode metadataColumn(String name, DataType type, boolean isVirtual) {
        LogicalType logicalType = type.getLogicalType();
        return new SqlTableColumn.SqlMetadataColumn(SqlParserPos.ZERO, this.identifier(name), null, SqlTypeUtil.convertTypeToSpec((RelDataType)this.typeFactory.createFieldTypeFromLogicalType(logicalType)).withNullable(Boolean.valueOf(logicalType.isNullable())), null, isVirtual);
    }

    private SqlNode plus(String column, String value) {
        return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.PLUS, new SqlNode[]{this.identifier(column), SqlLiteral.createExactNumeric((String)value, (SqlParserPos)SqlParserPos.ZERO)}, SqlParserPos.ZERO);
    }

    private SqlNode boundedStrategy(String rowtimeColumn, String delay) {
        return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.MINUS, new SqlNode[]{this.identifier(rowtimeColumn), SqlLiteral.createInterval((int)1, (String)delay, (SqlIntervalQualifier)new SqlIntervalQualifier(TimeUnit.SECOND, TimeUnit.SECOND, SqlParserPos.ZERO), (SqlParserPos)SqlParserPos.ZERO)}, SqlParserPos.ZERO);
    }

    private SqlIdentifier identifier(String name) {
        return new SqlIdentifier(name, SqlParserPos.ZERO);
    }

    private SqlTableConstraint primaryKey(String ... columns) {
        return new SqlTableConstraint(null, SqlUniqueSpec.PRIMARY_KEY.symbol(SqlParserPos.ZERO), new SqlNodeList((Collection)Arrays.stream(columns).map(this::identifier).collect(Collectors.toList()), SqlParserPos.ZERO), SqlConstraintEnforcement.ENFORCED.symbol(SqlParserPos.ZERO), true, SqlParserPos.ZERO);
    }
}

