/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.annotation.ProcedureHints;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.ProcedureNotExistException;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.operations.PlannerCallProcedureOperation;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversionTestBase;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.flink.table.procedures.Procedure;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SqlNodeToCallOperationTest
extends SqlNodeToOperationConversionTestBase {
    @Override
    @BeforeEach
    public void before() {
        CatalogWithBuiltInProcedure procedureCatalog = new CatalogWithBuiltInProcedure("procedure_catalog");
        this.catalogManager.registerCatalog("p1", (Catalog)procedureCatalog);
        this.catalogManager.setCurrentCatalog("p1");
    }

    @Test
    void testWithNamedArguments() {
        String sql = "call `system`.named_args(d=>'1',c=>'2')";
        this.verifyCallOperation(sql, "CALL PROCEDURE: (procedureIdentifier: [`p1`.`system`.`named_args`], inputTypes: [STRING, STRING], outputTypes: [INT], arguments: [2, 1])");
    }

    @Test
    void testCallStatement() {
        String sql = "call `system`.primitive_arg(1, 2)";
        this.verifyCallOperation(sql, "CALL PROCEDURE: (procedureIdentifier: [`p1`.`system`.`primitive_arg`], inputTypes: [INT NOT NULL, BIGINT NOT NULL], outputTypes: [INT NOT NULL], arguments: [1, 2])");
        sql = "call `system`.different_type_mapping(1)";
        this.verifyCallOperation(sql, "CALL PROCEDURE: (procedureIdentifier: [`p1`.`system`.`different_type_mapping`], inputTypes: [INT], outputTypes: [INT], arguments: [1])");
        sql = "call `system`.different_type_mapping(cast(1 as bigint))";
        this.verifyCallOperation(sql, "CALL PROCEDURE: (procedureIdentifier: [`p1`.`system`.`different_type_mapping`], inputTypes: [BIGINT], outputTypes: [BIGINT], arguments: [1])");
        sql = "call `system`.var_arg(1)";
        this.verifyCallOperation(sql, "CALL PROCEDURE: (procedureIdentifier: [`p1`.`system`.`var_arg`], inputTypes: [INT NOT NULL], outputTypes: [STRING], arguments: [1])");
        sql = "call `system`.var_arg(1, 2)";
        this.verifyCallOperation(sql, "CALL PROCEDURE: (procedureIdentifier: [`p1`.`system`.`var_arg`], inputTypes: [INT NOT NULL, INT NOT NULL], outputTypes: [STRING], arguments: [1, 2])");
        sql = "call `system`.var_arg(1, 2, 1 + 2)";
        this.verifyCallOperation(sql, "CALL PROCEDURE: (procedureIdentifier: [`p1`.`system`.`var_arg`], inputTypes: [INT NOT NULL, INT NOT NULL, INT NOT NULL], outputTypes: [STRING], arguments: [1, 2, 3])");
        sql = "call `system`.row_result(cast(1.2 as decimal))";
        this.verifyCallOperation(sql, "CALL PROCEDURE: (procedureIdentifier: [`p1`.`system`.`row_result`], inputTypes: [DECIMAL(10, 2)], outputTypes: [ROW<`i` INT>], arguments: [1.20])");
        sql = "call `system`.row_result(1.2)";
        this.verifyCallOperation(sql, "CALL PROCEDURE: (procedureIdentifier: [`p1`.`system`.`row_result`], inputTypes: [DECIMAL(10, 2)], outputTypes: [ROW<`i` INT>], arguments: [1.20])");
        sql = "call p1.`system`.pojo_result('name', 1)";
        this.verifyCallOperation(sql, "CALL PROCEDURE: (procedureIdentifier: [`p1`.`system`.`pojo_result`], inputTypes: [STRING, BIGINT NOT NULL], outputTypes: [*org.apache.flink.table.planner.operations.SqlNodeToCallOperationTest$MyPojo<`name` STRING, `id` BIGINT NOT NULL>*], arguments: [name, 1])");
        sql = "call p1.`system`.timestamp_arg(timestamp '2023-04-22 00:00:00.300', timestamp '2023-04-22 00:00:00.300' +  INTERVAL '1' day ) ";
        this.verifyCallOperation(sql, String.format("CALL PROCEDURE: (procedureIdentifier: [`p1`.`system`.`timestamp_arg`], inputTypes: [TIMESTAMP(3), TIMESTAMP(3)], outputTypes: [TIMESTAMP(3)], arguments: [%s, %s])", LocalDateTime.parse("2023-04-22T00:00:00.300"), LocalDateTime.parse("2023-04-23T00:00:00.300")));
        Assertions.assertThatThrownBy(() -> this.parse("call `system`.primitive_arg(1)")).hasMessageContaining("No match found for function signature primitive_arg(<NUMERIC>)");
        Assertions.assertThatThrownBy(() -> this.parse("call `system`.row_result(cast((1.2 + 2.4) as decimal))")).hasMessageContaining("The argument at position 0 CAST(CAST(1.2 + 2.4 AS DECIMAL) AS DECIMAL(10, 2)) for calling procedure can't be converted to literal.");
    }

    private void verifyCallOperation(String sql, String expectSummary) {
        Operation operation = this.parse(sql);
        Assertions.assertThat((Object)operation).isInstanceOf(PlannerCallProcedureOperation.class);
        Assertions.assertThat((String)this.parse(sql).asSummaryString()).isEqualTo(expectSummary);
    }

    public static class MyPojo {
        private final String name;
        private final long id;

        public MyPojo(String name, long id) {
            this.name = name;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }
    }

    private static class TimeStampArgProcedure
    implements Procedure {
        private TimeStampArgProcedure() {
        }

        @DataTypeHint(value="TIMESTAMP(3)")
        public LocalDateTime[] call(ProcedureContext procedureContext, @DataTypeHint(value="TIMESTAMP(3)") LocalDateTime localDateTime, @DataTypeHint(value="TIMESTAMP(3)") TimestampData timestampData) {
            return null;
        }
    }

    private static class PojoResultProcedure
    implements Procedure {
        private PojoResultProcedure() {
        }

        public MyPojo[] call(ProcedureContext procedureContext, String name, long id) {
            return new MyPojo[0];
        }
    }

    private static class RowResultProcedure
    implements Procedure {
        private RowResultProcedure() {
        }

        @DataTypeHint(value="ROW<i INT>")
        public Row[] call(ProcedureContext procedureContext, @DataTypeHint(value="DECIMAL(10, 2)") BigDecimal decimal) {
            return null;
        }
    }

    private static class VarArgProcedure
    implements Procedure {
        private VarArgProcedure() {
        }

        public String[] call(ProcedureContext procedureContext, int i, int ... more) {
            return null;
        }
    }

    @ProcedureHints(value={@ProcedureHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT")), @ProcedureHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT"))})
    private static class DifferentTypeMappingProcedure
    implements Procedure {
        private DifferentTypeMappingProcedure() {
        }

        public Number[] call(ProcedureContext procedureContext, Number n) {
            return null;
        }
    }

    private static class ProcedureWithNamedArguments
    implements Procedure {
        private ProcedureWithNamedArguments() {
        }

        @ProcedureHint(input={@DataTypeHint(value="STRING"), @DataTypeHint(value="STRING")}, output=@DataTypeHint(value="INT"), argumentNames={"c", "d"})
        public int[] call(ProcedureContext context, String arg3, String arg4) {
            return null;
        }
    }

    private static class ProcedureWithPrimitiveArg
    implements Procedure {
        private ProcedureWithPrimitiveArg() {
        }

        public int[] call(ProcedureContext context, int arg1, long arg2) {
            return null;
        }
    }

    private static class CatalogWithBuiltInProcedure
    extends GenericInMemoryCatalog {
        private static final Map<ObjectPath, Procedure> PROCEDURE_MAP = new HashMap<ObjectPath, Procedure>();

        public CatalogWithBuiltInProcedure(String name) {
            super(name);
        }

        public Procedure getProcedure(ObjectPath procedurePath) throws ProcedureNotExistException, CatalogException {
            if (PROCEDURE_MAP.containsKey(procedurePath)) {
                return PROCEDURE_MAP.get(procedurePath);
            }
            throw new ProcedureNotExistException(this.getName(), procedurePath);
        }

        static {
            PROCEDURE_MAP.put(ObjectPath.fromString((String)"system.primitive_arg"), new ProcedureWithPrimitiveArg());
            PROCEDURE_MAP.put(ObjectPath.fromString((String)"system.different_type_mapping"), new DifferentTypeMappingProcedure());
            PROCEDURE_MAP.put(ObjectPath.fromString((String)"system.var_arg"), new VarArgProcedure());
            PROCEDURE_MAP.put(ObjectPath.fromString((String)"system.row_result"), new RowResultProcedure());
            PROCEDURE_MAP.put(ObjectPath.fromString((String)"system.pojo_result"), new PojoResultProcedure());
            PROCEDURE_MAP.put(ObjectPath.fromString((String)"system.timestamp_arg"), new TimeStampArgProcedure());
            PROCEDURE_MAP.put(ObjectPath.fromString((String)"system.named_args"), new ProcedureWithNamedArguments());
        }
    }
}

