/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.function.Supplier;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.delegation.ParserImpl;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversion;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.apache.flink.table.utils.ExpressionResolverMocks;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public class SqlNodeToOperationConversionTestBase {
    private final boolean isStreamingMode = false;
    private final TableConfig tableConfig = TableConfig.getDefault();
    protected final Catalog catalog = new GenericInMemoryCatalog("MockCatalog", "default");
    protected final CatalogManager catalogManager = CatalogManagerMocks.preparedCatalogManager().defaultCatalog("builtin", this.catalog).config((ReadableConfig)Configuration.fromMap(Collections.singletonMap(ExecutionOptions.RUNTIME_MODE.key(), RuntimeExecutionMode.BATCH.name()))).build();
    private final PlannerMocks plannerMocks = PlannerMocks.newBuilder().withBatchMode(true).withTableConfig(this.tableConfig).withCatalogManager(this.catalogManager).withRootSchema(CalciteSchemaBuilder.asRootSchema((org.apache.calcite.schema.Schema)new CatalogManagerCalciteSchema(this.catalogManager, false))).build();
    private final PlannerContext plannerContext = this.plannerMocks.getPlannerContext();
    protected final FunctionCatalog functionCatalog = this.plannerMocks.getFunctionCatalog();
    private final Supplier<FlinkPlannerImpl> plannerSupplier = () -> ((PlannerContext)this.plannerContext).createFlinkPlanner();
    protected final Parser parser = new ParserImpl(this.catalogManager, this.plannerSupplier, () -> this.plannerSupplier.get().parser(), this.plannerContext.getRexFactory());

    @BeforeEach
    public void before() throws TableAlreadyExistException, DatabaseNotExistException {
        this.catalogManager.initSchemaResolver(false, ExpressionResolverMocks.basicResolver((CatalogManager)this.catalogManager, (FunctionCatalog)this.functionCatalog, (Parser)this.parser));
        ObjectPath path1 = new ObjectPath(this.catalogManager.getCurrentDatabase(), "t1");
        ObjectPath path2 = new ObjectPath(this.catalogManager.getCurrentDatabase(), "t2");
        Schema tableSchema = Schema.newBuilder().fromResolvedSchema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)DataTypes.BIGINT()), Column.physical((String)"b", (DataType)DataTypes.VARCHAR((int)Integer.MAX_VALUE)), Column.physical((String)"c", (DataType)DataTypes.INT()), Column.physical((String)"d", (DataType)DataTypes.VARCHAR((int)Integer.MAX_VALUE))})).build();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "COLLECTION");
        CatalogTable catalogTable = CatalogTable.of((Schema)tableSchema, (String)"", Collections.emptyList(), options);
        this.catalog.createTable(path1, (CatalogBaseTable)catalogTable, true);
        this.catalog.createTable(path2, (CatalogBaseTable)catalogTable, true);
    }

    @AfterEach
    public void after() throws TableNotExistException {
        ObjectPath path1 = new ObjectPath(this.catalogManager.getCurrentDatabase(), "t1");
        ObjectPath path2 = new ObjectPath(this.catalogManager.getCurrentDatabase(), "t2");
        this.catalog.dropTable(path1, true);
        this.catalog.dropTable(path2, true);
    }

    protected Operation parse(String sql, FlinkPlannerImpl planner, CalciteParser parser) {
        SqlNode node = parser.parse(sql);
        return (Operation)SqlNodeToOperationConversion.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
    }

    protected Operation parse(String sql) {
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        SqlNode node = parser.parse(sql);
        return (Operation)SqlNodeToOperationConversion.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
    }

    protected FlinkPlannerImpl getPlannerBySqlDialect(SqlDialect sqlDialect) {
        this.tableConfig.setSqlDialect(sqlDialect);
        return this.plannerContext.createFlinkPlanner();
    }

    protected CalciteParser getParserBySqlDialect(SqlDialect sqlDialect) {
        this.tableConfig.setSqlDialect(sqlDialect);
        return this.plannerContext.createCalciteParser();
    }
}

