/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.operations.LoadModuleOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ShowDatabasesOperation;
import org.apache.flink.table.operations.ShowFunctionsOperation;
import org.apache.flink.table.operations.ShowModulesOperation;
import org.apache.flink.table.operations.ShowPartitionsOperation;
import org.apache.flink.table.operations.ShowProceduresOperation;
import org.apache.flink.table.operations.ShowTablesOperation;
import org.apache.flink.table.operations.UnloadModuleOperation;
import org.apache.flink.table.operations.UseCatalogOperation;
import org.apache.flink.table.operations.UseDatabaseOperation;
import org.apache.flink.table.operations.UseModulesOperation;
import org.apache.flink.table.operations.command.AddJarOperation;
import org.apache.flink.table.operations.command.ClearOperation;
import org.apache.flink.table.operations.command.HelpOperation;
import org.apache.flink.table.operations.command.QuitOperation;
import org.apache.flink.table.operations.command.RemoveJarOperation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.table.operations.command.ShowJarsOperation;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversionTestBase;
import org.apache.flink.table.planner.parse.ExtendedParser;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class SqlOtherOperationConverterTest
extends SqlNodeToOperationConversionTestBase {
    @Test
    void testUseCatalog() {
        String sql = "USE CATALOG cat1";
        Operation operation = this.parse("USE CATALOG cat1");
        Assertions.assertThat((Object)operation).isInstanceOf(UseCatalogOperation.class);
        Assertions.assertThat((String)((UseCatalogOperation)operation).getCatalogName()).isEqualTo("cat1");
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo("USE CATALOG cat1");
    }

    @Test
    void testUseDatabase() {
        String sql1 = "USE db1";
        Operation operation1 = this.parse("USE db1");
        Assertions.assertThat((Object)operation1).isInstanceOf(UseDatabaseOperation.class);
        Assertions.assertThat((String)((UseDatabaseOperation)operation1).getCatalogName()).isEqualTo("builtin");
        Assertions.assertThat((String)((UseDatabaseOperation)operation1).getDatabaseName()).isEqualTo("db1");
        String sql2 = "USE cat1.db1";
        Operation operation2 = this.parse("USE cat1.db1");
        Assertions.assertThat((Object)operation2).isInstanceOf(UseDatabaseOperation.class);
        Assertions.assertThat((String)((UseDatabaseOperation)operation2).getCatalogName()).isEqualTo("cat1");
        Assertions.assertThat((String)((UseDatabaseOperation)operation2).getDatabaseName()).isEqualTo("db1");
    }

    @Test
    void testUseDatabaseWithException() {
        String sql = "USE cat1.db1.tbl1";
        Assertions.assertThatThrownBy(() -> this.parse("USE cat1.db1.tbl1")).isInstanceOf(ValidationException.class);
    }

    @Test
    void testLoadModule() {
        String sql = "LOAD MODULE dummy WITH ('k1' = 'v1', 'k2' = 'v2')";
        String expectedModuleName = "dummy";
        HashMap<String, String> expectedOptions = new HashMap<String, String>();
        expectedOptions.put("k1", "v1");
        expectedOptions.put("k2", "v2");
        Operation operation = this.parse("LOAD MODULE dummy WITH ('k1' = 'v1', 'k2' = 'v2')");
        Assertions.assertThat((Object)operation).isInstanceOf(LoadModuleOperation.class);
        LoadModuleOperation loadModuleOperation = (LoadModuleOperation)operation;
        Assertions.assertThat((String)loadModuleOperation.getModuleName()).isEqualTo("dummy");
        Assertions.assertThat((Map)loadModuleOperation.getOptions()).isEqualTo(expectedOptions);
    }

    @Test
    void testUnloadModule() {
        String sql = "UNLOAD MODULE dummy";
        String expectedModuleName = "dummy";
        Operation operation = this.parse("UNLOAD MODULE dummy");
        Assertions.assertThat((Object)operation).isInstanceOf(UnloadModuleOperation.class);
        UnloadModuleOperation unloadModuleOperation = (UnloadModuleOperation)operation;
        Assertions.assertThat((String)unloadModuleOperation.getModuleName()).isEqualTo("dummy");
    }

    @Test
    void testUseOneModule() {
        String sql = "USE MODULES dummy";
        List<String> expectedModuleNames = Collections.singletonList("dummy");
        Operation operation = this.parse("USE MODULES dummy");
        Assertions.assertThat((Object)operation).isInstanceOf(UseModulesOperation.class);
        UseModulesOperation useModulesOperation = (UseModulesOperation)operation;
        Assertions.assertThat((List)useModulesOperation.getModuleNames()).isEqualTo(expectedModuleNames);
        Assertions.assertThat((String)useModulesOperation.asSummaryString()).isEqualTo("USE MODULES: [dummy]");
    }

    @Test
    void testUseMultipleModules() {
        String sql = "USE MODULES x, y, z";
        List<String> expectedModuleNames = Arrays.asList("x", "y", "z");
        Operation operation = this.parse("USE MODULES x, y, z");
        Assertions.assertThat((Object)operation).isInstanceOf(UseModulesOperation.class);
        UseModulesOperation useModulesOperation = (UseModulesOperation)operation;
        Assertions.assertThat((List)useModulesOperation.getModuleNames()).isEqualTo(expectedModuleNames);
        Assertions.assertThat((String)useModulesOperation.asSummaryString()).isEqualTo("USE MODULES: [x, y, z]");
    }

    @Test
    void testShowModules() {
        String sql = "SHOW MODULES";
        Operation operation = this.parse("SHOW MODULES");
        Assertions.assertThat((Object)operation).isInstanceOf(ShowModulesOperation.class);
        ShowModulesOperation showModulesOperation = (ShowModulesOperation)operation;
        Assertions.assertThat((boolean)showModulesOperation.requireFull()).isFalse();
        Assertions.assertThat((String)showModulesOperation.asSummaryString()).isEqualTo("SHOW MODULES");
    }

    @Test
    void testShowTables() {
        String sql = "SHOW TABLES from cat1.db1 not like 't%'";
        Operation operation = this.parse("SHOW TABLES from cat1.db1 not like 't%'");
        Assertions.assertThat((Object)operation).isInstanceOf(ShowTablesOperation.class);
        ShowTablesOperation showTablesOperation = (ShowTablesOperation)operation;
        Assertions.assertThat((String)showTablesOperation.getCatalogName()).isEqualTo("cat1");
        Assertions.assertThat((String)showTablesOperation.getDatabaseName()).isEqualTo("db1");
        Assertions.assertThat((String)showTablesOperation.getPreposition()).isEqualTo("FROM");
        Assertions.assertThat((boolean)showTablesOperation.isUseLike()).isTrue();
        Assertions.assertThat((boolean)showTablesOperation.isNotLike()).isTrue();
        String sql2 = "SHOW TABLES in db2";
        showTablesOperation = (ShowTablesOperation)this.parse("SHOW TABLES in db2");
        Assertions.assertThat((String)showTablesOperation.getCatalogName()).isEqualTo("builtin");
        Assertions.assertThat((String)showTablesOperation.getDatabaseName()).isEqualTo("db2");
        Assertions.assertThat((String)showTablesOperation.getPreposition()).isEqualTo("IN");
        Assertions.assertThat((boolean)showTablesOperation.isUseLike()).isFalse();
        Assertions.assertThat((boolean)showTablesOperation.isNotLike()).isFalse();
        String sql3 = "SHOW TABLES";
        showTablesOperation = (ShowTablesOperation)this.parse("SHOW TABLES");
        Assertions.assertThat((String)showTablesOperation.getCatalogName()).isNull();
        Assertions.assertThat((String)showTablesOperation.getDatabaseName()).isNull();
        Assertions.assertThat((String)showTablesOperation.getPreposition()).isNull();
    }

    @Test
    void testShowFullModules() {
        String sql = "SHOW FULL MODULES";
        Operation operation = this.parse("SHOW FULL MODULES");
        Assertions.assertThat((Object)operation).isInstanceOf(ShowModulesOperation.class);
        ShowModulesOperation showModulesOperation = (ShowModulesOperation)operation;
        Assertions.assertThat((boolean)showModulesOperation.requireFull()).isTrue();
        Assertions.assertThat((String)showModulesOperation.asSummaryString()).isEqualTo("SHOW FULL MODULES");
    }

    @Test
    void testShowFunctions() {
        String sql1 = "SHOW FUNCTIONS";
        this.assertShowFunctions("SHOW FUNCTIONS", "SHOW FUNCTIONS", ShowFunctionsOperation.FunctionScope.ALL);
        String sql2 = "SHOW USER FUNCTIONS";
        this.assertShowFunctions("SHOW USER FUNCTIONS", "SHOW USER FUNCTIONS", ShowFunctionsOperation.FunctionScope.USER);
        String sql = "show functions from cat1.db1 not like 'f%'";
        this.assertShowFunctions(sql, "SHOW FUNCTIONS FROM cat1.db1 NOT LIKE 'f%'", ShowFunctionsOperation.FunctionScope.ALL);
        sql = "show user functions from cat1.db1 ilike 'f%'";
        this.assertShowFunctions(sql, "SHOW USER FUNCTIONS FROM cat1.db1 ILIKE 'f%'", ShowFunctionsOperation.FunctionScope.USER);
        sql = "show functions in db1";
        this.assertShowFunctions(sql, "SHOW FUNCTIONS IN builtin.db1", ShowFunctionsOperation.FunctionScope.ALL);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("show functions in cat.db.t")).isInstanceOf(ValidationException.class)).hasMessage("Show functions from/in identifier [ cat.db.t ] format error, it should be [catalog_name.]database_name.");
    }

    @Test
    void testShowDatabases() {
        String sql1 = "SHOW DATABASES";
        this.assertShowDatabases("SHOW DATABASES", "SHOW DATABASES");
        String sql = "show databases from db1 not like 'f%'";
        this.assertShowDatabases(sql, "SHOW DATABASES FROM/IN db1 NOT LIKE 'f%'");
        sql = "show databases from db1 not ilike 'f%'";
        this.assertShowDatabases(sql, "SHOW DATABASES FROM/IN db1 NOT ILIKE 'f%'");
        sql = "show databases from db1 like 'f%'";
        this.assertShowDatabases(sql, "SHOW DATABASES FROM/IN db1 LIKE 'f%'");
        sql = "show databases from db1 ilike 'f%'";
        this.assertShowDatabases(sql, "SHOW DATABASES FROM/IN db1 ILIKE 'f%'");
        sql = "show databases in db1";
        this.assertShowDatabases(sql, "SHOW DATABASES FROM/IN db1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("show databases in db.t")).isInstanceOf(SqlParserException.class)).hasMessage("SQL parse failed. Show databases from/in identifier [ db.t ] format error, catalog must be a single part identifier.");
    }

    @Test
    void testShowProcedures() {
        String sql = "SHOW procedures from cat1.db1 not like 't%'";
        this.assertShowProcedures(sql, "SHOW PROCEDURES FROM cat1.db1 NOT LIKE t%");
        sql = "SHOW procedures from cat1.db1 ilike 't%'";
        this.assertShowProcedures(sql, "SHOW PROCEDURES FROM cat1.db1 ILIKE t%");
        sql = "SHOW procedures in db1";
        this.assertShowProcedures(sql, "SHOW PROCEDURES IN builtin.db1");
        sql = "SHOW procedures";
        this.assertShowProcedures(sql, "SHOW PROCEDURES");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("SHOW procedures in cat.db.t")).isInstanceOf(ValidationException.class)).hasMessage("Show procedures from/in identifier [ cat.db.t ] format error, it should be [catalog_name.]database_name.");
    }

    @Test
    void testShowPartitions() {
        Operation operation = this.parse("show partitions tbl");
        Assertions.assertThat((Object)operation).isInstanceOf(ShowPartitionsOperation.class);
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo("SHOW PARTITIONS builtin.default.tbl");
        operation = this.parse("show partitions tbl partition (dt='2020-04-30 01:02:03')");
        Assertions.assertThat((Object)operation).isInstanceOf(ShowPartitionsOperation.class);
        Assertions.assertThat((String)operation.asSummaryString()).isEqualTo("SHOW PARTITIONS builtin.default.tbl PARTITION (dt=2020-04-30 01:02:03)");
    }

    @Test
    void testAddJar() {
        Arrays.asList("./test.\njar", "file:///path/to/whatever", "../test-jar.jar", "/root/test.jar", "test\\ jar.jar", "oss://path/helloworld.go").forEach(jarPath -> {
            AddJarOperation operation = (AddJarOperation)this.parser.parse(String.format("ADD JAR '%s'", jarPath)).get(0);
            Assertions.assertThat((String)operation.getPath()).isEqualTo(jarPath);
        });
    }

    @Test
    void testRemoveJar() {
        Arrays.asList("./test.\njar", "file:///path/to/whatever", "../test-jar.jar", "/root/test.jar", "test\\ jar.jar", "oss://path/helloworld.go").forEach(jarPath -> {
            RemoveJarOperation operation = (RemoveJarOperation)this.parser.parse(String.format("REMOVE JAR '%s'", jarPath)).get(0);
            Assertions.assertThat((String)operation.getPath()).isEqualTo(jarPath);
        });
    }

    @Test
    void testShowJars() {
        String sql = "SHOW JARS";
        Operation operation = this.parse("SHOW JARS");
        Assertions.assertThat((Object)operation).isInstanceOf(ShowJarsOperation.class);
        ShowJarsOperation showModulesOperation = (ShowJarsOperation)operation;
        Assertions.assertThat((String)showModulesOperation.asSummaryString()).isEqualTo("SHOW JARS");
    }

    @Test
    void testSet() {
        Operation operation1 = this.parse("SET");
        Assertions.assertThat((Object)operation1).isInstanceOf(SetOperation.class);
        SetOperation setOperation1 = (SetOperation)operation1;
        Assertions.assertThat((Optional)setOperation1.getKey()).isNotPresent();
        Assertions.assertThat((Optional)setOperation1.getValue()).isNotPresent();
        Operation operation2 = this.parse("SET 'test-key' = 'test-value'");
        Assertions.assertThat((Object)operation2).isInstanceOf(SetOperation.class);
        SetOperation setOperation2 = (SetOperation)operation2;
        Assertions.assertThat((Optional)setOperation2.getKey()).hasValue((Object)"test-key");
        Assertions.assertThat((Optional)setOperation2.getValue()).hasValue((Object)"test-value");
    }

    @Test
    void testReset() {
        Operation operation1 = this.parse("RESET");
        Assertions.assertThat((Object)operation1).isInstanceOf(ResetOperation.class);
        Assertions.assertThat((Optional)((ResetOperation)operation1).getKey()).isNotPresent();
        Operation operation2 = this.parse("RESET 'test-key'");
        Assertions.assertThat((Object)operation2).isInstanceOf(ResetOperation.class);
        Assertions.assertThat((Optional)((ResetOperation)operation2).getKey()).isPresent();
        Assertions.assertThat((Optional)((ResetOperation)operation2).getKey()).hasValue((Object)"test-key");
    }

    @ParameterizedTest
    @ValueSource(strings={"SET", "SET;", "SET ;", "SET\t;", "SET\n;"})
    void testSetCommands(String command) {
        ExtendedParser extendedParser = new ExtendedParser();
        Assertions.assertThat((Optional)extendedParser.parse(command)).get().isInstanceOf(SetOperation.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"HELP", "HELP;", "HELP ;", "HELP\t;", "HELP\n;"})
    void testHelpCommands(String command) {
        ExtendedParser extendedParser = new ExtendedParser();
        Assertions.assertThat((Optional)extendedParser.parse(command)).get().isInstanceOf(HelpOperation.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"CLEAR", "CLEAR;", "CLEAR ;", "CLEAR\t;", "CLEAR\n;"})
    void testClearCommands(String command) {
        ExtendedParser extendedParser = new ExtendedParser();
        Assertions.assertThat((Optional)extendedParser.parse(command)).get().isInstanceOf(ClearOperation.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"QUIT;", "QUIT;", "QUIT ;", "QUIT\t;", "QUIT\n;", "EXIT;", "EXIT ;", "EXIT\t;", "EXIT\n;", "EXIT ; "})
    void testQuitCommands(String command) {
        ExtendedParser extendedParser = new ExtendedParser();
        Assertions.assertThat((Optional)extendedParser.parse(command)).get().isInstanceOf(QuitOperation.class);
    }

    private void assertShowFunctions(String sql, String expectedSummary, ShowFunctionsOperation.FunctionScope expectedScope) {
        Operation operation = this.parse(sql);
        Assertions.assertThat((Object)operation).isInstanceOf(ShowFunctionsOperation.class);
        ShowFunctionsOperation showFunctionsOperation = (ShowFunctionsOperation)operation;
        Assertions.assertThat((Comparable)showFunctionsOperation.getFunctionScope()).isEqualTo((Object)expectedScope);
        Assertions.assertThat((String)showFunctionsOperation.asSummaryString()).isEqualTo(expectedSummary);
    }

    private void assertShowDatabases(String sql, String expectedSummary) {
        Operation operation = this.parse(sql);
        Assertions.assertThat((Object)operation).isInstanceOf(ShowDatabasesOperation.class);
        ShowDatabasesOperation showDatabasesOperation = (ShowDatabasesOperation)operation;
        Assertions.assertThat((String)showDatabasesOperation.asSummaryString()).isEqualTo(expectedSummary);
    }

    private void assertShowProcedures(String sql, String expectedSummary) {
        Operation operation = this.parse(sql);
        Assertions.assertThat((Object)operation).isInstanceOf(ShowProceduresOperation.class);
        ShowProceduresOperation showProceduresOperation = (ShowProceduresOperation)operation;
        Assertions.assertThat((String)showProceduresOperation.asSummaryString()).isEqualTo(expectedSummary);
    }
}

