/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ReplaceTableAsOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversion;
import org.apache.flink.table.planner.operations.SqlNodeToOperationConversionTestBase;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SqlRTASNodeToOperationConverterTest
extends SqlNodeToOperationConversionTestBase {
    @Test
    public void testReplaceTableAS() {
        String tableName = "replace_table";
        String tableComment = "test table comment \u8868\u63cf\u8ff0";
        String sql = "REPLACE TABLE " + tableName + " COMMENT '" + tableComment + "' WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT * FROM t1";
        this.testCommonReplaceTableAs(sql, tableName, tableComment);
    }

    @Test
    public void testCreateOrReplaceTableAS() {
        String tableName = "create_or_replace_table";
        String sql = "CREATE OR REPLACE TABLE " + tableName + " WITH ('k1' = 'v1', 'k2' = 'v2') as SELECT * FROM t1";
        this.testCommonReplaceTableAs(sql, tableName, null);
    }

    private void testCommonReplaceTableAs(String sql, String tableName, @Nullable String tableComment) {
        ObjectIdentifier expectedIdentifier = ObjectIdentifier.of((String)"builtin", (String)"default", (String)tableName);
        Operation operation = this.parseAndConvert(sql);
        CatalogTable expectedCatalogTable = CatalogTable.of((Schema)this.getDefaultTableSchema(), (String)tableComment, Collections.emptyList(), this.getDefaultTableOptions());
        this.verifyReplaceTableAsOperation(operation, expectedIdentifier, expectedCatalogTable);
    }

    private Operation parseAndConvert(String sql) {
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        SqlNode node = parser.parse(sql);
        return (Operation)SqlNodeToOperationConversion.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
    }

    private void verifyReplaceTableAsOperation(Operation operation, ObjectIdentifier expectedTableIdentifier, CatalogTable expectedCatalogTable) {
        Assertions.assertThat((Object)operation).isInstanceOf(ReplaceTableAsOperation.class);
        ReplaceTableAsOperation replaceTableAsOperation = (ReplaceTableAsOperation)operation;
        CreateTableOperation createTableOperation = replaceTableAsOperation.getCreateTableOperation();
        Assertions.assertThat((boolean)createTableOperation.isTemporary()).isFalse();
        Assertions.assertThat((boolean)createTableOperation.isIgnoreIfExists()).isFalse();
        Assertions.assertThat((Object)createTableOperation.getTableIdentifier()).isEqualTo((Object)expectedTableIdentifier);
        this.verifyCatalogTable(expectedCatalogTable, createTableOperation.getCatalogTable());
    }

    private void verifyCatalogTable(CatalogTable expectedCatalogTable, CatalogTable actualCatalogTable) {
        Assertions.assertThat((Object)actualCatalogTable.getUnresolvedSchema()).isEqualTo((Object)expectedCatalogTable.getUnresolvedSchema());
        Assertions.assertThat((String)actualCatalogTable.getComment()).isEqualTo(expectedCatalogTable.getComment());
        Assertions.assertThat((List)actualCatalogTable.getPartitionKeys()).isEqualTo((Object)expectedCatalogTable.getPartitionKeys());
        Assertions.assertThat((Map)actualCatalogTable.getOptions()).isEqualTo((Object)expectedCatalogTable.getOptions());
    }

    private Map<String, String> getDefaultTableOptions() {
        HashMap<String, String> expectedOptions = new HashMap<String, String>();
        expectedOptions.put("k1", "v1");
        expectedOptions.put("k2", "v2");
        return expectedOptions;
    }

    private Schema getDefaultTableSchema() {
        return Schema.newBuilder().fromFields(new String[]{"a", "b", "c", "d"}, new AbstractDataType[]{DataTypes.BIGINT(), DataTypes.STRING(), DataTypes.INT(), DataTypes.STRING()}).build();
    }
}

