/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.factories.TestManagedTableFactory;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001'\t92i\\7qC\u000e$X*\u00198bO\u0016$G+\u00192mKR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003cCR\u001c\u0007N\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\u001fQ\f'\r\\3JI\u0016tG/\u001b4jKJ,\u0012A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003K)\tqaY1uC2|w-\u0003\u0002(I\t\u0001rJ\u00196fGRLE-\u001a8uS\u001aLWM\u001d\u0005\u0007S\u0001\u0001\u000b\u0011\u0002\u0012\u0002!Q\f'\r\\3JI\u0016tG/\u001b4jKJ\u0004\u0003bB\u0016\u0001\u0005\u0004%I\u0001L\u0001\ti\u0016\u001cH/\u0016;jYV\tQ\u0006\u0005\u0002\u0016]%\u0011qF\u0006\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG\u000e\u0003\u00042\u0001\u0001\u0006I!L\u0001\ni\u0016\u001cH/\u0016;jY\u0002BQa\r\u0001\u0005\u0002Q\naAY3g_J,G#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\tUs\u0017\u000e\u001e\u0015\u0003eq\u0002\"!\u0010#\u000e\u0003yR!a\u0010!\u0002\u0007\u0005\u0004\u0018N\u0003\u0002B\u0005\u00069!.\u001e9ji\u0016\u0014(BA\"\u0011\u0003\u0015QWO\\5u\u0013\t)eH\u0001\u0006CK\u001a|'/Z#bG\"DQa\u0012\u0001\u0005\u0002Q\nQ!\u00194uKJD#AR%\u0011\u0005uR\u0015BA&?\u0005%\te\r^3s\u000b\u0006\u001c\u0007\u000eC\u0003N\u0001\u0011\u0005A'A\u001buKN$X\t\u001f9mC&t\u0017\t\u001c;feR\u000b'\r\\3D_6\u0004\u0018m\u0019;XSRD'+Z:pYZ,G\rU1si&$\u0018n\u001c8Ta\u0016\u001c\u0007F\u0001'P!\ti\u0004+\u0003\u0002R}\t!A+Z:u\u0011\u0015\u0019\u0006\u0001\"\u00015\u0003Y\"Xm\u001d;FqBd\u0017-\u001b8BYR,'\u000fV1cY\u0016\u001cu.\u001c9bGR<\u0016\u000e\u001e5V]>\u0014H-\u001a:fIB\u000b'\u000f^5uS>t7\u000b]3dQ\t\u0011v\nC\u0003W\u0001\u0011\u0005A'A\u001euKN$X\t\u001f9mC&t\u0017\t\u001c;feR\u000b'\r\\3D_6\u0004\u0018m\u0019;XSRDw.\u001e;Tk\n|'\u000fZ5oCR,\u0007+\u0019:uSRLwN\\*qK\u000eD#!V(\t\u000be\u0003A\u0011\u0001\u001b\u0002sQ,7\u000f^#ya2\f\u0017N\\!mi\u0016\u0014H+\u00192mK\u000e{W\u000e]1di^KG\u000f[8viN+7m\u001c8eCJL\b+\u0019:uSRLwN\\*qK\u000eD#\u0001W(\t\u000bq\u0003A\u0011\u0001\u001b\u0002aQ,7\u000f^#ya2\f\u0017N\\!mi\u0016\u0014H+\u00192mK\u000e{W\u000e]1di^KG\u000f[8viB\u000b'\u000f^5uS>t7\u000b]3dQ\tYv\n")
public class CompactManagedTableTest
extends TableTestBase {
    private final ObjectIdentifier tableIdentifier = ObjectIdentifier.of((String)"default_catalog", (String)"default_database", (String)"ManagedTable");
    private final BatchTableTestUtil testUtil = this.batchTestUtil(this.batchTestUtil$default$1());

    private ObjectIdentifier tableIdentifier() {
        return this.tableIdentifier;
    }

    private BatchTableTestUtil testUtil() {
        return this.testUtil;
    }

    @BeforeEach
    public void before() {
        AtomicReference tableRef = new AtomicReference();
        TestManagedTableFactory.MANAGED_TABLES.put(this.tableIdentifier(), tableRef);
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE ManagedTable (\n        |  a BIGINT,\n        |  b INT,\n        |  c VARCHAR\n        |) PARTITIONED BY (b, c)\n      ")).stripMargin();
        this.testUtil().tableEnv().executeSql(ddl);
        LinkedHashMap<String, String> partitionKVs = new LinkedHashMap<String, String>();
        partitionKVs.put("b", "0");
        partitionKVs.put("c", "flink");
        HashMap<CatalogPartitionSpec, List<Path>> managedTableFileEntries = new HashMap<CatalogPartitionSpec, List<Path>>();
        managedTableFileEntries.put(new CatalogPartitionSpec(partitionKVs), Collections.singletonList(new Path("/foo/bar/file")));
        AtomicReference<HashMap<CatalogPartitionSpec, List<Path>>> fileRef = new AtomicReference<HashMap<CatalogPartitionSpec, List<Path>>>();
        fileRef.set(managedTableFileEntries);
        TestManagedTableFactory.MANAGED_TABLE_FILE_ENTRIES.put(this.tableIdentifier(), fileRef);
    }

    @AfterEach
    public void after() {
        String ddl = "DROP TABLE ManagedTable";
        this.testUtil().tableEnv().executeSql(ddl);
        TestManagedTableFactory.MANAGED_TABLE_FILE_ENTRIES.remove(this.tableIdentifier());
    }

    @Test
    public void testExplainAlterTableCompactWithResolvedPartitionSpec() {
        String sql = "ALTER TABLE ManagedTable PARTITION (b = 0, c = 'flink') COMPACT";
        this.testUtil().verifyExplainSql(sql);
    }

    @Test
    public void testExplainAlterTableCompactWithUnorderedPartitionSpec() {
        String sql = "ALTER TABLE ManagedTable PARTITION (c = 'flink', b = 0) COMPACT";
        this.testUtil().verifyExplainSql(sql);
    }

    @Test
    public void testExplainAlterTableCompactWithoutSubordinatePartitionSpec() {
        String sql = "ALTER TABLE ManagedTable PARTITION (b = 0) COMPACT";
        this.testUtil().verifyExplainSql(sql);
    }

    @Test
    public void testExplainAlterTableCompactWithoutSecondaryPartitionSpec() {
        String sql = "ALTER TABLE ManagedTable PARTITION (c = 'flink') COMPACT";
        this.testUtil().verifyExplainSql(sql);
    }

    @Test
    public void testExplainAlterTableCompactWithoutPartitionSpec() {
        String sql = "ALTER TABLE ManagedTable COMPACT";
        this.testUtil().verifyExplainSql(sql);
    }
}

