/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.LegacyLimitTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001'\tyA*Z4bGfd\u0015.\\5u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011!\u00022bi\u000eD'BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%\t\"I\u0001\u0005kRLG.F\u0001#!\t)2%\u0003\u0002%-\t\u0011\")\u0019;dQR\u000b'\r\\3UKN$X\u000b^5m\u0011\u00191\u0003\u0001)A\u0005E\u0005)Q\u000f^5mA!)\u0001\u0006\u0001C\u0001S\u0005)1/\u001a;vaR\t!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0003V]&$\bFA\u00142!\t\u0011\u0014(D\u00014\u0015\t!T'A\u0002ba&T!AN\u001c\u0002\u000f),\b/\u001b;fe*\u0011\u0001\bE\u0001\u0006UVt\u0017\u000e^\u0005\u0003uM\u0012!BQ3g_J,W)Y2i\u0011\u0015a\u0004\u0001\"\u0001*\u0003Y!Xm\u001d;MS6LGoV5uQ>,Ho\u00144gg\u0016$\bFA\u001e?!\t\u0011t(\u0003\u0002Ag\t!A+Z:u\u0011\u0015\u0011\u0005\u0001\"\u0001*\u0003]!Xm\u001d;MS6LG\u000fM,ji\"|W\u000f^(gMN,G\u000f\u000b\u0002B}!)Q\t\u0001C\u0001S\u0005qB/Z:u\u001d\u0016<\u0017\r^5wK2KW.\u001b;XSRDw.\u001e;PM\u001a\u001cX\r\u001e\u0015\u0003\tzBQ\u0001\u0013\u0001\u0005\u0002%\n1\u0003^3ti2KW.\u001b;XSRDwJ\u001a4tKRD#a\u0012 \t\u000b-\u0003A\u0011A\u0015\u0002)Q,7\u000f\u001e'j[&$x+\u001b;i\u001f\u001a47/\u001a;1Q\tQe\bC\u0003O\u0001\u0011\u0005\u0011&A\u000buKN$H*[7jiB:\u0016\u000e\u001e5PM\u001a\u001cX\r\u001e\u0019)\u00055s\u0004\"B)\u0001\t\u0003I\u0013\u0001\u0006;fgRd\u0015.\\5ua]KG\u000f[(gMN,G\u000f\u000b\u0002Q}!)A\u000b\u0001C\u0001S\u0005YB/Z:u\u0019&l\u0017\u000e^,ji\"tUmZ1uSZ,wJ\u001a4tKRD#a\u0015 \t\u000b]\u0003A\u0011A\u0015\u0002'Q,7\u000f\u001e$fi\u000eDw+\u001b;i\u001f\u001a47/\u001a;)\u0005Ys\u0004\"\u0002.\u0001\t\u0003I\u0013A\u0006;fgR4U\r^2i/&$\bn\\;u\u001f\u001a47/\u001a;)\u0005es\u0004\"B/\u0001\t\u0003I\u0013a\u0006;fgR4U\r^2ia]KG\u000f[8vi>3gm]3uQ\taf\bC\u0003a\u0001\u0011\u0005\u0011&\u0001\buKN$xJ\u001c7z\u001f\u001a47/\u001a;)\u0005}s\u0004\"B2\u0001\t\u0003I\u0013\u0001\u0007;fgR4U\r^2i/&$\b\u000eT5nSR\u001cv.\u001e:dK\"\u0012!M\u0010\u0005\u0006M\u0002!\t!K\u0001\u001bi\u0016\u001cHo\u0014:eKJ\u0014\u0015pV5uQ2KW.\u001b;T_V\u00148-\u001a\u0015\u0003KzBQ!\u001b\u0001\u0005\u0002%\n\u0001\u0004^3ti2KW.\u001b;XSRDG*[7jiN{WO]2fQ\tAg\bC\u0003m\u0001\u0011\u0005\u0011&A\u0011uKN$H*[7ji^KG\u000f[(gMN,G/\u00118e\u0019&l\u0017\u000e^*pkJ\u001cW\r\u000b\u0002l}!)q\u000e\u0001C\u0001S\u0005\tC/Z:u\r\u0016$8\r[,ji\"|eMZ:fi\u0006sG\rT5nSR\u001cv.\u001e:dK\"\u0012aN\u0010")
public class LegacyLimitTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    public BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.LegacyLimitTest$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE LimitTable (\n         |  a int,\n         |  b bigint,\n         |  c string\n         |) WITH (\n         |  'connector.type' = 'TestLimitableTableSource',\n         |  'is-bounded' = 'true'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
    }

    @Test
    public void testLimitWithoutOffset() {
        this.util().verifyExecPlan("SELECT * FROM MyTable LIMIT 5");
    }

    @Test
    public void testLimit0WithoutOffset() {
        this.util().verifyExecPlan("SELECT * FROM MyTable LIMIT 0");
    }

    @Test
    public void testNegativeLimitWithoutOffset() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT * FROM MyTable LIMIT -1"));
    }

    @Test
    public void testLimitWithOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 10 OFFSET 1");
    }

    @Test
    public void testLimitWithOffset0() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 10 OFFSET 0");
    }

    @Test
    public void testLimit0WithOffset0() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 0 OFFSET 0");
    }

    @Test
    public void testLimit0WithOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 0 OFFSET 10");
    }

    @Test
    public void testLimitWithNegativeOffset() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 10 OFFSET -1"));
    }

    @Test
    public void testFetchWithOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable OFFSET 10 ROWS FETCH NEXT 10 ROWS ONLY");
    }

    @Test
    public void testFetchWithoutOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable FETCH FIRST 10 ROWS ONLY");
    }

    @Test
    public void testFetch0WithoutOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable FETCH FIRST 0 ROWS ONLY");
    }

    @Test
    public void testOnlyOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable OFFSET 10 ROWS");
    }

    @Test
    public void testFetchWithLimitSource() {
        String sqlQuery = "SELECT a, c FROM LimitTable FETCH FIRST 10 ROWS ONLY";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testOrderByWithLimitSource() {
        String sqlQuery = "SELECT a, c FROM LimitTable ORDER BY c LIMIT 10";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testLimitWithLimitSource() {
        String sqlQuery = "SELECT a, c FROM LimitTable LIMIT 10";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testLimitWithOffsetAndLimitSource() {
        String sqlQuery = "SELECT a, c FROM LimitTable LIMIT 10 OFFSET 1";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testFetchWithOffsetAndLimitSource() {
        String sqlQuery = "SELECT a, c FROM LimitTable OFFSET 10 ROWS FETCH NEXT 10 ROWS ONLY";
        this.util().verifyExecPlan(sqlQuery);
    }
}

