/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.batch.sql.OperatorFusionCodegenTest$;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001'\tIr\n]3sCR|'OR;tS>t7i\u001c3fO\u0016tG+Z:u\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\u000b\t\fGo\u00195\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"A\u0003vi&d7/\u0003\u0002\u001a-\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016D\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0015MV\u001c\u0018n\u001c8D_\u0012,w-\u001a8F]\u0006\u0014G.\u001a3\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\u000f\t{w\u000e\\3b]\")1\u0005\u0001C\u0001I\u00051A(\u001b8jiz\"\"!J\u0014\u0011\u0005\u0019\u0002Q\"\u0001\u0002\t\u000bm\u0011\u0003\u0019\u0001\u000f\t\u000f%\u0002!\u0019!C\u0005U\u0005!Q\u000f^5m+\u0005Y\u0003CA\u000b-\u0013\ticC\u0001\nCCR\u001c\u0007\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007BB\u0018\u0001A\u0003%1&A\u0003vi&d\u0007\u0005C\u00032\u0001\u0011\u0005!'A\u0003tKR,\b\u000fF\u00014!\tiB'\u0003\u00026=\t!QK\\5uQ\t\u0001t\u0007\u0005\u00029\u007f5\t\u0011H\u0003\u0002;w\u0005\u0019\u0011\r]5\u000b\u0005qj\u0014a\u00026va&$XM\u001d\u0006\u0003}A\tQA[;oSRL!\u0001Q\u001d\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0003C\u0001\u0011\u0005!'A\u0010uKN$\b*Y:i\u0003\u001e<\u0017i]'vi2$\u0018\u000e\u001d7f\u0013:\u0004X\u000f\u001e*p_RD#!\u0011#\u0011\u0005a*\u0015B\u0001$:\u00051!Vm\u001d;UK6\u0004H.\u0019;f\u0011\u0015A\u0005\u0001\"\u00013\u0003\u0011\"Xm\u001d;M_\u000e\fG\u000eS1tQ\u0006;w-Q:NkRdG/\u001b9mK&s\u0007/\u001e;S_>$\bFA$E\u0011\u0015Y\u0005\u0001\"\u00013\u0003q!Xm\u001d;DC2\u001c\u0017i]'vi2$\u0018\u000e\u001d7f\u0013:\u0004X\u000f\u001e*p_RD#A\u0013#)\t\u0001qE+\u0016\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#f\n\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005M\u0003&AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\nakI\u0001X!\tA\u0006-D\u0001Z\u0015\tQ6,A\u0007qCJ\fW.\u001a;fe&TX\r\u001a\u0006\u00039v\u000b!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\tqdL\u0003\u0002`\u0019\u0005IA/Z:ukRLGn]\u0005\u0003Cf\u0013!\u0004U1sC6,G/\u001a:ju\u0016$G+Z:u\u000bb$XM\\:j_:<Qa\u0019\u0002\t\u0002\u0011\f\u0011d\u00149fe\u0006$xN\u001d$vg&|gnQ8eK\u001e,g\u000eV3tiB\u0011a%\u001a\u0004\u0006\u0003\tA\tAZ\n\u0003K\u001e\u0004\"!\b5\n\u0005%t\"AB!osJ+g\rC\u0003$K\u0012\u00051\u000eF\u0001e\u0011\u0015iW\r\"\u0001o\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0002_B\u0019\u0001\u000f\u001e\u000f\u000e\u0003ET!!\u000b:\u000b\u0003M\fAA[1wC&\u0011Q/\u001d\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0006\u00027xun\u0004\"\u0001\u0017=\n\u0005eL&A\u0003)be\u0006lW\r^3sg\u0006!a.Y7fC\u0005a\u0018\u0001\u00074vg&|gnQ8eK\u001e,g.\u00128bE2,G-P>1{\u0002")
public class OperatorFusionCodegenTest
extends TableTestBase {
    private final boolean fusionCodegenEnabled;
    private final BatchTableTestUtil util;

    @Parameters(name="fusionCodegenEnabled={0}")
    public static Collection<Object> parameters() {
        return OperatorFusionCodegenTest$.MODULE$.parameters();
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTableSource("T1", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING(), Types.STRING()}), (String[])((Object[])new String[]{"a1", "b1", "c1", "d1"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000000L)).uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"a1"))).build());
        this.util().addTableSource("T2", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING()}), (String[])((Object[])new String[]{"a2", "b2", "c2"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000000L)).uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"b2"), (Object)ImmutableSet.of((Object)"a2", (Object)"b2"))).build());
        this.util().addTableSource("T3", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING(), Types.LONG()}), (String[])((Object[])new String[]{"a3", "b3", "c3", "d3"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(1000L)).build());
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_OPERATOR_FUSION_CODEGEN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)this.fusionCodegenEnabled));
    }

    @TestTemplate
    public void testHashAggAsMutltipleInputRoot() {
        this.util().verifyExecPlan("SELECT a1, b1, a2, b2, COUNT(c1) FROM (SELECT * FROM T1, T2 WHERE a1 = b2) t GROUP BY a1, b1, a2, b2");
    }

    @TestTemplate
    public void testLocalHashAggAsMutltipleInputRoot() {
        this.util().verifyExecPlan("SELECT a2, b2, a3, b3, COUNT(c2), AVG(d3) FROM (SELECT * FROM T2, T3 WHERE b2 = a3) t GROUP BY a2, b2, a3, b3");
    }

    @TestTemplate
    public void testCalcAsMutltipleInputRoot() {
        this.util().verifyExecPlan("SELECT a1, b1, a2, b2, a3, b3, COUNT(c1) FROM (SELECT * FROM T1, T2, T3 WHERE a1 = b2 AND a1 = a3) t GROUP BY a1, b1, a2, b2, a3, b3");
    }

    public OperatorFusionCodegenTest(boolean fusionCodegenEnabled) {
        this.fusionCodegenEnabled = fusionCodegenEnabled;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

