/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.plan.batch.sql.PartitionableSourceTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001M\u0011q\u0003U1si&$\u0018n\u001c8bE2,7k\\;sG\u0016$Vm\u001d;\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\"A1\u0004\u0001BC\u0002\u0013\u0005A$A\u000bt_V\u00148-\u001a$fi\u000eD\u0007+\u0019:uSRLwN\\:\u0016\u0003u\u0001\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u001e\u0003Y\u0019x.\u001e:dK\u001a+Go\u00195QCJ$\u0018\u000e^5p]N\u0004\u0003\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002!U\u001cXmQ1uC2|wMR5mi\u0016\u0014\b\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002#U\u001cXmQ1uC2|wMR5mi\u0016\u0014\b\u0005C\u0003+\u0001\u0011\u00051&\u0001\u0004=S:LGO\u0010\u000b\u0004Y9z\u0003CA\u0017\u0001\u001b\u0005\u0011\u0001\"B\u000e*\u0001\u0004i\u0002\"\u0002\u0014*\u0001\u0004i\u0002bB\u0019\u0001\u0005\u0004%IAM\u0001\u0005kRLG.F\u00014!\t)B'\u0003\u00026-\t\u0011\")\u0019;dQR\u000b'\r\\3UKN$X\u000b^5m\u0011\u00199\u0004\u0001)A\u0005g\u0005)Q\u000f^5mA!)\u0011\b\u0001C\u0001u\u0005)1/\u001a;vaR\t1\b\u0005\u0002\u001fy%\u0011Qh\b\u0002\u0005+:LG\u000f\u000b\u00029\u007fA\u0011\u0001iR\u0007\u0002\u0003*\u0011!iQ\u0001\u0004CBL'B\u0001#F\u0003\u001dQW\u000f]5uKJT!A\u0012\t\u0002\u000b),h.\u001b;\n\u0005!\u000b%A\u0003\"fM>\u0014X-R1dQ\")!\n\u0001C\u0001u\u0005\u0011C/Z:u'&l\u0007\u000f\\3QCJ$\u0018\u000e^5p]\u001aKW\r\u001c3Qe\u0016$\u0017nY1uKFB#!\u0013'\u0011\u0005\u0001k\u0015B\u0001(B\u00051!Vm\u001d;UK6\u0004H.\u0019;f\u0011\u0015\u0001\u0006\u0001\"\u0001;\u0003)\"Xm\u001d;QCJ$\u0018.\u00197QCJ$\u0018\u000e^5p]\u001aKW\r\u001c3Qe\u0016$\u0017nY1uKB+8\u000f\u001b#po:D#a\u0014'\t\u000bM\u0003A\u0011\u0001\u001e\u00027Q,7\u000f^,ji\",FMZ!oIZK'\u000f^;bY\u000e{G.^7oQ\t\u0011F\nC\u0003W\u0001\u0011\u0005!(A\ruKN$XK\\2p]Z,'\u000f^3e\u000bb\u0004(/Z:tS>t\u0007FA+M\u0011\u0015I\u0006\u0001\"\u0001;\u0003M\"Xm\u001d;QkNDGi\\<o!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a$jYR,'o]\"p]R\f\u0017N\u001c)beRLG/[8o\u0017\u0016L8\u000f\u000b\u0002Y\u0019\")A\f\u0001C\u0001u\u00059E/Z:u!V\u001c\b\u000eR8x]B\u000b'\u000f^5uS>t\u0017I\u001c3GS2$XM]:D_:$\u0018-\u001b8QCJ$\u0018\u000e^5p].+\u0017p],ji\"\u001c\u0016N\\4mKB\u0013xN[3di&|g\u000e\u000b\u0002\\\u0019\")q\f\u0001C\u0001u\u0005\u0001C/Z:u!V\u001c\b\u000eR8x]:{g.\u0012=jgR,g\u000e\u001e)beRLG/[8oQ\tqF\n\u000b\u0003\u0001E\"L\u0007CA2g\u001b\u0005!'BA3B\u0003%)\u0007\u0010^3og&|g.\u0003\u0002hI\nQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0003)\u001c\u0013a\u001b\t\u0003YRl\u0011!\u001c\u0006\u0003]>\fQ\u0002]1sC6,G/\u001a:ju\u0016$'B\u00019r\u0003))\u0007\u0010^3og&|gn\u001d\u0006\u0003\rJT!a\u001d\u0007\u0002\u0013Q,7\u000f^;uS2\u001c\u0018BA;n\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u000f\u00159(\u0001#\u0001y\u0003]\u0001\u0016M\u001d;ji&|g.\u00192mKN{WO]2f)\u0016\u001cH\u000f\u0005\u0002.s\u001a)\u0011A\u0001E\u0001uN\u0011\u0011p\u001f\t\u0003=qL!!`\u0010\u0003\r\u0005s\u0017PU3g\u0011\u0015Q\u0013\u0010\"\u0001\u0000)\u0005A\bbBA\u0002s\u0012\u0005\u0011QA\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cHCAA\u0004!\u0019\tI!!\u0005\u0002\u00165\u0011\u00111\u0002\u0006\u0004c\u00055!BAA\b\u0003\u0011Q\u0017M^1\n\t\u0005M\u00111\u0002\u0002\u000b\u0007>dG.Z2uS>t\u0007#\u0002\u0010\u0002\u0018\u0005m\u0011bAA\r?\t)\u0011I\u001d:bsB\u0019a$!\b\n\u0007\u0005}qDA\u0002B]fD\u0003\"!\u0001\u0002$\u0005%\u00121\u0006\t\u0004Y\u0006\u0015\u0012bAA\u0014[\nQ\u0001+\u0019:b[\u0016$XM]:\u0002\t9\fW.Z\u0011\u0003\u0003[\tqf]8ve\u000e,g)\u001a;dQB\u000b'\u000f^5uS>t7/P>1{2\u0002So]3DCR\fGn\\4GS2$XM]\u001f|cu\u0004")
public class PartitionableSourceTest
extends TableTestBase {
    private final boolean sourceFetchPartitions;
    private final boolean useCatalogFilter;
    private final BatchTableTestUtil util;

    @Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PartitionableSourceTest$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        String partitionableTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE PartitionableTable (\n        |  id int,\n        |  name string,\n        |  part1 string,\n        |  part2 int,\n        |  virtualField as part2 + 1)\n        |  partitioned by (part1, part2)\n        |  with (\n        |    'connector' = 'values',\n        |    'bounded' = 'true',\n        |    'partition-list' = '%s'\n        |)\n        |")).stripMargin();
        String partitionableAndFilterableTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE PartitionableAndFilterableTable (\n        |  id int,\n        |  name string,\n        |  part1 string,\n        |  part2 int,\n        |  virtualField as part2 + 1)\n        |  partitioned by (part1, part2)\n        |  with (\n        |    'connector' = 'values',\n        |    'bounded' = 'true',\n        |    'partition-list' = '%s',\n        |    'filterable-fields' = 'id;part1;part2'\n        |)\n        |")).stripMargin();
        if (this.sourceFetchPartitions()) {
            String partitions = "part1:A,part2:1;part1:A,part2:2;part1:B,part2:3;part1:C,part2:1";
            this.util().tableEnv().executeSql(String.format(partitionableTable, partitions));
            this.util().tableEnv().executeSql(String.format(partitionableAndFilterableTable, partitions));
        } else {
            TestValuesCatalog catalog = new TestValuesCatalog("test_catalog", "test_database", this.useCatalogFilter());
            this.util().tableEnv().registerCatalog("test_catalog", (Catalog)catalog);
            this.util().tableEnv().useCatalog("test_catalog");
            this.util().tableEnv().executeSql(String.format(partitionableTable, ""));
            this.util().tableEnv().executeSql(String.format(partitionableAndFilterableTable, ""));
            ObjectPath partitionableTablePath = ObjectPath.fromString((String)"test_database.PartitionableTable");
            ObjectPath partitionableAndFilterableTablePath = ObjectPath.fromString((String)"test_database.PartitionableAndFilterableTable");
            Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"2")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"3")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))}));
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionableSourceTest.$anonfun$setup$1(catalog, partitionableTablePath, partitionableAndFilterableTablePath, partition);
                return BoxedUnit.UNIT;
            });
        }
    }

    @TestTemplate
    public void testSimplePartitionFieldPredicate1() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE part1 = 'A'");
    }

    @TestTemplate
    public void testPartialPartitionFieldPredicatePushDown() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1");
    }

    @TestTemplate
    public void testWithUdfAndVirtualColumn() {
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)Func1$.MODULE$);
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE id > 2 AND MyUdf(part2) < 3");
    }

    @TestTemplate
    public void testUnconvertedExpression() {
        this.util().verifyExecPlan("select * from PartitionableTable where trim(part1) = 'A' and part2 > 1");
    }

    @TestTemplate
    public void testPushDownPartitionAndFiltersContainPartitionKeys() {
        this.util().verifyExecPlan("select * from PartitionableAndFilterableTable where part1 = 'A' and part2 > 1 and id > 1");
    }

    @TestTemplate
    public void testPushDownPartitionAndFiltersContainPartitionKeysWithSingleProjection() {
        this.util().verifyExecPlan("select name from PartitionableAndFilterableTable where part1 = 'A' and part2 > 1 and id > 1");
    }

    @TestTemplate
    public void testPushDownNonExistentPartition() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE part2 = 4");
    }

    public static final /* synthetic */ void $anonfun$setup$1(TestValuesCatalog catalog$1, ObjectPath partitionableTablePath$1, ObjectPath partitionableAndFilterableTablePath$1, scala.collection.immutable.Map partition) {
        CatalogPartitionSpec catalogPartitionSpec = new CatalogPartitionSpec(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)partition));
        CatalogPartitionImpl catalogPartition = new CatalogPartitionImpl(new HashMap(), "");
        catalog$1.createPartition(partitionableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
        catalog$1.createPartition(partitionableAndFilterableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
    }

    public PartitionableSourceTest(boolean sourceFetchPartitions, boolean useCatalogFilter) {
        this.sourceFetchPartitions = sourceFetchPartitions;
        this.useCatalogFilter = useCatalogFilter;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

