/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.RankTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001'\tA!+\u00198l)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011!\u00022bi\u000eD'BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u0005kRLG.F\u0001#!\t)2%\u0003\u0002%-\t\u0011\")\u0019;dQR\u000b'\r\\3UKN$X\u000b^5m\u0011\u00191\u0003\u0001)A\u0005E\u0005)Q\u000f^5mA!)\u0001\u0006\u0001C\u0001S\u0005YB/Z:u%><h*^7cKJ<\u0016\u000e\u001e5pkR|%\u000fZ3s\u0005f$\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0005+:LG\u000fC\u00032\u0001\u0011\u0005\u0011&\u0001\u0011uKN$(k\\<Ok6\u0014WM],ji\"|%\u000fZ3s\u0005f\u001cuN\\:uC:$\bF\u0001\u00194!\t!4(D\u00016\u0015\t1t'A\u0002ba&T!\u0001O\u001d\u0002\u000f),\b/\u001b;fe*\u0011!\bE\u0001\u0006UVt\u0017\u000e^\u0005\u0003yU\u0012A\u0001V3ti\")a\b\u0001C\u0001S\u0005aB/Z:u%><h*^7cKJ<\u0016\u000e\u001e5Nk2$\u0018n\u0012:pkB\u001c\bFA\u001f4\u0011\u0015\t\u0005\u0001\"\u0001*\u0003Y!Xm\u001d;SC:\\w+\u001b;i_V$xJ\u001d3fe\nK\bF\u0001!4\u0011\u0015!\u0005\u0001\"\u0001*\u0003]!Xm\u001d;SC:\\w+\u001b;i\u001bVdG/[$s_V\u00048\u000f\u000b\u0002Dg!)q\t\u0001C\u0001S\u0005YB/Z:u\t\u0016t7/\u001a*b].<\u0016\u000e\u001e5pkR|%\u000fZ3s\u0005fD#AR\u001a\t\u000b)\u0003A\u0011A\u0015\u00029Q,7\u000f\u001e#f]N,'+\u00198l/&$\b.T;mi&<%o\\;qg\"\u0012\u0011j\r\u0005\u0006\u001b\u0002!\t!K\u0001\"i\u0016\u001cHOU1oWZ\u000bG.^3GS2$XM],ji\",\u0006\u000f]3s-\u0006dW/\u001a\u0015\u0003\u0019NBQ\u0001\u0015\u0001\u0005\u0002%\nA\u0004^3tiJ\u000bgn\u001b,bYV,g)\u001b7uKJ<\u0016\u000e\u001e5SC:<W\r\u000b\u0002Pg!)1\u000b\u0001C\u0001S\u0005iB/Z:u%\u0006t7NV1mk\u00164\u0015\u000e\u001c;fe^KG\u000f[#rk\u0006d7\u000f\u000b\u0002Sg!)a\u000b\u0001C\u0001S\u00051B/Z:u/&$\bn\\;u!\u0006\u0014H/\u001b;j_:\u0014\u0015\u0010\u000b\u0002Vg!)\u0011\f\u0001C\u0001S\u00059C/Z:u\u001bVdG/[*b[\u0016\u0014\u0016M\\6Gk:\u001cG/[8og^KG\u000f[*b[\u0016<%o\\;qQ\tA6\u0007C\u0003]\u0001\u0011\u0005\u0011&A\u0012uKN$H)\u001e9mS\u000e\fG/\u001a*b].4UO\\2uS>t7i\u001c7v[:t\u0015-\\3)\u0005m\u001b\u0004\"B0\u0001\t\u0003I\u0013\u0001\u0007;fgR\u0014\u0016M\\6Gk:\u001cG/[8o\u0013:l\u0015\u000e\u001a3mK\"\u0012al\r\u0005\u0006E\u0002!\t!K\u0001\u001ci\u0016\u001cHo\u0011:fCR,g+[3x/&$\bNU8x\u001dVl'-\u001a:)\u0005\u0005\u001c\u0004\"B3\u0001\t\u0003I\u0013A\b;fgR\u0014\u0016M\\6XSRD\u0017I\\8uQ\u0016\u0014(+\u00198l\u0003NLe\u000e];uQ\t!7\u0007C\u0003i\u0001\u0011\u0005\u0011&A\u0012uKN$(+\u001a3v]\u0012\fg\u000e\u001e*b].tU/\u001c2fe\u000e{G.^7o%\u0016lwN^3)\u0005\u001d\u001c\u0004")
public class RankTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    public void testRowNumberWithoutOrderBy() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT ROW_NUMBER() over (partition by a) FROM MyTable\n      ")).stripMargin();
        Assertions.assertThatThrownBy(() -> this.util().tableEnv().executeSql(sqlQuery)).hasRootCauseMessage("Over Agg: The window rank function requires order by clause with non-constant fields. please re-check the over window statement.");
    }

    @Test
    public void testRowNumberWithOrderByConstant() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT a, b,\n        |  ROW_NUMBER() OVER (PARTITION BY b ORDER BY '2023-03-29') AS row_num\n        |  FROM MyTable\n        |)\n        |WHERE row_num <= 10\n      ")).stripMargin();
        Assertions.assertThatThrownBy(() -> this.util().tableEnv().executeSql(sqlQuery)).hasRootCauseMessage("Over Agg: The window rank function requires order by clause with non-constant fields. please re-check the over window statement.");
    }

    @Test
    public void testRowNumberWithMultiGroups() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT ROW_NUMBER() over (partition by a order by b) as a,\n        |       ROW_NUMBER() over (partition by b) as b\n        |       FROM MyTable\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testRankWithoutOrderBy() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT RANK() over (partition by a) FROM MyTable\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testRankWithMultiGroups() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT RANK() over (partition by a order by b) as a,\n        |       RANK() over (partition by b) as b\n        |       FROM MyTable\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testDenseRankWithoutOrderBy() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT dense_rank() over (partition by a) FROM MyTable\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testDenseRankWithMultiGroups() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT DENSE_RANK() over (partition by a order by b) as a,\n        |       DENSE_RANK() over (partition by b) as b\n        |       FROM MyTable\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testRankValueFilterWithUpperValue() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a) rk FROM MyTable) t\n        |WHERE rk <= 2 AND a > 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithRange() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b, c ORDER BY a) rk FROM MyTable) t\n        |WHERE rk <= 2 AND rk > -2\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithEquals() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a, c) rk FROM MyTable) t\n        |WHERE rk = 2\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testWithoutPartitionBy() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (ORDER BY a) rk FROM MyTable) t\n        |WHERE rk < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testMultiSameRankFunctionsWithSameGroup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk1,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk2 FROM MyTable) t\n        |WHERE rk1 < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDuplicateRankFunctionColumnName() {
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rk"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.RankTest$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a) rk FROM MyTable2) t\n        |WHERE rk < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRankFunctionInMiddle() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, RANK() OVER (PARTITION BY a ORDER BY a) rk, b, c FROM MyTable) t\n        |WHERE rk < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCreateViewWithRowNumber() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE test_source (\n                    |  name STRING,\n                    |  eat STRING,\n                    |  age BIGINT\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'bounded' = 'true'\n                    |)\n      ")).stripMargin());
        this.util().tableEnv().executeSql("create view view1 as select name, eat ,sum(age) as cnt\nfrom test_source group by name, eat");
        this.util().tableEnv().executeSql("create view view2 as\nselect *, ROW_NUMBER() OVER (PARTITION BY name ORDER BY cnt DESC) as row_num\nfrom view1");
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n         |create table sink (\n         |  name varchar,\n         |  eat varchar,\n         |  cnt bigint\n         |)\n         |with(\n         |  'connector' = 'print'\n         |)\n         |")).stripMargin());
        this.util().verifyExecPlanInsert("insert into sink select name, eat, cnt\nfrom view2 where row_num <= 3");
    }

    @Test
    public void testRankWithAnotherRankAsInput() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT CAST(rna AS INT) AS rn1, CAST(rnb AS INT) AS rn2 FROM (\n        |  SELECT *, row_number() over (partition by a order by b desc) AS rnb\n        |  FROM (\n        |    SELECT *, row_number() over (partition by a, c order by b desc) AS rna\n        |    FROM MyTable\n        |  )\n        |  WHERE rna <= 100\n        |)\n        |WHERE rnb <= 200\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRedundantRankNumberColumnRemove() {
        this.util().addDataStream("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "uri")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "reqcount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "start_time")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "bucket_id"))}), new CaseClassTypeInfo<Tuple4<String, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple4<String, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.RankTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  CONCAT('http://txmov2.a.yximgs.com', uri) AS url,\n        |  reqcount AS download_count,\n        |  start_time AS `timestamp`\n        |FROM\n        |  (\n        |    SELECT\n        |      uri,\n        |      reqcount,\n        |      rownum_2,\n        |      start_time\n        |    FROM\n        |      (\n        |        SELECT\n        |          uri,\n        |          reqcount,\n        |          start_time,\n        |          RANK() OVER (\n        |            PARTITION BY start_time\n        |            ORDER BY\n        |              reqcount DESC\n        |          ) AS rownum_2\n        |        FROM\n        |          (\n        |            SELECT\n        |            uri,\n        |            reqcount,\n        |            start_time,\n        |            RANK() OVER (\n        |                PARTITION BY start_time, bucket_id\n        |                ORDER BY\n        |                reqcount DESC\n        |            ) AS rownum_1\n        |            FROM MyTable1\n        |          )\n        |        WHERE\n        |          rownum_1 <= 100000\n        |      )\n        |    WHERE\n        |      rownum_2 <= 100000\n        |  )\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    public RankTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.RankTest$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

