/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalSortMergeJoinRule$;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalSortRule$;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableFunc1;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001'\t\u0019\"+Z7pm\u0016\u001cu\u000e\u001c7bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004gFd'BA\u0003\u0007\u0003\u0015\u0011\u0017\r^2i\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\u0006kRLGn]\u0005\u00033Y\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\n\u0005\nA!\u001e;jYV\t!\u0005\u0005\u0002\u0016G%\u0011AE\u0006\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG\u000e\u0003\u0004'\u0001\u0001\u0006IAI\u0001\u0006kRLG\u000e\t\u0005\u0006Q\u0001!\t!K\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t!QK\\5uQ\t9\u0013\u0007\u0005\u00023s5\t1G\u0003\u00025k\u0005\u0019\u0011\r]5\u000b\u0005Y:\u0014a\u00026va&$XM\u001d\u0006\u0003qA\tQA[;oSRL!AO\u001a\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0003=\u0001\u0011\u0005\u0011&A\u0011uKN$(+Z7pm\u0016\u001cu\u000e\u001c7bi&|gnX(wKJ<\u0016N\u001c3po\u0006;w\r\u000b\u0002<}A\u0011!gP\u0005\u0003\u0001N\u0012A\u0001V3ti\")!\t\u0001C\u0001S\u0005iB/Z:u%\u0016lwN^3D_2d\u0017\r^5p]~\u000bum\u001a:fO\u0006$X\r\u000b\u0002B}!)Q\t\u0001C\u0001S\u0005yB/Z:u%\u0016lwN^3D_2d\u0017\r^5p]~\u000bum\u001a:fO\u0006$XmX\u0019)\u0005\u0011s\u0004\"\u0002%\u0001\t\u0003I\u0013\u0001\u0007;fgR\u0014V-\\8wK\u000e{G\u000e\\1uS>twlU8si\"\u0012qI\u0010\u0005\u0006\u0017\u0002!\t!K\u0001 i\u0016\u001cHOU3n_Z,7i\u001c7mCRLwN\\0BO\u001e\u0014XmZ1uK~\u001b\u0004F\u0001&?\u0011\u0015q\u0005\u0001\"\u0001*\u0003i!Xm\u001d;SK6|g/Z\"pY2\fG/[8o?J\u000bgn[02Q\tie\bC\u0003R\u0001\u0011\u0005\u0011&\u0001\u000euKN$(+Z7pm\u0016\u001cu\u000e\u001c7bi&|gn\u0018*b].|&\u0007\u000b\u0002Q}!)A\u000b\u0001C\u0001S\u0005QB/Z:u%\u0016lwN^3D_2d\u0017\r^5p]~\u0013\u0016M\\6`g!\u00121K\u0010\u0005\u0006/\u0002!\t!K\u0001\u001bi\u0016\u001cHOU3n_Z,7i\u001c7mCRLwN\\0SC:\\w\f\u000e\u0015\u0003-zBQA\u0017\u0001\u0005\u0002%\n!\u0005^3tiJ+Wn\u001c<f\u0007>dG.\u0019;j_:|&+\u00198l?NKgn\u001a7fi>t\u0007FA-?\u0011\u0015i\u0006\u0001\"\u0001*\u0003-\"Xm\u001d;SK6|g/Z\"pY2\fG/[8o?6+H\u000e^5qY\u0016\u001cvN\u001d;NKJ<WMS8j]N\f\u0004F\u0001/?\u0011\u0015\u0001\u0007\u0001\"\u0001*\u0003e\"Xm\u001d;SK6|g/Z\"pY2\fG/[8o?6+H\u000e^5qY\u0016\u001cvN\u001d;NKJ<WMS8j]N|V*\u001e7uS*{\u0017N\\&fsN\f\u0004FA0?\u0011\u0015\u0019\u0007\u0001\"\u0001*\u0003-\"Xm\u001d;SK6|g/Z\"pY2\fG/[8o?6+H\u000e^5qY\u0016\u001cvN\u001d;NKJ<WMS8j]N\u0014\u0004F\u00012?\u0011\u00151\u0007\u0001\"\u0001*\u0003e\"Xm\u001d;SK6|g/Z\"pY2\fG/[8o?6+H\u000e^5qY\u0016\u001cvN\u001d;NKJ<WMS8j]N|V*\u001e7uS*{\u0017N\\&fsN\u0014\u0004FA3?\u0011\u0015I\u0007\u0001\"\u0001*\u0003-\"Xm\u001d;SK6|g/Z\"pY2\fG/[8o?6+H\u000e^5qY\u0016\u001cvN\u001d;NKJ<WMS8j]N\u001c\u0004F\u00015?\u0011\u0015a\u0007\u0001\"\u0001*\u0003y!Xm\u001d;SK6|g/Z\"pY2\fG/[8o?\u000e{'O]3mCR,\u0017\u0007\u000b\u0002l}!)q\u000e\u0001C\u0001S\u0005qB/Z:u%\u0016lwN^3D_2d\u0017\r^5p]~\u001buN\u001d:fY\u0006$XM\r\u0015\u0003]zBQA\u001d\u0001\u0005\u0002%\na\u0004^3tiJ+Wn\u001c<f\u0007>dG.\u0019;j_:|6i\u001c:sK2\fG/Z\u001a)\u0005Et\u0004")
public class RemoveCollationTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTableSource("x", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"a", "b", "c"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100L)).build());
        this.util().addTableSource("y", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"d", "e", "f"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100L)).build());
        this.util().addTableSource("t1", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"a1", "b1", "c1"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100L)).build());
        this.util().addTableSource("t2", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"d1", "e1", "f1"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100L)).build());
        this.util().tableEnv().getConfig().set(BatchPhysicalSortMergeJoinRule$.MODULE$.TABLE_OPTIMIZER_SMJ_REMOVE_SORT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    @Test
    public void testRemoveCollation_OverWindowAgg() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,HashAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT\n        |   SUM(b) sum_b,\n        |   AVG(SUM(b)) OVER (PARTITION BY a order by a) avg_b,\n        |   RANK() OVER (PARTITION BY a ORDER BY a) rn\n        | FROM x\n        | GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveCollation_Aggregate() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveCollation_Aggregate_1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveCollation_Sort() {
        this.util().tableEnv().getConfig().set(BatchPhysicalSortRule$.MODULE$.TABLE_EXEC_RANGE_SORT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, COUNT(c) AS cnt FROM x GROUP BY a, b)\n        |SELECT * FROM r ORDER BY a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRemoveCollation_Aggregate_3() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        this.util().tableEnv().getConfig().set(BatchPhysicalSortRule$.MODULE$.TABLE_EXEC_RANGE_SORT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x ORDER BY a, b)\n        |SELECT a, b, COUNT(c) AS cnt FROM r GROUP BY a, b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveCollation_Rank_1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, SUM(b) FROM (\n        | SELECT * FROM (\n        |   SELECT a, b, RANK() OVER(PARTITION BY a ORDER BY b) rk FROM x)\n        | WHERE rk <= 10\n        |) GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveCollation_Rank_2() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, MAX(c) FROM (\n        | SELECT * FROM (\n        |   SELECT a, b, c, RANK() OVER(PARTITION BY a ORDER BY b) rk FROM x)\n        | WHERE rk <= 10\n        |) GROUP BY a, b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveCollation_Rank_3() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, c, RANK() OVER(PARTITION BY a ORDER BY b) rk FROM (\n        |   SELECT a, b, c FROM x ORDER BY a, b\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveCollation_Rank_4() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, c, RANK() OVER(PARTITION BY a ORDER BY a) rk FROM (\n        |   SELECT a, COUNT(c) AS c FROM x GROUP BY a\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveCollation_Rank_Singleton() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(a), SUM(b) FROM (\n        | SELECT * FROM (\n        |   SELECT a, b, RANK() OVER(ORDER BY b) rk FROM x)\n        | WHERE rk <= 10\n        |)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveCollation_MultipleSortMergeJoins1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |   x join y on a = d\n        |   join t1 on a = a1\n        |   left outer join t2 on a = d1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRemoveCollation_MultipleSortMergeJoins_MultiJoinKeys1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |   x join y on a = d and b = e\n        |   join t1 on a = a1 and b = b1\n        |   left outer join t2 on a = d1 and b = e1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRemoveCollation_MultipleSortMergeJoins2() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |   x join y on a = d\n        |   join t1 on d = a1\n        |   left outer join t2 on a1 = d1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRemoveCollation_MultipleSortMergeJoins_MultiJoinKeys2() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |   x join y on a = d and b = e\n        |   join t1 on d = a1 and e = b1\n        |   left outer join t2 on a1 = d1 and b1 = e1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRemoveCollation_MultipleSortMergeJoins3() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        this.util().addTableSource("tb1", (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.STRING(), Types.STRING(), Types.STRING(), Types.STRING()}), (String[])((Object[])new String[]{"id", "key", "tb2_ids", "tb3_ids", "name"}), FlinkStatistic$.MODULE$.builder().uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"id"))).build());
        this.util().addTableSource("tb2", (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.STRING()}), (String[])((Object[])new String[]{"id", "name"}), FlinkStatistic$.MODULE$.builder().uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"id"))).build());
        this.util().addTableSource("tb3", (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.STRING()}), (String[])((Object[])new String[]{"id", "name"}), FlinkStatistic$.MODULE$.builder().uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"id"))).build());
        this.util().addTableSource("tb4", (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.STRING()}), (String[])((Object[])new String[]{"id", "name"}), FlinkStatistic$.MODULE$.builder().uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"id"))).build());
        this.util().addTableSource("tb5", (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.STRING()}), (String[])((Object[])new String[]{"id", "name"}), FlinkStatistic$.MODULE$.builder().uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"id"))).build());
        this.util().addTemporarySystemFunction("split", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |with v1 as (\n        | select id, tb2_id from tb1, LATERAL TABLE(split(tb2_ids)) AS T(tb2_id)\n        |),\n        |v2 as (\n        | select id, tb3_id from tb1, LATERAL TABLE(split(tb3_ids)) AS T(tb3_id)\n        |),\n        |\n        |join_tb2 as (\n        | select tb1_id, LISTAGG(tb2_name, ',') as tb2_names\n        | from (\n        |  select v1.id as tb1_id, tb2.name as tb2_name\n        |   from v1 left outer join tb2 on tb2_id = tb2.id\n        | ) group by tb1_id\n        |),\n        |\n        |join_tb3 as (\n        | select tb1_id, LISTAGG(tb3_name, ',') as tb3_names\n        | from (\n        |  select v2.id as tb1_id, tb3.name as tb3_name\n        |   from v2 left outer join tb3 on tb3_id = tb3.id\n        | ) group by tb1_id\n        |)\n        |\n        |select\n        |   tb1.id,\n        |   tb1.tb2_ids,\n        |   tb1.tb3_ids,\n        |   tb1.name,\n        |   tb2_names,\n        |   tb3_names,\n        |   tb4.name,\n        |   tb5.name\n        | from tb1\n        |   left outer join join_tb2 on tb1.id = join_tb2.tb1_id\n        |   left outer join join_tb3 on tb1.id = join_tb3.tb1_id\n        |   left outer join tb4 on tb1.key = tb4.id\n        |   left outer join tb5 on tb1.key = tb5.id\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRemoveCollation_Correlate1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin,HashAgg");
        this.util().addTemporarySystemFunction("split", (UserDefinedFunction)new TableFunc1());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT f, count(f) as cnt FROM y GROUP BY f),\n        |     v as (SELECT f1, f, cnt FROM r, LATERAL TABLE(split(f)) AS T(f1))\n        |SELECT * FROM x, v WHERE c = f\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveCollation_Correlate2() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin,HashAgg");
        this.util().addTemporarySystemFunction("split", (UserDefinedFunction)new TableFunc1());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT f, count(f) as cnt FROM y GROUP BY f),\n        |     v as (SELECT f, f1 FROM r, LATERAL TABLE(split(f)) AS T(f1))\n        |SELECT * FROM x, v WHERE c = f AND f LIKE '%llo%'\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveCollation_Correlate3() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin,HashAgg");
        this.util().addTemporarySystemFunction("split", (UserDefinedFunction)new TableFunc1());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT f, count(f) as cnt FROM y GROUP BY f),\n        |     v as (SELECT f1 FROM r, LATERAL TABLE(split(f)) AS T(f1))\n        |SELECT * FROM x, v WHERE c = f1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }
}

