/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalJoinRuleBase$;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalSortMergeJoinRule$;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableFunc1;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001M\u0011\u0011CU3n_Z,7\u000b[;gM2,G+Z:u\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\u000b\t\fGo\u00195\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"A\u0003vi&d7/\u0003\u0002\u001a-\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\u0005C\u0005!Q\u000f^5m+\u0005\u0011\u0003CA\u000b$\u0013\t!cC\u0001\nCCR\u001c\u0007\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\u0003tKR,\b\u000fF\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;)\u0005\u001d\n\u0004C\u0001\u001a:\u001b\u0005\u0019$B\u0001\u001b6\u0003\r\t\u0007/\u001b\u0006\u0003m]\nqA[;qSR,'O\u0003\u00029!\u0005)!.\u001e8ji&\u0011!h\r\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0007\"\u0002\u001f\u0001\t\u0003I\u0013a\t;fgR\u0014V-\\8wK\"\u000b7\u000f[*ik\u001a4G.Z0Pm\u0016\u0014x+\u001b8e_^\fum\u001a\u0015\u0003wy\u0002\"AM \n\u0005\u0001\u001b$\u0001\u0002+fgRDQA\u0011\u0001\u0005\u0002%\n\u0001\u0006^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWmX'vYRLwJ^3s/&tGm\\<BO\u001eD#!\u0011 \t\u000b\u0015\u0003A\u0011A\u0015\u0002]Q,7\u000f\u001e*f[>4X\rS1tQNCWO\u001a4mK~{e/\u001a:XS:$wn^!hO~\u0003\u0016M\u001d;jC2\\U-\u001f\u0015\u0003\tzBQ\u0001\u0013\u0001\u0005\u0002%\nA\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWmX!hO~\u0003\u0016M\u001d;jC2\\U-\u001f\u0015\u0003\u000fzBQa\u0013\u0001\u0005\u0002%\n1\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWm\u0018%bg\"\fum\u001a:fO\u0006$X\r\u000b\u0002K}!)a\n\u0001C\u0001S\u0005)C/Z:u%\u0016lwN^3ICND7\u000b[;gM2,w\fS1tQ\u0006;wM]3hCR,w,\r\u0015\u0003\u001bzBQ!\u0015\u0001\u0005\u0002%\nQ\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWm\u0018%bg\"\fum\u001a:fO\u0006$Xm\u0018\u001a)\u0005As\u0004\"\u0002+\u0001\t\u0003I\u0013a\t;fgR\u0014V-\\8wK\"\u000b7\u000f[*ik\u001a4G.Z0T_J$\u0018iZ4sK\u001e\fG/\u001a\u0015\u0003'zBQa\u0016\u0001\u0005\u0002%\nQ\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWmX*peR\fum\u001a:fO\u0006$XmX\u0019)\u0005Ys\u0004\"\u0002.\u0001\t\u0003I\u0013!\n;fgR\u0014V-\\8wK\"\u000b7\u000f[*ik\u001a4G.Z0T_J$\u0018iZ4sK\u001e\fG/Z03Q\tIf\bC\u0003^\u0001\u0011\u0005\u0011&A\u0012uKN$(+Z7pm\u0016D\u0015m\u001d5TQV4g\r\\3`'>\u0014H/T3sO\u0016Tu.\u001b8)\u0005qs\u0004\"\u00021\u0001\t\u0003I\u0013a\n;fgR\u0014V-\\8wK\"\u000b7\u000f[*ik\u001a4G.Z0T_J$X*\u001a:hK*{\u0017N\\0M\u001f*C#a\u0018 \t\u000b\r\u0004A\u0011A\u0015\u0002OQ,7\u000f\u001e*f[>4X\rS1tQNCWO\u001a4mK~\u001bvN\u001d;NKJ<WMS8j]~\u0013vJ\u0013\u0015\u0003EzBQA\u001a\u0001\u0005\u0002%\nq\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWmX*peRlUM]4f\u0015>Lgn\u0018$P\u0015\"\u0012QM\u0010\u0005\u0006S\u0002!\t!K\u0001\u001fi\u0016\u001cHOU3n_Z,\u0007*Y:i'\",hM\u001a7f?\"\u000b7\u000f\u001b&pS:D#\u0001\u001b \t\u000b1\u0004A\u0011A\u0015\u0002OQ,7\u000f\u001e*f[>4X\rS1tQNCWO\u001a4mK~\u0013%o\\1eG\u0006\u001cH\u000fS1tQ*{\u0017N\u001c\u0015\u0003WzBQa\u001c\u0001\u0005\u0002%\n!\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWm\u0018%bg\"Tu.\u001b8`\u0019>S\u0005F\u00018?\u0011\u0015\u0011\b\u0001\"\u0001*\u0003\t\"Xm\u001d;SK6|g/\u001a%bg\"\u001c\u0006.\u001e4gY\u0016|\u0006*Y:i\u0015>Lgn\u0018*P\u0015\"\u0012\u0011O\u0010\u0005\u0006k\u0002!\t!K\u0001#i\u0016\u001cHOU3n_Z,\u0007*Y:i'\",hM\u001a7f?\"\u000b7\u000f\u001b&pS:|fi\u0014&)\u0005Qt\u0004\"\u0002=\u0001\t\u0003I\u0013\u0001\t;fgR\u0014V-\\8wK\"\u000b7\u000f[*ik\u001a4G.Z0ICND'j\\5o?FB#a\u001e \t\u000bm\u0004A\u0011A\u0015\u0002IQ,7\u000f\u001e*f[>4X\rS1tQNCWO\u001a4mK~sUm\u001d;fI2{w\u000e\u001d&pS:D#A\u001f \t\u000by\u0004A\u0011A\u0015\u0002KQ,7\u000f\u001e*f[>4X\rS1tQNCWO\u001a4mK~Su.\u001b8`!\u0006\u0014H/[1m\u0017\u0016L\bFA??\u0011\u0019\t\u0019\u0001\u0001C\u0001S\u0005aB/Z:u%\u0016lwN^3TS:<G.Z#yG\"\fgnZ3`\u0003\u001e<\u0007fAA\u0001}!1\u0011\u0011\u0002\u0001\u0005\u0002%\n1\u0004^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWmX+oS>t\u0007fAA\u0004}!1\u0011q\u0002\u0001\u0005\u0002%\n!\u0004^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWm\u0018*b].D3!!\u0004?\u0011\u0019\t)\u0002\u0001C\u0001S\u00051C/Z:u%\u0016lwN^3ICND7\u000b[;gM2,wLU1oW~\u0003\u0016M\u001d;jC2\\U-_\u0019)\u0007\u0005Ma\b\u0003\u0004\u0002\u001c\u0001!\t!K\u0001'i\u0016\u001cHOU3n_Z,\u0007*Y:i'\",hM\u001a7f?J\u000bgn[0QCJ$\u0018.\u00197LKf\u0014\u0004fAA\r}!1\u0011\u0011\u0005\u0001\u0005\u0002%\na\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWm\u0018*b].|\u0006+\u0019:uS\u0006d7*Z=4Q\r\tyB\u0010\u0005\u0007\u0003O\u0001A\u0011A\u0015\u0002KQ,7\u000f\u001e*f[>4X\rS1tQNCWO\u001a4mK~\u0013\u0016M\\6`'&tw\r\\3u_:\f\u0004fAA\u0013}!1\u0011Q\u0006\u0001\u0005\u0002%\nQ\u0005^3tiJ+Wn\u001c<f\u0011\u0006\u001c\bn\u00155vM\u001adWm\u0018*b].|6+\u001b8hY\u0016$xN\u001c\u001a)\u0007\u0005-b\b\u0003\u0004\u00024\u0001!\t!K\u0001!i\u0016\u001cHOU3n_Z,\u0007*Y:i'\",hM\u001a7f?\u000e{'O]3mCR,\u0017\u0007K\u0002\u00022yBa!!\u000f\u0001\t\u0003I\u0013\u0001\t;fgR\u0014V-\\8wK\"\u000b7\u000f[*ik\u001a4G.Z0D_J\u0014X\r\\1uKJB3!a\u000e?\u0011\u0019\ty\u0004\u0001C\u0001S\u0005\u0001C/Z:u%\u0016lwN^3ICND7\u000b[;gM2,wlQ8se\u0016d\u0017\r^34Q\r\tiD\u0010\u0005\u0007\u0003\u000b\u0002A\u0011A\u0015\u0002EQ,7\u000f\u001e*f[>4XmU5oO2,Go\u001c8TQV4g\r\\3`\u001fZ,'/Q4hQ\r\t\u0019E\u0010\u0005\u0007\u0003\u0017\u0002A\u0011A\u0015\u0002EQ,7\u000f\u001e*f[>4XmU5oO2,Go\u001c8TQV4g\r\\3`\u0011\u0006\u001c\b.Q4hQ\r\tIE\u0010\u0005\u0007\u0003#\u0002A\u0011A\u0015\u0002EQ,7\u000f\u001e*f[>4XmU5oO2,Go\u001c8TQV4g\r\\3`'>\u0014H/Q4hQ\r\tyE\u0010")
public class RemoveShuffleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTableSource("x", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"a", "b", "c"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100L)).build());
        this.util().addTableSource("y", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()}), (String[])((Object[])new String[]{"d", "e", "f"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100L)).build());
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Test
    public void testRemoveHashShuffle_OverWindowAgg() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT\n        |   SUM(b) sum_b,\n        |   AVG(SUM(b)) OVER (PARTITION BY c) avg_b,\n        |   RANK() OVER (PARTITION BY c ORDER BY c) rn,\n        |   c\n        | FROM x\n        | GROUP BY c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_MultiOverWindowAgg() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT\n        |   SUM(b) sum_b,\n        |   AVG(SUM(b)) OVER (PARTITION BY a, c) avg_b,\n        |   RANK() OVER (PARTITION BY c ORDER BY a, c) rn,\n        |   c\n        | FROM x\n        | GROUP BY a, c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_OverWindowAgg_PartialKey() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        this.util().tableEnv().getConfig().set(BatchPhysicalJoinRuleBase$.MODULE$.TABLE_OPTIMIZER_SHUFFLE_BY_PARTIAL_KEY_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT\n        |   SUM(b) sum_b,\n        |   AVG(SUM(b)) OVER (PARTITION BY c) avg_b,\n        |   RANK() OVER (PARTITION BY c ORDER BY c) rn,\n        |   c\n        | FROM x\n        | GROUP BY a, c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Agg_PartialKey() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        this.util().tableEnv().getConfig().set(BatchPhysicalJoinRuleBase$.MODULE$.TABLE_OPTIMIZER_SHUFFLE_BY_PARTIAL_KEY_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | WITH r AS (SELECT a, c, count(b) as cnt FROM x GROUP BY a, c)\n        | SELECT count(cnt) FROM r group by c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashAggregate() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashAggregate_1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by a, d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashAggregate_2() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortAggregate() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,HashAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortAggregate_1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,HashAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by a, d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortAggregate_2() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,HashAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT sum(b) FROM r group by d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortMergeJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        this.util().tableEnv().getConfig().set(BatchPhysicalSortMergeJoinRule$.MODULE$.TABLE_OPTIMIZER_SMJ_REMOVE_SORT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortMergeJoin_LOJ() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        this.util().tableEnv().getConfig().set(BatchPhysicalSortMergeJoinRule$.MODULE$.TABLE_OPTIMIZER_SMJ_REMOVE_SORT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x left join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortMergeJoin_ROJ() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        this.util().tableEnv().getConfig().set(BatchPhysicalSortMergeJoinRule$.MODULE$.TABLE_OPTIMIZER_SMJ_REMOVE_SORT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x right join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_SortMergeJoin_FOJ() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x full join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_BroadcastHashJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashJoin_LOJ() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x left join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashJoin_ROJ() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x right join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashJoin_FOJ() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x full join (SELECT * FROM y WHERE e = 2) r on a = d)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_HashJoin_1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r1 AS (SELECT a, c, sum(b) FROM x group by a, c),\n        |r2 AS (SELECT a, c, sum(b) FROM x group by a, c)\n        |SELECT * FROM r1, r2 WHERE r1.a = r2.a and r1.c = r2.c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_NestedLoopJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Join_PartialKey() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.util().tableEnv().getConfig().set(BatchPhysicalJoinRuleBase$.MODULE$.TABLE_OPTIMIZER_SHUFFLE_BY_PARTIAL_KEY_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT d, count(f) as cnt FROM y GROUP BY d)\n        |SELECT * FROM x, r WHERE x.a = r.d AND x.b = r.cnt\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveSingleExchange_Agg() {
        String sqlQuery = "SELECT avg(b) FROM x GROUP BY c  HAVING sum(b) > (SELECT sum(b) * 0.1 FROM x)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Union() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (\n        |SELECT count(a) as cnt, c FROM x WHERE b > 10 group by c\n        |UNION ALL\n        |SELECT count(d) as cnt, f FROM y WHERE e < 100 group by f)\n        |SELECT r1.c, r1.cnt, r2.c, r2.cnt FROM r r1, r r2 WHERE r1.c = r2.c and r1.cnt < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER(PARTITION BY a ORDER BY b) rk FROM (\n        |   SELECT a, SUM(b) AS b FROM x GROUP BY a\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank_PartialKey1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortAgg");
        this.util().tableEnv().getConfig().set(BatchPhysicalJoinRuleBase$.MODULE$.TABLE_OPTIMIZER_SHUFFLE_BY_PARTIAL_KEY_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, SUM(b) FROM (\n        | SELECT * FROM (\n        |   SELECT a, b, c, RANK() OVER(PARTITION BY a, c ORDER BY b) rk FROM x)\n        | WHERE rk <= 10\n        |) GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank_PartialKey2() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortAgg");
        this.util().tableEnv().getConfig().set(BatchPhysicalJoinRuleBase$.MODULE$.TABLE_OPTIMIZER_SHUFFLE_BY_PARTIAL_KEY_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, c, RANK() OVER(PARTITION BY a, c ORDER BY b) rk FROM (\n        |   SELECT a, SUM(b) AS b, COUNT(c) AS c FROM x GROUP BY a\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank_PartialKey3() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortAgg");
        this.util().tableEnv().getConfig().set(BatchPhysicalJoinRuleBase$.MODULE$.TABLE_OPTIMIZER_SHUFFLE_BY_PARTIAL_KEY_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, c, RANK() OVER(PARTITION BY a, c ORDER BY b) rk FROM (\n        |   SELECT a, SUM(b) AS b, COUNT(c) AS c FROM x GROUP BY a\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank_Singleton1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER(ORDER BY b) rk FROM (\n        |   SELECT COUNT(a) AS a, SUM(b) AS b FROM x\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Rank_Singleton2() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER(PARTITION BY a ORDER BY b) rk FROM (\n        |   SELECT COUNT(a) AS a, SUM(b) AS b FROM x\n        | )\n        |) WHERE rk <= 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Correlate1() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.util().addTemporarySystemFunction("split", (UserDefinedFunction)new TableFunc1());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT f, count(f) as cnt FROM y GROUP BY f),\n        |     v as (SELECT f1, f, cnt FROM r, LATERAL TABLE(split(f)) AS T(f1))\n        |SELECT * FROM x, v WHERE c = f\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Correlate2() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.util().addTemporarySystemFunction("split", (UserDefinedFunction)new TableFunc1());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT f, count(f) as cnt FROM y GROUP BY f),\n        |     v as (SELECT f, f1 FROM r, LATERAL TABLE(split(f)) AS T(f1))\n        |SELECT * FROM x, v WHERE c = f AND f LIKE '%llo%'\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveHashShuffle_Correlate3() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortMergeJoin,NestedLoopJoin,SortAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.util().addTemporarySystemFunction("split", (UserDefinedFunction)new TableFunc1());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT f, count(f) as cnt FROM y GROUP BY f),\n        |     v as (SELECT f1 FROM r, LATERAL TABLE(split(f)) AS T(f1))\n        |SELECT * FROM x, v WHERE c = f1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRemoveSingletonShuffle_OverAgg() {
        this.util().verifyExecPlan("SELECT SUM(b) sum_b, AVG(SUM(b)) OVER () avg_b FROM x");
    }

    @Test
    public void testRemoveSingletonShuffle_HashAgg() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"SortAgg");
        this.util().verifyExecPlan("SELECT MAX(b) FROM (SELECT SUM(b) AS b FROM x)");
    }

    @Test
    public void testRemoveSingletonShuffle_SortAgg() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        this.util().verifyExecPlan("SELECT MAX(b) FROM (SELECT SUM(b) AS b FROM x)");
    }
}

