/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.batch.sql.SubplanReuseTest$;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalSortMergeJoinRule$;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalSortRule$;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.runtime.functions.aggregate.FirstValueAggFunction;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\u0001\u0003\u0001M\u0011\u0001cU;ca2\fgNU3vg\u0016$Vm\u001d;\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0011)H/\u001b7\u0016\u0003\t\u0002\"!F\u0012\n\u0005\u00112\"A\u0005\"bi\u000eDG+\u00192mKR+7\u000f^+uS2DaA\n\u0001!\u0002\u0013\u0011\u0013!B;uS2\u0004\u0003\"\u0002\u0015\u0001\t\u0003I\u0013A\u00022fM>\u0014X\rF\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;)\u0005\u001d\n\u0004C\u0001\u001a:\u001b\u0005\u0019$B\u0001\u001b6\u0003\r\t\u0007/\u001b\u0006\u0003m]\nqA[;qSR,'O\u0003\u00029!\u0005)!.\u001e8ji&\u0011!h\r\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0007\"\u0002\u001f\u0001\t\u0003I\u0013a\u0006;fgR$\u0015n]1cY\u0016\u001cVO\u00199mC:\u0014V-^:fQ\tYd\b\u0005\u00023\u007f%\u0011\u0001i\r\u0002\u0005)\u0016\u001cH\u000fC\u0003C\u0001\u0011\u0005\u0011&\u0001\u0013uKN$8+\u001e2qY\u0006t'+Z;tK^KG\u000f\u001b#jM\u001a,'/\u001a8u%><H+\u001f9fQ\t\te\bC\u0003F\u0001\u0011\u0005\u0011&\u0001\u000euKN$XI\\1cY\u0016\u0014V-^:f)\u0006\u0014G.Z*pkJ\u001cW\r\u000b\u0002E}!)\u0001\n\u0001C\u0001S\u0005YB/Z:u\t&\u001c\u0018M\u00197f%\u0016,8/\u001a+bE2,7k\\;sG\u0016D#a\u0012 \t\u000b-\u0003A\u0011A\u0015\u0002CQ,7\u000f^*vEBd\u0017M\u001c*fkN,wJ\\*pkJ\u001cWmV5uQ2KW.\u001b;)\u0005)s\u0004\"\u0002(\u0001\t\u0003I\u0013!\t;fgR\u001cVO\u00199mC:\u0014V-^:f\u001f:$\u0015\r^1TiJ,\u0017-\u001c+bE2,\u0007FA'?\u0011\u0015\t\u0006\u0001\"\u0001*\u0003Y!Xm\u001d;Tk\n\u0004H.\u00198SKV\u001cXm\u00148DC2\u001c\u0007F\u0001)?\u0011\u0015!\u0006\u0001\"\u0001*\u0003E\"Xm\u001d;Tk\n\u0004H.\u00198SKV\u001cXm\u00148DC2\u001cw+\u001b;i\u001d>tG)\u001a;fe6Lg.[:uS\u000e\u0004&o\u001c6fGRD#a\u0015 \t\u000b]\u0003A\u0011A\u0015\u0002[Q,7\u000f^*vEBd\u0017M\u001c*fkN,wJ\\\"bY\u000e<\u0016\u000e\u001e5O_:$U\r^3s[&t\u0017n\u001d;jGV#g\r\u000b\u0002W}!)!\f\u0001C\u0001S\u0005QB/Z:u'V\u0014\u0007\u000f\\1o%\u0016,8/Z(o\u000bb\u001c\u0007.\u00198hK\"\u0012\u0011L\u0010\u0005\u0006;\u0002!\t!K\u0001 i\u0016\u001cHoU;ca2\fgNU3vg\u0016|e\u000eS1tQ\u0006;wM]3hCR,\u0007F\u0001/?\u0011\u0015\u0001\u0007\u0001\"\u0001*\u0003}!Xm\u001d;Tk\n\u0004H.\u00198SKV\u001cXm\u00148T_J$\u0018iZ4sK\u001e\fG/\u001a\u0015\u0003?zBQa\u0019\u0001\u0005\u0002%\na\u0007^3tiN+(\r\u001d7b]J+Wo]3P]\u0006;wM]3hCR,w+\u001b;i\u001d>tG)\u001a;fe6Lg.[:uS\u000e\fumZ\"bY2D#A\u0019 \t\u000b\u0019\u0004A\u0011A\u0015\u0002-Q,7\u000f^*vEBd\u0017M\u001c*fkN,wJ\\*peRD#!\u001a \t\u000b%\u0004A\u0011A\u0015\u0002/Q,7\u000f^*vEBd\u0017M\u001c*fkN,wJ\u001c'j[&$\bF\u00015?\u0011\u0015a\u0007\u0001\"\u0001*\u0003m!Xm\u001d;Tk\n\u0004H.\u00198SKV\u001cXm\u00148T_J$H*[7ji\"\u00121N\u0010\u0005\u0006_\u0002!\t!K\u0001\u0018i\u0016\u001cHoU;ca2\fgNU3vg\u0016|e.\u00168j_:D#A\u001c \t\u000bI\u0004A\u0011A\u0015\u0002-Q,7\u000f^*vEBd\u0017M\u001c*fkN,wJ\u001c&pS:D#!\u001d \t\u000bU\u0004A\u0011A\u0015\u0002?Q,7\u000f^*vEBd\u0017M\u001c*fkN,wJ\\*peRlUM]4f\u0015>Lg\u000e\u000b\u0002u}!)\u0001\u0010\u0001C\u0001S\u0005QB/Z:u'V\u0014\u0007\u000f\\1o%\u0016,8/Z(o\u0011\u0006\u001c\bNS8j]\"\u0012qO\u0010\u0005\u0006w\u0002!\t!K\u0001!i\u0016\u001cHoU;ca2\fgNU3vg\u0016|eNT3ti\u0016$Gj\\8q\u0015>Lg\u000e\u000b\u0002{}!)a\u0010\u0001C\u0001S\u0005\u0019D/Z:u'V\u0014\u0007\u000f\\1o%\u0016,8/Z(o\u0015>LgNT8o\t\u0016$XM]7j]&\u001cH/[2K_&t7i\u001c8eSRLwN\u001c\u0015\u0003{zBa!a\u0001\u0001\t\u0003I\u0013\u0001\b;fgR\u001cVO\u00199mC:\u0014V-^:f\u001f:|e/\u001a:XS:$wn\u001e\u0015\u0004\u0003\u0003q\u0004BBA\u0005\u0001\u0011\u0005\u0011&\u0001\u000fuKN$8+\u001e2qY\u0006t'+Z;tK>s7k\u001c:uK\u00124\u0016.Z<)\u0007\u0005\u001da\b\u0003\u0004\u0002\u0010\u0001!\t!K\u00018i\u0016\u001cHoU;ca2\fgNU3vg\u0016|en\u0014<fe^Kg\u000eZ8x/&$\bNT8o\t\u0016$XM]7j]&\u001cH/[2BO\u001e\u001c\u0015\r\u001c7)\u0007\u00055a\b\u0003\u0004\u0002\u0016\u0001!\t!K\u0001\u001ci\u0016\u001cHoU;ca2\fgNU3vg\u0016|enQ8se\u0016d\u0017\r^3)\u0007\u0005Ma\b\u0003\u0004\u0002\u001c\u0001!\t!K\u00014i\u0016\u001cHoU;ca2\fgNU3vg\u0016|enQ8se\u0016d\u0017\r^3XSRDgj\u001c8EKR,'/\\5oSN$\u0018nY+E)\u001aC3!!\u0007?\u0011\u0019\t\t\u0003\u0001C\u0001S\u0005\u0019C/Z:u'V\u0014\u0007\u000f\\1o%\u0016,8/Z,ji\"$\u0015P\\1nS\u000e4UO\\2uS>t\u0007fAA\u0010}!1\u0011q\u0005\u0001\u0005\u0002%\na\u0003^3ti:+7\u000f^3e'V\u0014\u0007\u000f\\1o%\u0016,8/\u001a\u0015\u0004\u0003Kq\u0004BBA\u0017\u0001\u0011\u0005\u0011&A\u000fuKN$(I]3bWV\u0004H)Z1eY>\u001c7n\u00148ICND'j\\5oQ\r\tYC\u0010\u0005\u0007\u0003g\u0001A\u0011A\u0015\u0002GQ,7\u000f\u001e\"sK\u0006\\W\u000f\u001d#fC\u0012dwnY6P]:+7\u000f^3e\u0019>|\u0007OS8j]\"\u001a\u0011\u0011\u0007 \t\r\u0005e\u0002\u0001\"\u0001*\u0003\u0015\"Xm\u001d;F]\u0006\u0014G.\u001a*fkN,G+\u00192mKN{WO]2f\u001f:tUm^*pkJ\u001cW\rK\u0002\u00028yBa!a\u0010\u0001\t\u0003I\u0013A\n;fgR$\u0015n]1cY\u0016\u0014V-^:f)\u0006\u0014G.Z*pkJ\u001cWm\u00148OK^\u001cv.\u001e:dK\"\u001a\u0011Q\b \t\r\u0005\u0015\u0003\u0001\"\u0001*\u0003Y\"Xm\u001d;SKV\u001cX\rV1cY\u0016\u001cv.\u001e:dK^KG\u000f\u001b)s_*,7\r\u001e)vg\"$un\u001e8B]\u0012lU\r^1ECR\f7*Z=2Q\r\t\u0019E\u0010\u0005\u0007\u0003\u0017\u0002A\u0011A\u0015\u0002kQ,7\u000f\u001e*fkN,G+\u00192mKN{WO]2f/&$\b\u000e\u0015:pU\u0016\u001cG\u000fU;tQ\u0012{wO\\!oI6+G/\u0019#bi\u0006\\U-\u001f\u0015\u0004\u0003\u0013r\u0004BBA)\u0001\u0011\u0005\u0011&\u0001\u001cuKN$8k\\;sG\u0016\u0014V-^:f/&$\b.R7qif4\u0015\u000e\u001c;fe\u000e{g\u000eZ!oI&;gn\u001c:f\u000b6\u0004H/\u001f$jYR,'\u000fK\u0002\u0002PyBa!a\u0016\u0001\t\u0003I\u0013A\u000f;fgR\u001cv.\u001e:dKJ+Wo]3XSRDW)\u001c9us\u001aKG\u000e^3s\u0007>tG-\u00118e\u0013\u001etwN]3F[B$\u0018PR5mi\u0016\u0014HK];fQ\r\t)F\u0010\u0005\u0007\u0003;\u0002A\u0011A\u0015\u0002wQ,7\u000f^*pkJ\u001cWMU3vg\u0016<\u0016\u000e\u001e5F[B$\u0018PR5mi\u0016\u00148i\u001c8e\u0003:$\u0017j\u001a8pe\u0016,U\u000e\u001d;z\r&dG/\u001a:UeV,'\u0007K\u0002\u0002\\yBa!a\u0019\u0001\t\u0013I\u0013\u0001\u0006;fgR\u0014V-^:f\u001f:tUm^*pkJ\u001cW\r")
public class SubplanReuseTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().addTableSource("x", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.SubplanReuseTest$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("y", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.SubplanReuseTest$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testDisableSubplanReuse() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (\n        | SELECT a, SUM(b) as b, SUM(e) as e FROM x, y WHERE a = d AND c > 100 GROUP BY a\n        |)\n        |SELECT r1.a, r1.b, r2.e FROM r r1, r r2 WHERE r1.b > 10 AND r2.e < 20 AND r1.a = r2.a\n      ")).stripMargin();
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reused"}));
    }

    @Test
    public void testSubplanReuseWithDifferentRowType() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t1 AS (SELECT CAST(a as BIGINT) AS a, SUM(b) AS b FROM x GROUP BY CAST(a as BIGINT)),\n        |     t2 AS (SELECT CAST(a as DOUBLE) AS a, SUM(b) AS b FROM x GROUP BY CAST(a as DOUBLE))\n        |SELECT t1.*, t2.* FROM t1, t2 WHERE t1.b = t2.b\n      ")).stripMargin();
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reused"}));
    }

    @Test
    public void testEnableReuseTableSource() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t AS (SELECT x.a AS a, x.b AS b, y.d AS d, y.e AS e FROM x, y WHERE x.a = y.d)\n        |SELECT t1.*, t2.* FROM t t1, t t2 WHERE t1.b = t2.e AND t1.a < 10 AND t2.a > 5\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDisableReuseTableSource() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t AS (SELECT * FROM x, y WHERE x.a = y.d)\n        |SELECT t1.*, t2.* FROM t t1, t t2 WHERE t1.b = t2.e AND t1.a < 10 AND t2.a > 5\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSourceWithLimit() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b FROM x LIMIT 10)\n        |SELECT r1.a, r1.b, r2.a FROM r r1, r r2 WHERE r1.a = r2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnDataStreamTable() {
        this.util().addDataStream("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.SubplanReuseTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |(SELECT a FROM t WHERE a > 10)\n        |UNION ALL\n        |(SELECT a FROM t WHERE b > 10)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnCalc() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, c FROM x WHERE c LIKE 'test%')\n        |(SELECT r.a, LOWER(c) AS c, y.e FROM r, y WHERE r.a = y.d)\n        |UNION ALL\n        |(SELECT r.a, LOWER(c) AS c, y.e FROM r, y WHERE r.a = y.d)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnCalcWithNonDeterministicProject() {
        this.util().addTemporarySystemFunction("random_udf", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |(SELECT a, random_udf() FROM x WHERE a > 10)\n        |UNION ALL\n        |(SELECT a, random_udf() FROM x WHERE a > 10)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnCalcWithNonDeterministicUdf() {
        this.util().addTemporarySystemFunction("random_udf", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |(SELECT a FROM x WHERE b > random_udf(a))\n        |UNION ALL\n        |(SELECT a FROM x WHERE b > random_udf(a))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnExchange() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, c FROM x WHERE c LIKE 'test%')\n        |SELECT * FROM r, y WHERE a = d AND e > 10\n        |UNION ALL\n        |SELECT * FROM r, y WHERE a = d AND f <> ''\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnHashAggregate() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)OperatorType.SortAgg.toString());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, SUM(a) a, SUM(b) b FROM x GROUP BY c)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.b AND r2.a > 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSortAggregate() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)OperatorType.HashAgg.toString());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, SUM(a) a, SUM(b) b FROM x GROUP BY c)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.b AND r2.a > 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnAggregateWithNonDeterministicAggCall() {
        this.util().addTemporarySystemFunction("MyFirst", (UserDefinedFunction)new FirstValueAggFunction(DataTypes.INT().getLogicalType()));
        this.util().addTemporarySystemFunction("MyLast", (UserDefinedFunction)new FirstValueAggFunction(DataTypes.BIGINT().getLogicalType()));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, MyFirst(a) a, MyLast(b) b FROM x GROUP BY c)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.b AND r2.a > 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSort() {
        this.util().tableEnv().getConfig().set(BatchPhysicalSortRule$.MODULE$.TABLE_EXEC_RANGE_SORT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, SUM(a) a, SUM(b) b FROM x GROUP BY c ORDER BY a, b DESC)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.a AND r1.a > 1 AND r2.b < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnLimit() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b FROM x LIMIT 10)\n        |SELECT r1.a, r1.b, r2.a FROM r r1, r r2 WHERE r1.a = r2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSortLimit() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, SUM(a) a, SUM(b) b FROM x GROUP BY c ORDER BY a, b DESC LIMIT 10)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.a AND r1.a > 1 AND r2.b < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnUnion() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, c FROM x WHERE b > 10 UNION ALL SELECT d, f FROM y WHERE e < 100)\n        |SELECT r1.a, r1.c, r2.c FROM r r1, r r2 WHERE r1.a = r2.a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x FULL OUTER JOIN y ON ABS(a) = ABS(d) OR c = f\n        |           WHERE b > 1 and e < 2)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSortMergeJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        this.util().tableEnv().getConfig().set(BatchPhysicalSortMergeJoinRule$.MODULE$.TABLE_OPTIMIZER_SMJ_REMOVE_SORT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnHashJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnNestedLoopJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnJoinNonDeterministicJoinCondition() {
        this.util().addTemporarySystemFunction("random_udf", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x FULL OUTER JOIN y ON random_udf(a) = random_udf(d) OR c = f\n        |           WHERE b > 1 and e < 2)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnOverWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, RANK() OVER (ORDER BY c DESC) FROM x)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.a AND r1.b < 100 AND r2.b > 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSortedView() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE Source (\n                               |   a int,\n                               |   b bigint,\n                               |   c string,\n                               |   d string,\n                               |   e string\n                               |) WITH (\n                               |   'connector' = 'values',\n                               |   'bounded' = 'true'\n                               |)\n                               |")).stripMargin());
        String query = "SELECT * FROM Source order by c";
        Table table = this.util().tableEnv().sqlQuery(query);
        this.util().tableEnv().createTemporaryView("SortedView", table);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE Sink1 (\n                               |   a int,\n                               |   b bigint,\n                               |   c string\n                               |) WITH (\n                               |   'connector' = 'values',\n                               |   'bounded' = 'true'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE Sink2 (\n                               |   a int,\n                               |   b bigint,\n                               |   c string,\n                               |   d string\n                               |) WITH (\n                               |   'connector' = 'values',\n                               |   'bounded' = 'true'\n                               |)\n                               |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO Sink1 select a, b, listagg(d) from SortedView group by a, b");
        stmtSet.addInsertSql("INSERT INTO Sink2 select a, b, c, d from SortedView");
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testSubplanReuseOnOverWindowWithNonDeterministicAggCall() {
        this.util().addTemporarySystemFunction("MyFirst", (UserDefinedFunction)new FirstValueAggFunction(DataTypes.STRING().getLogicalType()));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, MyFirst(c) OVER (PARTITION BY c ORDER BY c DESC) FROM x)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.a AND r1.b < 100 AND r2.b > 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnCorrelate() {
        this.util().addTemporarySystemFunction("str_split", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, c, v FROM x, LATERAL TABLE(str_split(c, '-')) AS T(v))\n        |SELECT * FROM r r1, r r2 WHERE r1.v = r2.v\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnCorrelateWithNonDeterministicUDTF() {
        this.util().addTemporarySystemFunction("TableFun", (UserDefinedFunction)new JavaUserDefinedTableFunctions.NonDeterministicTableFunc());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, c, s FROM x, LATERAL TABLE(TableFun(c)) AS T(s))\n        |SELECT * FROM r r1, r r2 WHERE r1.c = r2.s\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseWithDynamicFunction() {
        Table sqlQuery = this.util().tableEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                                            |(SELECT a AS random FROM x ORDER BY rand() LIMIT 1)\n                                            |INTERSECT\n                                            |(SELECT a AS random FROM x ORDER BY rand() LIMIT 1)\n                                            |INTERSECT\n                                            |(SELECT a AS random FROM x ORDER BY rand() LIMIT 1)\n      ")).stripMargin());
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testNestedSubplanReuse() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH v1 AS (\n        | SELECT\n        |   SUM(b) sum_b,\n        |   AVG(SUM(b)) OVER (PARTITION BY c, e) avg_b,\n        |   RANK() OVER (PARTITION BY c, e ORDER BY c, e) rn,\n        |   c, e\n        | FROM x, y\n        | WHERE x.a = y.d AND c IS NOT NULl AND e > 10\n        | GROUP BY c, e\n        |),\n        |   v2 AS (\n        | SELECT\n        |    v11.c,\n        |    v11.e,\n        |    v11.avg_b,\n        |    v11.sum_b,\n        |    v12.sum_b psum,\n        |    v13.sum_b nsum,\n        |    v12.avg_b avg_b2\n        |  FROM v1 v11, v1 v12, v1 v13\n        |  WHERE v11.c = v12.c AND v11.c = v13.c AND\n        |    v11.e = v12.e AND v11.e = v13.e AND\n        |    v11.rn = v12.rn + 1 AND\n        |    v11.rn = v13.rn - 1\n        |)\n        |SELECT * from v2 WHERE c <> '' AND sum_b - avg_b > 3\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testBreakupDeadlockOnHashJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a FROM x LIMIT 10)\n        |SELECT r1.a FROM r r1, r r2 WHERE r1.a = r2.a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testBreakupDeadlockOnNestedLoopJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a FROM x LIMIT 10)\n        |SELECT r1.a FROM r r1, r r2 WHERE r1.a = r2.a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testEnableReuseTableSourceOnNewSource() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.testReuseOnNewSource();
    }

    @Test
    public void testDisableReuseTableSourceOnNewSource() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.testReuseOnNewSource();
    }

    @Test
    public void testReuseTableSourceWithProjectPushDownAndMetaDataKey1() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE reuseTable (\n         |  a bigint,\n         |  b varchar(64),\n         |  c bigint,\n         |  d STRING,\n         |  ts1 TIMESTAMP(3) METADATA,\n         |  ts2 TIMESTAMP(3) METADATA\n         | ) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'true',\n         |  'readable-metadata' = 'ts1:TIMESTAMP(3), ts2:TIMESTAMP(3)'\n         | )\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl1);
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE sink1 (\n         |  a1 bigint,\n         |  b1 VARCHAR(32),\n         |  my_time1 timestamp,\n         |  d1 DECIMAL(20,2)\n         | ) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'true'\n         | )\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl2);
        String ddl3 = new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE sink2 (\n         |  a2 bigint,\n         | `update_time` timestamp\n         | ) WITH (\n         | 'connector' = 'values',\n         | 'bounded' = 'true'\n         | )\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl3);
        String query1 = new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT a, b, ts1, CAST(d AS DECIMAL(28,2)) AS d1\n         | FROM reuseTable\n         |")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(query1);
        this.util().tableEnv().createTemporaryView("view1", table);
        String query2 = new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT a, ts1 AS update_time\n         | FROM reuseTable\n         |")).stripMargin();
        Table table2 = this.util().tableEnv().sqlQuery(query2);
        this.util().tableEnv().createTemporaryView("view2", table2);
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink1 SELECT a, b, ts1, d1 FROM view1");
        stmtSet.addInsertSql("INSERT INTO sink2 SELECT a, update_time FROM view2");
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testReuseTableSourceWithProjectPushDownAndMetaDataKey() {
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE reuseTable (\n         |  a bigint,\n         |  b varchar(64),\n         |  c bigint,\n         |  d STRING,\n         |  my_time TIMESTAMP(3) METADATA FROM 'ts1',\n         |  unUse_time TIMESTAMP(3) METADATA FROM 'ts2'\n         | ) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'true',\n         |  'readable-metadata' = 'ts1:TIMESTAMP(3), ts2:TIMESTAMP(3)'\n         | )\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl1);
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE sink1 (\n         |  a1 bigint,\n         |  b1 VARCHAR(32),\n         |  my_time1 timestamp,\n         |  d1 DECIMAL(20,2)\n         | ) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'true'\n         | )\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl2);
        String ddl3 = new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE sink2 (\n         |  a2 bigint,\n         | `update_time` timestamp\n         | ) WITH (\n         | 'connector' = 'values',\n         | 'bounded' = 'true'\n         | )\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl3);
        String query1 = new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT a, b, my_time, CAST(d AS DECIMAL(28,2)) AS d1\n         | FROM reuseTable\n         |")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(query1);
        this.util().tableEnv().createTemporaryView("view1", table);
        String query2 = new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT a, my_time AS update_time\n         | FROM reuseTable\n         |")).stripMargin();
        Table table2 = this.util().tableEnv().sqlQuery(query2);
        this.util().tableEnv().createTemporaryView("view2", table2);
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink1 SELECT a, b, my_time, d1 FROM view1");
        stmtSet.addInsertSql("INSERT INTO sink2 SELECT a, update_time FROM view2");
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testSourceReuseWithEmptyFilterCondAndIgnoreEmptyFilter() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table MyTable(\n                     |  a int,\n                     |  b bigint,\n                     |  c varchar\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT * FROM MyTable T1, MyTable T2 WHERE T1.a = T2.a AND T1.a > 5\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSourceReuseWithEmptyFilterCondAndIgnoreEmptyFilterTrue() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table MyTable(\n                     |  a int,\n                     |  b bigint,\n                     |  c varchar\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT * FROM MyTable T1, MyTable T2 WHERE T1.a = T2.a AND T1.a > 5\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSourceReuseWithEmptyFilterCondAndIgnoreEmptyFilterTrue2() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table MyTable(\n                     |  a int,\n                     |  b bigint,\n                     |  c varchar\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT * FROM MyTable T1, MyTable T2 WHERE T1.a = T2.a AND T2.a < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    private void testReuseOnNewSource() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table newX(\n                     |  a int,\n                     |  b bigint,\n                     |  c varchar\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table newY(\n                     |  d int,\n                     |  e bigint,\n                     |  f varchar\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t AS (\n        |  SELECT newX.a AS a, newX.b AS b, newY.d AS d, newY.e AS e\n        |  FROM newX, newY\n        |  WHERE newX.a = newY.d)\n        |SELECT t1.*, t2.* FROM t t1, t t2 WHERE t1.b = t2.e AND t1.a < 10 AND t2.a > 5\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }
}

