/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func0$;
import org.apache.flink.table.planner.plan.batch.sql.TableScanTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001'\tiA+\u00192mKN\u001b\u0017M\u001c+fgRT!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005)!-\u0019;dQ*\u0011q\u0001C\u0001\u0005a2\fgN\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0005\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0013\u0001B;uS2,\u0012A\t\t\u0003+\rJ!\u0001\n\f\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007M\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b!\u0002A\u0011A\u0015\u0002\r\t,gm\u001c:f)\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSRD#aJ\u0019\u0011\u0005IJT\"A\u001a\u000b\u0005Q*\u0014aA1qS*\u0011agN\u0001\bUV\u0004\u0018\u000e^3s\u0015\tA\u0004#A\u0003kk:LG/\u0003\u0002;g\tQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000bq\u0002A\u0011A\u0015\u00023Q,7\u000f\u001e'fO\u0006\u001c\u0017\u0010V1cY\u0016\u001cv.\u001e:dKN\u001b\u0017M\u001c\u0015\u0003wy\u0002\"AM \n\u0005\u0001\u001b$\u0001\u0002+fgRDQA\u0011\u0001\u0005\u0002%\n\u0001\u0003^3ti\u0012#E\nV1cY\u0016\u001c6-\u00198)\u0005\u0005s\u0004\"B#\u0001\t\u0003I\u0013!\u0007;fgR\u001c6-\u00198P]Vs'm\\;oI\u0016$7k\\;sG\u0016D#\u0001\u0012 \t\u000b!\u0003A\u0011A\u0015\u00023Q,7\u000f^*dC:|en\u00115b]\u001e,Gn\\4T_V\u00148-\u001a\u0015\u0003\u000fzBQa\u0013\u0001\u0005\u0002%\na\u0003^3tiN\u001b\u0017M\\(o+B\u001cXM\u001d;T_V\u00148-\u001a\u0015\u0003\u0015zBQA\u0014\u0001\u0005\u0002%\n\u0011\u0004^3ti\u0012#EjV5uQ\u000e{W\u000e];uK\u0012\u001cu\u000e\\;n]\"\u0012QJ\u0010\u0005\u0006#\u0002!\t!K\u0001#i\u0016\u001cH\u000f\u0012#M/&$\bnV1uKJl\u0017M]6D_6\u0004X\u000f^3e\u0007>dW/\u001c8)\u0005As\u0004\"\u0002+\u0001\t\u0003I\u0013a\u0005;fgR$E\tT,ji\"\u0004&o\\2uS6,\u0007FA*?\u0011\u00159\u0006\u0001\"\u0001*\u0003\t\"Xm\u001d;UC\ndW-\u00119j'\u000e\fgnV5uQ\u000e{W\u000e];uK\u0012\u001cu\u000e\\;n]\"\u0012aK\u0010\u0005\u00065\u0002!\t!K\u0001\u001ei\u0016\u001cH\u000fV1cY\u0016\f\u0005/[*dC:<\u0016\u000e\u001e5XCR,'/\\1sW\"\u0012\u0011L\u0010\u0005\u0006;\u0002!\t!K\u0001\u0018i\u0016\u001cH\u000fV1cY\u0016\f\u0005/[*dC:<\u0016\u000e\u001e5E\t2C#\u0001\u0018 \t\u000b\u0001\u0004A\u0011A\u0015\u0002EQ,7\u000f\u001e+bE2,\u0017\t]5TG\u0006tw+\u001b;i)\u0016l\u0007o\u001c:bef$\u0016M\u00197fQ\tyf\b")
public class TableScanTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().addTemporarySystemFunction("my_udf", (UserDefinedFunction)Func0$.MODULE$);
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table computed_column_t(\n                     |  a int,\n                     |  b varchar,\n                     |  c as a + 1,\n                     |  d as to_timestamp(b),\n                     |  e as my_udf(a)\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table c_watermark_t(\n                     |  a int,\n                     |  b varchar,\n                     |  c as a + 1,\n                     |  d as to_timestamp(b),\n                     |  e as my_udf(a),\n                     |  WATERMARK FOR d AS d - INTERVAL '0.001' SECOND\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
    }

    @Test
    public void testLegacyTableSourceScan() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.TableScanTest$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().verifyExecPlan("SELECT * FROM MyTable");
    }

    @Test
    public void testDDLTableScan() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE src (\n                    |  ts TIMESTAMP(3),\n                    |  a INT,\n                    |  b DOUBLE,\n                    |  WATERMARK FOR ts AS ts - INTERVAL '0.001' SECOND\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'bounded' = 'true'\n                    |)\n      ")).stripMargin());
        this.util().verifyExecPlan("SELECT * FROM src WHERE a > 1");
    }

    @Test
    public void testScanOnUnboundedSource() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE src (\n                    |  ts TIMESTAMP(3),\n                    |  a INT,\n                    |  b DOUBLE,\n                    |  WATERMARK FOR ts AS ts - INTERVAL '0.001' SECOND\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'bounded' = 'false'\n                    |)\n      ")).stripMargin());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan("SELECT * FROM src WHERE a > 1")).hasMessageContaining("Querying an unbounded table 'default_catalog.default_database.src' in batch mode is not allowed. The table source is unbounded.") instanceof ValidationException;
    }

    @Test
    public void testScanOnChangelogSource() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE src (\n                    |  ts TIMESTAMP(3),\n                    |  a INT,\n                    |  b DOUBLE\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'bounded' = 'true',\n                    |  'changelog-mode' = 'I,UA,UB'\n                    |)\n      ")).stripMargin());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan("SELECT * FROM src WHERE a > 1")).hasMessageContaining("Querying a table in batch mode is currently only possible for INSERT-only table sources. But the source for table 'default_catalog.default_database.src' produces other changelog messages than just INSERT.") instanceof TableException;
    }

    @Test
    public void testScanOnUpsertSource() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE src (\n                    |  id STRING,\n                    |  a INT,\n                    |  b DOUBLE,\n                    |  PRIMARY KEY (id) NOT ENFORCED\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'bounded' = 'true',\n                    |  'changelog-mode' = 'UA,D'\n                    |)\n      ")).stripMargin());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan("SELECT * FROM src WHERE a > 1")).hasMessageContaining("Querying a table in batch mode is currently only possible for INSERT-only table sources. But the source for table 'default_catalog.default_database.src' produces other changelog messages than just INSERT.") instanceof TableException;
    }

    @Test
    public void testDDLWithComputedColumn() {
        this.util().verifyExecPlan("SELECT * FROM computed_column_t");
    }

    @Test
    public void testDDLWithWatermarkComputedColumn() {
        this.util().verifyExecPlan("SELECT * FROM c_watermark_t");
    }

    @Test
    public void testDDLWithProctime() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n         |create table proctime_t (\n         | a int,\n         | b varchar,\n         | c as a + 1,\n         | d as to_timestamp(b),\n         | e as my_udf(a),\n         | ptime as proctime()\n         |) with (\n         |  'connector' = 'values',\n         |  'bounded' = 'true'\n         |)\n      ")).stripMargin());
        this.util().verifyExecPlan("SELECT * FROM proctime_t");
    }

    @Test
    public void testTableApiScanWithComputedColumn() {
        this.util().verifyExecPlan(this.util().tableEnv().from("computed_column_t"));
    }

    @Test
    public void testTableApiScanWithWatermark() {
        this.util().verifyExecPlan(this.util().tableEnv().from("c_watermark_t"));
    }

    @Test
    public void testTableApiScanWithDDL() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table t1(\n                     |  a int,\n                     |  b varchar\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        this.util().verifyExecPlan(this.util().tableEnv().from("t1"));
    }

    @Test
    public void testTableApiScanWithTemporaryTable() {
        this.util().tableEnv().createTemporaryTable("t1", TableDescriptor.forConnector((String)"datagen").schema(Schema.newBuilder().column("word", (AbstractDataType)DataTypes.STRING()).build()).option("number-of-rows", "1").build());
        this.util().verifyExecPlan(this.util().tableEnv().from("t1"));
    }
}

