/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.batch.sql.agg.GroupWindowTest$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.AggregatePhaseStrategy;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.CountAggFunction;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u0001U\u0011qb\u0012:pkB<\u0016N\u001c3poR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1!Y4h\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000b\t\fGo\u00195\u000b\u0005%Q\u0011\u0001\u00029mC:T!a\u0003\u0007\u0002\u000fAd\u0017M\u001c8fe*\u0011QBD\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001fA\tQA\u001a7j].T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9\"$D\u0001\u0019\u0015\tI\"\"A\u0003vi&d7/\u0003\u0002\u001c1\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016D\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\fC\u001e<7\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u0002\u0018?%\u0011\u0001\u0005\u0007\u0002\u0017\u0003\u001e<'/Z4bi\u0016\u0004\u0006.Y:f'R\u0014\u0018\r^3hs\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001\n\u0014\u0011\u0005\u0015\u0002Q\"\u0001\u0002\t\u000bu\t\u0003\u0019\u0001\u0010\t\u000f!\u0002!\u0019!C\u0005S\u0005!Q\u000f^5m+\u0005Q\u0003CA\f,\u0013\ta\u0003D\u0001\nCCR\u001c\u0007\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0018\u0001A\u0003%!&A\u0003vi&d\u0007\u0005C\u00031\u0001\u0011\u0005\u0011'\u0001\u0004cK\u001a|'/\u001a\u000b\u0002eA\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t!QK\\5uQ\ty\u0013\b\u0005\u0002;\u00036\t1H\u0003\u0002={\u0005\u0019\u0011\r]5\u000b\u0005yz\u0014a\u00026va&$XM\u001d\u0006\u0003\u0001J\tQA[;oSRL!AQ\u001e\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0003E\u0001\u0011\u0005\u0011'A\u000buKN$\bj\u001c9XS:$wn\u001e(p\u001f\u001a47/\u001a;)\u0005\r3\u0005C\u0001\u001eH\u0013\tA5H\u0001\u0007UKN$H+Z7qY\u0006$X\rC\u0003K\u0001\u0011\u0005\u0011'A\ruKN$8+Z:tS>tw+\u001b8e_^tun\u00144gg\u0016$\bFA%G\u0011\u0015i\u0005\u0001\"\u00012\u0003Y!Xm\u001d;WCJL\u0017M\u00197f/&tGm\\<TSj,\u0007F\u0001'G\u0011\u0015\u0001\u0006\u0001\"\u00012\u0003\u0011\"Xm\u001d;Uk6\u0014G.Z,j]\u0012|woV5uQ&sg/\u00197jIV#\u0017iZ4Be\u001e\u001c\bFA(G\u0011\u0015\u0019\u0006\u0001\"\u00012\u0003I!Xm\u001d;XS:$wn\u001e)s_\u000e$\u0018.\\3)\u0005I3\u0005\"\u0002,\u0001\t\u0003\t\u0014A\u0007;fgR<\u0016N\u001c3po\u0006;wmV5uQ\u001e\u0013x.\u001e9TKR\u001c\bFA+G\u0011\u0015I\u0006\u0001\"\u00012\u0003q!Xm\u001d;O_\u001e\u0013x.\u001e9j]\u001e$V/\u001c2mS:<w+\u001b8e_^D#\u0001\u0017$\t\u000bq\u0003A\u0011A\u0019\u00025Q,7\u000f\u001e+v[\nd\u0017N\\4XS:$wn^*peR\fumZ\u0019)\u0005m3\u0005\"B0\u0001\t\u0003\t\u0014A\u0007;fgR$V/\u001c2mS:<w+\u001b8e_^\u001cvN\u001d;BO\u001e\u0014\u0004F\u00010G\u0011\u0015\u0011\u0007\u0001\"\u00012\u0003i!Xm\u001d;Uk6\u0014G.\u001b8h/&tGm\\<ICND\u0017iZ42Q\t\tg\tC\u0003f\u0001\u0011\u0005\u0011'\u0001\u000euKN$H+^7cY&twmV5oI><\b*Y:i\u0003\u001e<'\u0007\u000b\u0002e\r\")\u0001\u000e\u0001C\u0001c\u0005\u0001C/Z:u\u001d>t\u0007+\u0019:uSRLwN\\3e)Vl'\r\\5oO^Kg\u000eZ8xQ\t9g\tC\u0003l\u0001\u0011\u0005\u0011'A\u000fuKN$\b+\u0019:uSRLwN\\3e)Vl'\r\\5oO^Kg\u000eZ8xQ\tQg\tC\u0003o\u0001\u0011\u0005\u0011'A\u000euKN$H+^7cY&twmV5oI><x+\u001b;i+\u0012\fum\u001a\u0015\u0003[\u001aCQ!\u001d\u0001\u0005\u0002E\na\u0004^3tiR+XN\u00197j]\u001e<\u0016N\u001c3po^KG\u000f\u001b)s_\u000e$\u0018.\\3)\u0005A4\u0005\"\u0002;\u0001\t\u0003\t\u0014a\u0007;fgRtun\u0012:pkBLgnZ*mS\u0012LgnZ,j]\u0012|w\u000f\u000b\u0002t\r\")q\u000f\u0001C\u0001c\u0005IB/Z:u'2LG-\u001b8h/&tGm\\<T_J$\u0018iZ42Q\t1h\tC\u0003{\u0001\u0011\u0005\u0011'A\ruKN$8\u000b\\5eS:<w+\u001b8e_^\u001cvN\u001d;BO\u001e\u0014\u0004FA=G\u0011\u0015i\b\u0001\"\u00012\u0003e!Xm\u001d;TY&$\u0017N\\4XS:$wn^*peR\fumZ\u001a)\u0005q4\u0005BBA\u0001\u0001\u0011\u0005\u0011'\u0001\u0017uKN$8\u000b\\5eS:<w+\u001b8e_^\u001cvN\u001d;BO\u001e<\u0016\u000e\u001e5QC:,w\n\u001d;j[&T\u0018\r^5p]\"\u0012qP\u0012\u0005\u0007\u0003\u000f\u0001A\u0011A\u0019\u00021Q,7\u000f^*mS\u0012LgnZ,j]\u0012|w\u000fS1tQ\u0006;w\rK\u0002\u0002\u0006\u0019Ca!!\u0004\u0001\t\u0003\t\u0014a\b;fgRtuN\u001c)beRLG/[8oK\u0012\u001cF.\u001b3j]\u001e<\u0016N\u001c3po\"\u001a\u00111\u0002$\t\r\u0005M\u0001\u0001\"\u00012\u0003q!Xm\u001d;QCJ$\u0018\u000e^5p]\u0016$7\u000b\\5eS:<w+\u001b8e_^D3!!\u0005G\u0011\u0019\tI\u0002\u0001C\u0001c\u0005iB/Z:u'2LG-\u001b8h/&tGm\\<XSRD\u0007K]8di&lW\rK\u0002\u0002\u0018\u0019Ca!a\b\u0001\t\u0003\t\u0014a\b;fgRtuN\u001c)beRLG/[8oK\u0012\u001cVm]:j_:<\u0016N\u001c3po\"\u001a\u0011Q\u0004$\t\r\u0005\u0015\u0002\u0001\"\u00012\u0003q!Xm\u001d;QCJ$\u0018\u000e^5p]\u0016$7+Z:tS>tw+\u001b8e_^D3!a\tG\u0011\u0019\tY\u0003\u0001C\u0001c\u0005iB/Z:u'\u0016\u001c8/[8o/&tGm\\<XSRD\u0007K]8di&lW\rK\u0002\u0002*\u0019Ca!!\r\u0001\t\u0003\t\u0014!\u0005;fgR<\u0016N\u001c3po\u0016sGm\u00148ms\"\u001a\u0011q\u0006$\t\r\u0005]\u0002\u0001\"\u00012\u0003\u0011\"Xm\u001d;FqB\u0014Xm]:j_:|enV5oI><\b*\u0019<j]\u001e4UO\\2uS>t\u0007fAA\u001b\r\"1\u0011Q\b\u0001\u0005\u0002E\nA\u0004^3ti\u0012+7m\\7q_N\f'\r\\3BO\u001e4UO\\2uS>t7\u000fK\u0002\u0002<\u0019Ca!a\u0011\u0001\t\u0003\t\u0014a\t;fgR\u0014V\r^;s]RK\b/Z%oM\u0016\u0014XM\\2f\r>\u0014x+\u001b8e_^\fum\u001a\u0015\u0004\u0003\u00032\u0005BBA%\u0001\u0011\u0005\u0011'A\u0014uKN$x+\u001b8e_^\fum\u001a:fO\u0006$XmV5uQ\u0012KgMZ3sK:$x+\u001b8e_^\u001c\bfAA$\r\":\u0001!a\u0014\u0002\\\u0005u\u0003\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005U3(A\u0005fqR,gn]5p]&!\u0011\u0011LA*\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003?\u001a#!!\u0019\u0011\t\u0005\r\u00141O\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005i\u0001/\u0019:b[\u0016$XM]5{K\u0012TA!a\u001b\u0002n\u0005QQ\r\u001f;f]NLwN\\:\u000b\u0007\u0001\u000byGC\u0002\u0002r9\t\u0011\u0002^3tiV$\u0018\u000e\\:\n\t\u0005U\u0014Q\r\u0002\u001b!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$X\t\u001f;f]NLwN\\\u0004\b\u0003s\u0012\u0001\u0012AA>\u0003=9%o\\;q/&tGm\\<UKN$\bcA\u0013\u0002~\u00191\u0011A\u0001E\u0001\u0003\u007f\u001aB!! \u0002\u0002B\u00191'a!\n\u0007\u0005\u0015EG\u0001\u0004B]f\u0014VM\u001a\u0005\bE\u0005uD\u0011AAE)\t\tY\b\u0003\u0005\u0002\u000e\u0006uD\u0011AAH\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0003\u0003#\u0003R!a%\u0002\u001czi!!!&\u000b\u0007!\n9J\u0003\u0002\u0002\u001a\u0006!!.\u0019<b\u0013\u0011\ti*!&\u0003\u0015\r{G\u000e\\3di&|g\u000e\u000b\u0005\u0002\f\u0006\u0005\u0016qUAU!\u0011\t\u0019'a)\n\t\u0005\u0015\u0016Q\r\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\u0001\u00028b[\u0016\f#!a+\u0002\u001f\u0005<wm\u0015;sCR,w-_\u001f|au\u0004")
public class GroupWindowTest
extends TableTestBase {
    private final AggregatePhaseStrategy aggStrategy;
    private final BatchTableTestUtil util;

    @Parameters(name="aggStrategy={0}")
    public static Collection<AggregatePhaseStrategy> parameters() {
        return GroupWindowTest$.MODULE$.parameters();
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)this.aggStrategy.toString());
        this.util().addTemporarySystemFunction("countFun", (UserDefinedFunction)new CountAggFunction());
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, Timestamp, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Timestamp, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Timestamp, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Timestamp, Object, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Timestamp, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((Timestamp)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple4<Object, Timestamp, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.agg.GroupWindowTest$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple4<Timestamp, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Timestamp, Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Timestamp, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple4<Timestamp, Object, Object, String>>(this, fieldSerializers){

                    public Tuple4<Timestamp, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)((Timestamp)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple4<Timestamp, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.agg.GroupWindowTest$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}), new CaseClassTypeInfo<Tuple5<Object, Object, String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple5<Object, Object, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)((Timestamp)fields[4]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple5<Object, Object, String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.agg.GroupWindowTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |create table MyTable3 (\n                                |  a int,\n                                |  b bigint,\n                                |  c as proctime()\n                                |) with (\n                                |  'connector' = 'COLLECTION'\n                                |)\n                                |")).stripMargin());
    }

    @TestTemplate
    public void testHopWindowNoOffset() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable2 GROUP BY HOP(ts, INTERVAL '1' HOUR, INTERVAL '2' HOUR, TIME '10:00:00')";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sqlQuery)).hasMessageContaining("HOP window with alignment is not supported yet.") instanceof TableException;
    }

    @TestTemplate
    public void testSessionWindowNoOffset() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable2 GROUP BY SESSION(ts, INTERVAL '2' HOUR, TIME '10:00:00')";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sqlQuery)).hasMessageContaining("SESSION window with alignment is not supported yet.") instanceof TableException;
    }

    @TestTemplate
    public void testVariableWindowSize() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan("SELECT COUNT(*) FROM MyTable2 GROUP BY TUMBLE(ts, b * INTERVAL '1' MINUTE)")).hasMessageContaining("Only constant window descriptors are supported") instanceof TableException;
    }

    @TestTemplate
    public void testTumbleWindowWithInvalidUdAggArgs() {
        JavaUserDefinedAggFunctions.WeightedAvgWithMerge weightedAvg = new JavaUserDefinedAggFunctions.WeightedAvgWithMerge();
        this.util().addTemporarySystemFunction("weightedAvg", (UserDefinedFunction)weightedAvg);
        String sql = "SELECT weightedAvg(c, a) AS wAvg FROM MyTable2 GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE)";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("SQL validation failed. Invalid function call:\nweightedAvg(STRING, INT)") instanceof ValidationException;
    }

    @TestTemplate
    public void testWindowProctime() {
        String sqlQuery = "SELECT TUMBLE_PROCTIME(ts, INTERVAL '4' MINUTE) FROM MyTable2 GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE), c";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sqlQuery)).hasMessageContaining("PROCTIME window property is not supported in batch queries.") instanceof ValidationException;
    }

    @TestTemplate
    public void testWindowAggWithGroupSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    TUMBLE_END(ts, INTERVAL '15' MINUTE) + INTERVAL '1' MINUTE\n        |FROM MyTable1\n        |    GROUP BY rollup(TUMBLE(ts, INTERVAL '15' MINUTE), b)\n    ")).stripMargin();
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> this.util().verifyRelPlanNotExpected(sql, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TUMBLE(ts"})));
    }

    @TestTemplate
    public void testNoGroupingTumblingWindow() {
        String sqlQuery = "SELECT AVG(c), SUM(a) FROM MyTable GROUP BY TUMBLE(b, INTERVAL '3' SECOND)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testTumblingWindowSortAgg1() {
        String sqlQuery = "SELECT MAX(c) FROM MyTable1 GROUP BY a, TUMBLE(ts, INTERVAL '3' SECOND)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testTumblingWindowSortAgg2() {
        String sqlQuery = "SELECT AVG(c), countFun(a) FROM MyTable GROUP BY a, d, TUMBLE(b, INTERVAL '3' SECOND)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testTumblingWindowHashAgg1() {
        String sqlQuery = "SELECT COUNT(c) FROM MyTable1 GROUP BY a, TUMBLE(ts, INTERVAL '3' SECOND)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testTumblingWindowHashAgg2() {
        String sql = "SELECT AVG(c), COUNT(a) FROM MyTable GROUP BY a, d, TUMBLE(b, INTERVAL '3' SECOND)";
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testNonPartitionedTumblingWindow() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable2 GROUP BY TUMBLE(ts, INTERVAL '2' HOUR)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testPartitionedTumblingWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(ts, INTERVAL '4' MINUTE),\n        |    TUMBLE_END(ts, INTERVAL '4' MINUTE),\n        |    TUMBLE_ROWTIME(ts, INTERVAL '4' MINUTE),\n        |    c,\n        |    SUM(a) AS sumA,\n        |    MIN(b) AS minB\n        |FROM MyTable2\n        |    GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE), c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testTumblingWindowWithUdAgg() {
        this.util().addTemporarySystemFunction("weightedAvg", (UserDefinedFunction)new JavaUserDefinedAggFunctions.WeightedAvgWithMerge());
        String sql = "SELECT weightedAvg(b, a) AS wAvg FROM MyTable2 GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE)";
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testTumblingWindowWithProctime() {
        String sql = "select sum(a), max(b) from MyTable3 group by TUMBLE(c, INTERVAL '1' SECOND)";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("Window can not be defined over a proctime attribute column for batch mode") instanceof ValidationException;
    }

    @TestTemplate
    public void testNoGroupingSlidingWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT SUM(a),\n        |    HOP_START(b, INTERVAL '3' SECOND, INTERVAL '3' SECOND),\n        |    HOP_END(b, INTERVAL '3' SECOND, INTERVAL '3' SECOND)\n        |FROM MyTable\n        |    GROUP BY HOP(b, INTERVAL '3' SECOND, INTERVAL '3' SECOND)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSlidingWindowSortAgg1() {
        String sqlQuery = "SELECT MAX(c) FROM MyTable1 GROUP BY a, HOP(ts, INTERVAL '3' SECOND, INTERVAL '1' HOUR)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSlidingWindowSortAgg2() {
        String sqlQuery = "SELECT MAX(c) FROM MyTable1 GROUP BY b, HOP(ts, INTERVAL '0.111' SECOND(1,3), INTERVAL '1' SECOND)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSlidingWindowSortAgg3() {
        String sqlQuery = "SELECT countFun(c) FROM MyTable  GROUP BY a, d, HOP(b, INTERVAL '3' SECOND, INTERVAL '1' HOUR)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSlidingWindowSortAggWithPaneOptimization() {
        String sqlQuery = "SELECT COUNT(c) FROM MyTable1 GROUP BY a, HOP(ts, INTERVAL '3' SECOND, INTERVAL '1' HOUR)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSlidingWindowHashAgg() {
        String sqlQuery = "SELECT count(c) FROM MyTable1 GROUP BY b, HOP(ts, INTERVAL '3' SECOND, INTERVAL '1' HOUR)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testNonPartitionedSlidingWindow() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable2 GROUP BY HOP(ts, INTERVAL '15' MINUTE, INTERVAL '90' MINUTE)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testPartitionedSlidingWindow() {
        String sqlQuery = "SELECT   c,   HOP_END(ts, INTERVAL '1' HOUR, INTERVAL '3' HOUR),   HOP_START(ts, INTERVAL '1' HOUR, INTERVAL '3' HOUR),   HOP_ROWTIME(ts, INTERVAL '1' HOUR, INTERVAL '3' HOUR),   SUM(a) AS sumA,   AVG(b) AS avgB FROM MyTable2 GROUP BY HOP(ts, INTERVAL '1' HOUR, INTERVAL '3' HOUR), d, c";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSlidingWindowWithProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select sum(a), max(b)\n         |from MyTable3\n         |group by HOP(c, INTERVAL '1' SECOND, INTERVAL '1' MINUTE)\n         |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("Window can not be defined over a proctime attribute column for batch mode") instanceof ValidationException;
    }

    @TestTemplate
    public void testNonPartitionedSessionWindow() {
        String sqlQuery = "SELECT COUNT(*) AS cnt FROM MyTable2 GROUP BY SESSION(ts, INTERVAL '30' MINUTE)";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sqlQuery)).hasMessageContaining("Cannot generate a valid execution plan for the given query") instanceof TableException;
    }

    @TestTemplate
    public void testPartitionedSessionWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c, d,\n        |    SESSION_START(ts, INTERVAL '12' HOUR),\n        |    SESSION_END(ts, INTERVAL '12' HOUR),\n        |    SESSION_ROWTIME(ts, INTERVAL '12' HOUR),\n        |    SUM(a) AS sumA,\n        |    MIN(b) AS minB\n        |FROM MyTable2\n        |    GROUP BY SESSION(ts, INTERVAL '12' HOUR), c, d\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sqlQuery)).hasMessageContaining("Cannot generate a valid execution plan for the given query") instanceof TableException;
    }

    @TestTemplate
    public void testSessionWindowWithProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select sum(a), max(b)\n         |from MyTable3\n         |group by SESSION(c, INTERVAL '1' MINUTE)\n         |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sql)).hasMessageContaining("Window can not be defined over a proctime attribute column for batch mode") instanceof ValidationException;
    }

    @TestTemplate
    public void testWindowEndOnly() {
        String sqlQuery = "SELECT TUMBLE_END(ts, INTERVAL '4' MINUTE) FROM MyTable2 GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE), c";
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testExpressionOnWindowHavingFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    HOP_START(ts, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)\n        |FROM MyTable2\n        |    GROUP BY HOP(ts, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)\n        |    HAVING\n        |     SUM(a) > 0 AND\n        |     QUARTER(HOP_START(ts, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)) = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testDecomposableAggFunctions() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT VAR_POP(b),\n        |    VAR_SAMP(b),\n        |    STDDEV_POP(b),\n        |    STDDEV_SAMP(b),\n        |    TUMBLE_START(ts, INTERVAL '15' MINUTE),\n        |    TUMBLE_END(ts, INTERVAL '15' MINUTE)\n        |FROM MyTable1\n        |    GROUP BY TUMBLE(ts, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testReturnTypeInferenceForWindowAgg() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  SUM(correct) AS s,\n        |  AVG(correct) AS a,\n        |  TUMBLE_START(b, INTERVAL '15' MINUTE) AS wStart\n        |FROM (\n        |  SELECT CASE a\n        |      WHEN 1 THEN 1\n        |      ELSE 99\n        |    END AS correct, b\n        |  FROM MyTable\n        |)\n        |GROUP BY TUMBLE(b, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testWindowAggregateWithDifferentWindows() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH window_1h AS (\n        |    SELECT 1\n        |    FROM MyTable2\n        |    GROUP BY HOP(`ts`, INTERVAL '1' HOUR, INTERVAL '1' HOUR)\n        |),\n        |\n        |window_2h AS (\n        |    SELECT 1\n        |    FROM MyTable2\n        |    GROUP BY HOP(`ts`, INTERVAL '1' HOUR, INTERVAL '2' HOUR)\n        |)\n        |\n        |(SELECT * FROM window_1h)\n        |UNION ALL\n        |(SELECT * FROM window_2h)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    public GroupWindowTest(AggregatePhaseStrategy aggStrategy) {
        this.aggStrategy = aggStrategy;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

