/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple10;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple8;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001U\u0011\u0001c\u0012:pkBLgnZ*fiN$Vm\u001d;\u000b\u0005\r!\u0011aA1hO*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0011\u0017\r^2i\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\u0011\u0011DC\u0001\u0006kRLGn]\u0005\u00037a\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0003\u0011\u001d\u0011\u0003A1A\u0005\n\r\nA!\u001e;jYV\tA\u0005\u0005\u0002\u0018K%\u0011a\u0005\u0007\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG\u000e\u0003\u0004)\u0001\u0001\u0006I\u0001J\u0001\u0006kRLG\u000e\t\u0005\u0006U\u0001!\taK\u0001\u0011i\u0016\u001cHo\u0012:pkBLgnZ*fiN$\u0012\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0005+:LG\u000f\u000b\u0002*gA\u0011AgO\u0007\u0002k)\u0011agN\u0001\u0004CBL'B\u0001\u001d:\u0003\u001dQW\u000f]5uKJT!A\u000f\n\u0002\u000b),h.\u001b;\n\u0005q*$\u0001\u0002+fgRDQA\u0010\u0001\u0005\u0002-\n\u0011\u0003^3ti\u001e\u0013x.\u001e9j]\u001e\u001cV\r^:3Q\ti4\u0007C\u0003B\u0001\u0011\u00051&A\tuKN$xI]8va&twmU3ugNB#\u0001Q\u001a\t\u000b\u0011\u0003A\u0011A\u0016\u0002EQ,7\u000f^$s_V\u0004\u0018N\\4TKR\u001cx*\u001e;qkR\u001ch*\u001e7mC\nLG.\u001b;zQ\t\u00195\u0007C\u0003H\u0001\u0011\u00051&\u0001\u0005uKN$8)\u001e2fQ\t15\u0007C\u0003K\u0001\u0011\u00051&\u0001\u0006uKN$(k\u001c7mkBD#!S\u001a\t\u000b5\u0003A\u0011A\u0016\u0002?Q,7\u000f^$s_V\u0004\u0018N\\4TKR\u001cx+\u001b;i\u001f:,wI]8va&tw\r\u000b\u0002Mg!)\u0001\u000b\u0001C\u0001W\u0005)B/Z:u\u0005\u0006\u001c\u0018nY$s_V\u0004\u0018N\\4TKR\u001c\bFA(4\u0011\u0015\u0019\u0006\u0001\"\u0001,\u0003q!Xm\u001d;He>,\b/\u001b8h'\u0016$8o\u00148FqB\u0014Xm]:j_:D#AU\u001a\t\u000bY\u0003A\u0011A\u0016\u0002\u001dQ,7\u000f^*j[BdWmQ;cK\"\u0012Qk\r\u0005\u00063\u0002!\taK\u0001\u0014i\u0016\u001cHOU8mYV\u0004xJ\\\u0019D_2,XN\u001c\u0015\u00031NBQ\u0001\u0018\u0001\u0005\u0002-\n1\u0003^3tiJ{G\u000e\\;q\u001f:\u00144i\u001c7v[:D#aW\u001a\t\u000b}\u0003A\u0011A\u0016\u00027Q,7\u000f\u001e*pY2,\bo\u00148D_2,XN\\,ji\"tU\u000f\u001c7tQ\tq6\u0007C\u0003c\u0001\u0011\u00051&A\u000buKN$(k\u001c7mkB\u0004F.^:Pe\u0012,'OQ=)\u0005\u0005\u001c\u0004\"B3\u0001\t\u0003Y\u0013A\u0007;fgR\u0014v\u000e\u001c7va\u000e\u000b'\u000f^3tS\u0006t\u0007K]8ek\u000e$\bF\u000134\u0011\u0015A\u0007\u0001\"\u0001,\u0003M\"Xm\u001d;S_2dW\u000f]\"beR,7/[1o!J|G-^2u\u001f\u001a<\u0016\u000e\u001e5UkBdWmV5uQ\u0016C\bO]3tg&|g\u000e\u000b\u0002hg!)1\u000e\u0001C\u0001W\u0005!B/Z:u%>dG.\u001e9XSRD\u0007*\u0019<j]\u001eD#A[\u001a\t\u000b9\u0004A\u0011A\u0016\u0002'Q,7\u000f^\"vE\u0016\fe\u000e\u001a#jgRLgn\u0019;)\u00055\u001c\u0004\"B9\u0001\t\u0003Y\u0013a\u0004;fgR\u001cUOY3B]\u0012Tu.\u001b8)\u0005A\u001c\u0004\"\u0002;\u0001\t\u0003Y\u0013\u0001\u000b;fgR<%o\\;qS:<\u0017J\\*fY\u0016\u001cGo\u00117bkN,wJZ$s_V\u0004()_)vKJL\bFA:4\u0011\u00159\b\u0001\"\u0001,\u0003\u0015\"Xm\u001d;He>,\b/\u001b8h\u0013:\u001cV\r\\3di\u000ec\u0017-^:f\u001f\u001a\u001cUOY3Rk\u0016\u0014\u0018\u0010\u000b\u0002wg!)!\u0010\u0001C\u0001W\u0005YD/Z:u\u000fJ|W\u000f]5oO\u001e\u0013x.\u001e9`S\u0012<%o\\;qS:<w,\u001b3J]N+G.Z2u\u00072\fWo]3PM\u001e\u0013x.\u001e9CsF+XM]=)\u0005e\u001c\u0004\"B?\u0001\t\u0003Y\u0013\u0001\u0011;fgR<%o\\;qS:<\u0017iY2faR\u001cX*\u001e7uSBdW-\u0011:hk6,g\u000e^:HSZ,7oU1nKJ+7/\u001e7u\u0003N<%o\\;qS:<w,\u001b3)\u0005q\u001c\u0004BBA\u0001\u0001\u0011\u00051&A\u000euKN$xI]8va&tw-\u00138Pe\u0012,'OQ=DY\u0006,8/\u001a\u0015\u0003\u007fNBa!a\u0002\u0001\t\u0003Y\u0013A\t;fgR$U\u000f\u001d7jG\u0006$X-\u0011:hk6,g\u000e\u001e+p\u000fJ|W\u000f]5oO~KG\rK\u0002\u0002\u0006MBa!!\u0004\u0001\t\u0003Y\u0013a\n;fgR<%o\\;qS:<\u0017J\\*fY\u0016\u001cGo\u00117bkN,wJ\u001a*pY2,\b/U;fefD3!a\u00034\u0011\u0019\t\u0019\u0002\u0001C\u0001W\u0005\u0011C/Z:u\u000fJ|W\u000f]5oO\u001e\u0013x.\u001e9j]\u001e|\u0016\u000eZ!oI\u001e\u0013x.\u001e9`S\u0012D3!!\u00054\u0011\u0019\tI\u0002\u0001C\u0001W\u0005aB/Z:u\u00032dwn^#yaJ,7o]5p]&s'k\u001c7mkB\f\u0004fAA\fg!1\u0011q\u0004\u0001\u0005\u0002-\n!\u0004^3ti\u0006cGn\\<FqB\u0014Xm]:j_:LenQ;cKFB3!!\b4\u0011\u0019\t)\u0003\u0001C\u0001W\u0005aB/Z:u\u00032dwn^#yaJ,7o]5p]&s'k\u001c7mkB\u0014\u0004fAA\u0012g!1\u00111\u0006\u0001\u0005\u0002-\n!\u0004^3ti\u0006cGn\\<FqB\u0014Xm]:j_:LenQ;cKJB3!!\u000b4\u0011\u0019\t\t\u0004\u0001C\u0001W\u0005aB/Z:u\u00032dwn^#yaJ,7o]5p]&s'k\u001c7mkB\u001c\u0004fAA\u0018g!1\u0011q\u0007\u0001\u0005\u0002-\nq\u0002^3ti\u000e\u000bEjQ%U\u000bFB$\u0007\u000e\u0015\u0004\u0003k\u0019\u0004BBA\u001f\u0001\u0011\u00051&\u0001\tuKN$hI]8n\u00052|wm\u001d9pi\"\u001a\u00111H\u001a\t\r\u0005\r\u0003\u0001\"\u0001,\u0003Y!Xm\u001d;Dk\n,\u0017i]$s_V\u0004\u0018N\\4TKR\u001c\bfAA!g!1\u0011\u0011\n\u0001\u0005\u0002-\n\u0001\u0004^3tiJ{G\u000e\\;q\u0003N<%o\\;qS:<7+\u001a;tQ\r\t9e\r\u0005\b\u0003\u001f\u0002A\u0011AA)\u0003M1XM]5gsBc\u0017M\\%eK:$\u0018nY1m)\u0015a\u00131KA7\u0011!\t)&!\u0014A\u0002\u0005]\u0013\u0001B:rYF\u0002B!!\u0017\u0002h9!\u00111LA2!\r\tiFL\u0007\u0003\u0003?R1!!\u0019\u0015\u0003\u0019a$o\\8u}%\u0019\u0011Q\r\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\tI'a\u001b\u0003\rM#(/\u001b8h\u0015\r\t)G\f\u0005\t\u0003_\ni\u00051\u0001\u0002X\u0005!1/\u001d73\u0001")
public class GroupingSetsTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testGroupingSets() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c, avg(a) AS a, GROUP_ID() AS g FROM MyTable\n        |GROUP BY GROUPING SETS (b, c)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingSets2() {
        this.util().verifyExecPlan("SELECT b, c, AVG(a) AS a FROM MyTable GROUP BY GROUPING SETS (b, c, ())");
    }

    @Test
    public void testGroupingSets3() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) AS gid,\n        |    COUNT(*) AS cnt\n        |FROM MyTable\n        |     GROUP BY GROUPING SETS (b, c, ())\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsOutputsNullability() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |create table t1(\n         |  a int,\n         |  b varchar,\n         |  c varchar not null,\n         |  d bigint\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '/to/my/path1',\n         |  'format' = 'testcsv'\n         |)\n      ")).stripMargin();
        this.util().tableEnv().executeSql(sourceDDL);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        | a,\n        | b,\n        | coalesce(c, 'empty'),\n        | avg(d)\n        |FROM t1\n        |GROUP BY GROUPING SETS ((a, b), (a, b, c))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCube() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY CUBE (b, c)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRollup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) as gid\n        |FROM MyTable\n        |     GROUP BY ROLLUP (b, c)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsWithOneGrouping() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno,\n        |    AVG(age) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(deptno) AS gb,\n        |    GROUPING_ID(deptno) AS gib\n        |FROM emps GROUP BY GROUPING SETS (deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testBasicGroupingSets() {
        this.util().verifyExecPlan("SELECT deptno, COUNT(*) AS c FROM emps GROUP BY GROUPING SETS ((), (deptno))");
    }

    @Test
    public void testGroupingSetsOnExpression() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno + 1, COUNT(*) AS c FROM emps GROUP BY GROUPING SETS ((), (deptno + 1))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSimpleCube() {
        this.util().verifyExecPlan("SELECT deptno + 1, COUNT(*) AS c FROM emp GROUP BY CUBE(deptno, gender)");
    }

    @Test
    public void testRollupOn1Column() {
        this.util().verifyExecPlan("SELECT deptno + 1, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno)");
    }

    @Test
    public void testRollupOn2Column() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT gender, deptno + 1, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno, gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRollupOnColumnWithNulls() {
        this.util().verifyExecPlan("SELECT gender, COUNT(*) AS c FROM emp GROUP BY ROLLUP(gender)");
    }

    @Test
    public void testRollupPlusOrderBy() {
        this.util().verifyExecPlan("SELECT gender, COUNT(*) AS c FROM emp GROUP BY ROLLUP(gender) ORDER BY c DESC");
    }

    @Test
    public void testRollupCartesianProduct() {
        this.util().verifyExecPlan("SELECT deptno, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno), ROLLUP(gender)");
    }

    @Test
    public void testRollupCartesianProductOfWithTupleWithExpression() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno / 2 + 1 AS half1, COUNT(*) AS c FROM emp\n        |GROUP BY ROLLUP(deptno / 2, gender), ROLLUP(substring(ename FROM 1 FOR 1))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRollupWithHaving() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno + 1 AS d1, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno) HAVING COUNT(*) > 3\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCubeAndDistinct() {
        this.util().verifyExecPlan("SELECT DISTINCT COUNT(*) FROM emp GROUP BY CUBE(deptno, gender)");
    }

    @Test
    public void testCubeAndJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT e.deptno, e.gender,\n        |    MIN(e.ename) AS min_name\n        |FROM emp AS e JOIN dept AS d USING (deptno)\n        |    GROUP BY CUBE(e.deptno, d.deptno, e.gender)\n        |    HAVING COUNT(*) > 2 OR gender = 'M' AND e.deptno = 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingInSelectClauseOfGroupByQuery() {
        this.util().verifyExecPlan("SELECT COUNT(*) AS c, GROUPING(deptno) AS g FROM emp GROUP BY deptno");
    }

    @Test
    public void testGroupingInSelectClauseOfCubeQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, job,\n        |    COUNT(*) AS c,\n        |    GROUPING(deptno) AS d,\n        |    GROUPING(job) j,\n        |    GROUPING(deptno, job) AS x\n        |FROM scott_emp GROUP BY CUBE(deptno, job)\n        |\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingGroup_idGrouping_idInSelectClauseOfGroupByQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) as c,\n        |    GROUPING(deptno) AS g,\n        |    GROUP_ID() AS gid,\n        |    GROUPING_ID(deptno) AS gd,\n        |    GROUPING_ID(gender) AS gg,\n        |    GROUPING_ID(gender, deptno) AS ggd,\n        |    GROUPING_ID(deptno, gender) AS gdg\n        |FROM emp GROUP BY ROLLUP(deptno, gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingAcceptsMultipleArgumentsGivesSameResultAsGrouping_id() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) AS c,\n        |    GROUPING(deptno) AS gd,\n        |    GROUPING_ID(deptno) AS gid,\n        |    GROUPING(deptno, gender, deptno) AS gdgd,\n        |    GROUPING_ID(deptno, gender, deptno) AS gidgd\n        |FROM emp\n        |    GROUP BY ROLLUP(deptno, gender)\n        |    HAVING GROUPING(deptno) <= GROUPING_ID(deptno, gender, deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingInOrderByClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno) ORDER BY GROUPING(deptno), c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDuplicateArgumentToGrouping_id() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, gender,\n        |    GROUPING_ID(deptno, gender, deptno),\n        |    COUNT(*) AS c\n        |FROM emp WHERE deptno = 10\n        |    GROUP BY ROLLUP(gender, deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingInSelectClauseOfRollupQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) AS c, deptno, GROUPING(deptno) AS g FROM emp GROUP BY ROLLUP(deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingGrouping_idAndGroup_id() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, gender,\n        |    GROUPING(deptno) gd,\n        |    GROUPING(gender) gg,\n        |    GROUPING_ID(deptno, gender) dg,\n        |    GROUPING_ID(gender, deptno) gd,\n        |    GROUP_ID() gid,\n        |    COUNT(*) c\n        |FROM emp\n        |    GROUP BY CUBE(deptno, gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInRollup1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno + 1 AS d1, deptno + 1 - 1 AS d0, COUNT(*) AS c\n        |FROM emp GROUP BY ROLLUP (deptno + 1)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInCube1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MOD(deptno, 20) AS d, COUNT(*) AS c, gender AS g\n        |FROM emp GROUP BY CUBE(MOD(deptno, 20), gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInRollup2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select MOD(deptno, 20) AS d, COUNT(*) AS c, gender AS g\n        |FROM emp GROUP BY ROLLUP(MOD(deptno, 20), gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInCube2() {
        this.util().verifyExecPlan("SELECT COUNT(*) AS c FROM emp GROUP BY CUBE(1)");
    }

    @Test
    public void testAllowExpressionInRollup3() {
        this.util().verifyExecPlan("SELECT COUNT(*) AS c FROM emp GROUP BY ROLLUP(1)");
    }

    @Test
    public void testCALCITE1824() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, GROUP_ID() AS g, COUNT(*) AS c\n        |FROM scott_emp GROUP BY GROUPING SETS (deptno, (), ())\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testFromBlogspot() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, job, empno, ename, SUM(sal) sumsal,\n        |    CASE GROUPING_ID(deptno, job, empno)\n        |    WHEN 0 THEN CAST('grouped by deptno,job,empno,ename' as varchar)\n        |    WHEN 1 THEN CAST('grouped by deptno,job' as varchar)\n        |    WHEN 3 THEN CAST('grouped by deptno' as varchar)\n        |    WHEN 7 THEN CAST('grouped by ()' as varchar)\n        |    END gr_text\n        |from scott_emp\n        |    GROUP BY ROLLUP(deptno, job, (empno,ename))\n        |    ORDER BY deptno, job, empno\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCubeAsGroupingSets() {
        String cubeQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY CUBE (b, c)\n      ")).stripMargin();
        String groupingSetsQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY GROUPING SETS ((b, c), (b), (c), ())\n      ")).stripMargin();
        this.verifyPlanIdentical(cubeQuery, groupingSetsQuery);
        this.util().verifyExecPlan(cubeQuery);
    }

    @Test
    public void testRollupAsGroupingSets() {
        String rollupQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY ROLLUP (b, c)\n      ")).stripMargin();
        String groupingSetsQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY GROUPING SETS ((b, c), (b), ())\n      ")).stripMargin();
        this.verifyPlanIdentical(rollupQuery, groupingSetsQuery);
        this.util().verifyExecPlan(rollupQuery);
    }

    public void verifyPlanIdentical(String sql1, String sql2) {
        Table table1 = this.util().tableEnv().sqlQuery(sql1);
        Table table2 = this.util().tableEnv().sqlQuery(sql2);
        RelNode optimized1 = this.util().getPlanner().optimize(TableTestUtil$.MODULE$.toRelNode(table1));
        RelNode optimized2 = this.util().getPlanner().optimize(TableTestUtil$.MODULE$.toRelNode(table2));
        Assertions.assertThat((String)FlinkRelOptUtil$.MODULE$.toString(optimized2, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7())).isEqualTo(FlinkRelOptUtil$.MODULE$.toString(optimized1, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7()));
    }

    public GroupingSetsTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("emp", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ename")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "gender"))}), new CaseClassTypeInfo<Tuple3<String, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, String>>(this, fieldSerializers){

                    public Tuple3<String, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$$anon$7 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("dept", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "dname"))}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$$anon$8 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("emps", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "gender")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "city")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empid")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "slacker")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "manager")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "joinedat"))}), new CaseClassTypeInfo<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>> unused = new ScalaCaseClassSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>>(this, fieldSerializers){

                    public Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date> createInstance(Object[] fields) {
                        return new Tuple10((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)((String)fields[4]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[5])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[6])), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[7])), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[8])), (Object)((Date)fields[9]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$$anon$9 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("scott_emp", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ename")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "job")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "mgr")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "hiredate")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "sal")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "comm")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno"))}), new CaseClassTypeInfo<Tuple8<Object, String, String, Object, Date, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple8<Object, String, String, Object, Date, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple8((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)((Date)fields[4]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[6])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[7])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.batch.sql.agg.GroupingSetsTest$$anon$10 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

