/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.batch.sql.agg.OverAggregateTest$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u0001U\u0011\u0011c\u0014<fe\u0006;wM]3hCR,G+Z:u\u0015\t\u0019A!A\u0002bO\u001eT!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)!-\u0019;dQ*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0007\u000f\u0003\u0015!\u0018M\u00197f\u0015\ty\u0001#A\u0003gY&t7N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0006\u0002\u000bU$\u0018\u000e\\:\n\u0005mA\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u0005!9!\u0005\u0001b\u0001\n\u0013\u0019\u0013\u0001B;uS2,\u0012\u0001\n\t\u0003/\u0015J!A\n\r\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007Q\u0001\u0001\u000b\u0011\u0002\u0013\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b)\u0002A\u0011A\u0016\u0002OQ,7\u000f^(wKJ<\u0016N\u001c3po^KG\u000f[8viB\u000b'\u000f^5uS>t')_(sI\u0016\u0014()\u001f\u000b\u0002YA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t!QK\\5uQ\tI3\u0007\u0005\u00025w5\tQG\u0003\u00027o\u0005\u0019\u0011\r]5\u000b\u0005aJ\u0014a\u00026va&$XM\u001d\u0006\u0003uI\tQA[;oSRL!\u0001P\u001b\u0003\tQ+7\u000f\u001e\u0005\u0006}\u0001!\taK\u0001\u001bi\u0016\u001cHo\u0014<fe^Kg\u000eZ8x/&$\bn\\;u\rJ\fW.\u001a\u0015\u0003{MBQ!\u0011\u0001\u0005\u0002-\n\u0001\u0005^3ti>3XM],j]\u0012|woV5uQ>,H\u000fU1si&$\u0018n\u001c8Cs\"\u0012\u0001i\r\u0005\u0006\t\u0002!\taK\u0001'i\u0016\u001cH\u000fR5gMB\u000b'\u000f^5uS>t7*Z=t/&$\bnU1nK>\u0013H-\u001a:LKf\u001c\bFA\"4\u0011\u00159\u0005\u0001\"\u0001,\u0003\u001d\"Xm\u001d;ES\u001a4\u0007+\u0019:uSRLwN\\&fsN<\u0016\u000e\u001e5ES\u001a4wJ\u001d3fe.+\u0017p]\u0019)\u0005\u0019\u001b\u0004\"\u0002&\u0001\t\u0003Y\u0013a\n;fgR$\u0015N\u001a4QCJ$\u0018\u000e^5p].+\u0017p],ji\"$\u0015N\u001a4Pe\u0012,'oS3zgJB#!S\u001a\t\u000b5\u0003A\u0011A\u0016\u0002OQ,7\u000f^*b[\u0016\u0004\u0016M\u001d;ji&|gnS3zg^KG\u000f\u001b#jM\u001a|%\u000fZ3s\u0017\u0016L8/\r\u0015\u0003\u0019NBQ\u0001\u0015\u0001\u0005\u0002-\nq\u0005^3tiN\u000bW.\u001a)beRLG/[8o\u0017\u0016L8oV5uQ\u0012KgMZ(sI\u0016\u00148*Z=te!\u0012qj\r\u0005\u0006'\u0002!\taK\u0001'i\u0016\u001cHoU1nKB\u000b'\u000f^5uS>t7*Z=t/&$\bnU1nK>\u0013H-\u001a:LKf\u001c\bF\u0001*4\u0011\u00151\u0006\u0001\"\u0001,\u0003Q\"Xm\u001d;TC6,\u0007+\u0019:uSRLwN\\&fsN<\u0016\u000e\u001e5TC6,wJ\u001d3fe.+\u0017p],ji\",U\u000e\u001d;z\u001fJ$WM\u001d\u0015\u0003+NBQ!\u0017\u0001\u0005\u0002-\nA\u0007^3tiN\u000bW.\u001a)beRLG/[8o\u0017\u0016L8oV5uQN\u000bW.Z(sI\u0016\u00148*Z=t\t&4g\rR5sK\u000e$\u0018n\u001c82Q\tA6\u0007C\u0003]\u0001\u0011\u00051&\u0001\u001buKN$8+Y7f!\u0006\u0014H/\u001b;j_:\\U-_:XSRD7+Y7f\u001fJ$WM]&fsN$\u0015N\u001a4ESJ,7\r^5p]JB#aW\u001a\t\u000b}\u0003A\u0011A\u0016\u0002YQ,7\u000f^*b[\u0016\u0004\u0016M\u001d;ji&|gnS3zg^KG\u000f[*b[\u0016|%\u000fZ3s\u0017\u0016L8\u000f\u0015:fM&D\bF\u000104\u0011\u0015\u0011\u0007\u0001\"\u0001,\u0003\u0015\"Xm\u001d;Pm\u0016\u0014x+\u001b8e_^\u0004\u0004K]3dK\u0012LgnZ!oIB2u\u000e\u001c7po&tw\r\u000b\u0002bg!)Q\r\u0001C\u0001W\u0005)C/Z:u\u001fZ,'oV5oI><8)\u001e:sK:$(k\\<B]\u0012\u0004di\u001c7m_^Lgn\u001a\u0015\u0003INBQ\u0001\u001b\u0001\u0005\u0002-\nQ\u0005^3ti>3XM],j]\u0012|w\u000f\r)sK\u000e,G-\u001b8h\u0003:$7)\u001e:sK:$(k\\<)\u0005\u001d\u001c\u0004\"B6\u0001\t\u0003Y\u0013a\b;fgR|e/\u001a:XS:$wn\u001e*b]\u001e,\u0007K]8iS\nLG\u000fV=qK\"\u0012!n\r\u0005\u0006]\u0002!\taK\u0001\u0018i\u0016\u001cHo\u0014<fe^Kg\u000eZ8x%\u0006tw-\u001a+za\u0016D#!\\\u001a\t\u000bE\u0004A\u0011A\u0016\u00029Q,7\u000f^'vYRLwJ^3s/&tGm\\<SC:<W\rV=qK\"\u0012\u0001o\r\u0005\u0006i\u0002!\taK\u0001\u001bi\u0016\u001cHOU8xg^Kg\u000eZ8x/&$\bNT3hCRLg/\u001a\u0015\u0003gNBQa\u001e\u0001\u0005\u0002-\nA\u0004^3tiJ\u000bgnZ3XS:$wn^,ji\"tUmZ1uSZ,\u0017\u0007\u000b\u0002wg!)!\u0010\u0001C\u0001W\u0005aB/Z:u%\u0006tw-Z,j]\u0012|woV5uQ:+w-\u0019;jm\u0016\u0014\u0004FA=4\u0011\u0015i\b\u0001\"\u0001,\u0003\u0019\"Xm\u001d;SC:\\'+\u00198hK^Kg\u000eZ8x/&$\bnQ8na>\u001c\u0018\u000e^3Pe\u0012,'o\u001d\u0015\u0003yNBa!!\u0001\u0001\t\u0003Y\u0013!\t;fgR\u0014\u0016M\\6SC:<WmV5oI><x+\u001b;i\u0007>t7\u000f^1oiN\f\u0004FA@4\u0011\u0019\t9\u0001\u0001C\u0001W\u0005\tC/Z:u%\u0006t7NU1oO\u0016<\u0016N\u001c3po^KG\u000f[\"p]N$\u0018M\u001c;te!\u001a\u0011QA\u001a\t\r\u00055\u0001\u0001\"\u0001,\u0003q!Xm\u001d;Pm\u0016\u0014x+\u001b8e_^<\u0016\u000e\u001e5D_:\u001cH/\u00198ugNB3!a\u00034\u0011\u0019\t\u0019\u0002\u0001C\u0001W\u0005aA/Z:u\t&\u001cH/\u001b8di\"\u001a\u0011\u0011C\u001a\t\r\u0005e\u0001\u0001\"\u0001,\u0003i!Xm\u001d;J]Z\fG.\u001b3Pm\u0016\u0014\u0018iZ4sK\u001e\fG/[8oQ\r\t9b\r\u0005\u0007\u0003?\u0001A\u0011A\u0016\u00027Q,7\u000f^%om\u0006d\u0017\u000eZ(wKJ\fum\u001a:fO\u0006$\u0018n\u001c83Q\r\tib\r")
public class OverAggregateTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testOverWindowWithoutPartitionByOrderBy() {
        this.util().verifyExecPlan("SELECT c, COUNT(*) OVER () FROM MyTable");
    }

    @Test
    public void testOverWindowWithoutFrame() {
        this.util().verifyExecPlan("SELECT c, COUNT(*) OVER (PARTITION BY c) FROM MyTable");
    }

    @Test
    public void testOverWindowWithoutPartitionBy() {
        this.util().verifyExecPlan("SELECT c, SUM(a) OVER (ORDER BY b) FROM MyTable");
    }

    @Test
    public void testDiffPartitionKeysWithSameOrderKeys() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MAX(a) OVER (PARTITION BY c ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDiffPartitionKeysWithDiffOrderKeys1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY c),\n        |    AVG(a) OVER (PARTITION BY c ORDER BY a),\n        |    RANK() OVER (PARTITION BY b ORDER BY a),\n        |    MIN(a) OVER (PARTITION BY c ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDiffPartitionKeysWithDiffOrderKeys2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY c),\n        |    MAX(a) OVER (PARTITION BY c ORDER BY a),\n        |    MIN(a) OVER (ORDER BY c, a),\n        |    RANK() OVER (PARTITION BY b ORDER BY c),\n        |    AVG(a) OVER (ORDER BY b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithDiffOrderKeys1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY c),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY b),\n        |    AVG(a) OVER (PARTITION BY b ORDER BY a),\n        |    RANK() OVER (PARTITION BY b ORDER BY c),\n        |    MIN(a) OVER (PARTITION BY b ORDER BY b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithDiffOrderKeys2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY c),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a),\n        |    AVG(a) OVER (PARTITION BY b ORDER BY a, c),\n        |    RANK() OVER (PARTITION BY b ORDER BY a, b),\n        |    MIN(a) OVER (PARTITION BY b ORDER BY b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeys() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysWithEmptyOrder() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MIN(a) OVER (PARTITION BY b),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysDiffDirection1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a ASC),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a ASC),\n        |    AVG(a) OVER (PARTITION BY b ORDER BY a DESC),\n        |    RANK() OVER (PARTITION BY b ORDER BY a ASC),\n        |    MIN(a) OVER (PARTITION BY b ORDER BY a DESC)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysDiffDirection2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    RANK() OVER (PARTITION BY b ORDER BY a DESC),\n        |    RANK() OVER (PARTITION BY b ORDER BY a ASC)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysPrefix() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a,\n        |    RANK() OVER (PARTITION BY b ORDER BY c, a DESC),\n        |    RANK() OVER (PARTITION BY b ORDER BY c, b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testOverWindow0PrecedingAnd0Following() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a ROWS BETWEEN 0 PRECEDING AND 0 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testOverWindowCurrentRowAnd0Following() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a ROWS BETWEEN CURRENT ROW AND 0 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testOverWindow0PrecedingAndCurrentRow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a ROWS BETWEEN 0 PRECEDING AND CURRENT ROW)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testOverWindowRangeProhibitType() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY c RANGE BETWEEN -1 PRECEDING AND 10 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testOverWindowRangeType() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 PRECEDING AND 10 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testMultiOverWindowRangeType() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 PRECEDING AND 10 FOLLOWING),\n        |    SUM(a) OVER (PARTITION BY c ORDER BY a),\n        |    RANK() OVER (PARTITION BY c ORDER BY a, c),\n        |    SUM(a) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN 1 PRECEDING AND 10 FOLLOWING),\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY c ROWS BETWEEN 1 PRECEDING AND 10 FOLLOWING)\n        | FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRowsWindowWithNegative() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a ROWS BETWEEN -1 PRECEDING AND 10 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testRangeWindowWithNegative1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 PRECEDING AND 10 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRangeWindowWithNegative2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 FOLLOWING AND 10 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRankRangeWindowWithCompositeOrders() {
        this.util().verifyExecPlan("SELECT RANK() OVER (PARTITION BY c ORDER BY a, c) FROM MyTable");
    }

    @Test
    public void testRankRangeWindowWithConstants1() {
        this.util().verifyExecPlan("SELECT COUNT(1) OVER () FROM MyTable");
    }

    @Test
    public void testRankRangeWindowWithConstants2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 FOLLOWING AND 10 FOLLOWING),\n        |    COUNT(1) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 FOLLOWING and 10 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testOverWindowWithConstants3() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(2) OVER (ORDER BY a),\n        |    COUNT(1) OVER (PARTITION BY c ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDistinct() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT SUM(DISTINCT a)\n        |    OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 FOLLOWING AND 10 FOLLOWING)\n        |FROM MyTable\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testInvalidOverAggregation() {
        this.util().addTemporarySystemFunction("overAgg", (UserDefinedFunction)new JavaUserDefinedAggFunctions.OverAgg0());
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT overAgg(b, a) FROM MyTable"));
    }

    @Test
    public void testInvalidOverAggregation2() {
        this.util().addTableSource("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.agg.OverAggregateTest$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTemporarySystemFunction("overAgg", (UserDefinedFunction)new JavaUserDefinedAggFunctions.OverAgg0());
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT overAgg(b, a) FROM T GROUP BY TUMBLE(ts, INTERVAL '2' HOUR)"));
    }

    public OverAggregateTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.agg.OverAggregateTest$$anon$3 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

