/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.agg;

import java.util.Collection;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.plan.batch.sql.agg.AggregateTestBase;
import org.apache.flink.table.planner.plan.batch.sql.agg.SortAggregateTest$;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.planner.utils.AggregatePhaseStrategy;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001+\t\t2k\u001c:u\u0003\u001e<'/Z4bi\u0016$Vm\u001d;\u000b\u0005\r!\u0011aA1hO*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0011\u0017\r^2i\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0012\u0003\u001e<'/Z4bi\u0016$Vm\u001d;CCN,\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0017\u0005<wm\u0015;sCR,w-\u001f\t\u0003;\u0001j\u0011A\b\u0006\u0003?)\tQ!\u001e;jYNL!!\t\u0010\u0003-\u0005;wM]3hCR,\u0007\u000b[1tKN#(/\u0019;fOfDQa\t\u0001\u0005\u0002\u0011\na\u0001P5oSRtDCA\u0013'!\t9\u0002\u0001C\u0003\u001cE\u0001\u0007A\u0004C\u0003)\u0001\u0011\u0005\u0011&\u0001\u0004cK\u001a|'/\u001a\u000b\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t!QK\\5uQ\t9\u0013\u0007\u0005\u00023s5\t1G\u0003\u00025k\u0005\u0019\u0011\r]5\u000b\u0005Y:\u0014a\u00026va&$XM\u001d\u0006\u0003qI\tQA[;oSRL!AO\u001a\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0003=\u0001\u0011\u0005\u0011&\u0001\u000fuKN$\u0018\t\u001d9s_bLW.\u0019;f\u0007>,h\u000e\u001e#jgRLgn\u0019;)\u0005mr\u0004C\u0001\u001a@\u0013\t\u00015G\u0001\u0007UKN$H+Z7qY\u0006$X\r\u000b\u0003\u0001\u0005\"K\u0005CA\"G\u001b\u0005!%BA#4\u0003%)\u0007\u0010^3og&|g.\u0003\u0002H\t\nQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0003)\u001b\u0013a\u0013\t\u0003\u0019Rk\u0011!\u0014\u0006\u0003\u001d>\u000bQ\u0002]1sC6,G/\u001a:ju\u0016$'B\u0001)R\u0003))\u0007\u0010^3og&|gn\u001d\u0006\u0003qIS!a\u0015\b\u0002\u0013Q,7\u000f^;uS2\u001c\u0018BA+N\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u000f\u00159&\u0001#\u0001Y\u0003E\u0019vN\u001d;BO\u001e\u0014XmZ1uKR+7\u000f\u001e\t\u0003/e3Q!\u0001\u0002\t\u0002i\u001b\"!W.\u0011\u0005-b\u0016BA/-\u0005\u0019\te.\u001f*fM\")1%\u0017C\u0001?R\t\u0001\fC\u0003b3\u0012\u0005!-\u0001\u0006qCJ\fW.\u001a;feN$\u0012a\u0019\t\u0004I&dR\"A3\u000b\u0005\u0019<\u0017\u0001B;uS2T\u0011\u0001[\u0001\u0005U\u00064\u0018-\u0003\u0002kK\nQ1i\u001c7mK\u000e$\u0018n\u001c8)\t\u0001dw\u000e\u001d\t\u0003\u00196L!A\\'\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\u0003oC6,\u0017%A9\u0002\u001f\u0005<wm\u0015;sCR,w-_\u001f|au\u0004")
public class SortAggregateTest
extends AggregateTestBase {
    private final AggregatePhaseStrategy aggStrategy;

    @Parameters(name="aggStrategy={0}")
    public static Collection<AggregatePhaseStrategy> parameters() {
        return SortAggregateTest$.MODULE$.parameters();
    }

    @BeforeEach
    public void before() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)OperatorType.HashAgg.toString());
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)this.aggStrategy.toString());
    }

    @TestTemplate
    public void testApproximateCountDistinct() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT \n        | APPROX_COUNT_DISTINCT(`byte`), \n        | APPROX_COUNT_DISTINCT(`short`), \n        | APPROX_COUNT_DISTINCT(`int`), \n        | APPROX_COUNT_DISTINCT(`long`), \n        | APPROX_COUNT_DISTINCT(`float`), \n        | APPROX_COUNT_DISTINCT(`double`), \n        | APPROX_COUNT_DISTINCT(`string`), \n        | APPROX_COUNT_DISTINCT(`date`), \n        | APPROX_COUNT_DISTINCT(`time`), \n        | APPROX_COUNT_DISTINCT(`timestamp`), \n        | APPROX_COUNT_DISTINCT(`decimal3020`), \n        | APPROX_COUNT_DISTINCT(`decimal105`)\n        | FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    public SortAggregateTest(AggregatePhaseStrategy aggStrategy) {
        this.aggStrategy = aggStrategy;
    }
}

