/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.join;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.batch.sql.join.LookupJoinTest$;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.stream.sql.join.TestTemporalTable$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001U\u0011a\u0002T8pWV\u0004(j\\5o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005!!n\\5o\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000b\t\fGo\u00195\u000b\u0005%Q\u0011\u0001\u00029mC:T!a\u0003\u0007\u0002\u000fAd\u0017M\u001c8fe*\u0011QBD\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001fA\tQA\u001a7j].T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9\"$D\u0001\u0019\u0015\tI\"\"A\u0003vi&d7/\u0003\u0002\u001c1\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016D\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0012Y\u0016<\u0017mY=UC\ndWmU8ve\u000e,\u0007CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#a\u0002\"p_2,\u0017M\u001c\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u001dJ\u0003C\u0001\u0015\u0001\u001b\u0005\u0011\u0001\"B\u000f%\u0001\u0004q\u0002bB\u0016\u0001\u0005\u0004%I\u0001L\u0001\ti\u0016\u001cH/\u0016;jYV\tQ\u0006\u0005\u0002\u0018]%\u0011q\u0006\u0007\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG\u000e\u0003\u00042\u0001\u0001\u0006I!L\u0001\ni\u0016\u001cH/\u0016;jY\u0002BQa\r\u0001\u0005\u0002Q\naAY3g_J,G#A\u001b\u0011\u0005}1\u0014BA\u001c!\u0005\u0011)f.\u001b;)\u0005IJ\u0004C\u0001\u001eB\u001b\u0005Y$B\u0001\u001f>\u0003\r\t\u0007/\u001b\u0006\u0003}}\nqA[;qSR,'O\u0003\u0002A%\u0005)!.\u001e8ji&\u0011!i\u000f\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0007\"\u0002#\u0001\t\u0003!\u0014\u0001\t;fgRTu.\u001b8J]Z\fG.\u001b3K_&tG+Z7q_J\fG\u000eV1cY\u0016D#a\u0011$\u0011\u0005i:\u0015B\u0001%<\u00051!Vm\u001d;UK6\u0004H.\u0019;f\u0011\u0015Q\u0005\u0001\"\u00015\u0003\t\"Xm\u001d;O_R$\u0015n\u001d;j]\u000e$hI]8n\u0013:Tu.\u001b8D_:$\u0017\u000e^5p]\"\u0012\u0011J\u0012\u0005\u0006\u001b\u0002!\t\u0001N\u0001\u001di\u0016\u001cH\u000fU=uQ>tW\u000b\u0012$J]*{\u0017N\\\"p]\u0012LG/[8oQ\tae\tC\u0003Q\u0001\u0011\u0005A'A\buKN$Hj\\4jG\u0006d\u0007\u000b\\1oQ\tye\tC\u0003T\u0001\u0011\u0005A'A\u0012uKN$Hj\\4jG\u0006d\u0007\u000b\\1o/&$\b.S7qY&\u001c\u0017\u000e\u001e+za\u0016\u001c\u0015m\u001d;)\u0005I3\u0005\"\u0002,\u0001\t\u0003!\u0014!\u0006;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.\u001a\u0015\u0003+\u001aCQ!\u0017\u0001\u0005\u0002Q\n\u0011\u0004^3ti2+g\r\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK\"\u0012\u0001L\u0012\u0005\u00069\u0002!\t\u0001N\u0001%i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\bNT3ti\u0016$\u0017+^3ss\"\u00121L\u0012\u0005\u0006?\u0002!\t\u0001N\u0001,i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b\u000e\u0015:pU\u0016\u001cG/[8o!V\u001c\b\u000eR8x]\"\u0012aL\u0012\u0005\u0006E\u0002!\t\u0001N\u0001(i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\bNR5mi\u0016\u0014\b+^:i\t><h\u000e\u000b\u0002b\r\")Q\r\u0001C\u0001i\u0005QB/Z:u\u0003Z|\u0017\u000eZ!hOJ,w-\u0019;f!V\u001c\b\u000eR8x]\"\u0012AM\u0012\u0005\u0006Q\u0002!\t\u0001N\u0001'i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b\u000e\u0016:vK\u000e{g\u000eZ5uS>t\u0007FA4G\u0011\u0015Y\u0007\u0001\"\u00015\u0003\u001d\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5D_6\u0004X\u000f^3e\u0007>dW/\u001c8)\u0005)4\u0005\"\u00028\u0001\t\u0003!\u0014A\r;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"\u001cu.\u001c9vi\u0016$7i\u001c7v[:\fe\u000e\u001a)vg\"$un\u001e8)\u000554\u0005\"B9\u0001\t\u0003!\u0014a\u0003;fgR\u0014V-^:j]\u001eD#\u0001\u001d$\t\u000bQ\u0004A\u0011B;\u0002+\u0015D\b/Z2u\u000bb\u001cW\r\u001d;j_:$\u0006N]8x]R1QG^A\u0003\u0003\u0013AQ!B:A\u0002]\u0004\"\u0001_@\u000f\u0005el\bC\u0001>!\u001b\u0005Y(B\u0001?\u0015\u0003\u0019a$o\\8u}%\u0011a\u0010I\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00111\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y\u0004\u0003BBA\u0004g\u0002\u0007q/\u0001\u0005lKf<xN\u001d3t\u0011%\tYa\u001dI\u0001\u0002\u0004\ti!A\u0003dY\u0006T(\u0010\r\u0003\u0002\u0010\u0005e\u0001#\u0002=\u0002\u0012\u0005U\u0011\u0002BA\n\u0003\u0007\u0011Qa\u00117bgN\u0004B!a\u0006\u0002\u001a1\u0001A\u0001DA\u000e\u0003\u0013\t\t\u0011!A\u0003\u0002\u0005u!aA0%cE!\u0011qDA\u0013!\ry\u0012\u0011E\u0005\u0004\u0003G\u0001#a\u0002(pi\"Lgn\u001a\t\u0005\u0003O\t\tD\u0004\u0003\u0002*\u00055bb\u0001>\u0002,%\t\u0011%C\u0002\u00020\u0001\nq\u0001]1dW\u0006<W-\u0003\u0003\u00024\u0005U\"!\u0003+ie><\u0018M\u00197f\u0015\r\ty\u0003\t\u0005\n\u0003s\u0001\u0011\u0013!C\u0005\u0003w\tq$\u001a=qK\u000e$X\t_2faRLwN\u001c+ie><h\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\ti\u0004\r\u0003\u0002@\u0005\r\u0003#\u0002=\u0002\u0012\u0005\u0005\u0003\u0003BA\f\u0003\u0007\"A\"a\u0007\u00028\u0005\u0005\t\u0011!B\u0001\u0003;As\u0001AA$\u0003'\n)\u0006\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\tieO\u0001\nKb$XM\\:j_:LA!!\u0015\u0002L\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0005\u0005]3EAA-!\u0011\tY&a\u001b\u000e\u0005\u0005u#\u0002BA0\u0003C\nQ\u0002]1sC6,G/\u001a:ju\u0016$'\u0002BA2\u0003K\n!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\r\u0001\u0015q\r\u0006\u0004\u0003Sr\u0011!\u0003;fgR,H/\u001b7t\u0013\u0011\ti'!\u0018\u00035A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8\b\u000f\u0005E$\u0001#\u0001\u0002t\u0005qAj\\8lkBTu.\u001b8UKN$\bc\u0001\u0015\u0002v\u00191\u0011A\u0001E\u0001\u0003o\u001aB!!\u001e\u0002zA\u0019q$a\u001f\n\u0007\u0005u\u0004E\u0001\u0004B]f\u0014VM\u001a\u0005\bK\u0005UD\u0011AAA)\t\t\u0019\b\u0003\u0005\u0002\u0006\u0006UD\u0011AAD\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0003\u0003\u0013\u0003b!a#\u0002\u0016\u0006eUBAAG\u0015\u0011\ty)!%\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003'\u000bAA[1wC&!\u0011qSAG\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0006?\u0005m\u0015qT\u0005\u0004\u0003;\u0003#!B!se\u0006L\b\u0003BAQ\u0003Ok!!a)\u000b\t\u0005\u0015\u0016\u0011S\u0001\u0005Y\u0006tw-\u0003\u0003\u0002*\u0006\r&AB(cU\u0016\u001cG\u000f\u000b\u0005\u0002\u0004\u00065\u00161WA[!\u0011\tY&a,\n\t\u0005E\u0016Q\f\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\u0001\u00028b[\u0016\f#!a.\u0002+1+w-Y2z)\u0006\u0014G.Z*pkJ\u001cW-P>1{\u0002")
public class LookupJoinTest
extends TableTestBase {
    private final boolean legacyTableSource;
    private final BatchTableTestUtil testUtil;

    @Parameters(name="LegacyTableSource={0}")
    public static Collection<Object[]> parameters() {
        return LookupJoinTest$.MODULE$.parameters();
    }

    private BatchTableTestUtil testUtil() {
        return this.testUtil;
    }

    @BeforeEach
    public void before() {
        this.testUtil().addDataStream("T0", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.join.LookupJoinTest$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.testUtil().addDataStream("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple4<Object, String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.join.LookupJoinTest$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.testUtil().addDataStream("nonTemporal", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.join.LookupJoinTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table myTable = this.testUtil().tableEnv().sqlQuery("SELECT *, PROCTIME() as proctime FROM T0");
        this.testUtil().tableEnv().createTemporaryView("MyTable", myTable);
        if (this.legacyTableSource) {
            TestTemporalTable$.MODULE$.createTemporaryTable(this.testUtil().tableEnv(), "LookupTable", true, TestTemporalTable$.MODULE$.createTemporaryTable$default$4());
        } else {
            this.testUtil().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                          |CREATE TABLE LookupTable (\n                          |  `id` INT,\n                          |  `name` STRING,\n                          |  `age` INT\n                          |) WITH (\n                          |  'connector' = 'values',\n                          |  'bounded' = 'true'\n                          |)\n                          |")).stripMargin());
            this.testUtil().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                          |CREATE TABLE LookupTableWithComputedColumn (\n                          |  `id` INT,\n                          |  `name` STRING,\n                          |  `age` INT,\n                          |  `nominal_age` as age + 1\n                          |) WITH (\n                          |  'connector' = 'values',\n                          |  'bounded' = 'true'\n                          |)\n                          |")).stripMargin());
        }
    }

    @TestTemplate
    public void testJoinInvalidJoinTemporalTable() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T JOIN LookupTable T.proc AS D ON T.a = D.id", "SQL parse failed", SqlParserException.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T RIGHT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id", null, AssertionError.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a + 1 = D.id + 1", "Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable].", TableException.class);
    }

    @TestTemplate
    public void testNotDistinctFromInJoinCondition() {
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a IS NOT  DISTINCT FROM D.id", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
        this.expectExceptionThrown("SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id OR (T.a IS NULL AND D.id IS NULL)", "LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or alternative '(a = b) or (a IS NULL AND b IS NULL)')", TableException.class);
    }

    @TestTemplate
    public void testPythonUDFInJoinCondition() {
        this.testUtil().addTemporarySystemFunction("pyFunc", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.PythonScalarFunction("pyFunc"));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |LEFT OUTER JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10 AND pyFunc(D.age, T.a) > 100\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.testUtil().verifyExecPlan(sql)).hasMessageContaining("Only inner join condition with equality predicates supports the Python UDF taking the inputs from the left table and the right table at the same time, e.g., ON T1.id = T2.id && pythonUdf(T1.a, T2.b)") instanceof TableException;
    }

    @TestTemplate
    public void testLogicalPlan() {
        String sql1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, a, sum(c) c, sum(d) d, PROCTIME() as proctime\n        |FROM T1\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(157).append("\n         |SELECT T.* FROM (").append(sql1).append(") AS T\n         |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n         |ON T.a = D.id\n         |WHERE D.age > 10\n      ").toString())).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n         |SELECT b, count(a), sum(c), sum(d)\n         |FROM (").append(sql2).append(") AS T\n         |GROUP BY b\n      ").toString())).stripMargin();
        FlinkChainedProgram programs = FlinkBatchProgram$.MODULE$.buildProgram((ReadableConfig)this.testUtil().tableEnv().getConfig());
        programs.remove(FlinkBatchProgram$.MODULE$.PHYSICAL());
        this.testUtil().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.testUtil().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testLogicalPlanWithImplicitTypeCast() {
        FlinkChainedProgram programs = FlinkBatchProgram$.MODULE$.buildProgram((ReadableConfig)this.testUtil().tableEnv().getConfig());
        programs.remove(FlinkBatchProgram$.MODULE$.PHYSICAL());
        this.testUtil().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.testUtil().verifyRelPlan("SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.b = D.id")).hasMessageContaining("implicit type conversion between VARCHAR(2147483647) and INTEGER is not supported on join's condition now") instanceof TableException;
    }

    @TestTemplate
    public void testJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.testUtil().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testLeftJoinTemporalTable() {
        String sql = "SELECT * FROM MyTable AS T LEFT JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.testUtil().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithNestedQuery() {
        String sql = "SELECT * FROM (SELECT a, b, proctime FROM MyTable WHERE c > 1000) AS T JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D ON T.a = D.id";
        this.testUtil().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithProjectionPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT T.*, D.id\n        |FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id\n      ")).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithFilterPushDown() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON T.a = D.id AND D.age = 10\n        |WHERE T.c > 1000\n      ")).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testAvoidAggregatePushDown() {
        String sql1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, a, sum(c) c, sum(d) d, PROCTIME() as proctime\n        |FROM T1\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(157).append("\n         |SELECT T.* FROM (").append(sql1).append(") AS T\n         |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n         |ON T.a = D.id\n         |WHERE D.age > 10\n      ").toString())).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n         |SELECT b, count(a), sum(c), sum(d)\n         |FROM (").append(sql2).append(") AS T\n         |GROUP BY b\n      ").toString())).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithTrueCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable AS T\n        |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n        |ON true\n        |WHERE T.c > 1000\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.testUtil().verifyExplain(sql)).hasMessageContaining("Temporal table join requires an equality condition on fields of table [default_catalog.default_database.LookupTable]") instanceof TableException;
    }

    @TestTemplate
    public void testJoinTemporalTableWithComputedColumn() {
        Assumptions.assumeThat((boolean)this.legacyTableSource).isFalse();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id\n      ")).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        Assumptions.assumeThat((boolean)this.legacyTableSource).isFalse();
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.a, T.b, T.c, D.name, D.age, D.nominal_age\n        |FROM\n        |  MyTable AS T JOIN LookupTableWithComputedColumn FOR SYSTEM_TIME AS OF T.proctime AS D\n        |  ON T.a = D.id and D.nominal_age > 12\n      ")).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    @TestTemplate
    public void testReusing() {
        this.testUtil().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sql1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, a, sum(c) c, sum(d) d, PROCTIME() as proctime\n        |FROM T1\n        |GROUP BY a, b\n      ")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(155).append("\n         |SELECT * FROM (").append(sql1).append(") AS T\n         |JOIN LookupTable FOR SYSTEM_TIME AS OF T.proctime AS D\n         |ON T.a = D.id\n         |WHERE D.age > 10\n      ").toString())).stripMargin();
        String sql3 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(49).append("\n         |SELECT id as a, b FROM (").append(sql2).append(") AS T\n       ").toString())).stripMargin();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append("\n         |SELECT count(T1.a), count(T1.id), sum(T2.a)\n         |FROM (").append(sql2).append(") AS T1, (").append(sql3).append(") AS T2\n         |WHERE T1.a = T2.a\n         |GROUP BY T1.b, T2.b\n      ").toString())).stripMargin();
        this.testUtil().verifyExecPlan(sql);
    }

    private void expectExceptionThrown(String sql, String keywords, Class<? extends Throwable> clazz) {
        ThrowableAssert.ThrowingCallable callable = () -> this.testUtil().verifyExplain(sql);
        if (keywords != null) {
            Assertions.assertThatExceptionOfType(clazz).isThrownBy(callable).withMessageContaining(keywords);
        } else {
            Assertions.assertThatExceptionOfType(clazz).isThrownBy(callable);
        }
    }

    private Class<? extends Throwable> expectExceptionThrown$default$3() {
        return ValidationException.class;
    }

    public LookupJoinTest(boolean legacyTableSource) {
        this.legacyTableSource = legacyTableSource;
        this.testUtil = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

