/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.join;

import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001+\t\u0001B+Z7q_J\fGNS8j]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tAA[8j]*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0011\u0017\r^2i\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\u0011\u0011DC\u0001\u0006kRLGn]\u0005\u00037a\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0003\u0011\u001d\u0011\u0003A1A\u0005\u0002\r\nA!\u001e;jYV\tA\u0005\u0005\u0002\u0018K%\u0011a\u0005\u0007\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG\u000e\u0003\u0004)\u0001\u0001\u0006I\u0001J\u0001\u0006kRLG\u000e\t\u0005\u0006U\u0001!\taK\u0001\u0007E\u00164wN]3\u0015\u00031\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012A!\u00168ji\"\u0012\u0011f\r\t\u0003imj\u0011!\u000e\u0006\u0003m]\n1!\u00199j\u0015\tA\u0014(A\u0004kkBLG/\u001a:\u000b\u0005i\u0012\u0012!\u00026v]&$\u0018B\u0001\u001f6\u0005)\u0011UMZ8sK\u0016\u000b7\r\u001b\u0005\u0006}\u0001!\taK\u0001\u000fi\u0016\u001cHoU5na2,'j\\5oQ\ti\u0004\t\u0005\u00025\u0003&\u0011!)\u000e\u0002\u0005)\u0016\u001cH\u000fC\u0003E\u0001\u0011\u00051&\u0001\u0012uKN$8+[7qY\u0016\u0014vn\u001e;j[\u00164VM]:j_:,GMV5fo*{\u0017N\u001c\u0015\u0003\u0007\u0002CQa\u0012\u0001\u0005\u0002-\n1\u0005^3tiNKW\u000e\u001d7f!J|7\r^5nKZ+'o]5p]\u0016$g+[3x\u0015>Lg\u000e\u000b\u0002G\u0001\")!\n\u0001C\u0001W\u0005QB/Z:u'&l\u0007\u000f\\3WS\u0016<\bK]8d)&lWMS8j]\"\u0012\u0011\n\u0011")
public class TemporalJoinTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    public BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE Orders (\n                    | o_amount INT,\n                    | o_currency STRING,\n                    | o_rowtime TIMESTAMP(3),\n                    | o_proctime as PROCTIME(),\n                    | WATERMARK FOR o_rowtime AS o_rowtime\n                    |) WITH (\n                    | 'connector' = 'values',\n                    | 'bounded' = 'true'\n                    |)\n      ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE RatesHistory (\n                    | currency STRING,\n                    | rate INT,\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime\n                    |) WITH (\n                    | 'connector' = 'values',\n                    | 'bounded' = 'true'\n                    |)\n      ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE RatesHistoryWithPK (\n                    | currency STRING,\n                    | rate INT,\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime,\n                    | PRIMARY KEY(currency) NOT ENFORCED\n                    |) WITH (\n                    | 'connector' = 'values',\n                    | 'bounded' = 'true'\n                    |)\n      ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE RatesOnly (\n                    | currency STRING,\n                    | rate INT,\n                    | proctime AS PROCTIME()\n                    |) WITH (\n                    | 'connector' = 'values',\n                    | 'bounded' = 'true'\n                    |)\n      ")).stripMargin());
        this.util().addTable(" CREATE VIEW rates_last_row_rowtime as SELECT currency, rate, rowtime FROM   (SELECT *,           ROW_NUMBER() OVER (PARTITION BY currency ORDER BY rowtime DESC) AS rowNum    FROM RatesHistory  ) T   WHERE rowNum = 1");
        this.util().addTable(" CREATE VIEW rates_last_row_proctime as SELECT currency, rate, proctime FROM   (SELECT *,           ROW_NUMBER() OVER (PARTITION BY currency ORDER BY proctime DESC) AS rowNum    FROM RatesOnly  ) T  WHERE rowNum = 1");
        this.util().addTable("CREATE VIEW rates_last_value AS SELECT currency, LAST_VALUE(rate) AS rate FROM RatesHistory GROUP BY currency ");
    }

    @Test
    public void testSimpleJoin() {
        String sqlQuery = "SELECT o_amount * rate as rate FROM Orders AS o JOIN RatesHistoryWithPK FOR SYSTEM_TIME AS OF o.o_rowtime as r on o.o_currency = r.currency";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testSimpleRowtimeVersionedViewJoin() {
        String sqlQuery = "SELECT o_amount * rate as rate FROM Orders AS o JOIN rates_last_row_rowtime FOR SYSTEM_TIME AS OF o.o_rowtime as r1 on o.o_currency = r1.currency";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testSimpleProctimeVersionedViewJoin() {
        String sqlQuery = "SELECT o_amount * rate as rate FROM Orders AS o JOIN rates_last_row_proctime FOR SYSTEM_TIME AS OF o.o_proctime as r1 on o.o_currency = r1.currency";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testSimpleViewProcTimeJoin() {
        String sqlQuery = "SELECT o_amount * rate as rate FROM Orders AS o JOIN rates_last_value FOR SYSTEM_TIME AS OF o.o_proctime as r1 on o.o_currency = r1.currency";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }
}

