/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkRuleSetProgram;
import org.apache.flink.table.planner.plan.rules.logical.FlinkAggregateRemoveRule;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005me!B\u0001\u0003\u0003\u0003\t\"aH!hOJ,w-\u0019;f%\u0016$WoY3He>,\b/\u001b8h)\u0016\u001cHOQ1tK*\u00111\u0001B\u0001\u0007G>lWn\u001c8\u000b\u0005\u00151\u0011\u0001\u00029mC:T!a\u0002\u0005\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\t)b!A\u0003vi&d7/\u0003\u0002\u0018)\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016D\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\ro&$\b.\u0012=fGBc\u0017M\u001c\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\b\u0005>|G.Z1o\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\u00111%\n\t\u0003I\u0001i\u0011A\u0001\u0005\u00063\u0001\u0002\rA\u0007\u0005\bO\u0001\u0011\r\u0011\"\u0005)\u0003\u0011)H/\u001b7\u0016\u0003%\u0002\"a\u0005\u0016\n\u0005-\"\"A\u0005\"bi\u000eDG+\u00192mKR+7\u000f^+uS2Da!\f\u0001!\u0002\u0013I\u0013!B;uS2\u0004\u0003\"B\u0018\u0001\t\u0003\u0001\u0014!B:fiV\u0004H#A\u0019\u0011\u0005m\u0011\u0014BA\u001a\u001d\u0005\u0011)f.\u001b;)\u00059*\u0004C\u0001\u001c>\u001b\u00059$B\u0001\u001d:\u0003\r\t\u0007/\u001b\u0006\u0003um\nqA[;qSR,'O\u0003\u0002=\u001d\u0005)!.\u001e8ji&\u0011ah\u000e\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0007\"\u0002!\u0001\t\u0003\u0001\u0014!\u0006;fgR\fumZ,ji\"|W\u000f^!hO\u000e\u000bG\u000e\u001c\u0015\u0003\u007f\t\u0003\"AN\"\n\u0005\u0011;$\u0001\u0002+fgRDQA\u0012\u0001\u0005\u0002A\nA\u0004^3ti\u0006;wmV5uQ>,HOU3ek\u000e,wI]8va&tw\r\u000b\u0002F\u0005\")\u0011\n\u0001C\u0001a\u0005\tC/Z:u'&tw\r\\3BO\u001e|e\u000eV1cY\u0016<\u0016\u000e\u001e5V]&\fX/Z&fs\"\u0012\u0001J\u0011\u0005\u0006\u0019\u0002!\t\u0001M\u0001%i\u0016\u001cHoU5oO2,\u0017iZ4P]R\u000b'\r\\3XSRDw.\u001e;V]&\fX/Z&fs\"\u00121J\u0011\u0005\u0006\u001f\u0002!\t\u0001M\u0001#i\u0016\u001cHoU5oO2,\u0017iZ4P]R\u000b'\r\\3XSRDWK\\5rk\u0016\\U-_:)\u00059\u0013\u0005\"\u0002*\u0001\t\u0003\u0001\u0014!\t;fgR\u001c\u0016N\\4mK\u0006;wmV5uQ\u000e{gn\u001d;b]R<%o\\;q\u0017\u0016L\bFA)C\u0011\u0015)\u0006\u0001\"\u00011\u0003\u0005\"Xm\u001d;TS:<G.Z!hO>sG._\"p]N$\u0018M\u001c;He>,\boS3zQ\t!&\tC\u0003Y\u0001\u0011\u0005\u0001'\u0001\buKN$X*\u001e7uS\u0006;wm]\u0019)\u0005]\u0013\u0005\"B.\u0001\t\u0003\u0001\u0014A\u0004;fgRlU\u000f\u001c;j\u0003\u001e<7O\r\u0015\u00035\nCQA\u0018\u0001\u0005\u0002A\n1\u0003^3ti\u0006;wm\u00148J]:,'OS8j]FB#!\u0018\"\t\u000b\u0005\u0004A\u0011\u0001\u0019\u0002'Q,7\u000f^!hO>s\u0017J\u001c8fe*{\u0017N\u001c\u001a)\u0005\u0001\u0014\u0005\"\u00023\u0001\t\u0003\u0001\u0014a\u0005;fgR\fumZ(o\u0013:tWM\u001d&pS:\u001c\u0004FA2C\u0011\u00159\u0007\u0001\"\u00011\u0003I!Xm\u001d;BO\u001e|e\u000eT3gi*{\u0017N\\\u0019)\u0005\u0019\u0014\u0005\"\u00026\u0001\t\u0003\u0001\u0014A\u0005;fgR\fumZ(o\u0019\u00164GOS8j]JB#!\u001b\"\t\u000b5\u0004A\u0011\u0001\u0019\u0002%Q,7\u000f^!hO>sG*\u001a4u\u0015>Lgn\r\u0015\u0003Y\nCQ\u0001\u001d\u0001\u0005\u0002A\n1\u0003^3ti\u0006;wm\u00148SS\u001eDGOS8j]FB#a\u001c\"\t\u000bM\u0004A\u0011\u0001\u0019\u0002'Q,7\u000f^!hO>s'+[4ii*{\u0017N\u001c\u001a)\u0005I\u0014\u0005\"\u0002<\u0001\t\u0003\u0001\u0014a\u0005;fgR\fumZ(o%&<\u0007\u000e\u001e&pS:\u001c\u0004FA;C\u0011\u0015I\b\u0001\"\u00011\u0003I!Xm\u001d;BO\u001e|eNR;mY*{\u0017N\\\u0019)\u0005a\u0014\u0005\"\u0002?\u0001\t\u0003\u0001\u0014A\u0005;fgR\fumZ(o\rVdGNS8j]JB#a\u001f\"\t\u000b}\u0004A\u0011\u0001\u0019\u0002\u001bQ,7\u000f^!hO>swJ^3sQ\tq(\t\u0003\u0004\u0002\u0006\u0001!\t\u0001M\u0001\u0011i\u0016\u001cH/Q4h\u001f:<\u0016N\u001c3poFB3!a\u0001C\u0011\u0019\tY\u0001\u0001C\u0001a\u0005\u0001B/Z:u\u0003\u001e<wJ\\,j]\u0012|wO\r\u0015\u0004\u0003\u0013\u0011\u0005BBA\t\u0001\u0011\u0005\u0001'\u0001\tuKN$\u0018iZ4P]^Kg\u000eZ8xg!\u001a\u0011q\u0002\"\t\r\u0005]\u0001\u0001\"\u00011\u0003A!Xm\u001d;BO\u001e|enV5oI><H\u0007K\u0002\u0002\u0016\tCa!!\b\u0001\t\u0003\u0001\u0014\u0001\u0005;fgR\fumZ(o/&tGm\\<6Q\r\tYB\u0011\u0005\u0007\u0003G\u0001A\u0011\u0001\u0019\u00021Q,7\u000f^!hO^KG\u000f[$s_V\u0004\u0018N\\4TKR\u001c\u0018\u0007K\u0002\u0002\"\tCa!!\u000b\u0001\t\u0003\u0001\u0014\u0001\u0007;fgR\fumZ,ji\"<%o\\;qS:<7+\u001a;te!\u001a\u0011q\u0005\"\t\r\u0005=\u0002\u0001\"\u00011\u0003a!Xm\u001d;BO\u001e<\u0016\u000e\u001e5He>,\b/\u001b8h'\u0016$8o\r\u0015\u0004\u0003[\u0011\u0005BBA\u001b\u0001\u0011\u0005\u0001'A\tuKN$\u0018iZ4XSRD'k\u001c7mkBD3!a\rC\u0011\u0019\tY\u0004\u0001C\u0001a\u0005yA/Z:u\u0003\u001e<w+\u001b;i\u0007V\u0014W\rK\u0002\u0002:\tCa!!\u0011\u0001\t\u0003\u0001\u0014A\u0006;fgR\u001c\u0016N\\4mK\u0012K7\u000f^5oGR\fumZ\u0019)\u0007\u0005}\"\t\u0003\u0004\u0002H\u0001!\t\u0001M\u0001\u0017i\u0016\u001cHoU5oO2,G)[:uS:\u001cG/Q4he!\u001a\u0011Q\t\"\t\r\u00055\u0003\u0001\"\u00011\u0003%\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e|v+\u001b;i\u001d>tG)[:uS:\u001cG/Q4hc!\u001a\u00111\n\"\t\r\u0005M\u0003\u0001\"\u00011\u0003%\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e|v+\u001b;i\u001d>tG)[:uS:\u001cG/Q4he!\u001a\u0011\u0011\u000b\"\t\r\u0005e\u0003\u0001\"\u00011\u0003%\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e|v+\u001b;i\u001d>tG)[:uS:\u001cG/Q4hg!\u001a\u0011q\u000b\"\t\r\u0005}\u0003\u0001\"\u00011\u0003%\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e|v+\u001b;i\u001d>tG)[:uS:\u001cG/Q4hi!\u001a\u0011Q\f\"\t\r\u0005\u0015\u0004\u0001\"\u00011\u0003Y!Xm\u001d;Nk2$\u0018\u000eR5ti&t7\r^!hON\f\u0004fAA2\u0005\"1\u00111\u000e\u0001\u0005\u0002A\na\u0003^3ti6+H\u000e^5ESN$\u0018N\\2u\u0003\u001e<7O\r\u0015\u0004\u0003S\u0012\u0005BBA9\u0001\u0011\u0005\u0001'\u0001\fuKN$X*\u001e7uS\u0012K7\u000f^5oGR\fumZ:4Q\r\tyG\u0011\u0005\u0007\u0003o\u0002A\u0011\u0001\u0019\u0002SQ,7\u000f^'vYRLG)[:uS:\u001cG/Q4hg~;\u0016\u000e\u001e5O_:$\u0015n\u001d;j]\u000e$\u0018iZ42Q\r\t)H\u0011\u0005\b\u0003{\u0002A\u0011AA@\u0003)1XM]5gsBc\u0017M\u001c\u000b\u0004c\u0005\u0005\u0005\u0002CAB\u0003w\u0002\r!!\"\u0002\u0011M\fH.U;fef\u0004B!a\"\u0002\u0016:!\u0011\u0011RAI!\r\tY\tH\u0007\u0003\u0003\u001bS1!a$\u0011\u0003\u0019a$o\\8u}%\u0019\u00111\u0013\u000f\u0002\rA\u0013X\rZ3g\u0013\u0011\t9*!'\u0003\rM#(/\u001b8h\u0015\r\t\u0019\n\b")
public abstract class AggregateReduceGroupingTestBase
extends TableTestBase {
    private final boolean withExecPlan;
    private final BatchTableTestUtil util;

    public BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTableSource("T1", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING(), Types.STRING()}), (String[])((Object[])new String[]{"a1", "b1", "c1", "d1"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000000L)).uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"a1"))).build());
        this.util().addTableSource("T2", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING()}), (String[])((Object[])new String[]{"a2", "b2", "c2"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000000L)).uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"b2"), (Object)ImmutableSet.of((Object)"a2", (Object)"b2"))).build());
        this.util().addTableSource("T3", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING(), Types.LONG()}), (String[])((Object[])new String[]{"a3", "b3", "c3", "d3"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(1000L)).build());
        this.util().addTableSource("T4", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.INT(), Types.STRING(), Types.LOCAL_DATE_TIME()}), (String[])((Object[])new String[]{"a4", "b4", "c4", "d4"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000000L)).uniqueKeys((Set)ImmutableSet.of((Object)ImmutableSet.of((Object)"a4"))).build());
    }

    @Test
    public void testAggWithoutAggCall() {
        FlinkChainedProgram<BatchOptimizeContext> programs = this.util().getBatchProgram();
        ((FlinkRuleSetProgram)programs.getFlinkRuleSetProgram(FlinkBatchProgram$.MODULE$.LOGICAL()).get()).remove(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FlinkAggregateRemoveRule.INSTANCE}));
        this.util().replaceBatchProgram(programs);
        this.util().verifyRelPlan("SELECT a1, b1, c1 FROM T1 GROUP BY a1, b1, c1");
    }

    @Test
    public void testAggWithoutReduceGrouping() {
        this.verifyPlan("SELECT a3, b3, count(c3) FROM T3 GROUP BY a3, b3");
    }

    @Test
    public void testSingleAggOnTableWithUniqueKey() {
        this.verifyPlan("SELECT a1, b1, count(c1) FROM T1 GROUP BY a1, b1");
    }

    @Test
    public void testSingleAggOnTableWithoutUniqueKey() {
        this.verifyPlan("SELECT a3, b3, count(c3) FROM T3 GROUP BY a3, b3");
    }

    @Test
    public void testSingleAggOnTableWithUniqueKeys() {
        this.verifyPlan("SELECT  b2, c2, avg(a2) FROM T2 GROUP BY b2, c2");
    }

    @Test
    public void testSingleAggWithConstantGroupKey() {
        this.verifyPlan("SELECT a1, b1, count(c1) FROM T1 GROUP BY a1, b1, 1, true");
    }

    @Test
    public void testSingleAggOnlyConstantGroupKey() {
        this.verifyPlan("SELECT count(c1) FROM T1 GROUP BY 1, true");
    }

    @Test
    public void testMultiAggs1() {
        this.verifyPlan("SELECT a1, b1, c1, d1, m, COUNT(*) FROM (SELECT a1, b1, c1, COUNT(d1) AS d1, MAX(d1) AS m FROM T1 GROUP BY a1, b1, c1) t GROUP BY a1, b1, c1, d1, m");
    }

    @Test
    public void testMultiAggs2() {
        this.verifyPlan("SELECT a3, b3, c, s, a, COUNT(*) FROM (SELECT a3, b3, COUNT(c3) AS c, SUM(d3) AS s, AVG(d3) AS a FROM T3 GROUP BY a3, b3) t GROUP BY a3, b3, c, s, a");
    }

    @Test
    public void testAggOnInnerJoin1() {
        this.verifyPlan("SELECT a1, b1, a2, b2, COUNT(c1) FROM (SELECT * FROM T1, T2 WHERE a1 = b2) t GROUP BY a1, b1, a2, b2");
    }

    @Test
    public void testAggOnInnerJoin2() {
        this.verifyPlan("SELECT a2, b2, a3, b3, COUNT(c2), AVG(d3) FROM (SELECT * FROM T2, T3 WHERE b2 = a3) t GROUP BY a2, b2, a3, b3");
    }

    @Test
    public void testAggOnInnerJoin3() {
        this.verifyPlan("SELECT a1, b1, a2, b2, a3, b3, COUNT(c1) FROM (SELECT * FROM T1, T2, T3 WHERE a1 = b2 AND a1 = a3) t GROUP BY a1, b1, a2, b2, a3, b3");
    }

    @Test
    public void testAggOnLeftJoin1() {
        this.verifyPlan("SELECT a1, b1, a2, b2, COUNT(c1) FROM (SELECT * FROM T1 LEFT JOIN T2 ON a1 = b2) t GROUP BY a1, b1, a2, b2");
    }

    @Test
    public void testAggOnLeftJoin2() {
        this.verifyPlan("SELECT a1, b1, a3, b3, COUNT(c1) FROM (SELECT * FROM T1 LEFT JOIN T3 ON a1 = a3) t GROUP BY a1, b1, a3, b3");
    }

    @Test
    public void testAggOnLeftJoin3() {
        this.verifyPlan("SELECT a3, b3, a1, b1, COUNT(c1) FROM (SELECT * FROM T3 LEFT JOIN T1 ON a1 = a3) t GROUP BY a3, b3, a1, b1");
    }

    @Test
    public void testAggOnRightJoin1() {
        this.verifyPlan("SELECT a1, b1, a2, b2, COUNT(c1) FROM (SELECT * FROM T1 RIGHT JOIN T2 ON a1 = b2) t GROUP BY a1, b1, a2, b2");
    }

    @Test
    public void testAggOnRightJoin2() {
        this.verifyPlan("SELECT a1, b1, a3, b3, COUNT(c1) FROM (SELECT * FROM T1 RIGHT JOIN T3 ON a1 = a3) t GROUP BY a1, b1, a3, b3");
    }

    @Test
    public void testAggOnRightJoin3() {
        this.verifyPlan("SELECT a3, b3, a1, b1, COUNT(c1) FROM (SELECT * FROM T3 RIGHT JOIN T1 ON a1 = a3) t GROUP BY a3, b3, a1, b1");
    }

    @Test
    public void testAggOnFullJoin1() {
        this.verifyPlan("SELECT a1, b1, a2, b2, COUNT(c1) FROM (SELECT * FROM T1 FULL OUTER JOIN T2 ON a1 = b2) t GROUP BY a1, b1, a2, b2");
    }

    @Test
    public void testAggOnFullJoin2() {
        this.verifyPlan("SELECT a1, b1, a3, b3, COUNT(c1) FROM (SELECT * FROM T1 FULL OUTER JOIN T3 ON a1 = a3) t GROUP BY a1, b1, a3, b3");
    }

    @Test
    public void testAggOnOver() {
        this.verifyPlan("SELECT a1, b1, c, COUNT(d1) FROM (SELECT a1, b1, d1, COUNT(*) OVER (PARTITION BY c1) AS c FROM T1) t GROUP BY a1, b1, c");
    }

    @Test
    public void testAggOnWindow1() {
        this.verifyPlan("SELECT a4, b4, COUNT(c4) FROM T4 GROUP BY a4, b4, TUMBLE(d4, INTERVAL '15' MINUTE)");
    }

    @Test
    public void testAggOnWindow2() {
        this.verifyPlan("SELECT a4, c4, COUNT(b4), AVG(b4) FROM T4 GROUP BY a4, c4, TUMBLE(d4, INTERVAL '15' MINUTE)");
    }

    @Test
    public void testAggOnWindow3() {
        this.verifyPlan("SELECT a4, c4, s, COUNT(b4) FROM (SELECT a4, c4, VAR_POP(b4) AS b4, TUMBLE_START(d4, INTERVAL '15' MINUTE) AS s, TUMBLE_END(d4, INTERVAL '15' MINUTE) AS e FROM T4 GROUP BY a4, c4, TUMBLE(d4, INTERVAL '15' MINUTE)) t GROUP BY a4, c4, s");
    }

    @Test
    public void testAggOnWindow4() {
        this.verifyPlan("SELECT a4, c4, e, COUNT(b4) FROM (SELECT a4, c4, VAR_POP(b4) AS b4, TUMBLE_START(d4, INTERVAL '15' MINUTE) AS s, TUMBLE_END(d4, INTERVAL '15' MINUTE) AS e FROM T4 GROUP BY a4, c4, TUMBLE(d4, INTERVAL '15' MINUTE)) t GROUP BY a4, c4, e");
    }

    @Test
    public void testAggOnWindow5() {
        this.verifyPlan("SELECT a4, b4, c4, COUNT(*) FROM (SELECT a4, c4, VAR_POP(b4) AS b4, TUMBLE_START(d4, INTERVAL '15' MINUTE) AS s, TUMBLE_END(d4, INTERVAL '15' MINUTE) AS e FROM T4 GROUP BY a4, c4, TUMBLE(d4, INTERVAL '15' MINUTE)) t GROUP BY a4, b4, c4");
    }

    @Test
    public void testAggWithGroupingSets1() {
        this.verifyPlan("SELECT a1, b1, c1, COUNT(d1) FROM T1 GROUP BY GROUPING SETS ((a1, b1), (a1, c1))");
    }

    @Test
    public void testAggWithGroupingSets2() {
        this.verifyPlan("SELECT a1, SUM(b1) AS s FROM T1 GROUP BY GROUPING SETS((a1, c1), (a1), ())");
    }

    @Test
    public void testAggWithGroupingSets3() {
        this.verifyPlan("SELECT a1, b1, c1, COUNT(d1) FROM T1 GROUP BY GROUPING SETS ((a1, b1, c1), (a1, b1, d1))");
    }

    @Test
    public void testAggWithRollup() {
        this.verifyPlan("SELECT a1, b1, c1, COUNT(d1) FROM T1 GROUP BY ROLLUP (a1, b1, c1)");
    }

    @Test
    public void testAggWithCube() {
        this.verifyPlan("SELECT a1, b1, c1, COUNT(d1) FROM T1 GROUP BY CUBE (a1, b1, c1)");
    }

    @Test
    public void testSingleDistinctAgg1() {
        this.verifyPlan("SELECT a1, COUNT(DISTINCT c1) FROM T1 GROUP BY a1");
    }

    @Test
    public void testSingleDistinctAgg2() {
        this.verifyPlan("SELECT a1, b1, COUNT(DISTINCT c1) FROM T1 GROUP BY a1, b1");
    }

    @Test
    public void testSingleDistinctAgg_WithNonDistinctAgg1() {
        this.verifyPlan("SELECT a1, COUNT(DISTINCT b1), SUM(b1) FROM T1 GROUP BY a1");
    }

    @Test
    public void testSingleDistinctAgg_WithNonDistinctAgg2() {
        this.verifyPlan("SELECT a1, c1, COUNT(DISTINCT b1), SUM(b1) FROM T1 GROUP BY a1, c1");
    }

    @Test
    public void testSingleDistinctAgg_WithNonDistinctAgg3() {
        this.verifyPlan("SELECT a1, COUNT(DISTINCT c1), SUM(b1) FROM T1 GROUP BY a1");
    }

    @Test
    public void testSingleDistinctAgg_WithNonDistinctAgg4() {
        this.verifyPlan("SELECT a1, d1, COUNT(DISTINCT c1), SUM(b1) FROM T1 GROUP BY a1, d1");
    }

    @Test
    public void testMultiDistinctAggs1() {
        this.verifyPlan("SELECT a1, COUNT(DISTINCT b1), SUM(DISTINCT b1) FROM T1 GROUP BY a1");
    }

    @Test
    public void testMultiDistinctAggs2() {
        this.verifyPlan("SELECT a1, d1, COUNT(DISTINCT c1), SUM(DISTINCT b1) FROM T1 GROUP BY a1, d1");
    }

    @Test
    public void testMultiDistinctAggs3() {
        this.verifyPlan("SELECT a1, SUM(DISTINCT b1), MAX(DISTINCT b1), MIN(DISTINCT c1) FROM T1 GROUP BY a1");
    }

    @Test
    public void testMultiDistinctAggs_WithNonDistinctAgg1() {
        this.verifyPlan("SELECT a1, d1, COUNT(DISTINCT c1), MAX(DISTINCT b1), SUM(b1) FROM T1 GROUP BY a1, d1");
    }

    public void verifyPlan(String sqlQuery) {
        if (this.withExecPlan) {
            this.util().verifyExecPlan(sqlQuery);
        } else {
            this.util().verifyRelPlan(sqlQuery);
        }
    }

    public AggregateReduceGroupingTestBase(boolean withExecPlan) {
        this.withExecPlan = withExecPlan;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

