/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.common.DistinctAggregateTestBase$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c!B\u0001\u0003\u0003\u0003\t\"!\u0007#jgRLgn\u0019;BO\u001e\u0014XmZ1uKR+7\u000f\u001e\"bg\u0016T!a\u0001\u0003\u0002\r\r|W.\\8o\u0015\t)a!\u0001\u0003qY\u0006t'BA\u0004\t\u0003\u001d\u0001H.\u00198oKJT!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\u0011QCB\u0001\u0006kRLGn]\u0005\u0003/Q\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0019]LG\u000f[#yK\u000e\u0004F.\u00198\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f\t{w\u000e\\3b]\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"aI\u0013\u0011\u0005\u0011\u0002Q\"\u0001\u0002\t\u000be\u0001\u0003\u0019\u0001\u000e\t\u000f\u001d\u0002!\u0019!C\tQ\u0005!Q\u000f^5m+\u0005I\u0003CA\n+\u0013\tYCC\u0001\nCCR\u001c\u0007\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007BB\u0017\u0001A\u0003%\u0011&A\u0003vi&d\u0007\u0005C\u00030\u0001\u0011\u0005\u0001'A\u0003tKR,\b\u000fF\u00012!\tY\"'\u0003\u000249\t!QK\\5uQ\tqS\u0007\u0005\u00027{5\tqG\u0003\u00029s\u0005\u0019\u0011\r]5\u000b\u0005iZ\u0014a\u00026va&$XM\u001d\u0006\u0003y9\tQA[;oSRL!AP\u001c\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0003A\u0001\u0011\u0005\u0001'A\u000buKN$8+\u001b8hY\u0016$\u0015n\u001d;j]\u000e$\u0018iZ4)\u0005}\u0012\u0005C\u0001\u001cD\u0013\t!uG\u0001\u0003UKN$\b\"\u0002$\u0001\t\u0003\u0001\u0014\u0001\t;fgRlU\u000f\u001c;j\t&\u001cH/\u001b8di\u0006;wm\u00148TC6,7i\u001c7v[:D#!\u0012\"\t\u000b%\u0003A\u0011\u0001\u0019\u0002cQ,7\u000f^*j]\u001edW\rR5ti&t7\r^!hO\u0006sGm\u00148f\u001fJlU\u000f\u001c;j\u001d>tG)[:uS:\u001cG/Q4hc!\u0012\u0001J\u0011\u0005\u0006\u0019\u0002!\t\u0001M\u00012i\u0016\u001cHoU5oO2,G)[:uS:\u001cG/Q4h\u0003:$wJ\\3Pe6+H\u000e^5O_:$\u0015n\u001d;j]\u000e$\u0018iZ43Q\tY%\tC\u0003P\u0001\u0011\u0005\u0001'A\u0013uKN$X*\u001e7uS\u0012K7\u000f^5oGR\fumZ(o\t&4g-\u001a:f]R\u001cu\u000e\\;n]\"\u0012aJ\u0011\u0005\u0006%\u0002!\t\u0001M\u00014i\u0016\u001cH/T;mi&$\u0015n\u001d;j]\u000e$\u0018I\u001c3O_:$\u0015n\u001d;j]\u000e$\u0018iZ4P]\u0012KgMZ3sK:$8i\u001c7v[:D#!\u0015\"\t\u000bU\u0003A\u0011\u0001\u0019\u0002AQ,7\u000f^*j]\u001edW\rR5ti&t7\r^!hO^KG\u000f[$s_V\u0004()\u001f\u0015\u0003)\nCQ\u0001\u0017\u0001\u0005\u0002A\nA\u0006^3tiNKgn\u001a7f\t&\u001cH/\u001b8di\u0006;wmV5uQ\u001e\u0013x.\u001e9Cs\u0006sGmQ8v]R\u001cF/\u0019:)\u0005]\u0013\u0005\"B.\u0001\t\u0003\u0001\u0014!\u000b;fgR$vo\u001c#jgRLgn\u0019;BO\u001e<\u0016\u000e\u001e5He>,\bOQ=B]\u0012\u001cu.\u001e8u'R\f'\u000f\u000b\u0002[\u0005\")a\f\u0001C\u0001a\u0005\u0011D/Z:u)^|G)\u001b4gKJ,g\u000e\u001e#jgRLgn\u0019;BO\u001e<\u0016\u000e\u001e5He>,\bOQ=B]\u0012\u001cu.\u001e8u'R\f'\u000f\u000b\u0002^\u0005\")\u0011\r\u0001C\u0001a\u0005YD/Z:u\u001bVdG/\u001b#jM\u001a,'/\u001a8u\t&\u001cH/\u001b8di\u0006;wmV5uQ:{g\u000eR5ti&t7\r^!hO>s7+Y7f\u0007>dW/\u001c8)\u0005\u0001\u0014\u0005\"\u00023\u0001\t\u0003\u0001\u0014!\u0012;fgRlU\u000f\u001c;j\t&4g-\u001a:f]R$\u0015n\u001d;j]\u000e$\u0018iZ4XSRDgj\u001c8ESN$\u0018N\\2u\u0003\u001e<wJ\\*b[\u0016\u001cu\u000e\\;n]\u0006sGm\u0012:pkB\u0014\u0015\u0010\u000b\u0002d\u0005\")q\r\u0001C\u0001a\u0005QE/Z:u\u001bVdG/\u001b#jM\u001a,'/\u001a8u\t&\u001cH/\u001b8di\u0006;wmV5uQ:{g\u000eR5ti&t7\r^!hO>sG)\u001b4gKJ,g\u000e^\"pYVlg.\u00118e\u000fJ|W\u000f\u001d\"zQ\t1'\tC\u0003k\u0001\u0011\u0005\u0001'A\u0011uKN$H)[:uS:\u001cG/Q4h/&$\b\u000eR;qY&\u001c\u0017\r^3GS\u0016dG\r\u000b\u0002j\u0005\")Q\u000e\u0001C\u0001a\u0005\u0001D/Z:u\u001bVdG/\u001b#jgRLgn\u0019;BO\u001e|enU1nK\u000e{G.^7o/&$\bn\u0012:pkBLgnZ*fiND#\u0001\u001c\"\t\u000bA\u0004A\u0011\u0001\u0019\u0002\u0003R,7\u000f^*j]\u001edW\rR5ti&t7\r^!hO\u0006sGm\u00148f\u001fJlU\u000f\u001c;j\u001d>tG)[:uS:\u001cG/Q4h/&$\bn\u0012:pkBLgnZ*fiN\f\u0004FA8C\u0011\u0015\u0019\b\u0001\"\u00011\u0003\u0005#Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e\fe\u000eZ(oK>\u0013X*\u001e7uS:{g\u000eR5ti&t7\r^!hO^KG\u000f[$s_V\u0004\u0018N\\4TKR\u001c(\u0007\u000b\u0002s\u0005\")a\u000f\u0001C\u0001a\u0005)D/Z:u\u001bVdG/\u001b#jgRLgn\u0019;BO\u001e|e\u000eR5gM\u0016\u0014XM\u001c;D_2,XN\\,ji\"<%o\\;qS:<7+\u001a;tQ\t)(\tC\u0003z\u0001\u0011\u0005\u0001'A\"uKN$X*\u001e7uS\u0012K7\u000f^5oGR\fe\u000e\u001a(p]\u0012K7\u000f^5oGR\fumZ(o\t&4g-\u001a:f]R\u001cu\u000e\\;n]^KG\u000f[$s_V\u0004\u0018N\\4TKR\u001c\bF\u0001=C\u0011\u0015a\b\u0001\"\u00011\u0003q!Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;XSRDg)\u001b7uKJD#a\u001f\"\t\u000b}\u0004A\u0011\u0001\u0019\u0002OQ,7\u000f^'vYRLG)[:uS:\u001cGo\u00148TC6,7i\u001c7v[:<\u0016\u000e\u001e5GS2$XM\u001d\u0015\u0003}\nCa!!\u0002\u0001\t\u0003\u0001\u0014\u0001\f+fgRlU\u000f\u001c;j\t&\u001cH/\u001b8di>sG)\u001b4gKJ,g\u000e^\"pYVlgnV5uQ\u001aKG\u000e^3sQ\r\t\u0019A\u0011\u0005\u0007\u0003\u0017\u0001A\u0011\u0001\u0019\u0002YQ+7\u000f^'vYRLG)[:uS:\u001cGoV5uQ\u001aKG\u000e^3s\u0003:$gj\u001c8ESN$\u0018N\\2u\u0003\u001e<\u0007fAA\u0005\u0005\"1\u0011\u0011\u0003\u0001\u0005\u0002A\nA\u0006^3ti6+H\u000e^5ESN$\u0018N\\2u\u0003:$gj\u001c8ESN$\u0018N\\2u\u0003\u001e<w+\u001b;i\r&dG/\u001a:)\u0007\u0005=!\t\u0003\u0004\u0002\u0018\u0001!\t\u0001M\u0001(i\u0016\u001cH\u000fR5ti&t7\r^!hO^KG\u000f\u001b#va2L7-\u0019;f\r&dG/\u001a:GS\u0016dG\rK\u0002\u0002\u0016\tCa!!\b\u0001\t\u0003\u0001\u0014a\n;fgR$vn\\'b]f$\u0015n\u001d;j]\u000e$\u0018iZ4P]\u0012KgMZ3sK:$8i\u001c7v[:D3!a\u0007C\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003K\t!B^3sS\u001aL\b\u000b\\1o)\r\t\u0014q\u0005\u0005\t\u0003S\t\t\u00031\u0001\u0002,\u0005A1/\u001d7Rk\u0016\u0014\u0018\u0010\u0005\u0003\u0002.\u0005mb\u0002BA\u0018\u0003o\u00012!!\r\u001d\u001b\t\t\u0019DC\u0002\u00026A\ta\u0001\u0010:p_Rt\u0014bAA\u001d9\u00051\u0001K]3eK\u001aLA!!\u0010\u0002@\t11\u000b\u001e:j]\u001eT1!!\u000f\u001d\u0001")
public abstract class DistinctAggregateTestBase
extends TableTestBase {
    private final boolean withExecPlan;
    private final BatchTableTestUtil util;

    public BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.common.DistinctAggregateTestBase$$anon$3 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}), new CaseClassTypeInfo<Tuple5<Object, Object, String, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, String, String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, String, String, String>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, String, String, String>>(this, fieldSerializers){

                    public Tuple5<Object, Object, String, String, String> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((String)fields[3]), (Object)((String)fields[4]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple5<Object, Object, String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.common.DistinctAggregateTestBase$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testSingleDistinctAgg() {
        this.verifyPlan("SELECT COUNT(DISTINCT a) FROM MyTable");
    }

    @Test
    public void testMultiDistinctAggOnSameColumn() {
        this.verifyPlan("SELECT COUNT(DISTINCT a), SUM(DISTINCT a) FILTER (WHERE b > 0),\nMAX(DISTINCT a) FROM MyTable");
    }

    @Test
    public void testSingleDistinctAggAndOneOrMultiNonDistinctAgg1() {
        this.verifyPlan("SELECT COUNT(DISTINCT a) FILTER (WHERE a > 0), SUM(b) FROM MyTable");
    }

    @Test
    public void testSingleDistinctAggAndOneOrMultiNonDistinctAgg2() {
        this.verifyPlan("SELECT COUNT(a) filter (WHERE a > 0), SUM(DISTINCT b) FROM MyTable");
    }

    @Test
    public void testMultiDistinctAggOnDifferentColumn() {
        this.verifyPlan("SELECT COUNT(DISTINCT a), SUM(DISTINCT b),\nCOUNT(DISTINCT c) FILTER (WHERE a > 5) FROM MyTable");
    }

    @Test
    public void testMultiDistinctAndNonDistinctAggOnDifferentColumn() {
        this.verifyPlan("SELECT COUNT(DISTINCT a) FILTER (WHERE c > 0),\nSUM(DISTINCT b), COUNT(c) FROM MyTable");
    }

    @Test
    public void testSingleDistinctAggWithGroupBy() {
        this.verifyPlan("SELECT a, COUNT(a), SUM(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleDistinctAggWithGroupByAndCountStar() {
        this.verifyPlan("SELECT a, COUNT(*), SUM(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testTwoDistinctAggWithGroupByAndCountStar() {
        String sqlQuery = "SELECT a, COUNT(*), SUM(DISTINCT b), COUNT(DISTINCT b) FROM MyTable GROUP BY a";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testTwoDifferentDistinctAggWithGroupByAndCountStar() {
        String sqlQuery = "SELECT a, COUNT(*), SUM(DISTINCT b), COUNT(DISTINCT c) FROM MyTable GROUP BY a";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testMultiDifferentDistinctAggWithNonDistinctAggOnSameColumn() {
        this.verifyPlan("SELECT COUNT(DISTINCT a), SUM(DISTINCT b), MAX(a), MIN(a) FROM MyTable");
    }

    @Test
    public void testMultiDifferentDistinctAggWithNonDistinctAggOnSameColumnAndGroupBy() {
        String sqlQuery = "SELECT COUNT(DISTINCT a), SUM(DISTINCT b), MAX(a), MIN(a) FROM MyTable GROUP BY c";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testMultiDifferentDistinctAggWithNonDistinctAggOnDifferentColumnAndGroupBy() {
        this.verifyPlan("SELECT SUM(DISTINCT a), COUNT(DISTINCT c) FROM MyTable GROUP BY b");
    }

    @Test
    public void testDistinctAggWithDuplicateField() {
        this.verifyPlan("SELECT a, COUNT(a), SUM(b), SUM(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testMultiDistinctAggOnSameColumnWithGroupingSets() {
        String sqlQuery = "SELECT COUNT(DISTINCT a), SUM(DISTINCT a), MAX(DISTINCT a) FROM MyTable2 GROUP BY GROUPING SETS (b, c)";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testSingleDistinctAggAndOneOrMultiNonDistinctAggWithGroupingSets1() {
        this.verifyPlan("SELECT COUNT(DISTINCT a), SUM(b) FROM MyTable2 GROUP BY GROUPING SETS (b, c)");
    }

    @Test
    public void testSingleDistinctAggAndOneOrMultiNonDistinctAggWithGroupingSets2() {
        this.verifyPlan("SELECT COUNT(a), SUM(DISTINCT b) FROM MyTable2 GROUP BY GROUPING SETS (c, d)");
    }

    @Test
    public void testMultiDistinctAggOnDifferentColumnWithGroupingSets() {
        String sqlQuery = "SELECT COUNT(DISTINCT a), SUM(DISTINCT b) FROM MyTable2 GROUP BY GROUPING SETS (c, d)";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testMultiDistinctAndNonDistinctAggOnDifferentColumnWithGroupingSets() {
        String sqlQuery = "SELECT COUNT(DISTINCT a), SUM(DISTINCT b), COUNT(c) FROM MyTable2 GROUP BY GROUPING SETS (d, e)";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testSingleDistinctWithFilter() {
        String sqlQuery = "SELECT d, COUNT(DISTINCT c) FILTER (WHERE a > 0) FROM MyTable2 GROUP BY d";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testMultiDistinctOnSameColumnWithFilter() {
        String sqlQuery = "SELECT d, COUNT(DISTINCT c), COUNT(DISTINCT c) FILTER (WHERE a > 10),\nCOUNT(DISTINCT c) FILTER (WHERE a < 10) FROM MyTable2 GROUP BY d";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void TestMultiDistinctOnDifferentColumnWithFilter() {
        String sqlQuery = "SELECT d, COUNT(DISTINCT c), COUNT(DISTINCT c) FILTER (WHERE a > 0),\nCOUNT(DISTINCT b) FILTER (WHERE b > 1) FROM MyTable2 GROUP BY d";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void TestMultiDistinctWithFilterAndNonDistinctAgg() {
        String sqlQuery = "SELECT d, COUNT(DISTINCT c), COUNT(DISTINCT c) FILTER (WHERE a > 0),\nMAX(e), MIN(e) FROM MyTable2 GROUP BY d";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testMultiDistinctAndNonDistinctAggWithFilter() {
        String sqlQuery = "SELECT d, MAX(e), MAX(e) FILTER (WHERE a < 10), COUNT(DISTINCT c),\nCOUNT(DISTINCT c) FILTER (WHERE a > 5), COUNT(DISTINCT b) FILTER (WHERE b > 3)\nFROM MyTable2 GROUP BY d";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testDistinctAggWithDuplicateFilterField() {
        String sqlQuery = "SELECT a, COUNT(c) FILTER (WHERE b > 1),\nCOUNT(DISTINCT d) FILTER (WHERE b > 1) FROM MyTable2 GROUP BY a";
        this.verifyPlan(sqlQuery);
    }

    @Test
    public void testTooManyDistinctAggOnDifferentColumn() {
        String[] fieldNames = (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 64).map((Function1 & Serializable & scala.Serializable)i -> DistinctAggregateTestBase.$anonfun$testTooManyDistinctAggOnDifferentColumn$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        TypeInformation[] fieldTypes = (TypeInformation[])Array$.MODULE$.fill(fieldNames.length, (Function0 & Serializable & scala.Serializable)() -> Types.INT(), ClassTag$.MODULE$.apply(TypeInformation.class));
        this.util().addTableSource("MyTable64", fieldTypes, fieldNames);
        String distinctList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(16).append("COUNT(DISTINCT ").append((String)f).append(")").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
        String maxList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(5).append("MAX(").append((String)f).append(")").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
        String sqlQuery = new StringBuilder(24).append("SELECT ").append(distinctList).append(", ").append(maxList).append(" FROM MyTable64").toString();
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.verifyPlan(sqlQuery));
    }

    private void verifyPlan(String sqlQuery) {
        if (this.withExecPlan) {
            this.util().verifyExecPlan(sqlQuery);
        } else {
            this.util().verifyRelPlan(sqlQuery);
        }
    }

    public static final /* synthetic */ String $anonfun$testTooManyDistinctAggOnDifferentColumn$1(int i) {
        return new StringBuilder(1).append("f").append(i).toString();
    }

    public DistinctAggregateTestBase(boolean withExecPlan) {
        this.withExecPlan = withExecPlan;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

