/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import java.util.Collection;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.common.JoinReorderTestBase$;
import org.apache.flink.table.planner.plan.rules.logical.JoinDeriveNullFilterRule$;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d!B\u0001\u0003\u0003\u0003\t\"a\u0005&pS:\u0014Vm\u001c:eKJ$Vm\u001d;CCN,'BA\u0002\u0005\u0003\u0019\u0019w.\\7p]*\u0011QAB\u0001\u0005a2\fgN\u0003\u0002\b\u0011\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\f\u000e\u0003QQ!!\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005]!\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\r\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003II7OQ;tQfTu.\u001b8SK>\u0014H-\u001a:\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f\t{w\u000e\\3b]\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"aI\u0013\u0011\u0005\u0011\u0002Q\"\u0001\u0002\t\u000be\u0001\u0003\u0019\u0001\u000e\t\u000f\u001d\u0002!\u0019!C\tQ\u0005!Q\u000f^5m+\u0005I\u0003CA\n+\u0013\tYCCA\u0007UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007[\u0001\u0001\u000b\u0011B\u0015\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b=\u0002a\u0011\u0003\u0015\u0002!\u001d,G\u000fV1cY\u0016$Vm\u001d;Vi&d\u0007\"B\u0019\u0001\t\u0003\u0011\u0014!B:fiV\u0004H#A\u001a\u0011\u0005m!\u0014BA\u001b\u001d\u0005\u0011)f.\u001b;)\u0005A:\u0004C\u0001\u001d@\u001b\u0005I$B\u0001\u001e<\u0003\r\t\u0007/\u001b\u0006\u0003yu\nqA[;qSR,'O\u0003\u0002?\u001d\u0005)!.\u001e8ji&\u0011\u0001)\u000f\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0007\"\u0002\"\u0001\t\u0003\u0011\u0014A\u0006;fgR\u001cF/\u0019:K_&t7i\u001c8eSRLwN\\\u0019)\u0005\u0005#\u0005C\u0001\u001dF\u0013\t1\u0015H\u0001\u0007UKN$H+Z7qY\u0006$X\rC\u0003I\u0001\u0011\u0005!'\u0001\fuKN$8\u000b^1s\u0015>LgnQ8oI&$\u0018n\u001c83Q\t9E\tC\u0003L\u0001\u0011\u0005!'A\fuKN$()^:is*{\u0017N\\\"p]\u0012LG/[8oc!\u0012!\n\u0012\u0005\u0006\u001d\u0002!\tAM\u0001\u0018i\u0016\u001cHOQ;tQfTu.\u001b8D_:$\u0017\u000e^5p]JB#!\u0014#\t\u000bE\u0003A\u0011\u0001\u001a\u0002-Q,7\u000f^,ji\"|W\u000f^\"pYVlgn\u0015;biND#\u0001\u0015#\t\u000bQ\u0003A\u0011\u0001\u001a\u0002'Q,7\u000f\u001e&pS:<\u0016\u000e\u001e5Qe>TWm\u0019;)\u0005M#\u0005\"B,\u0001\t\u0003\u0011\u0014A\u0005;fgRTu.\u001b8XSRDg)\u001b7uKJD#A\u0016#\t\u000bi\u0003A\u0011\u0001\u001a\u0002!Q,7\u000f^!mY&sg.\u001a:K_&t\u0007FA-E\u0011\u0015i\u0006\u0001\"\u00013\u0003e!Xm\u001d;J]:,'/\u00118e\u0019\u00164GoT;uKJTu.\u001b8)\u0005q#\u0005\"\u00021\u0001\t\u0003\u0011\u0014A\u0007;fgRLeN\\3s\u0003:$'+[4ii>+H/\u001a:K_&t\u0007FA0E\u0011\u0015\u0019\u0007\u0001\"\u00013\u0003e!Xm\u001d;J]:,'/\u00118e\rVdGnT;uKJTu.\u001b8)\u0005\t$\u0005\"\u00024\u0001\t\u0003\u0011\u0014\u0001\u0006;fgR\fE\u000e\u001c'fMR|U\u000f^3s\u0015>Lg\u000e\u000b\u0002f\t\")\u0011\u000e\u0001C\u0001e\u0005)B/Z:u\u00032d'+[4ii>+H/\u001a:K_&t\u0007F\u00015E\u0011\u0015a\u0007\u0001\"\u00013\u0003Q!Xm\u001d;BY24U\u000f\u001c7PkR,'OS8j]\"\u00121\u000e\u0012\u0005\u0006_\u0002!\tAM\u00011i\u0016\u001cH/\u00138oKJTu.\u001b8MK\u001a$x*\u001e;fe*{\u0017N\\%o]\u0016\u0014(j\\5o\u0019\u00164GoT;uKJTu.\u001b8)\u00059$\u0005\"\u0002:\u0001\t\u0003\u0011\u0014\u0001\r;fgRdUM\u001a;PkR,'OS8j]&sg.\u001a:K_&tG*\u001a4u\u001fV$XM\u001d&pS:LeN\\3s\u0015>Lg\u000e\u000b\u0002r\t\")Q\u000f\u0001C\u0001e\u0005\u0011D/Z:u\u0013:tWM\u001d&pS:\u0014\u0016n\u001a5u\u001fV$XM\u001d&pS:LeN\\3s\u0015>LgNU5hQR|U\u000f^3s\u0015>Lg\u000e\u000b\u0002u\t\")\u0001\u0010\u0001C\u0001e\u0005\u0011D/Z:u%&<\u0007\u000e^(vi\u0016\u0014(j\\5o\u0013:tWM\u001d&pS:\u0014\u0016n\u001a5u\u001fV$XM\u001d&pS:LeN\\3s\u0015>Lg\u000e\u000b\u0002x\t\")1\u0010\u0001C\u0001e\u0005)B/Z:u\u0013:tWM\u001d&pS:\u001cV-\\5K_&t\u0007F\u0001>E\u0011\u0015q\b\u0001\"\u00013\u0003U!Xm\u001d;J]:,'OS8j]\u0006sG/\u001b&pS:D#! #\t\r\u0005\r\u0001\u0001\"\u00013\u00035!Xm\u001d;De>\u001c8OS8j]\"\u001a\u0011\u0011\u0001#\t\r\u0005%\u0001\u0001\"\u00013\u0003Y!Xm\u001d;J]:,'OS8j]\u000e\u0013xn]:K_&t\u0007fAA\u0004\t\"1\u0011q\u0002\u0001\u0005\u0002I\n1\u0005^3ti&sg.\u001a:K_&tG*\u001a4u\u001fV$XM\u001d&pS:\u001c%o\\:t\u0015>Lg\u000eK\u0002\u0002\u000e\u0011Ca!!\u0006\u0001\t\u0003\u0011\u0014a\n;fgRLeN\\3s\u0015>LgnV5uQ\n+8\u000f[=UsB,'j\\5o\u0007>tG-\u001b;j_:D3!a\u0005E\u0011\u0019\tY\u0002\u0001C\u0001e\u0005!C/Z:u\t\u0016\u0014\u0018N^3Ok2dg)\u001b7uKJ\fe\r^3s\u0015>LgNU3pe\u0012,'\u000fK\u0002\u0002\u001a\u0011;q!!\t\u0003\u0011\u0003\t\u0019#A\nK_&t'+Z8sI\u0016\u0014H+Z:u\u0005\u0006\u001cX\rE\u0002%\u0003K1a!\u0001\u0002\t\u0002\u0005\u001d2\u0003BA\u0013\u0003S\u00012aGA\u0016\u0013\r\ti\u0003\b\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0005\n)\u0003\"\u0001\u00022Q\u0011\u00111\u0005\u0005\t\u0003k\t)\u0003\"\u0001\u00028\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\u0005e\u0002#BA\u001e\u0003\u0007RRBAA\u001f\u0015\r9\u0013q\b\u0006\u0003\u0003\u0003\nAA[1wC&!\u0011QIA\u001f\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\u0015\t\u0003g\tI%a\u0018\u0002bA!\u00111JA.\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013!\u00049be\u0006lW\r^3sSj,GM\u0003\u0003\u0002T\u0005U\u0013AC3yi\u0016t7/[8og*\u0019a(a\u0016\u000b\u0007\u0005e#\"A\u0005uKN$X\u000f^5mg&!\u0011QLA'\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0005]\u0006lW-\t\u0002\u0002d\u00051\u0012n\u001d\"vg\"L(j\\5o%\u0016|'\u000fZ3s{m\u0004T\u0010")
public abstract class JoinReorderTestBase
extends TableTestBase {
    private final boolean isBushyJoinReorder;
    private final TableTestUtil util;

    @Parameters(name="isBushyJoinReorder={0}")
    public static Collection<Object> parameters() {
        return JoinReorderTestBase$.MODULE$.parameters();
    }

    public TableTestUtil util() {
        return this.util;
    }

    public abstract TableTestUtil getTableTestUtil();

    @BeforeEach
    public void setup() {
        TypeInformation[] types = (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()});
        this.util().addTableSource("T1", types, (String[])((Object[])new String[]{"a1", "b1", "c1"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a1"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(1000000L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b1"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(50L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T2", types, (String[])((Object[])new String[]{"a2", "b2", "c2"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(10000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a2"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(100L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b2"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(500000L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T3", types, (String[])((Object[])new String[]{"a3", "b3", "c3"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(1000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a3"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b3"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(50L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T4", types, (String[])((Object[])new String[]{"a4", "b4", "c4"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a4"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(100L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b4"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(500000L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T5", types, (String[])((Object[])new String[]{"a5", "b5", "c5"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(500000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a5"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(200000L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b5"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(200L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().getTableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_JOIN_REORDER_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        if (!this.isBushyJoinReorder) {
            this.util().getTableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BUSHY_JOIN_REORDER_THRESHOLD, (Object)3);
        } else {
            this.util().getTableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BUSHY_JOIN_REORDER_THRESHOLD, (Object)1000);
        }
    }

    @TestTemplate
    public void testStarJoinCondition1() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE a1 = a2 AND a1 = a3 AND a1 = a4 AND a1 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testStarJoinCondition2() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE b1 = b2 AND b1 = b3 AND b1 = b4 AND b1 = b5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testBushyJoinCondition1() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE a1 = a2 AND a2 = a3 AND a1 = a4 AND a3 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testBushyJoinCondition2() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE b1 = b2 AND b2 = b3 AND b1 = b4 AND b3 = b5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testWithoutColumnStats() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE c1 = c2 AND c1 = c3 AND c2 = c4 AND c1 = c5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testJoinWithProject() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |WITH V1 AS (SELECT b1, a1, a2, c2 FROM T1 JOIN T2 ON a1 = a2),\n         |     V2 AS (SELECT a3, b1, a1, c2, c3 FROM V1 JOIN T3 ON a2 = a3),\n         |     V3 AS (SELECT a3, b1, a1, c2, c3, a4, b4 FROM T4 JOIN V2 ON a1 = a4)\n         |\n         |SELECT * FROM V3, T5 where a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testJoinWithFilter() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |WITH V1 AS (SELECT * FROM T1 JOIN T2 ON a1 = a2 WHERE b1 * b2 > 10),\n         |     V2 AS (SELECT * FROM V1 JOIN T3 ON a2 = a3 WHERE b1 * b3 < 2000),\n         |     V3 AS (SELECT * FROM T4 JOIN V2 ON a3 = a4 WHERE b2 + b4 > 100)\n         |\n         |SELECT * FROM V3, T5 WHERE a4 = a5 AND b5 < 15\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testAllInnerJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a2 = a4\n         |   JOIN T5 ON a1 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerAndLeftOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   LEFT OUTER JOIN T4 ON a1 = a4\n         |   JOIN T5 ON a1 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerAndRightOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   RIGHT OUTER JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a2 = a4\n         |   JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerAndFullOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   FULL OUTER JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a1 = a4\n         |   JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testAllLeftOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   LEFT OUTER JOIN T2 ON a1 = a2\n         |   LEFT OUTER JOIN T3 ON a1 = a3\n         |   LEFT OUTER JOIN T4 ON a1 = a4\n         |   LEFT OUTER JOIN T5 ON a1 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testAllRightOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   RIGHT OUTER JOIN T2 ON a1 = a2\n         |   RIGHT OUTER JOIN T3 ON a2 = a3\n         |   RIGHT OUTER JOIN T4 ON a1 = a4\n         |   RIGHT OUTER JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testAllFullOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   FULL OUTER JOIN T2 ON a1 = a2\n         |   FULL OUTER JOIN T3 ON a1 = a3\n         |   FULL OUTER JOIN T4 ON a1 = a4\n         |   FULL OUTER JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerJoinLeftOuterJoinInnerJoinLeftOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   LEFT OUTER JOIN T3 ON a1 = a3\n         |   JOIN T4 ON a1 = a4\n         |   LEFT OUTER JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testLeftOuterJoinInnerJoinLeftOuterJoinInnerJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   LEFT OUTER JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a1 = a3\n         |   LEFT OUTER JOIN T4 ON a1 = a4\n         |   JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerJoinRightOuterJoinInnerJoinRightOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   RIGHT OUTER JOIN T3 ON a1 = a3\n         |   JOIN T4 ON a1 = a4\n         |   RIGHT OUTER JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testRightOuterJoinInnerJoinRightOuterJoinInnerJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   RIGHT OUTER JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a1 = a3\n         |   RIGHT OUTER JOIN T4 ON a1 = a4\n         |   JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerJoinSemiJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a1 = a4\n         |   WHERE a1 IN (SELECT a5 FROM T5)\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerJoinAntiJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a1 = a4\n         |   WHERE NOT EXISTS (SELECT a5 FROM T5 WHERE a1 = a5)\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testCrossJoin() {
        String sql = "SELECT * FROM T1, T2, T3, T4, T5";
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerJoinCrossJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1,\n         |   (SELECT * FROM T2 JOIN T3 ON a2 = a3) tab1, T4\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerJoinLeftOuterJoinCrossJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1,\n         |   (SELECT * FROM T2 LEFT JOIN T3 ON a2 = a3 JOIN T4 ON a2 = a4) tab1, T5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testInnerJoinWithBushyTypeJoinCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM\n         |(SELECT * FROM T1 JOIN T2 ON T1.b1 = T2.b2) tab1 JOIN\n         |(SELECT * FROM T3 JOIN T4 ON T3.b3 = T4.b4) tab2\n         |ON tab1.b2 = tab2.b4\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @TestTemplate
    public void testDeriveNullFilterAfterJoinReorder() {
        TypeInformation[] types = (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG()});
        ColumnStats.Builder builderA = ColumnStats.Builder.builder().setNdv(Predef$.MODULE$.long2Long(200000L)).setNullCount(Predef$.MODULE$.long2Long(50000L)).setAvgLen(Predef$.MODULE$.double2Double(4.0)).setMaxLen(Predef$.MODULE$.int2Integer(4));
        ColumnStats.Builder builderB = ColumnStats.Builder.builder().setNdv(Predef$.MODULE$.long2Long(100000L)).setNullCount(Predef$.MODULE$.long2Long(0L)).setAvgLen(Predef$.MODULE$.double2Double(8.0)).setMaxLen(Predef$.MODULE$.int2Integer(8));
        this.util().addTableSource("T6", types, (String[])((Object[])new String[]{"a6", "b6"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(500000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a6"), (Object)builderA.build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b6"), (Object)builderB.build())}))))).build());
        this.util().addTableSource("T7", types, (String[])((Object[])new String[]{"a7", "b7"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(500000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a7"), (Object)builderA.build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b7"), (Object)builderB.build())}))))).build());
        this.util().addTableSource("T8", types, (String[])((Object[])new String[]{"a8", "b8"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(500000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a8"), (Object)builderA.build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b8"), (Object)builderB.build())}))))).build());
        this.util().getTableEnv().getConfig().set(JoinDeriveNullFilterRule$.MODULE$.TABLE_OPTIMIZER_JOIN_NULL_FILTER_THRESHOLD(), (Object)BoxesRunTime.boxToLong((long)10000L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T6\n         |   INNER JOIN T7 ON b6 = b7\n         |   INNER JOIN T8 ON a6 = a8\n         |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    public JoinReorderTestBase(boolean isBushyJoinReorder) {
        this.isBushyJoinReorder = isBushyJoinReorder;
        this.util = this.getTableTestUtil();
    }
}

