/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.common.PartialInsertTest$;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u0001E\u0011\u0011\u0003U1si&\fG.\u00138tKJ$H+Z:u\u0015\t\u0019A!\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u0019\tA\u0001\u001d7b]*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U1\u0011!B;uS2\u001c\u0018BA\f\u0015\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\"A\u0011\u0004\u0001B\u0001B\u0003%!$A\u0004jg\n\u000bGo\u00195\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f\t{w\u000e\\3b]\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"aI\u0013\u0011\u0005\u0011\u0002Q\"\u0001\u0002\t\u000be\u0001\u0003\u0019\u0001\u000e\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005!Q\u000f^5m+\u0005I#\u0003\u0002\u0016-_I2Aa\u000b\u0001\u0001S\taAH]3gS:,W.\u001a8u}A\u00111#L\u0005\u0003]Q\u0011Q\u0002V1cY\u0016$Vm\u001d;Vi&d\u0007CA\u000e1\u0013\t\tDDA\u0004Qe>$Wo\u0019;\u0011\u0005m\u0019\u0014B\u0001\u001b\u001d\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u00191\u0004\u0001)A\u0005S\u0005)Q\u000f^5mA!)\u0001\b\u0001C\u0001s\u0005\u0019C/Z:u!\u0006\u0014H/[1m\u0013:\u001cXM\u001d;XSRD7i\\7qY\u0016D(+Z8sI\u0016\u0014H#\u0001\u001e\u0011\u0005mY\u0014B\u0001\u001f\u001d\u0005\u0011)f.\u001b;)\u0005]r\u0004CA G\u001b\u0005\u0001%BA!C\u0003\r\t\u0007/\u001b\u0006\u0003\u0007\u0012\u000bqA[;qSR,'O\u0003\u0002F\u001d\u0005)!.\u001e8ji&\u0011q\t\u0011\u0002\r)\u0016\u001cH\u000fV3na2\fG/\u001a\u0005\u0006\u0013\u0002!\t!O\u00015i\u0016\u001cH\u000fU1si&\fG.\u00138tKJ$x+\u001b;i\u0007>l\u0007\u000f\\3y%\u0016|'\u000fZ3s\u0003:$7i\\7qkR,GmQ8mk6t\u0007F\u0001%?\u0011\u0015a\u0005\u0001\"\u0001:\u0003i!Xm\u001d;QCJ$\u0018.\u00197J]N,'\u000f^,ji\",f.[8oQ\tYe\bC\u0003P\u0001\u0011\u0005\u0011(A\u000fuKN$\b+\u0019:uS\u0006d\u0017J\\:feR<\u0016\u000e\u001e5V]&|g.\u00117mQ\tqe\bC\u0003S\u0001\u0011\u0005\u0011(A\u0011uKN$\b+\u0019:uS\u0006d\u0017J\\:feR<\u0016\u000e\u001e5J]R,'o]3di\u0006cG\u000e\u000b\u0002R}!)Q\u000b\u0001C\u0001s\u0005qB/Z:u!\u0006\u0014H/[1m\u0013:\u001cXM\u001d;XSRDW\t_2faR\fE\u000e\u001c\u0015\u0003)zBQ\u0001\u0017\u0001\u0005\ne\u000b\u0001\u0005^3tiB\u000b'\u000f^5bY&s7/\u001a:u/&$\bnU3u\u001fB,'/\u0019;peR\u0011!H\u0017\u0005\u00067^\u0003\r\u0001X\u0001\t_B,'/\u0019;peB\u0011Q\f\u001a\b\u0003=\n\u0004\"a\u0018\u000f\u000e\u0003\u0001T!!\u0019\t\u0002\rq\u0012xn\u001c;?\u0013\t\u0019G$\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u001a\u0014aa\u0015;sS:<'BA2\u001d\u0011\u0015A\u0007\u0001\"\u0001:\u0003\r\"Xm\u001d;QCJ$\u0018.\u00197J]N,'\u000f^,ji\",f.[8o\u00032dg*Z:uK\u0012D#a\u001a \t\u000b-\u0004A\u0011A\u001d\u00029Q,7\u000f\u001e)beRL\u0017\r\\%og\u0016\u0014HoV5uQ>\u0013H-\u001a:Cs\"\u0012!N\u0010\u0005\u0006]\u0002!\t!O\u0001'i\u0016\u001cH\u000fU1si&\fG.\u00138tKJ$x+\u001b;i!\u0016\u00148/[:uK\u0012lU\r^1eCR\f\u0007FA7?\u0011\u0015\t\b\u0001\"\u0001:\u0003)\"Xm\u001d;QCJ$\u0018.\u00197J]N,'\u000f^,ji\"4\u0016N\u001d;vC2lU\r^1ECR\f7i\u001c7v[:D#\u0001\u001d \t\u000bQ\u0004A\u0011A\u001d\u0002GQ,7\u000f\u001e)beRL\u0017\r\\%og\u0016\u0014HoV5uQ\u000e{W\u000e];uK\u0012\u001cu\u000e\\;n]\"\u00121O\u0010\u0005\u0006o\u0002!\t!O\u0001\u001di\u0016\u001cH\u000fU1si&\fG.\u00138tKJ$x+\u001b;i\u000fJ|W\u000f\u001d\"zQ\t1h\bC\u0003{\u0001\u0011\u0005\u0011(\u0001\u0010uKN$\b+\u0019:uS\u0006d\u0017J\\:feR\u001cu.\u001c9pg&$X\rV=qK\"\u0012\u0011P\u0010\u0015\u0007\u0001u\f9!!\u0003\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t\u0001Q\u0001\nKb$XM\\:j_:L1!!\u0002\u0000\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003\u0017\u0019#!!\u0004\u0011\t\u0005=\u0011qD\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005i\u0001/\u0019:b[\u0016$XM]5{K\u0012TA!a\u0006\u0002\u001a\u0005QQ\r\u001f;f]NLwN\\:\u000b\u0007\u0015\u000bYBC\u0002\u0002\u001e)\t\u0011\u0002^3tiV$\u0018\u000e\\:\n\t\u0005\u0005\u0012\u0011\u0003\u0002\u001b!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$X\t\u001f;f]NLwN\\\u0004\b\u0003K\u0011\u0001\u0012AA\u0014\u0003E\u0001\u0016M\u001d;jC2Len]3siR+7\u000f\u001e\t\u0004I\u0005%bAB\u0001\u0003\u0011\u0003\tYc\u0005\u0003\u0002*\u00055\u0002cA\u000e\u00020%\u0019\u0011\u0011\u0007\u000f\u0003\r\u0005s\u0017PU3g\u0011\u001d\t\u0013\u0011\u0006C\u0001\u0003k!\"!a\n\t\u0011\u0005e\u0012\u0011\u0006C\u0001\u0003w\t!\u0002]1sC6,G/\u001a:t)\t\ti\u0004E\u0003\u0002@\u0005\u001d#$\u0004\u0002\u0002B)\u0019q%a\u0011\u000b\u0005\u0005\u0015\u0013\u0001\u00026bm\u0006LA!!\u0013\u0002B\tQ1i\u001c7mK\u000e$\u0018n\u001c8)\u0011\u0005]\u0012QJA*\u0003+\u0002B!a\u0004\u0002P%!\u0011\u0011KA\t\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0005]\u0006lW-\t\u0002\u0002X\u0005a\u0011n\u001d\"bi\u000eD'\bI>1{\u0002")
public class PartialInsertTest
extends TableTestBase {
    private final TableTestUtil util;

    @Parameters(name="isBatch: {0}")
    public static Collection<Object> parameters() {
        return PartialInsertTest$.MODULE$.parameters();
    }

    private TableTestUtil util() {
        return this.util;
    }

    @TestTemplate
    public void testPartialInsertWithComplexReorder() {
        this.util().verifyRelPlanInsert("INSERT INTO sink (b,e,a,g,f,c,d) SELECT b,e,a,456,123,c,d FROM MyTable GROUP BY a,b,c,d,e");
    }

    @TestTemplate
    public void testPartialInsertWithComplexReorderAndComputedColumn() {
        this.util().verifyRelPlanInsert("INSERT INTO partitioned_sink (e,a,g,f,c,d) SELECT e,a,456,123,c,d FROM MyTable GROUP BY a,b,c,d,e");
    }

    @TestTemplate
    public void testPartialInsertWithUnion() {
        this.testPartialInsertWithSetOperator("UNION");
    }

    @TestTemplate
    public void testPartialInsertWithUnionAll() {
        this.testPartialInsertWithSetOperator("UNION ALL");
    }

    @TestTemplate
    public void testPartialInsertWithIntersectAll() {
        this.testPartialInsertWithSetOperator("INTERSECT ALL");
    }

    @TestTemplate
    public void testPartialInsertWithExceptAll() {
        this.testPartialInsertWithSetOperator("EXCEPT ALL");
    }

    private void testPartialInsertWithSetOperator(String operator) {
        this.util().verifyRelPlanInsert(new StringBuilder(154).append("INSERT INTO partitioned_sink (e,a,g,f,c,d) SELECT e,a,456,123,c,d FROM MyTable GROUP BY a,b,c,d,e ").append(operator).append(" ").append("SELECT e,a,789,456,c,d FROM MyTable GROUP BY a,b,c,d,e ").toString());
    }

    @TestTemplate
    public void testPartialInsertWithUnionAllNested() {
        this.util().verifyRelPlanInsert("INSERT INTO partitioned_sink (e,a,g,f,c,d) SELECT e,a,456,123,c,d FROM MyTable GROUP BY a,b,c,d,e UNION ALL SELECT e,a,789,456,c,d FROM MyTable GROUP BY a,b,c,d,e UNION ALL SELECT e,a,123,456,c,d FROM MyTable GROUP BY a,b,c,d,e ");
    }

    @TestTemplate
    public void testPartialInsertWithOrderBy() {
        this.util().verifyRelPlanInsert("INSERT INTO partitioned_sink (e,a,g,f,c,d) SELECT e,a,456,123,c,d FROM MyTable ORDER BY a,e,c,d");
    }

    @TestTemplate
    public void testPartialInsertWithPersistedMetadata() {
        this.util().verifyRelPlanInsert("INSERT INTO metadata_sink (a,b,c,d,e,f) SELECT a,b,c,d,e,123 FROM MyTable");
    }

    @TestTemplate
    public void testPartialInsertWithVirtualMetaDataColumn() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlanInsert("INSERT INTO metadata_sink (a,b,c,d,e,g) SELECT a,b,c,d,e,123 FROM MyTable")).hasMessageContaining("SQL validation failed. At line 1, column 38: Unknown target column 'g'") instanceof ValidationException;
    }

    @TestTemplate
    public void testPartialInsertWithComputedColumn() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlanInsert("INSERT INTO metadata_sink (a,b,c,d,e,h) SELECT a,b,c,d,e,123 FROM MyTable")).hasMessageContaining("SQL validation failed. At line 1, column 38: Unknown target column 'h'") instanceof ValidationException;
    }

    @TestTemplate
    public void testPartialInsertWithGroupBy() {
        this.util().verifyExplainInsert("INSERT INTO partitioned_sink (e,a,d) SELECT e,a,d FROM MyTable GROUP BY a,b,c,d,e");
    }

    @TestTemplate
    public void testPartialInsertCompositeType() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExplainInsert("INSERT INTO complex_type_sink (a,b.b1,c.c2,f) SELECT a,b.b1,c.c2,f FROM complex_type_src"));
    }

    public PartialInsertTest(boolean isBatch) {
        this.util = isBatch ? this.batchTestUtil(this.batchTestUtil$default$1()) : this.streamTestUtil(this.streamTestUtil$default$1());
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}), new CaseClassTypeInfo<Tuple5<Object, String, String, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, String, String, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, String, String, String, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, String, String, String, Object>>(this, fieldSerializers){

                    public Tuple5<Object, String, String, String, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple5<Object, String, String, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.common.PartialInsertTest$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |create table sink (\n                              |  `a` INT,\n                              |  `b` STRING,\n                              |  `c` STRING,\n                              |  `d` STRING,\n                              |  `e` DOUBLE,\n                              |  `f` BIGINT,\n                              |  `g` INT\n                              |) with (\n                              |  'connector' = 'values',\n                              |  'sink-insert-only' = 'false'\n                              |)\n                              |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |create table partitioned_sink (\n                              |  `a` INT,\n                              |  `b` AS `a` + 1,\n                              |  `c` STRING,\n                              |  `d` STRING,\n                              |  `e` DOUBLE,\n                              |  `f` BIGINT,\n                              |  `g` INT\n                              |) PARTITIONED BY (`c`, `d`) with (\n                              |  'connector' = 'values',\n                              |  'sink-insert-only' = 'false'\n                              |)\n                              |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |create table complex_type_src (\n                              |  `a` BIGINT,\n                              |  `b` ROW<b1 STRING, b2 INT>,\n                              |  `c` ROW<c1 BIGINT, c2 STRING>,\n                              |  `d` MAP<STRING, STRING>,\n                              |  `e` DOUBLE,\n                              |  `f` BIGINT,\n                              |  `g` INT\n                              |) with (\n                              |  'connector' = 'values'\n                              |)\n                              |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |create table complex_type_sink (\n                              |  `a` BIGINT,\n                              |  `b` ROW<b1 STRING, b2 INT>,\n                              |  `c` ROW<c1 BIGINT, c2 STRING>,\n                              |  `d` MAP<STRING, STRING>,\n                              |  `e` DOUBLE,\n                              |  `f` BIGINT METADATA,\n                              |  `g` INT,\n                              |  primary key (`a`) not enforced\n                              |) with (\n                              |  'connector' = 'values',\n                              |  'sink-insert-only' = 'false',\n                              |  'writable-metadata' = 'f:bigint'\n                              |)\n                              |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("create table metadata_sink (\n                              |  `a` INT,\n                              |  `b` STRING,\n                              |  `c` STRING,\n                              |  `d` STRING,\n                              |  `e` DOUBLE,\n                              |  `f` BIGINT METADATA,\n                              |  `g` INT METADATA VIRTUAL,\n                              |  `h` AS `a` + 1\n                              |) with (\n                              |  'connector' = 'values',\n                              |  'sink-insert-only' = 'false',\n                              |  'writable-metadata' = 'f:BIGINT, g:INT'\n                              |)")).stripMargin());
    }
}

