/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import java.util.Collection;
import java.util.Optional;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory$;
import org.apache.flink.table.planner.plan.common.TableFactoryTest$;
import org.apache.flink.table.planner.plan.utils.TestContextTableFactory;
import org.apache.flink.table.planner.plan.utils.TestContextTableFactory$;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001#\t\u0001B+\u00192mK\u001a\u000b7\r^8ssR+7\u000f\u001e\u0006\u0003\u0007\u0011\taaY8n[>t'BA\u0003\u0007\u0003\u0011\u0001H.\u00198\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\r\u0005)Q\u000f^5mg&\u0011q\u0003\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u0011e\u0001!\u0011!Q\u0001\ni\tq![:CCR\u001c\u0007\u000e\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBDA\u0004C_>dW-\u00198\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\t!\u0001C\u0003\u001aA\u0001\u0007!\u0004C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002\tU$\u0018\u000e\\\u000b\u0002SI!!\u0006L\u00183\r\u0011Y\u0003\u0001A\u0015\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0005Mi\u0013B\u0001\u0018\u0015\u00055!\u0016M\u00197f)\u0016\u001cH/\u0016;jYB\u00111\u0004M\u0005\u0003cq\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u001cg%\u0011A\u0007\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0007m\u0001\u0001\u000b\u0011B\u0015\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000ba\u0002A\u0011A\u001d\u0002\r\t,gm\u001c:f)\u0005Q\u0004CA\u000e<\u0013\taDD\u0001\u0003V]&$\bFA\u001c?!\tyd)D\u0001A\u0015\t\t%)A\u0002ba&T!a\u0011#\u0002\u000f),\b/\u001b;fe*\u0011QID\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u000f\u0002\u0013!BQ3g_J,W)Y2i\u0011\u0015I\u0005\u0001\"\u0001:\u0003i!Xm\u001d;UC\ndWmU8ve\u000e,7+\u001b8l\r\u0006\u001cGo\u001c:zQ\tA5\n\u0005\u0002@\u0019&\u0011Q\n\u0011\u0002\r)\u0016\u001cH\u000fV3na2\fG/\u001a\u0015\u0005\u0001=+f\u000b\u0005\u0002Q'6\t\u0011K\u0003\u0002S\u0001\u0006IQ\r\u001f;f]NLwN\\\u0005\u0003)F\u0013!\"\u0012=uK:$w+\u001b;i\u0003\u00151\u0018\r\\;fY\u000596%\u0001-\u0011\u0005e\u000bW\"\u0001.\u000b\u0005mc\u0016!\u00049be\u0006lW\r^3sSj,GM\u0003\u0002^=\u0006QQ\r\u001f;f]NLwN\\:\u000b\u0005\u0015{&B\u00011\u000b\u0003%!Xm\u001d;vi&d7/\u0003\u0002c5\nQ\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;FqR,gn]5p]\u001e)AM\u0001E\u0001K\u0006\u0001B+\u00192mK\u001a\u000b7\r^8ssR+7\u000f\u001e\t\u0003I\u00194Q!\u0001\u0002\t\u0002\u001d\u001c\"A\u001a5\u0011\u0005mI\u0017B\u00016\u001d\u0005\u0019\te.\u001f*fM\")\u0011E\u001aC\u0001YR\tQ\rC\u0003oM\u0012\u0005q.\u0001\u0006qCJ\fW.\u001a;feN$\u0012\u0001\u001d\t\u0004cVTR\"\u0001:\u000b\u0005\u001d\u001a(\"\u0001;\u0002\t)\fg/Y\u0005\u0003mJ\u0014!bQ8mY\u0016\u001cG/[8oQ\u0011i\u0007p\u001f?\u0011\u0005eK\u0018B\u0001>[\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0005]\u0006lW-I\u0001~\u00031I7OQ1uG\"T\u0004e\u001f\u0019~\u0001")
public class TableFactoryTest
extends TableTestBase {
    private final boolean isBatch;
    private final TableTestUtil util;

    @Parameters(name="isBatch: {0}")
    public static Collection<Object> parameters() {
        return TableFactoryTest$.MODULE$.parameters();
    }

    private TableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        TestCollectionTableFactory$.MODULE$.reset();
    }

    @TestTemplate
    public void testTableSourceSinkFactory() {
        TestContextTableFactory factory = new TestContextTableFactory(ObjectIdentifier.of((String)"cat", (String)"default", (String)"t1"), ObjectIdentifier.of((String)"cat", (String)"default", (String)"t2"), this.isBatch);
        this.util().tableEnv().getConfig().set(TestContextTableFactory$.MODULE$.REQUIRED_KEY(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().registerCatalog("cat", (Catalog)new GenericInMemoryCatalog(null, factory){
            private final TestContextTableFactory factory$1;

            public Optional<TableFactory> getTableFactory() {
                return Optional.of(this.factory$1);
            }
            {
                this.factory$1 = factory$1;
                super("default");
            }
        });
        this.util().tableEnv().useCatalog("cat");
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t1(\n        |  a int,\n        |  b varchar,\n        |  c as a + 1\n        |) with (\n        |  'connector.type' = 'filesystem',\n        |  'connector.path' = '/to/my/path1',\n        |  'format.type' = 'csv'\n        |)\n      ")).stripMargin();
        String sinkDDL = new StringOps(Predef$.MODULE$.augmentString("\n        |create table t2(\n        |  a int,\n        |  b as c - 1,\n        |  c int\n        |) with (\n        |  'connector.type' = 'filesystem',\n        |  'connector.path' = '/to/my/path2',\n        |  'format.type' = 'csv'\n        |)\n      ")).stripMargin();
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |insert into t2\n        |select t1.a, t1.c from t1\n      ")).stripMargin();
        this.util().tableEnv().executeSql(sourceDDL);
        this.util().tableEnv().executeSql(sinkDDL);
        this.util().tableEnv().explainSql(query, new ExplainDetail[0]);
        Assertions.assertThat((boolean)factory.hasInvokedSource()).isTrue();
        Assertions.assertThat((boolean)factory.hasInvokedSink()).isTrue();
    }

    public TableFactoryTest(boolean isBatch) {
        this.isBatch = isBatch;
        this.util = isBatch ? this.batchTestUtil(this.batchTestUtil$default$1()) : this.streamTestUtil(this.streamTestUtil$default$1());
    }
}

